/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.hierarchy.type.JavaTypeHierarchyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.lightClasses.KtFakeLightClass;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinClassShortNameIndex;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformUtil;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/hierarchy/KotlinTypeHierarchyProvider;", "Lcom/intellij/ide/hierarchy/type/JavaTypeHierarchyProvider;", "()V", "getOriginalPsiClassOrCreateLightClass", "Lcom/intellij/psi/PsiClass;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "module", "Lcom/intellij/openapi/module/Module;", "getTarget", "Lcom/intellij/psi/PsiElement;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getTargetByContainingElement", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getTargetByReference", "project", "Lcom/intellij/openapi/project/Project;", "idea"})
public final class KotlinTypeHierarchyProvider
extends JavaTypeHierarchyProvider {
    private final PsiClass getOriginalPsiClassOrCreateLightClass(KtClassOrObject classOrObject, Module module) {
        FqName fqName2 = classOrObject.getFqName();
        if (fqName2 != null) {
            Module module2 = module;
            if (JvmIdePlatformUtil.isJvm(module2 != null ? PlatformKt.getPlatform(module2) : null)) {
                FqNameUnsafe fqNameUnsafe = fqName2.toUnsafe();
                Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"fqName.toUnsafe()");
                ClassId javaClassId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
                if (javaClassId != null) {
                    return JavaPsiFacade.getInstance((Project)classOrObject.getProject()).findClass(javaClassId.asSingleFqName().asString(), GlobalSearchScope.allScope((Project)classOrObject.getProject()));
                }
            }
        }
        KtLightClass ktLightClass = LightClassUtilsKt.toLightClass(classOrObject);
        return ktLightClass != null ? (PsiClass)ktLightClass : (PsiClass)new KtFakeLightClass(classOrObject);
    }

    private final PsiElement getTargetByReference(Project project, Editor editor, Module module) {
        PsiElement psiElement2;
        PsiElement target;
        TargetElementUtil targetElementUtil = TargetElementUtil.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)targetElementUtil, (String)"TargetElementUtil.getInstance()");
        PsiElement psiElement3 = target = TargetElementUtil.findTargetElement((Editor)editor, (int)targetElementUtil.getAllAccepted());
        if (psiElement3 instanceof PsiClass) {
            psiElement2 = target;
        } else if (psiElement3 instanceof KtConstructor) {
            psiElement2 = (PsiElement)this.getOriginalPsiClassOrCreateLightClass(((KtConstructor)target).getContainingClassOrObject(), module);
        } else if (psiElement3 instanceof KtClassOrObject) {
            psiElement2 = (PsiElement)this.getOriginalPsiClassOrCreateLightClass((KtClassOrObject)target, module);
        } else if (psiElement3 instanceof KtNamedFunction) {
            String functionName = ((KtNamedFunction)target).getName();
            FunctionDescriptor functionDescriptor2 = ResolutionUtils.resolveToDescriptorIfAny((KtNamedFunction)target, BodyResolveMode.FULL);
            if (functionDescriptor2 == null) {
                return null;
            }
            FunctionDescriptor functionDescriptor3 = functionDescriptor2;
            KotlinType kotlinType = functionDescriptor3.getReturnType();
            if (kotlinType == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"functionDescriptor.returnType ?: return null");
            KotlinType type2 = kotlinType;
            String returnTypeText = DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(type2);
            if (Intrinsics.areEqual((Object)returnTypeText, (Object)functionName) ^ true) {
                return null;
            }
            Collection<KtClassOrObject> collection = KotlinClassShortNameIndex.getInstance().get(functionName, project, SearchUtilKt.allScope(project));
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"KotlinClassShortNameInde\u2026ject, project.allScope()]");
            KtClassOrObject ktClassOrObject = (KtClassOrObject)CollectionsKt.singleOrNull((Iterable)collection);
            if (ktClassOrObject == null) {
                return null;
            }
            KtClassOrObject classOrObject = ktClassOrObject;
            psiElement2 = (PsiElement)this.getOriginalPsiClassOrCreateLightClass(classOrObject, module);
        } else {
            psiElement2 = null;
        }
        return psiElement2;
    }

    private final PsiElement getTargetByContainingElement(Editor editor, PsiFile file) {
        PsiElement element3;
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        int offset2 = caretModel.getOffset();
        PsiElement psiElement2 = file.findElementAt(offset2);
        if (psiElement2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"file.findElementAt(offset) ?: return null");
        PsiElement $receiver$iv = element3 = psiElement2;
        KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtClassOrObject.class, (boolean)false);
        if (ktClassOrObject == null) {
            return null;
        }
        KtClassOrObject classOrObject = ktClassOrObject;
        return (PsiElement)this.getOriginalPsiClassOrCreateLightClass(classOrObject, ProjectRootsUtilKt.getModule((PsiElement)file));
    }

    @Nullable
    public PsiElement getTarget(@NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"PlatformDataKeys.PROJECT\u2026taContext) ?: return null");
        Project project2 = project;
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            PsiElement psiElement2;
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
            if (psiFile == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"PsiDocumentManager.getIn\u2026.document) ?: return null");
            PsiFile file = psiFile;
            if (!ProjectRootsUtil.isInProjectOrLibSource((PsiElement)file)) {
                return null;
            }
            PsiElement psiElement3 = this.getTargetByReference(project2, editor, ProjectRootsUtilKt.getModule((PsiElement)file));
            if (psiElement3 == null) {
                psiElement3 = psiElement2 = this.getTargetByContainingElement(editor, file);
            }
            if (psiElement2 instanceof PsiNamedElement && ((PsiNamedElement)psiElement2).getName() == null) {
                return null;
            }
            return psiElement2;
        }
        PsiElement element3 = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element3 instanceof KtClassOrObject) {
            return (PsiElement)this.getOriginalPsiClassOrCreateLightClass((KtClassOrObject)element3, ProjectRootsUtilKt.getModule(element3));
        }
        return null;
    }
}

