/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.RedundantSemicolonInspection;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0013\u001a\u00020\f*\u0004\u0018\u00010\u0011H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantSemicolonInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "softModifierKeywords", "", "", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "isRedundant", "semicolon", "Lcom/intellij/psi/PsiElement;", "isRequiredForCompanion", "isLineBreak", "Fix", "idea"})
public final class RedundantSemicolonInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool {
    private final List<String> softModifierKeywords;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new PsiElementVisitor(this, holder){
            final /* synthetic */ RedundantSemicolonInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                super.visitElement(element3);
                ASTNode aSTNode = element3.getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"element.node");
                if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)((Object)KtTokens.SEMICOLON)) && RedundantSemicolonInspection.access$isRedundant(this.this$0, element3)) {
                    this.$holder.registerProblem(element3, "Redundant semicolon", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{Fix.INSTANCE});
                }
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    private final boolean isRedundant(PsiElement semicolon2) {
        KtNameReferenceExpression prevNameReference;
        KtStatementExpression ktStatementExpression;
        KtClass it;
        boolean isAtEndOfLine;
        PsiElement nextLeaf2 = PsiUtilsKt.nextLeaf(semicolon2, (Function1<? super PsiElement, Boolean>)((Function1)new Function1<PsiElement, Boolean>(this){
            final /* synthetic */ RedundantSemicolonInspection this$0;

            public final boolean invoke(@NotNull PsiElement it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return !(it instanceof PsiWhiteSpace) && !(it instanceof PsiComment) || RedundantSemicolonInspection.access$isLineBreak(this.this$0, it);
            }
            {
                this.this$0 = redundantSemicolonInspection;
                super(1);
            }
        }));
        boolean bl = isAtEndOfLine = nextLeaf2 == null || this.isLineBreak(nextLeaf2);
        if (!isAtEndOfLine) {
            if (semicolon2.getParent() instanceof KtPackageDirective) {
                Object object;
                PsiElement psiElement2 = nextLeaf2;
                if (!(psiElement2 instanceof KtImportList)) {
                    psiElement2 = null;
                }
                if ((object = (KtImportList)psiElement2) != null && (object = ((KtImportList)object).getImports()) != null) {
                    if (object.isEmpty()) {
                        return true;
                    }
                }
            }
            return false;
        }
        PsiElement psiElement3 = PsiUtilsKt.prevLeaf$default(semicolon2, false, 1, null);
        if (Intrinsics.areEqual((Object)(psiElement3 != null && (psiElement3 = psiElement3.getNode()) != null ? psiElement3.getElementType() : null), (Object)((Object)KtNodeTypes.ELSE))) {
            return false;
        }
        if (semicolon2.getParent() instanceof KtEnumEntry) {
            return false;
        }
        PsiElement psiElement4 = semicolon2.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"semicolon.parent");
        PsiElement psiElement5 = psiElement4.getParent();
        if (!(psiElement5 instanceof KtClass)) {
            psiElement5 = null;
        }
        KtClass ktClass2 = (KtClass)psiElement5;
        if (ktClass2 != null && (it = (ktStatementExpression = ktClass2)).isEnum()) {
            PsiElement psiElement6;
            Object $receiver$iv = (PsiElement[])it;
            Object object = PsiTreeUtil.getChildrenOfType((PsiElement)$receiver$iv, KtEnumEntry.class);
            if (object == null) {
                object = $receiver$iv = new KtEnumEntry[]{};
            }
            if (((PsiElement[])$receiver$iv).length == 0 && Intrinsics.areEqual((Object)((psiElement6 = PsiUtilsKt.prevLeaf(semicolon2, (Function1<? super PsiElement, Boolean>)((Function1)new Function1<PsiElement, Boolean>(this, semicolon2){
                final /* synthetic */ RedundantSemicolonInspection this$0;
                final /* synthetic */ PsiElement $semicolon$inlined;
                {
                    this.this$0 = redundantSemicolonInspection;
                    this.$semicolon$inlined = psiElement2;
                    super(1);
                }

                public final boolean invoke(@NotNull PsiElement it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return !(it instanceof PsiWhiteSpace) && !(it instanceof PsiComment) && !RedundantSemicolonInspection.access$isLineBreak(this.this$0, it);
                }
            }))) != null && (psiElement6 = psiElement6.getNode()) != null ? psiElement6.getElementType() : null), (Object)((Object)KtTokens.LBRACE)) && !($receiver$iv = (Collection)it.getDeclarations()).isEmpty()) {
                return false;
            }
        }
        PsiElement psiElement7 = PsiUtilsKt.prevLeaf$default(semicolon2, false, 1, null);
        Object object = psiElement7 != null ? psiElement7.getParent() : null;
        if (!(object instanceof KtLoopExpression)) {
            object = null;
        }
        KtLoopExpression ktLoopExpression = (KtLoopExpression)object;
        if (ktLoopExpression != null && !((it = (ktStatementExpression = ktLoopExpression)) instanceof KtDoWhileExpression) && ((KtLoopExpression)((Object)it)).getBody() == null) {
            return false;
        }
        PsiElement psiElement8 = nextLeaf2;
        if (Intrinsics.areEqual(psiElement8 != null && (psiElement8 = PsiUtilsKt.nextLeaf(psiElement8, (Function1<? super PsiElement, Boolean>)((Function1)isRedundant.3.INSTANCE))) != null && (psiElement8 = psiElement8.getNode()) != null ? psiElement8.getElementType() : null, (Object)((Object)KtTokens.LBRACE))) {
            return false;
        }
        if (this.isRequiredForCompanion(semicolon2)) {
            return false;
        }
        PsiElement psiElement9 = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default(semicolon2, false, 1, null);
        if (!(psiElement9 instanceof KtNameReferenceExpression)) {
            psiElement9 = null;
        }
        return (prevNameReference = (KtNameReferenceExpression)psiElement9) == null || !this.softModifierKeywords.contains(prevNameReference.getText()) || !(PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default(semicolon2, false, 1, null) instanceof KtDeclaration);
    }

    private final boolean isRequiredForCompanion(PsiElement semicolon2) {
        PsiElement $receiver$iv;
        PsiElement psiElement2 = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default(semicolon2, false, 1, null);
        if (!(psiElement2 instanceof KtObjectDeclaration)) {
            psiElement2 = null;
        }
        KtObjectDeclaration ktObjectDeclaration = (KtObjectDeclaration)psiElement2;
        if (ktObjectDeclaration == null) {
            return false;
        }
        KtObjectDeclaration prev2 = ktObjectDeclaration;
        if (!prev2.isCompanion()) {
            return false;
        }
        if (prev2.getNameIdentifier() != null || PsiTreeUtil.getChildOfType((PsiElement)($receiver$iv = (PsiElement)prev2), KtClassBody.class) != null) {
            return false;
        }
        PsiElement psiElement3 = PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default(semicolon2, false, 1, null);
        if (psiElement3 == null) {
            return false;
        }
        PsiElement next2 = psiElement3;
        PsiElement psiElement4 = next2.getFirstChild();
        if (psiElement4 == null || (psiElement4 = psiElement4.getNode()) == null) {
            return false;
        }
        PsiElement firstChildNode = psiElement4;
        return !KtTokens.KEYWORDS.contains(firstChildNode.getElementType());
    }

    private final boolean isLineBreak(@Nullable PsiElement $receiver) {
        return $receiver instanceof PsiWhiteSpace && $receiver.textContains('\n');
    }

    /*
     * WARNING - void declaration
     */
    public RedundantSemicolonInspection() {
        void var3_4;
        List list2;
        void $receiver$iv$iv;
        void $receiver$iv$iv$iv;
        void $receiver$iv;
        TokenSet tokenSet = KtTokens.SOFT_KEYWORDS;
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"KtTokens.SOFT_KEYWORDS");
        IElementType[] iElementTypeArray = tokenSet.getTypes();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementTypeArray, (String)"KtTokens.SOFT_KEYWORDS.types");
        IElementType[] iElementTypeArray2 = iElementTypeArray;
        RedundantSemicolonInspection redundantSemicolonInspection = this;
        void var2_3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (void element$iv$iv$iv : $receiver$iv$iv$iv = $receiver$iv$iv) {
            String string;
            void element$iv$iv = element$iv$iv$iv;
            void it = element$iv$iv;
            Object v2 = it;
            if (!(v2 instanceof KtModifierKeywordToken)) {
                v2 = null;
            }
            KtModifierKeywordToken ktModifierKeywordToken = v2;
            String string2 = ktModifierKeywordToken != null ? ktModifierKeywordToken.toString() : null;
            if (string2 == null) continue;
            String it$iv$iv = string = string2;
            destination$iv$iv.add(it$iv$iv);
        }
        redundantSemicolonInspection.softModifierKeywords = list2 = (List)var3_4;
    }

    public static final /* synthetic */ boolean access$isRedundant(RedundantSemicolonInspection $this, @NotNull PsiElement semicolon2) {
        return $this.isRedundant(semicolon2);
    }

    public static final /* synthetic */ boolean access$isLineBreak(RedundantSemicolonInspection $this, @Nullable PsiElement $receiver) {
        return $this.isLineBreak($receiver);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantSemicolonInspection$Fix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    private static final class Fix
    implements LocalQuickFix {
        public static final Fix INSTANCE;

        @NotNull
        public String getName() {
            return "Remove redundant semicolon";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            if (!FileModificationService.getInstance().preparePsiElementForWrite(descriptor2.getPsiElement())) {
                return;
            }
            descriptor2.getPsiElement().delete();
        }

        private Fix() {
        }

        static {
            Fix fix;
            INSTANCE = fix = new Fix();
        }
    }
}

