/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0005*\u00020\u0002H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceAssertBooleanWithAssertEqualityInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fixText", "inspectionText", "isApplicable", "", "replaceableAssertion", "Companion", "idea"})
public final class ReplaceAssertBooleanWithAssertEqualityInspection
extends AbstractApplicabilityBasedInspection<KtCallExpression> {
    @NotNull
    private final String defaultFixText = "Replace assert boolean with assert equality";
    private static final Set<String> assertions;
    private static final Map<Pair<String, KtSingleValueToken>, String> assertionMap;
    public static final Companion Companion;

    @Override
    @NotNull
    public String inspectionText(@NotNull KtCallExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return "Replace assert boolean with assert equality";
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return this.defaultFixText;
    }

    @Override
    @NotNull
    public String fixText(@NotNull KtCallExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        String string = this.replaceableAssertion(element3);
        if (string == null) {
            return this.getDefaultFixText();
        }
        String assertion = string;
        return "Replace with '" + assertion + '\'';
    }

    @Override
    public boolean isApplicable(@NotNull KtCallExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return this.replaceableAssertion(element3) != null;
    }

    @Override
    public void applyTo(@NotNull PsiElement element3, @NotNull Project project, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        PsiElement psiElement2 = element3;
        if (!(psiElement2 instanceof KtCallExpression)) {
            psiElement2 = null;
        }
        KtCallExpression ktCallExpression = (KtCallExpression)psiElement2;
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression expression2 = ktCallExpression;
        List<KtValueArgument> list2 = expression2.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"expression.valueArguments");
        KtExpression ktExpression = ((KtValueArgument)CollectionsKt.first(list2)).getArgumentExpression();
        if (!(ktExpression instanceof KtBinaryExpression)) {
            ktExpression = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktExpression;
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression condition2 = ktBinaryExpression;
        KtExpression ktExpression2 = condition2.getLeft();
        if (ktExpression2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"condition.left ?: return");
        KtExpression left = ktExpression2;
        KtExpression ktExpression3 = condition2.getRight();
        if (ktExpression3 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"condition.right ?: return");
        KtExpression right = ktExpression3;
        String string = this.replaceableAssertion(expression2);
        if (string == null) {
            return;
        }
        String assertion = string;
        KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
        if (expression2.getValueArguments().size() == 1) {
            expression2.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default(factory2, assertion + "($0, $1)", new Object[]{left, right}, false, 4, null));
        } else if (expression2.getValueArguments().size() == 2) {
            KtExpression ktExpression4 = expression2.getValueArguments().get(1).getArgumentExpression();
            if (ktExpression4 == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"expression.valueArgument\u2026entExpression() ?: return");
            KtExpression message2 = ktExpression4;
            expression2.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default(factory2, assertion + "($0, $1, $2)", new Object[]{left, right, message2}, false, 4, null));
        }
    }

    private final String replaceableAssertion(@NotNull KtCallExpression $receiver) {
        Object object;
        KtExpression ktExpression = $receiver.getCalleeExpression();
        if (!(ktExpression instanceof KtNameReferenceExpression)) {
            ktExpression = null;
        }
        if ((object = (KtNameReferenceExpression)ktExpression) == null || (object = ((KtNameReferenceExpression)object).getReferencedName()) == null) {
            return null;
        }
        Object referencedName = object;
        if (!assertions.contains(referencedName)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = UtilsKt.getCallableDescriptor($receiver);
        if (Intrinsics.areEqual((Object)(declarationDescriptor != null && (declarationDescriptor = declarationDescriptor.getContainingDeclaration()) != null ? DescriptorUtilsKt.getFqNameSafe(declarationDescriptor) : null), (Object)new FqName("kotlin.test")) ^ true) {
            return null;
        }
        if ($receiver.getValueArguments().size() != 1 && $receiver.getValueArguments().size() != 2) {
            return null;
        }
        List<KtValueArgument> list2 = $receiver.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"valueArguments");
        KtExpression ktExpression2 = ((KtValueArgument)CollectionsKt.first(list2)).getArgumentExpression();
        if (!(ktExpression2 instanceof KtBinaryExpression)) {
            ktExpression2 = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktExpression2;
        if (ktBinaryExpression == null) {
            return null;
        }
        KtBinaryExpression binaryExpression = ktBinaryExpression;
        IElementType iElementType = binaryExpression.getOperationToken();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"binaryExpression.operationToken");
        IElementType operationToken = iElementType;
        Map<Pair<String, KtSingleValueToken>, String> map2 = assertionMap;
        Pair pair2 = new Pair(referencedName, (Object)operationToken);
        return map2.get(pair2);
    }

    public ReplaceAssertBooleanWithAssertEqualityInspection() {
        super(KtCallExpression.class);
    }

    static {
        Companion = new Companion(null);
        assertions = SetsKt.setOf((Object[])new String[]{"assertTrue", "assertFalse"});
        assertionMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)new Pair((Object)"assertTrue", (Object)KtTokens.EQEQ), (Object)"assertEquals"), TuplesKt.to((Object)new Pair((Object)"assertTrue", (Object)KtTokens.EQEQEQ), (Object)"assertSame"), TuplesKt.to((Object)new Pair((Object)"assertFalse", (Object)KtTokens.EQEQ), (Object)"assertNotEquals"), TuplesKt.to((Object)new Pair((Object)"assertFalse", (Object)KtTokens.EQEQEQ), (Object)"assertNotSame")});
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R.\u0010\u0003\u001a\"\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceAssertBooleanWithAssertEqualityInspection$Companion;", "", "()V", "assertionMap", "", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "assertions", "", "idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

