/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.migration;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.actions.RunInspectionIntention;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteExperimentalCoroutinesInspection;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteCoroutineUsageInWholeFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "startInWriteAction", "", "Companion", "idea"})
final class ObsoleteCoroutineUsageInWholeFix
implements LocalQuickFix {
    @NotNull
    private static final ObsoleteCoroutineUsageInWholeFix INSTANCE;
    public static final Companion Companion;

    @NotNull
    public String getFamilyName() {
        return "Fix experimental coroutines usages in the project";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        InspectionProjectProfileManager inspectionProjectProfileManager = InspectionProjectProfileManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)inspectionProjectProfileManager, (String)"InspectionProjectProfile\u2026ager.getInstance(project)");
        InspectionToolWrapper inspectionToolWrapper = inspectionProjectProfileManager.getCurrentProfile().getInspectionTool(new ObsoleteExperimentalCoroutinesInspection().getShortName(), project);
        if (inspectionToolWrapper == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)inspectionToolWrapper, (String)"InspectionProjectProfile\u2026      project\n        )!!");
        InspectionToolWrapper toolWrapper = inspectionToolWrapper;
        ObsoleteCoroutineUsageInWholeFix.Companion.runToolInProject(project, toolWrapper);
    }

    public boolean startInWriteAction() {
        return false;
    }

    static {
        Companion = new Companion(null);
        INSTANCE = new ObsoleteCoroutineUsageInWholeFix();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\nH\u0086\b\u00a2\u0006\u0002\u0010\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0011H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteCoroutineUsageInWholeFix$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteCoroutineUsageInWholeFix;", "getINSTANCE", "()Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteCoroutineUsageInWholeFix;", "runInInspectionProfileInitMode", "T", "runnable", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "runToolInProject", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWrapper", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "idea"})
    public static final class Companion {
        @NotNull
        public final ObsoleteCoroutineUsageInWholeFix getINSTANCE() {
            return INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void runToolInProject(Project project, InspectionToolWrapper<?, ?> toolWrapper) {
            InspectionProfileImpl inspectionProfileImpl;
            InspectionManager inspectionManager = InspectionManager.getInstance((Project)project);
            if (inspectionManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.codeInspection.ex.InspectionManagerEx");
            }
            InspectionManagerEx managerEx = (InspectionManagerEx)inspectionManager;
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(project)");
            GlobalSearchScope kotlinSourcesScope = KotlinSourceFilterScope.Companion.projectSources(globalSearchScope, project);
            AnalysisScope cleanupScope = new AnalysisScope((SearchScope)kotlinSourcesScope, project);
            Companion this_$iv = this;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isUnitTestMode()) {
                inspectionProfileImpl = RunInspectionIntention.createProfile(toolWrapper, (InspectionManagerEx)managerEx, null);
            } else {
                InspectionProfileImpl inspectionProfileImpl2;
                boolean old$iv = InspectionProfileImpl.INIT_INSPECTIONS;
                try {
                    InspectionProfileImpl.INIT_INSPECTIONS = true;
                    inspectionProfileImpl2 = RunInspectionIntention.createProfile(toolWrapper, (InspectionManagerEx)managerEx, null);
                }
                finally {
                    InspectionProfileImpl.INIT_INSPECTIONS = old$iv;
                }
                inspectionProfileImpl = inspectionProfileImpl2;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)inspectionProfileImpl, (String)"runInInspectionProfileIn\u2026apper, managerEx, null) }");
            InspectionProfileImpl cleanupToolProfile = inspectionProfileImpl;
            managerEx.createNewGlobalContext(false).codeCleanup(cleanupScope, (InspectionProfile)cleanupToolProfile, "Apply in the project: " + toolWrapper.getDisplayName(), null, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T runInInspectionProfileInitMode(@NotNull Function0<? extends T> runnable) {
            Object object;
            Intrinsics.checkParameterIsNotNull(runnable, (String)"runnable");
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isUnitTestMode()) {
                object = runnable.invoke();
            } else {
                Object object2;
                boolean old = InspectionProfileImpl.INIT_INSPECTIONS;
                try {
                    InspectionProfileImpl.INIT_INSPECTIONS = true;
                    object2 = runnable.invoke();
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    InspectionProfileImpl.INIT_INSPECTIONS = old;
                    InlineMarker.finallyEnd((int)1);
                }
                object = object2;
            }
            return (T)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

