/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.conversion.copy.RangeUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatchStatus;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddNameToArgumentIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "allowCaretInsideElement", "", "element", "Lcom/intellij/psi/PsiElement;", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "detectNameToAdd", "Lorg/jetbrains/kotlin/name/Name;", "argument", "isApplicableTo", "caretOffset", "", "idea"})
public final class AddNameToArgumentIntention
extends SelfTargetingIntention<KtValueArgument>
implements LowPriorityAction {
    @Override
    public boolean isApplicableTo(@NotNull KtValueArgument element3, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = element3.getArgumentExpression();
        if (ktExpression == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"element.getArgumentExpression() ?: return false");
        KtExpression expression2 = ktExpression;
        Name name2 = this.detectNameToAdd(element3);
        if (name2 == null) {
            return false;
        }
        Name name3 = name2;
        this.setText("Add '" + name3 + " =' to argument");
        if (expression2 instanceof KtLambdaExpression) {
            TextRange range;
            TextRange textRange = range = ((KtLambdaExpression)expression2).getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"range");
            return caretOffset == RangeUtilsKt.getStart(textRange) || caretOffset == RangeUtilsKt.getEnd(range);
        }
        return true;
    }

    @Override
    protected boolean allowCaretInsideElement(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return !(element3 instanceof KtValueArgumentList) && !(element3 instanceof KtContainerNode) && super.allowCaretInsideElement(element3);
    }

    @Override
    public void applyTo(@NotNull KtValueArgument element3, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Name name2 = this.detectNameToAdd(element3);
        if (name2 == null) {
            Intrinsics.throwNpe();
        }
        Name name3 = name2;
        KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
        KtExpression ktExpression = element3.getArgumentExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtValueArgument newArgument = KtPsiFactory.createArgument$default(ktPsiFactory, ktExpression, name3, element3.getSpreadElement() != null, false, 8, null);
        element3.replace((PsiElement)newArgument);
    }

    /*
     * WARNING - void declaration
     */
    private final Name detectNameToAdd(KtValueArgument argument2) {
        Object element$iv;
        KtValueArgument ktValueArgument;
        KtValueArgumentList argumentList2;
        block17: {
            void $receiver$iv;
            if (argument2.isNamed()) {
                return null;
            }
            if (argument2 instanceof KtLambdaArgument) {
                return null;
            }
            PsiElement psiElement2 = argument2.getParent();
            if (!(psiElement2 instanceof KtValueArgumentList)) {
                psiElement2 = null;
            }
            KtValueArgumentList ktValueArgumentList = (KtValueArgumentList)psiElement2;
            if (ktValueArgumentList == null) {
                return null;
            }
            argumentList2 = ktValueArgumentList;
            List<KtValueArgument> list2 = argumentList2.getArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"argumentList.arguments");
            List<KtValueArgument> list3 = list2;
            ktValueArgument = argument2;
            ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
            while (iterator$iv.hasPrevious()) {
                element$iv = iterator$iv.previous();
                KtValueArgument it = (KtValueArgument)element$iv;
                if (!(!it.isNamed())) continue;
                break block17;
            }
            throw (Throwable)new NoSuchElementException("List contains no element matching the predicate.");
        }
        Object e = element$iv;
        if (Intrinsics.areEqual((Object)ktValueArgument, (Object)((KtValueArgument)e)) ^ true) {
            return null;
        }
        PsiElement psiElement3 = argumentList2.getParent();
        if (!(psiElement3 instanceof KtCallElement)) {
            psiElement3 = null;
        }
        KtCallElement ktCallElement = (KtCallElement)psiElement3;
        if (ktCallElement == null) {
            return null;
        }
        KtCallElement callExpr = ktCallElement;
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default(callExpr, null, 1, null);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        ArgumentMapping argumentMapping = resolvedCall3.getArgumentMapping(argument2);
        if (!(argumentMapping instanceof ArgumentMatch)) {
            argumentMapping = null;
        }
        ArgumentMatch argumentMatch = (ArgumentMatch)argumentMapping;
        if (argumentMatch == null) {
            return null;
        }
        ArgumentMatch argumentMatch2 = argumentMatch;
        if (argumentMatch2.getStatus() != ArgumentMatchStatus.SUCCESS) {
            return null;
        }
        if (!resolvedCall3.getResultingDescriptor().hasStableParameterNames()) {
            return null;
        }
        if (argumentMatch2.getValueParameter().getVarargElementType() != null) {
            ResolvedValueArgument resolvedValueArgument = resolvedCall3.getValueArguments().get(argumentMatch2.getValueParameter());
            if (!(resolvedValueArgument instanceof VarargValueArgument)) {
                resolvedValueArgument = null;
            }
            VarargValueArgument varargValueArgument = (VarargValueArgument)resolvedValueArgument;
            if (varargValueArgument == null) {
                return null;
            }
            VarargValueArgument varargArgument = varargValueArgument;
            if (varargArgument.getArguments().size() != 1) {
                return null;
            }
        }
        return argumentMatch2.getValueParameter().getName();
    }

    public AddNameToArgumentIntention() {
        super(KtValueArgument.class, "Add name to argument", null, 4, null);
    }
}

