/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.internal;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.internal.KotlinBytecodeDecompilerTask;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\u00a8\u0006\f"}, d2={"KOTLIN_DECOMPILED_FOLDER", "", "getKOTLIN_DECOMPILED_FOLDER", "()Ljava/lang/String;", "KOTLIN_DECOMPILED_ROOT", "getKOTLIN_DECOMPILED_ROOT", "getOrCreateDummyRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "showDecompiledCode", "", "sourceFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "idea"})
public final class KotlinDecompilerAdapterKt {
    @NotNull
    private static final String KOTLIN_DECOMPILED_FOLDER = "kotlinDecompiled";
    @NotNull
    private static final String KOTLIN_DECOMPILED_ROOT = "dummy://kotlinDecompiled";

    public static final void showDecompiledCode(@NotNull KtFile sourceFile) {
        Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
        ProgressManager.getInstance().run((Task)new KotlinBytecodeDecompilerTask(sourceFile));
    }

    @NotNull
    public static final String getKOTLIN_DECOMPILED_FOLDER() {
        return KOTLIN_DECOMPILED_FOLDER;
    }

    @NotNull
    public static final String getKOTLIN_DECOMPILED_ROOT() {
        return KOTLIN_DECOMPILED_ROOT;
    }

    @NotNull
    public static final VirtualFile getOrCreateDummyRoot() {
        VirtualFile virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(KOTLIN_DECOMPILED_ROOT);
        if (virtualFile == null) {
            VirtualFile virtualFile2 = DummyFileSystem.getInstance().createRoot(KOTLIN_DECOMPILED_FOLDER);
            virtualFile = virtualFile2;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"DummyFileSystem.getInsta\u2026KOTLIN_DECOMPILED_FOLDER)");
        }
        return virtualFile;
    }

    static {
        KOTLIN_DECOMPILED_FOLDER = KOTLIN_DECOMPILED_FOLDER;
        KOTLIN_DECOMPILED_ROOT = "dummy://" + KOTLIN_DECOMPILED_FOLDER;
    }
}

