/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.changePackage;

import com.intellij.CommonBundle;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.AutocreatingSingleSourceRootMoveDestination;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.changePackage.KotlinChangePackageRefactoring;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/changePackage/PackageDirectoryMismatchInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "ChangePackageFix", "MoveFileToPackageFix", "idea"})
public final class PackageDirectoryMismatchInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            public void visitPackageDirective(@NotNull KtPackageDirective directive) {
                LocalQuickFix[] localQuickFixArray;
                void $receiver$iv;
                FqName fqNameWithImplicitPrefix;
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)directive, (String)"directive");
                super.visitPackageDirective(directive);
                String string = directive.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"directive.text");
                CharSequence charSequence = string;
                if (charSequence.length() == 0) {
                    return;
                }
                KtFile ktFile = directive.getContainingKtFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"directive.containingKtFile");
                KtFile file = ktFile;
                if (KotlinRefactoringUtilKt.isInjectedFragment((PsiFile)file) || PackageUtilsKt.packageMatchesDirectoryOrImplicit(file)) {
                    return;
                }
                List fixes = new ArrayList<E>();
                String string2 = directive.getQualifiedName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"directive.qualifiedName");
                String qualifiedName2 = string2;
                Object object2 = qualifiedName2;
                String dirName = object2.length() == 0 ? "source root" : '\'' + StringsKt.replace$default((String)qualifiedName2, (char)'.', (char)'/', (boolean)false, (int)4, null) + '\'';
                object2 = fixes;
                Object object3 = new MoveFileToPackageFix(dirName);
                object2.add(object3);
                FqName fqNameByDirectory = PackageUtilsKt.getFqNameByDirectory((PsiFile)file);
                if (fqNameByDirectory.isRoot()) {
                    object3 = fixes;
                    object = new ChangePackageFix("source root", fqNameByDirectory);
                    object3.add(object);
                } else if (KotlinRefactoringUtilKt.hasIdentifiersOnly(fqNameByDirectory)) {
                    object3 = fixes;
                    object = new ChangePackageFix('\'' + fqNameByDirectory.asString() + '\'', fqNameByDirectory);
                    object3.add(object);
                }
                PsiDirectory psiDirectory = file.getParent();
                FqName fqName2 = fqNameWithImplicitPrefix = psiDirectory != null ? PackageUtilsKt.getFqNameWithImplicitPrefix(psiDirectory) : null;
                if (fqNameWithImplicitPrefix != null && Intrinsics.areEqual((Object)fqNameWithImplicitPrefix, (Object)fqNameByDirectory) ^ true) {
                    object = fixes;
                    ChangePackageFix changePackageFix = new ChangePackageFix('\'' + fqNameWithImplicitPrefix.asString() + '\'', fqNameWithImplicitPrefix);
                    object.add(changePackageFix);
                }
                object = fixes;
                ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                String string3 = "Package directive doesn't match file location";
                PsiElement psiElement2 = directive;
                ProblemsHolder problemsHolder = this.$holder;
                void thisCollection$iv = $receiver$iv;
                LocalQuickFix[] localQuickFixArray2 = thisCollection$iv.toArray(new LocalQuickFix[0]);
                if (localQuickFixArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                LocalQuickFix[] localQuickFixArray3 = localQuickFixArray = localQuickFixArray2;
                problemsHolder.registerProblem(psiElement2, string3, problemHighlightType, Arrays.copyOf(localQuickFixArray3, localQuickFixArray3.length));
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/changePackage/PackageDirectoryMismatchInspection$MoveFileToPackageFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "dirName", "", "(Ljava/lang/String;)V", "getDirName", "()Ljava/lang/String;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "startInWriteAction", "", "idea"})
    private static final class MoveFileToPackageFix
    implements LocalQuickFix {
        @NotNull
        private final String dirName;

        @NotNull
        public String getFamilyName() {
            return "Move file to package-matching directory";
        }

        @NotNull
        public String getName() {
            return "Move file to " + this.dirName;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtPackageDirective)) {
                psiElement2 = null;
            }
            KtPackageDirective ktPackageDirective = (KtPackageDirective)psiElement2;
            if (ktPackageDirective == null) {
                return;
            }
            KtPackageDirective directive = ktPackageDirective;
            KtFile ktFile = directive.getContainingKtFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"directive.containingKtFile");
            KtFile file = ktFile;
            List list2 = JavaProjectRootsUtil.getSuitableDestinationSourceRoots((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"JavaProjectRootsUtil.get\u2026ationSourceRoots(project)");
            List sourceRoots = list2;
            PackageWrapper packageWrapper = new PackageWrapper(PsiManager.getInstance((Project)project), directive.getQualifiedName());
            PsiFile psiFile = directive.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"directive.containingFile");
            PsiFile fileToMove = psiFile;
            VirtualFile virtualFile = (VirtualFile)CollectionsKt.singleOrNull((List)sourceRoots);
            if (virtualFile == null) {
                virtualFile = MoveClassesOrPackagesUtil.chooseSourceRoot((PackageWrapper)packageWrapper, (List)sourceRoots, (PsiDirectory)fileToMove.getContainingDirectory());
            }
            if (virtualFile == null) {
                return;
            }
            VirtualFile chosenRoot = virtualFile;
            AutocreatingSingleSourceRootMoveDestination targetDirFactory = new AutocreatingSingleSourceRootMoveDestination(packageWrapper, chosenRoot);
            String string = targetDirFactory.verify(fileToMove);
            if (string != null) {
                String string2;
                String it = string2 = string;
                Messages.showMessageDialog((Project)project, (String)it, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
            PsiDirectory psiDirectory = (PsiDirectory)ApplicationUtilsKt.runWriteAction((Function0)new Function0<PsiDirectory>(targetDirFactory, fileToMove){
                final /* synthetic */ AutocreatingSingleSourceRootMoveDestination $targetDirFactory;
                final /* synthetic */ PsiFile $fileToMove;

                public final PsiDirectory invoke() {
                    return this.$targetDirFactory.getTargetDirectory(this.$fileToMove);
                }
                {
                    this.$targetDirFactory = autocreatingSingleSourceRootMoveDestination;
                    this.$fileToMove = psiFile;
                    super(0);
                }
            });
            if (psiDirectory == null) {
                return;
            }
            PsiDirectory targetDirectory2 = psiDirectory;
            String string3 = RefactoringMessageUtil.checkCanCreateFile((PsiDirectory)targetDirectory2, (String)file.getName());
            if (string3 != null) {
                String string4;
                String it = string4 = string3;
                Messages.showMessageDialog((Project)project, (String)it, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return;
            }
            ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(file, targetDirectory2){
                final /* synthetic */ KtFile $file;
                final /* synthetic */ PsiDirectory $targetDirectory;

                public final void invoke() {
                    MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)((PsiFile)this.$file), (PsiDirectory)this.$targetDirectory);
                }
                {
                    this.$file = ktFile;
                    this.$targetDirectory = psiDirectory;
                    super(0);
                }
            });
        }

        @NotNull
        public final String getDirName() {
            return this.dirName;
        }

        public MoveFileToPackageFix(@NotNull String dirName) {
            Intrinsics.checkParameterIsNotNull((Object)dirName, (String)"dirName");
            this.dirName = dirName;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/changePackage/PackageDirectoryMismatchInspection$ChangePackageFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "packageName", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/name/FqName;)V", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getPackageName", "()Ljava/lang/String;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea"})
    private static final class ChangePackageFix
    implements LocalQuickFix {
        @NotNull
        private final String packageName;
        @NotNull
        private final FqName packageFqName;

        @NotNull
        public String getFamilyName() {
            return "Change file's package to match directory";
        }

        @NotNull
        public String getName() {
            return "Change file's package to " + this.packageName;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtPackageDirective)) {
                psiElement2 = null;
            }
            KtPackageDirective ktPackageDirective = (KtPackageDirective)psiElement2;
            if (ktPackageDirective == null) {
                return;
            }
            KtPackageDirective directive = ktPackageDirective;
            KtFile ktFile = directive.getContainingKtFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"directive.containingKtFile");
            KtFile file = ktFile;
            new KotlinChangePackageRefactoring(file).run(this.packageFqName);
        }

        @NotNull
        public final String getPackageName() {
            return this.packageName;
        }

        @NotNull
        public final FqName getPackageFqName() {
            return this.packageFqName;
        }

        public ChangePackageFix(@NotNull String packageName, @NotNull FqName packageFqName) {
            Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
            Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
            this.packageName = packageName;
            this.packageFqName = packageFqName;
        }
    }
}

