/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.coroutine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDebugger;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.coroutine.CoroutineBlock;
import org.jetbrains.kotlin.js.coroutine.CoroutineMetadataPropertiesKt;
import org.jetbrains.kotlin.js.coroutine.CoroutinePassesKt;
import org.jetbrains.kotlin.js.coroutine.CoroutineTransformationContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002fgB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0(2\u0006\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\"H\u0002J\b\u0010+\u001a\u00020,H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020.H\u0002J\u0018\u00100\u001a\u00020,2\u0006\u00101\u001a\u00020.2\u0006\u00102\u001a\u00020.H\u0002J\b\u00103\u001a\u00020\u001aH\u0002J\b\u00104\u001a\u00020\u0007H\u0002J \u00105\u001a\u00020,2\u0006\u00106\u001a\u00020\u00142\u0006\u00107\u001a\u00020\r2\u0006\u0010*\u001a\u00020\"H\u0002J\f\u00108\u001a\b\u0012\u0004\u0012\u00020\r0(J\u000e\u00109\u001a\u00020,2\u0006\u0010:\u001a\u00020\"J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020\r0(2\u0006\u00106\u001a\u00020\u0014H\u0002J\u001f\u0010<\u001a\u00020,2\u0006\u0010=\u001a\u00020\b2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020,0?H\u0082\bJ\u001e\u0010@\u001a\b\u0012\u0004\u0012\u00020\b0(2\u0006\u0010)\u001a\u00020\r2\u0006\u0010A\u001a\u00020\"H\u0002J\u001e\u0010B\u001a\b\u0012\u0004\u0012\u00020\b0(2\u0006\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\"H\u0002J\u001c\u0010C\u001a\b\u0012\u0004\u0012\u00020\b0(2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\r0(H\u0002J\u0010\u0010E\u001a\u00020,2\u0006\u0010F\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020,2\u0006\u0010F\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020,2\u0006\u0010F\u001a\u00020KH\u0016J\u0010\u0010L\u001a\u00020,2\u0006\u0010F\u001a\u00020\u0007H\u0016J\u0010\u0010M\u001a\u00020,2\u0006\u0010F\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020,2\u0006\u0010F\u001a\u00020PH\u0016J\u0010\u0010Q\u001a\u00020,2\u0006\u0010F\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020,2\u0006\u0010F\u001a\u00020TH\u0016J\u0010\u0010U\u001a\u00020,2\u0006\u0010F\u001a\u00020VH\u0016J\u0010\u0010W\u001a\u00020,2\u0006\u0010F\u001a\u00020XH\u0016J\u0010\u0010Y\u001a\u00020,2\u0006\u0010F\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020,2\u0006\u0010F\u001a\u00020\\H\u0016J\u0010\u0010]\u001a\u00020,2\u0006\u0010F\u001a\u00020^H\u0016J\u0010\u0010_\u001a\u00020,2\u0006\u0010F\u001a\u00020`H\u0016J\u0010\u0010a\u001a\u00020,2\u0006\u0010F\u001a\u00020bH\u0016J2\u0010c\u001a\u00020,2\u0006\u0010=\u001a\u00020\b2\u0006\u0010d\u001a\u00020\r2\n\b\u0002\u0010e\u001a\u0004\u0018\u00010\r2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020,0?H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a8F@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006h"}, d2={"Lorg/jetbrains/kotlin/js/coroutine/CoroutineBodyTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "context", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineTransformationContext;", "(Lorg/jetbrains/kotlin/js/coroutine/CoroutineTransformationContext;)V", "breakContinueTargetStatements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsContinue;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "breakTargets", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineBodyTransformer$JumpTarget;", "continueTargets", "currentBlock", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;", "currentCatchBlock", "currentStatements", "", "getCurrentStatements", "()Ljava/util/List;", "currentTryDepth", "", "getCurrentTryDepth", "()I", "entryBlock", "globalCatchBlock", "<set-?>", "", "hasFinallyBlocks", "getHasFinallyBlocks", "()Z", "setHasFinallyBlocks", "(Z)V", "nodesToSplit", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "referencedBlocks", "", "tryStack", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineBodyTransformer$TryBlock;", "exceptionState", "", "target", "fromNode", "generateFinallyExit", "", "handleExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "expression", "handleSuspend", "invocation", "sourceNode", "hasEnclosingFinallyBlock", "jump", "jumpWithFinally", "targetTryDepth", "successor", "postProcess", "preProcess", "node", "relativeFinallyPath", "splitIfNecessary", "statement", "action", "Lkotlin/Function0;", "state", "fromExpression", "stateAndJump", "updateFinallyPath", "path", "visit", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsSwitch;", "visitBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "visitBreak", "Lorg/jetbrains/kotlin/js/backend/ast/JsBreak;", "visitContinue", "visitDebugger", "Lorg/jetbrains/kotlin/js/backend/ast/JsDebugger;", "visitDoWhile", "Lorg/jetbrains/kotlin/js/backend/ast/JsDoWhile;", "visitExpressionStatement", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpressionStatement;", "visitFor", "Lorg/jetbrains/kotlin/js/backend/ast/JsFor;", "visitIf", "Lorg/jetbrains/kotlin/js/backend/ast/JsIf;", "visitLabel", "Lorg/jetbrains/kotlin/js/backend/ast/JsLabel;", "visitReturn", "Lorg/jetbrains/kotlin/js/backend/ast/JsReturn;", "visitThrow", "Lorg/jetbrains/kotlin/js/backend/ast/JsThrow;", "visitTry", "Lorg/jetbrains/kotlin/js/backend/ast/JsTry;", "visitVars", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "visitWhile", "Lorg/jetbrains/kotlin/js/backend/ast/JsWhile;", "withBreakAndContinue", "breakBlock", "continueBlock", "JumpTarget", "TryBlock", "js.translator"})
public final class CoroutineBodyTransformer
extends RecursiveJsVisitor {
    private final CoroutineBlock entryBlock;
    private final CoroutineBlock globalCatchBlock;
    private CoroutineBlock currentBlock;
    private final Map<JsContinue, JsStatement> breakContinueTargetStatements;
    private final Map<JsStatement, JumpTarget> breakTargets;
    private final Map<JsStatement, JumpTarget> continueTargets;
    private final Set<CoroutineBlock> referencedBlocks;
    private Set<? extends JsNode> nodesToSplit;
    private CoroutineBlock currentCatchBlock;
    private final List<TryBlock> tryStack;
    private boolean hasFinallyBlocks;
    private final CoroutineTransformationContext context;

    private final List<JsStatement> getCurrentStatements() {
        return this.currentBlock.getStatements();
    }

    public final boolean getHasFinallyBlocks() {
        return this.hasFinallyBlocks;
    }

    private final void setHasFinallyBlocks(boolean bl) {
        this.hasFinallyBlocks = bl;
    }

    private final int getCurrentTryDepth() {
        return CollectionsKt.getLastIndex(this.tryStack);
    }

    public final void preProcess(@NotNull JsNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Map<JsContinue, JsStatement> map2 = this.breakContinueTargetStatements;
        Map<JsContinue, JsStatement> map3 = CollectUtilsKt.collectBreakContinueTargets(node);
        map2.putAll(map3);
        this.nodesToSplit = CoroutinePassesKt.collectNodesToSplit(node, this.breakContinueTargetStatements);
    }

    @NotNull
    public final List<CoroutineBlock> postProcess() {
        List<CoroutineBlock> orderedBlocks2;
        Collection collection = this.currentBlock.getStatements();
        JsReturn jsReturn = new JsReturn();
        collection.add(jsReturn);
        Map<CoroutineBlock, Set<CoroutineBlock>> graph2 = CoroutinePassesKt.buildGraph(this.entryBlock, this.globalCatchBlock);
        List<CoroutineBlock> list2 = orderedBlocks2 = DFS.topologicalOrder(CollectionsKt.listOf((Object)this.entryBlock), new DFS.Neighbors<N>(graph2){
            final /* synthetic */ Map $graph;

            @NotNull
            public final Set<CoroutineBlock> getNeighbors(CoroutineBlock it) {
                Set set2 = (Set)this.$graph.get(it);
                Set set3 = set2;
                if (set3 == null) {
                    set3 = SetsKt.emptySet();
                }
                return set3;
            }
            {
                this.$graph = map2;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"orderedBlocks");
        CoroutinePassesKt.replaceCoroutineFlowStatements(list2, this.context);
        return orderedBlocks2;
    }

    @Override
    public void visitBlock(@NotNull JsBlock x) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        CoroutineBodyTransformer this_$iv = this;
        if (CoroutineBodyTransformer.access$getNodesToSplit$p(this_$iv).contains(x)) {
            for (JsStatement statement2 : x.getStatements()) {
                statement2.accept(this);
            }
        } else {
            Collection collection = this_$iv.getCurrentStatements();
            collection.add((JsStatement)x);
        }
    }

    @Override
    public void visitIf(@NotNull JsIf x) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        CoroutineBodyTransformer this_$iv = this;
        if (CoroutineBodyTransformer.access$getNodesToSplit$p(this_$iv).contains(x)) {
            CoroutineBlock elseEntryBlock;
            CoroutineBlock thenEntryBlock;
            CoroutineBlock ifBlock = this.currentBlock;
            this.currentBlock = thenEntryBlock = new CoroutineBlock();
            x.getThenStatement().accept(this);
            CoroutineBlock thenExitBlock = this.currentBlock;
            this.currentBlock = elseEntryBlock = new CoroutineBlock();
            JsStatement jsStatement = x.getElseStatement();
            if (jsStatement != null) {
                jsStatement.accept(this);
            }
            CoroutineBlock elseExitBlock = this.currentBlock;
            x.setThenStatement(new JsBlock(thenEntryBlock.getStatements()));
            x.setElseStatement(new JsBlock(elseEntryBlock.getStatements()));
            Collection collection = ifBlock.getStatements();
            Object object = x;
            collection.add(object);
            CoroutineBlock jointBlock = new CoroutineBlock();
            object = thenExitBlock.getStatements();
            Iterable iterable = this.stateAndJump(jointBlock, x);
            CollectionsKt.addAll((Collection)object, (Iterable)iterable);
            object = elseExitBlock.getStatements();
            iterable = this.stateAndJump(jointBlock, x);
            CollectionsKt.addAll((Collection)object, (Iterable)iterable);
            this.currentBlock = jointBlock;
        } else {
            Collection collection = this_$iv.getCurrentStatements();
            collection.add((JsStatement)x);
        }
    }

    @Override
    public void visit(@NotNull JsSwitch x) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        CoroutineBodyTransformer this_$iv = this;
        if (CoroutineBodyTransformer.access$getNodesToSplit$p(this_$iv).contains(x)) {
            CoroutineBlock switchBlock = this.currentBlock;
            CoroutineBlock jointBlock = new CoroutineBlock();
            this.withBreakAndContinue(x, jointBlock, null, (Function0<Unit>)((Function0)new Function0<Unit>(this, x){
                final /* synthetic */ CoroutineBodyTransformer this$0;
                final /* synthetic */ JsSwitch $x$inlined;
                {
                    this.this$0 = coroutineBodyTransformer;
                    this.$x$inlined = jsSwitch;
                    super(0);
                }

                public final void invoke() {
                    for (JsSwitchMember jsCase : this.$x$inlined.getCases()) {
                        CoroutineBlock caseBlock = new CoroutineBlock();
                        CoroutineBodyTransformer.access$setCurrentBlock$p(this.this$0, caseBlock);
                        JsSwitchMember jsSwitchMember = jsCase;
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsSwitchMember, (String)"jsCase");
                        List<JsStatement> list2 = jsSwitchMember.getStatements();
                        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"jsCase.statements");
                        Iterable $receiver$iv = list2;
                        for (T element$iv : $receiver$iv) {
                            JsStatement it = (JsStatement)element$iv;
                            this.this$0.accept((JsNode)it);
                        }
                        jsCase.getStatements().clear();
                        Collection collection = jsCase.getStatements();
                        Iterable iterable = caseBlock.getStatements();
                        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                    }
                }
            }));
            Collection collection = switchBlock.getStatements();
            JsSwitch jsSwitch = x;
            collection.add(jsSwitch);
            this.currentBlock = jointBlock;
        } else {
            Collection collection = this_$iv.getCurrentStatements();
            collection.add((JsStatement)x);
        }
    }

    @Override
    public void visitLabel(@NotNull JsLabel x) {
        JsStatement inner;
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        JsStatement jsStatement = inner = x.getStatement();
        if (jsStatement instanceof JsWhile || jsStatement instanceof JsDoWhile || jsStatement instanceof JsFor) {
            Set<? extends JsNode> set2 = this.nodesToSplit;
            if (set2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"nodesToSplit");
            }
            if (set2.contains(x)) {
                inner.accept(this);
            } else {
                Collection collection = this.getCurrentStatements();
                collection.add(x);
            }
        } else {
            CoroutineBodyTransformer this_$iv = this;
            if (CoroutineBodyTransformer.access$getNodesToSplit$p(this_$iv).contains(x)) {
                CoroutineBlock successor = new CoroutineBlock();
                JsStatement jsStatement2 = x.getStatement();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement2, (String)"x.statement");
                this.withBreakAndContinue(jsStatement2, successor, null, (Function0<Unit>)((Function0)new Function0<Unit>(this, x, inner){
                    final /* synthetic */ CoroutineBodyTransformer this$0;
                    final /* synthetic */ JsLabel $x$inlined;
                    final /* synthetic */ JsStatement $inner$inlined;
                    {
                        this.this$0 = coroutineBodyTransformer;
                        this.$x$inlined = jsLabel;
                        this.$inner$inlined = jsStatement;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.accept((JsNode)this.$inner$inlined);
                    }
                }));
                if (this.referencedBlocks.contains(successor)) {
                    Collection collection = this.currentBlock.getStatements();
                    Iterable iterable = this.stateAndJump(successor, x);
                    CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                    this.currentBlock = successor;
                }
            } else {
                Collection collection = this_$iv.getCurrentStatements();
                collection.add((JsStatement)x);
            }
        }
    }

    @Override
    public void visitWhile(@NotNull JsWhile x) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        CoroutineBodyTransformer this_$iv = this;
        if (CoroutineBodyTransformer.access$getNodesToSplit$p(this_$iv).contains(x)) {
            CoroutineBlock successor = new CoroutineBlock();
            CoroutineBlock bodyEntryBlock = new CoroutineBlock();
            Collection collection = this.getCurrentStatements();
            Object object = this.stateAndJump(bodyEntryBlock, x);
            CollectionsKt.addAll((Collection)collection, (Iterable)object);
            this.currentBlock = bodyEntryBlock;
            if (!JsBooleanLiteral.isTrue(x.getCondition())) {
                collection = this.getCurrentStatements();
                Object $receiver = object = new JsIf(JsAstUtils.notOptimized(x.getCondition()), new JsBlock(this.stateAndJump(successor, x)));
                ((SourceInfoAwareJsNode)$receiver).setSource(x.getSource());
                collection.add(object);
            }
            this.withBreakAndContinue(x, successor, bodyEntryBlock, (Function0<Unit>)((Function0)new Function0<Unit>(this, x){
                final /* synthetic */ CoroutineBodyTransformer this$0;
                final /* synthetic */ JsWhile $x$inlined;
                {
                    this.this$0 = coroutineBodyTransformer;
                    this.$x$inlined = jsWhile;
                    super(0);
                }

                public final void invoke() {
                    this.$x$inlined.getBody().accept(this.this$0);
                }
            }));
            collection = this.getCurrentStatements();
            object = this.stateAndJump(bodyEntryBlock, x);
            CollectionsKt.addAll((Collection)collection, (Iterable)object);
            this.currentBlock = successor;
        } else {
            Collection collection = this_$iv.getCurrentStatements();
            collection.add((JsStatement)x);
        }
    }

    @Override
    public void visitDoWhile(@NotNull JsDoWhile x) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        CoroutineBodyTransformer this_$iv = this;
        if (CoroutineBodyTransformer.access$getNodesToSplit$p(this_$iv).contains(x)) {
            CoroutineBlock successor = new CoroutineBlock();
            CoroutineBlock bodyEntryBlock = new CoroutineBlock();
            Collection collection = this.getCurrentStatements();
            Object object = this.stateAndJump(bodyEntryBlock, x);
            CollectionsKt.addAll((Collection)collection, (Iterable)object);
            this.currentBlock = bodyEntryBlock;
            this.withBreakAndContinue(x, successor, bodyEntryBlock, (Function0<Unit>)((Function0)new Function0<Unit>(this, x){
                final /* synthetic */ CoroutineBodyTransformer this$0;
                final /* synthetic */ JsDoWhile $x$inlined;
                {
                    this.this$0 = coroutineBodyTransformer;
                    this.$x$inlined = jsDoWhile;
                    super(0);
                }

                public final void invoke() {
                    this.$x$inlined.getBody().accept(this.this$0);
                }
            }));
            if (!JsBooleanLiteral.isTrue(x.getCondition())) {
                Object $receiver = object = new JsIf(JsAstUtils.notOptimized(x.getCondition()), new JsBlock(this.stateAndJump(successor, x)));
                ((SourceInfoAwareJsNode)$receiver).setSource(x.getSource());
                Object jsIf = object;
                this.getCurrentStatements().add((JsStatement)jsIf);
            }
            collection = this.currentBlock.getStatements();
            object = this.stateAndJump(bodyEntryBlock, x);
            CollectionsKt.addAll((Collection)collection, (Iterable)object);
            this.currentBlock = successor;
        } else {
            Collection collection = this_$iv.getCurrentStatements();
            collection.add((JsStatement)x);
        }
    }

    @Override
    public void visitFor(@NotNull JsFor x) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        CoroutineBodyTransformer this_$iv = this;
        if (CoroutineBodyTransformer.access$getNodesToSplit$p(this_$iv).contains(x)) {
            SourceInfoAwareJsNode sourceInfoAwareJsNode;
            JsExpression jsExpression = x.getInitExpression();
            if (jsExpression != null) {
                sourceInfoAwareJsNode = jsExpression;
                JsExpression it = sourceInfoAwareJsNode;
                new JsExpressionStatement(it).accept(this);
            }
            JsVars jsVars = x.getInitVars();
            if (jsVars != null) {
                SourceInfoAwareJsNode initVars = sourceInfoAwareJsNode = jsVars;
                List<JsVars.JsVar> list2 = ((JsVars)initVars).getVars();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"initVars.vars");
                Collection $i$a$1$let = list2;
                if (!$i$a$1$let.isEmpty()) {
                    ((JsVars)initVars).accept(this);
                }
            }
            CoroutineBlock increment = new CoroutineBlock();
            CoroutineBlock successor = new CoroutineBlock();
            CoroutineBlock bodyEntryBlock = new CoroutineBlock();
            Object object = this.getCurrentStatements();
            Object object2 = this.stateAndJump(bodyEntryBlock, x);
            CollectionsKt.addAll((Collection)object, (Iterable)object2);
            this.currentBlock = bodyEntryBlock;
            if (x.getCondition() != null && !JsBooleanLiteral.isTrue(x.getCondition())) {
                object = this.getCurrentStatements();
                Object $receiver = object2 = new JsIf(JsAstUtils.notOptimized(x.getCondition()), new JsBlock(this.stateAndJump(successor, x)));
                ((SourceInfoAwareJsNode)$receiver).setSource(x.getSource());
                object.add(object2);
            }
            this.withBreakAndContinue(x, successor, increment, (Function0<Unit>)((Function0)new Function0<Unit>(this, x){
                final /* synthetic */ CoroutineBodyTransformer this$0;
                final /* synthetic */ JsFor $x$inlined;
                {
                    this.this$0 = coroutineBodyTransformer;
                    this.$x$inlined = jsFor;
                    super(0);
                }

                public final void invoke() {
                    this.$x$inlined.getBody().accept(this.this$0);
                }
            }));
            object = this.getCurrentStatements();
            object2 = this.stateAndJump(increment, x);
            CollectionsKt.addAll((Collection)object, (Iterable)object2);
            this.currentBlock = increment;
            JsExpression jsExpression2 = x.getIncrementExpression();
            if (jsExpression2 != null) {
                Object it = object = jsExpression2;
                new JsExpressionStatement((JsExpression)it).accept(this);
            }
            object = this.getCurrentStatements();
            object2 = this.stateAndJump(bodyEntryBlock, x);
            CollectionsKt.addAll((Collection)object, (Iterable)object2);
            this.currentBlock = successor;
        } else {
            Collection collection = this_$iv.getCurrentStatements();
            collection.add((JsStatement)x);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitBreak(@NotNull JsBreak x) {
        void targetBlock;
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        JsStatement jsStatement = this.breakContinueTargetStatements.get(x);
        if (jsStatement == null) {
            Intrinsics.throwNpe();
        }
        JsStatement targetStatement = jsStatement;
        JumpTarget jumpTarget = this.breakTargets.get(targetStatement);
        if (jumpTarget == null) {
            Intrinsics.throwNpe();
        }
        Object object = jumpTarget;
        CoroutineBlock coroutineBlock = ((JumpTarget)object).component1();
        int targetTryDepth = ((JumpTarget)object).component2();
        object = this.referencedBlocks;
        object.add(targetBlock);
        this.jumpWithFinally(targetTryDepth + 1, (CoroutineBlock)targetBlock, x);
        object = this.getCurrentStatements();
        JsContinue jsContinue = this.jump();
        object.add(jsContinue);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitContinue(@NotNull JsContinue x) {
        void targetBlock;
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        JsStatement jsStatement = this.breakContinueTargetStatements.get(x);
        if (jsStatement == null) {
            Intrinsics.throwNpe();
        }
        JsStatement targetStatement = jsStatement;
        JumpTarget jumpTarget = this.continueTargets.get(targetStatement);
        if (jumpTarget == null) {
            Intrinsics.throwNpe();
        }
        Object object = jumpTarget;
        CoroutineBlock coroutineBlock = ((JumpTarget)object).component1();
        int targetTryDepth = ((JumpTarget)object).component2();
        object = this.referencedBlocks;
        object.add(targetBlock);
        this.jumpWithFinally(targetTryDepth + 1, (CoroutineBlock)targetBlock, x);
        object = this.getCurrentStatements();
        JsContinue jsContinue = this.jump();
        object.add(jsContinue);
    }

    private final void jumpWithFinally(int targetTryDepth, CoroutineBlock successor, JsNode fromNode) {
        Iterable iterable;
        List<CoroutineBlock> relativeFinallyPath;
        List fullPath;
        Iterable iterable2;
        if (targetTryDepth < this.tryStack.size()) {
            TryBlock tryBlock2 = this.tryStack.get(targetTryDepth);
            Collection collection = this.getCurrentStatements();
            iterable2 = this.exceptionState(tryBlock2.getCatchBlock(), fromNode);
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
        }
        if ((fullPath = CollectionsKt.plus((Collection)(relativeFinallyPath = this.relativeFinallyPath(targetTryDepth)), (Object)successor)).size() > 1) {
            iterable2 = this.getCurrentStatements();
            iterable = this.updateFinallyPath(CollectionsKt.drop((Iterable)fullPath, (int)1));
            CollectionsKt.addAll((Collection)iterable2, (Iterable)iterable);
        }
        iterable2 = this.getCurrentStatements();
        iterable = this.state((CoroutineBlock)fullPath.get(0), fromNode);
        CollectionsKt.addAll((Collection)iterable2, (Iterable)iterable);
    }

    @Override
    public void visitTry(@NotNull JsTry x) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        CoroutineBodyTransformer this_$iv = this;
        if (CoroutineBodyTransformer.access$getNodesToSplit$p(this_$iv).contains(x)) {
            JsStatement it;
            List<JsCatch> list2 = x.getCatches();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"x.catches");
            JsCatch catchNode = (JsCatch)CollectionsKt.firstOrNull(list2);
            JsBlock finallyNode = x.getFinallyBlock();
            CoroutineBlock successor = new CoroutineBlock();
            CoroutineBlock catchBlock = new CoroutineBlock();
            CoroutineBlock finallyBlock = new CoroutineBlock();
            Collection collection = this.tryStack;
            Object object = new TryBlock(catchBlock, finallyNode != null ? finallyBlock : null);
            collection.add(object);
            CoroutineBlock oldCatchBlock = this.currentCatchBlock;
            this.currentCatchBlock = catchBlock;
            object = this.getCurrentStatements();
            Object object2 = this.exceptionState(catchBlock, x);
            CollectionsKt.addAll((Collection)object, (Iterable)object2);
            JsBlock jsBlock = x.getTryBlock();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"x.tryBlock");
            List<JsStatement> list3 = jsBlock.getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"x.tryBlock.statements");
            Iterable $receiver$iv = list3;
            for (Object element$iv : $receiver$iv) {
                it = (JsStatement)element$iv;
                it.accept(this);
            }
            $receiver$iv = this.getCurrentStatements();
            object2 = this.exceptionState(oldCatchBlock, x);
            CollectionsKt.addAll((Collection)$receiver$iv, (Iterable)object2);
            this.currentCatchBlock = oldCatchBlock;
            if (finallyNode != null) {
                $receiver$iv = this.getCurrentStatements();
                object2 = this.updateFinallyPath(CollectionsKt.listOf((Object)successor));
                CollectionsKt.addAll((Collection)$receiver$iv, (Iterable)object2);
                $receiver$iv = this.getCurrentStatements();
                object2 = this.stateAndJump(finallyBlock, x);
                CollectionsKt.addAll((Collection)$receiver$iv, (Iterable)object2);
            } else {
                $receiver$iv = this.getCurrentStatements();
                object2 = this.stateAndJump(successor, x);
                CollectionsKt.addAll((Collection)$receiver$iv, (Iterable)object2);
            }
            this.currentBlock = catchBlock;
            if (finallyNode != null) {
                $receiver$iv = this.getCurrentStatements();
                object2 = this.updateFinallyPath(CollectionsKt.listOf((Object)oldCatchBlock));
                CollectionsKt.addAll((Collection)$receiver$iv, (Iterable)object2);
                $receiver$iv = this.getCurrentStatements();
                object2 = catchNode != null ? this.exceptionState(finallyBlock, x) : this.stateAndJump(finallyBlock, x);
                CollectionsKt.addAll((Collection)$receiver$iv, (Iterable)object2);
            } else {
                $receiver$iv = this.getCurrentStatements();
                object2 = catchNode != null ? this.exceptionState(oldCatchBlock, x) : this.stateAndJump(oldCatchBlock, x);
                CollectionsKt.addAll((Collection)$receiver$iv, (Iterable)object2);
            }
            if (catchNode != null) {
                $receiver$iv = this.getCurrentStatements();
                JsParameter jsParameter = catchNode.getParameter();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsParameter, (String)"catchNode.parameter");
                object2 = JsAstUtils.newVar(jsParameter.getName(), new JsNameRef(this.context.getMetadata().getExceptionName(), JsAstUtils.stateMachineReceiver()));
                $receiver$iv.add(object2);
                JsBlock jsBlock2 = catchNode.getBody();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock2, (String)"catchNode.body");
                List<JsStatement> list4 = jsBlock2.getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list4, (String)"catchNode.body.statements");
                $receiver$iv = list4;
                for (Object element$iv : $receiver$iv) {
                    it = (JsStatement)element$iv;
                    it.accept(this);
                }
                if (finallyNode == null) {
                    $receiver$iv = this.getCurrentStatements();
                    object2 = this.stateAndJump(successor, x);
                    CollectionsKt.addAll((Collection)$receiver$iv, (Iterable)object2);
                } else {
                    $receiver$iv = this.getCurrentStatements();
                    object2 = this.updateFinallyPath(CollectionsKt.listOf((Object)successor));
                    CollectionsKt.addAll((Collection)$receiver$iv, (Iterable)object2);
                    $receiver$iv = this.getCurrentStatements();
                    object2 = this.stateAndJump(finallyBlock, x);
                    CollectionsKt.addAll((Collection)$receiver$iv, (Iterable)object2);
                }
            }
            this.tryStack.remove(CollectionsKt.getLastIndex(this.tryStack));
            if (finallyNode != null) {
                this.currentBlock = finallyBlock;
                List<JsStatement> list5 = finallyNode.getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list5, (String)"finallyNode.statements");
                $receiver$iv = list5;
                for (Object element$iv : $receiver$iv) {
                    it = (JsStatement)element$iv;
                    it.accept(this);
                }
                this.generateFinallyExit();
                this.hasFinallyBlocks = true;
            }
            this.currentBlock = successor;
        } else {
            Collection collection = this_$iv.getCurrentStatements();
            collection.add((JsStatement)x);
        }
    }

    private final void generateFinallyExit() {
        JsNameRef finallyPathRef = new JsNameRef(this.context.getMetadata().getFinallyPathName(), JsAstUtils.stateMachineReceiver());
        JsNameRef stateRef = new JsNameRef(this.context.getMetadata().getStateName(), JsAstUtils.stateMachineReceiver());
        JsInvocation nextState = new JsInvocation((JsExpression)new JsNameRef("shift", (JsExpression)finallyPathRef), new JsExpression[0]);
        Collection collection = this.getCurrentStatements();
        JsStatement jsStatement = JsAstUtils.assignment(stateRef, nextState).makeStmt();
        collection.add(jsStatement);
        collection = this.getCurrentStatements();
        jsStatement = this.jump();
        collection.add(jsStatement);
    }

    @Override
    public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        JsExpression jsExpression = x.getExpression();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"x.expression");
        JsExpression expression2 = jsExpression;
        JsExpression splitExpression = this.handleExpression(expression2);
        if (Intrinsics.areEqual((Object)splitExpression, (Object)expression2)) {
            Collection collection = this.getCurrentStatements();
            collection.add(x);
        } else if (splitExpression != null) {
            JsExpressionStatement jsExpressionStatement;
            Collection collection = this.getCurrentStatements();
            JsExpressionStatement $receiver = jsExpressionStatement = new JsExpressionStatement(splitExpression);
            MetadataProperties.setSynthetic($receiver, true);
            collection.add(jsExpressionStatement);
        }
    }

    @Override
    public void visitVars(@NotNull JsVars x) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Collection collection = this.getCurrentStatements();
        collection.add(x);
    }

    @Override
    public void visitReturn(@NotNull JsReturn x) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        boolean isInFinally = this.hasEnclosingFinallyBlock();
        if (isInFinally) {
            JsNameRef jsNameRef;
            Object object;
            CoroutineBlock returnBlock = new CoroutineBlock();
            this.jumpWithFinally(0, returnBlock, x);
            JsExpression returnExpression = x.getExpression();
            if (returnExpression != null) {
                JsNameRef ref = new JsNameRef(this.context.getReturnValueFieldName(), JsAstUtils.stateMachineReceiver());
                object = this.getCurrentStatements();
                JsStatement jsStatement = JsAstUtils.assignment(ref, x.getExpression()).makeStmt();
                object.add(jsStatement);
                jsNameRef = ref;
            } else {
                jsNameRef = null;
            }
            JsNameRef returnFieldRef = jsNameRef;
            Collection collection = this.getCurrentStatements();
            object = this.jump();
            collection.add(object);
            this.currentBlock = returnBlock;
            collection = this.getCurrentStatements();
            JsNameRef jsNameRef2 = returnFieldRef;
            object = new JsReturn(jsNameRef2 != null ? jsNameRef2.deepCopy() : null);
            collection.add(object);
        } else {
            Collection collection = this.getCurrentStatements();
            collection.add(x);
        }
    }

    @Override
    public void visitThrow(@NotNull JsThrow x) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Collection collection = this.getCurrentStatements();
        collection.add(x);
    }

    @Override
    public void visitDebugger(@NotNull JsDebugger x) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Collection collection = this.getCurrentStatements();
        collection.add(x);
    }

    private final JsExpression handleExpression(JsExpression expression2) {
        Pair<JsExpression, JsExpression> assignment = JsAstUtils.decomposeAssignment(expression2);
        if (assignment != null) {
            JsExpression rhs;
            JsExpression jsExpression = rhs = (JsExpression)assignment.getSecond();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"rhs");
            if (MetadataProperties.isSuspend(jsExpression)) {
                this.handleSuspend(expression2, rhs);
                return null;
            }
        } else if (MetadataProperties.isSuspend(expression2)) {
            this.handleSuspend(expression2, expression2);
            return null;
        }
        return expression2;
    }

    private final void handleSuspend(JsExpression invocation, JsExpression sourceNode) {
        Object object = sourceNode.getSource();
        if (object == null) {
            object = invocation.getSource();
        }
        Object psi = object;
        CoroutineBlock nextBlock = new CoroutineBlock();
        Collection collection = this.getCurrentStatements();
        Object object2 = this.state(nextBlock, invocation);
        CollectionsKt.addAll((Collection)collection, (Iterable)object2);
        Object $receiver = object2 = new JsNameRef(this.context.getMetadata().getResultName(), JsAstUtils.stateMachineReceiver());
        MetadataProperties.setSideEffects((HasMetadata)$receiver, SideEffectKind.DEPENDS_ON_STATE);
        Object resultRef = object2;
        JsStatement jsStatement = JsAstUtils.assignment((JsExpression)resultRef, invocation).makeStmt();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement, (String)"JsAstUtils.assignment(re\u2026f, invocation).makeStmt()");
        JsStatement invocationStatement = jsStatement;
        JsExpression suspendCondition = JsAstUtils.equality(((JsNameRef)resultRef).deepCopy(), this.context.getMetadata().getSuspendObjectRef().deepCopy()).source(psi);
        JsIf suspendIfNeeded = new JsIf(suspendCondition, new JsReturn(this.context.getMetadata().getSuspendObjectRef().deepCopy().source(psi)));
        Collection collection2 = this.getCurrentStatements();
        Object[] objectArray = new JsStatement[3];
        objectArray[0] = invocationStatement;
        objectArray[1] = suspendIfNeeded;
        Object object3 = new JsContinue();
        int n = 2;
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = objectArray;
        JsContinue $receiver2 = object3;
        $receiver2.setSource(psi);
        JsContinue jsContinue = object3;
        objectArray2[n] = jsContinue;
        object3 = CollectionsKt.listOf((Object[])objectArray3);
        CollectionsKt.addAll((Collection)collection2, (Iterable)object3);
        this.currentBlock = nextBlock;
    }

    private final List<JsStatement> state(CoroutineBlock target, JsNode fromExpression) {
        JsDebugger placeholder = new JsDebugger();
        CoroutineMetadataPropertiesKt.setTargetBlock(placeholder, target);
        placeholder.setSource(fromExpression.getSource());
        return CollectionsKt.listOf((Object)placeholder);
    }

    private final JsContinue jump() {
        return new JsContinue();
    }

    private final List<JsStatement> stateAndJump(CoroutineBlock target, JsNode fromNode) {
        return CollectionsKt.plus((Collection)this.state(target, fromNode), (Object)this.jump());
    }

    private final List<JsStatement> exceptionState(CoroutineBlock target, JsNode fromNode) {
        JsDebugger placeholder = new JsDebugger();
        CoroutineMetadataPropertiesKt.setTargetExceptionBlock(placeholder, target);
        placeholder.setSource(fromNode);
        return CollectionsKt.listOf((Object)placeholder);
    }

    private final List<JsStatement> updateFinallyPath(List<CoroutineBlock> path2) {
        JsDebugger placeholder = new JsDebugger();
        CoroutineMetadataPropertiesKt.setFinallyPath(placeholder, path2);
        return CollectionsKt.listOf((Object)placeholder);
    }

    private final void splitIfNecessary(JsStatement statement2, Function0<Unit> action2) {
        if (CoroutineBodyTransformer.access$getNodesToSplit$p(this).contains(statement2)) {
            action2.invoke();
        } else {
            Collection collection = this.getCurrentStatements();
            collection.add(statement2);
        }
    }

    private final void withBreakAndContinue(JsStatement statement2, CoroutineBlock breakBlock, CoroutineBlock continueBlock, Function0<Unit> action2) {
        Object object = this.breakTargets;
        JumpTarget jumpTarget = new JumpTarget(breakBlock, this.getCurrentTryDepth());
        object.put((JsStatement)statement2, (JumpTarget)jumpTarget);
        if (continueBlock != null) {
            object = this.continueTargets;
            jumpTarget = new JumpTarget(continueBlock, this.getCurrentTryDepth());
            object.put(statement2, jumpTarget);
        }
        action2.invoke();
        object = this.breakTargets.keySet();
        object.remove(statement2);
        object = this.continueTargets.keySet();
        object.remove(statement2);
    }

    static /* synthetic */ void withBreakAndContinue$default(CoroutineBodyTransformer coroutineBodyTransformer, JsStatement jsStatement, CoroutineBlock coroutineBlock, CoroutineBlock coroutineBlock2, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            coroutineBlock2 = null;
        }
        coroutineBodyTransformer.withBreakAndContinue(jsStatement, coroutineBlock, coroutineBlock2, (Function0<Unit>)function0);
    }

    /*
     * WARNING - void declaration
     */
    private final List<CoroutineBlock> relativeFinallyPath(int targetTryDepth) {
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.tryStack.subList(targetTryDepth, this.tryStack.size());
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            CoroutineBlock coroutineBlock;
            Object element$iv$iv = element$iv$iv$iv;
            TryBlock it = (TryBlock)element$iv$iv;
            if (it.getFinallyBlock() == null) continue;
            CoroutineBlock it$iv$iv = coroutineBlock;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
    }

    private final boolean hasEnclosingFinallyBlock() {
        boolean bl;
        block3: {
            Iterable $receiver$iv = this.tryStack;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    TryBlock it = (TryBlock)element$iv;
                    if (!(it.getFinallyBlock() != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public CoroutineBodyTransformer(@NotNull CoroutineTransformationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.entryBlock = this.context.getEntryBlock();
        this.globalCatchBlock = this.context.getGlobalCatchBlock();
        this.currentBlock = this.entryBlock;
        CoroutineBodyTransformer coroutineBodyTransformer = this;
        Object object = new LinkedHashMap();
        coroutineBodyTransformer.breakContinueTargetStatements = object;
        coroutineBodyTransformer = this;
        object = new LinkedHashMap();
        coroutineBodyTransformer.breakTargets = object;
        coroutineBodyTransformer = this;
        object = new LinkedHashMap();
        coroutineBodyTransformer.continueTargets = object;
        coroutineBodyTransformer = this;
        coroutineBodyTransformer.referencedBlocks = object = (Set)new LinkedHashSet();
        this.currentCatchBlock = this.globalCatchBlock;
        this.tryStack = CollectionsKt.mutableListOf((Object[])new TryBlock[]{new TryBlock(this.globalCatchBlock, null)});
    }

    @NotNull
    public static final /* synthetic */ CoroutineBlock access$getCurrentBlock$p(CoroutineBodyTransformer $this) {
        return $this.currentBlock;
    }

    public static final /* synthetic */ void access$setCurrentBlock$p(CoroutineBodyTransformer $this, @NotNull CoroutineBlock coroutineBlock) {
        $this.currentBlock = coroutineBlock;
    }

    @NotNull
    public static final /* synthetic */ Set access$getNodesToSplit$p(CoroutineBodyTransformer $this) {
        Set<? extends JsNode> set2 = $this.nodesToSplit;
        if (set2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nodesToSplit");
        }
        return set2;
    }

    public static final /* synthetic */ void access$setNodesToSplit$p(CoroutineBodyTransformer $this, @NotNull Set set2) {
        $this.nodesToSplit = set2;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/js/coroutine/CoroutineBodyTransformer$JumpTarget;", "", "block", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;", "tryDepth", "", "(Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;I)V", "getBlock", "()Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;", "getTryDepth", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "js.translator"})
    private static final class JumpTarget {
        @NotNull
        private final CoroutineBlock block;
        private final int tryDepth;

        @NotNull
        public final CoroutineBlock getBlock() {
            return this.block;
        }

        public final int getTryDepth() {
            return this.tryDepth;
        }

        public JumpTarget(@NotNull CoroutineBlock block, int tryDepth) {
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            this.block = block;
            this.tryDepth = tryDepth;
        }

        @NotNull
        public final CoroutineBlock component1() {
            return this.block;
        }

        public final int component2() {
            return this.tryDepth;
        }

        @NotNull
        public final JumpTarget copy(@NotNull CoroutineBlock block, int tryDepth) {
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            return new JumpTarget(block, tryDepth);
        }

        @NotNull
        public static /* synthetic */ JumpTarget copy$default(JumpTarget jumpTarget, CoroutineBlock coroutineBlock, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                coroutineBlock = jumpTarget.block;
            }
            if ((n2 & 2) != 0) {
                n = jumpTarget.tryDepth;
            }
            return jumpTarget.copy(coroutineBlock, n);
        }

        @NotNull
        public String toString() {
            return "JumpTarget(block=" + this.block + ", tryDepth=" + this.tryDepth + ")";
        }

        public int hashCode() {
            CoroutineBlock coroutineBlock = this.block;
            return (coroutineBlock != null ? coroutineBlock.hashCode() : 0) * 31 + this.tryDepth;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof JumpTarget)) break block3;
                    JumpTarget jumpTarget = (JumpTarget)object;
                    if (!Intrinsics.areEqual((Object)this.block, (Object)jumpTarget.block) || !(this.tryDepth == jumpTarget.tryDepth)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/js/coroutine/CoroutineBodyTransformer$TryBlock;", "", "catchBlock", "Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;", "finallyBlock", "(Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;)V", "getCatchBlock", "()Lorg/jetbrains/kotlin/js/coroutine/CoroutineBlock;", "getFinallyBlock", "js.translator"})
    private static final class TryBlock {
        @NotNull
        private final CoroutineBlock catchBlock;
        @Nullable
        private final CoroutineBlock finallyBlock;

        @NotNull
        public final CoroutineBlock getCatchBlock() {
            return this.catchBlock;
        }

        @Nullable
        public final CoroutineBlock getFinallyBlock() {
            return this.finallyBlock;
        }

        public TryBlock(@NotNull CoroutineBlock catchBlock, @Nullable CoroutineBlock finallyBlock) {
            Intrinsics.checkParameterIsNotNull((Object)catchBlock, (String)"catchBlock");
            this.catchBlock = catchBlock;
            this.finallyBlock = finallyBlock;
        }
    }
}

