/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.components;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.types.KotlinType;

public interface SignaturePropagator {
    public static final SignaturePropagator DO_NOTHING = new SignaturePropagator(){

        @Override
        @NotNull
        public PropagatedSignature resolvePropagatedSignature(@NotNull JavaMethod method, @NotNull ClassDescriptor owner, @NotNull KotlinType returnType, @Nullable KotlinType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters) {
            return new PropagatedSignature(returnType, receiverType, valueParameters, typeParameters, Collections.<String>emptyList(), false);
        }

        @Override
        public void reportSignatureErrors(@NotNull CallableMemberDescriptor descriptor2, @NotNull List<String> signatureErrors) {
            throw new UnsupportedOperationException("Should not be called");
        }
    };

    @NotNull
    public PropagatedSignature resolvePropagatedSignature(@NotNull JavaMethod var1, @NotNull ClassDescriptor var2, @NotNull KotlinType var3, @Nullable KotlinType var4, @NotNull List<ValueParameterDescriptor> var5, @NotNull List<TypeParameterDescriptor> var6);

    public void reportSignatureErrors(@NotNull CallableMemberDescriptor var1, @NotNull List<String> var2);

    public static class PropagatedSignature {
        private final KotlinType returnType;
        private final KotlinType receiverType;
        private final List<ValueParameterDescriptor> valueParameters;
        private final List<TypeParameterDescriptor> typeParameters;
        private final List<String> signatureErrors;
        private final boolean hasStableParameterNames;

        public PropagatedSignature(@NotNull KotlinType returnType, @Nullable KotlinType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters, @NotNull List<String> signatureErrors, boolean hasStableParameterNames) {
            this.returnType = returnType;
            this.receiverType = receiverType;
            this.valueParameters = valueParameters;
            this.typeParameters = typeParameters;
            this.signatureErrors = signatureErrors;
            this.hasStableParameterNames = hasStableParameterNames;
        }

        @NotNull
        public KotlinType getReturnType() {
            return this.returnType;
        }

        @Nullable
        public KotlinType getReceiverType() {
            return this.receiverType;
        }

        @NotNull
        public List<ValueParameterDescriptor> getValueParameters() {
            return this.valueParameters;
        }

        @NotNull
        public List<TypeParameterDescriptor> getTypeParameters() {
            return this.typeParameters;
        }

        public boolean hasStableParameterNames() {
            return this.hasStableParameterNames;
        }

        @NotNull
        public List<String> getErrors() {
            return this.signatureErrors;
        }
    }
}

