/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.codeStyle.bean;

import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleBeanAccessorGenerator {
    private static final String BOOL_GETTER_PREFIX = "is";
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";
    @NotNull
    private final Field myField;
    @NotNull
    private final Class myContainerClass;
    @NotNull
    private final String myFieldName;
    @NotNull
    private final Set<String> myImports;
    private static final Map<String, String> FIELD_TO_METHOD_NAME_MAP = ContainerUtilRt.newHashMap();

    public CodeStyleBeanAccessorGenerator(@NotNull Field field) {
        if (field == null) {
            CodeStyleBeanAccessorGenerator.$$$reportNull$$$0(0);
        }
        this.myImports = ContainerUtil.newHashSet();
        this.myField = field;
        this.myContainerClass = field.getDeclaringClass();
        this.myFieldName = field.getName();
    }

    private static void addMapping(@NotNull String fieldName, @NotNull String methodName) {
        if (fieldName == null) {
            CodeStyleBeanAccessorGenerator.$$$reportNull$$$0(1);
        }
        if (methodName == null) {
            CodeStyleBeanAccessorGenerator.$$$reportNull$$$0(2);
        }
        FIELD_TO_METHOD_NAME_MAP.put(fieldName, methodName);
    }

    String getGetterName() {
        return (this.getValueType() == ValueType.BOOLEAN ? BOOL_GETTER_PREFIX : GETTER_PREFIX) + this.fieldToMethodName();
    }

    private ValueType getValueType() {
        Class<?> fieldType = this.myField.getType();
        String name = fieldType.getName();
        if (fieldType.isPrimitive()) {
            if ("int".equals(name)) {
                if (this.myFieldName.endsWith("_WRAP")) {
                    return ValueType.WRAP;
                }
                if (this.myFieldName.endsWith("BRACE_STYLE")) {
                    return ValueType.BRACE_STYLE;
                }
                if (this.myFieldName.endsWith("_BRACE_FORCE")) {
                    return ValueType.FORCE_BRACES;
                }
                return ValueType.INT;
            }
            if ("boolean".equals(name)) {
                return ValueType.BOOLEAN;
            }
        } else {
            if ("java.lang.String".equals(name)) {
                return ValueType.STRING;
            }
            if (fieldType.isEnum()) {
                return ValueType.ENUM;
            }
        }
        return ValueType.OTHER;
    }

    private String fieldToMethodName() {
        String[] chunks;
        if (FIELD_TO_METHOD_NAME_MAP.containsKey(this.myFieldName)) {
            return FIELD_TO_METHOD_NAME_MAP.get(this.myFieldName);
        }
        StringBuilder nameBuilder = new StringBuilder();
        for (String chunk : chunks = this.myFieldName.split("_")) {
            CodeStyleBeanAccessorGenerator.appendNamePart(nameBuilder, chunk);
        }
        return nameBuilder.toString();
    }

    private static void appendNamePart(@NotNull StringBuilder nameBuilder, @NotNull String chunk) {
        if (nameBuilder == null) {
            CodeStyleBeanAccessorGenerator.$$$reportNull$$$0(3);
        }
        if (chunk == null) {
            CodeStyleBeanAccessorGenerator.$$$reportNull$$$0(4);
        }
        if (chunk.length() > 0) {
            if (FIELD_TO_METHOD_NAME_MAP.containsKey(chunk)) {
                nameBuilder.append(FIELD_TO_METHOD_NAME_MAP.get(chunk));
            } else {
                nameBuilder.append(chunk.substring(0, 1).toUpperCase());
                if (chunk.length() > 1) {
                    nameBuilder.append(chunk.substring(1).toLowerCase());
                }
            }
        }
    }

    String getSetterName() {
        return SETTER_PREFIX + this.fieldToMethodName();
    }

    @Nullable
    String getTypeString() {
        Class<?> fieldType = this.myField.getType();
        ValueType valueType = this.getValueType();
        switch (valueType) {
            case WRAP: {
                this.myImports.add("com.intellij.formatting.WrapType");
                return "WrapType";
            }
            case BRACE_STYLE: {
                this.myImports.add("com.intellij.formatting.BraceStyle");
                return "BraceStyle";
            }
            case FORCE_BRACES: {
                this.myImports.add("com.intellij.formatting.ForceBraces");
                return "ForceBraces";
            }
            case INT: 
            case BOOLEAN: {
                return fieldType.getSimpleName();
            }
            case ENUM: 
            case STRING: {
                this.myImports.add(fieldType.getCanonicalName());
                return fieldType.getSimpleName();
            }
            case OTHER: {
                return null;
            }
        }
        return null;
    }

    boolean isFieldSupported() {
        return this.myField.getType().getCanonicalName() != null && this.myField.getAnnotation(Deprecated.class) == null;
    }

    String getContainerClassAccessor(boolean isWriteAccess) {
        if (this.myContainerClass == CommonCodeStyleSettings.class) {
            return "getCommonSettings()";
        }
        if (this.myContainerClass == CommonCodeStyleSettings.IndentOptions.class) {
            return "getIndentOptions(" + isWriteAccess + ")";
        }
        this.myImports.add(this.myContainerClass.getName());
        return "getCustomSettings(" + this.myContainerClass.getSimpleName() + ".class)";
    }

    void generateGetter(StringBuilder output) {
        String typeString = this.getTypeString();
        if (typeString != null) {
            output.append("public ").append(this.getTypeString()).append(' ').append(this.getGetterName()).append("() {\n");
            ValueType valueType = this.getValueType();
            if (valueType == ValueType.WRAP) {
                output.append("return intToWrapType(").append(this.getContainerClassAccessor(false)).append(".").append(this.myFieldName).append(");\n");
            } else if (valueType == ValueType.BRACE_STYLE || valueType == ValueType.FORCE_BRACES) {
                output.append("return ").append(typeString).append(".fromInt(").append(this.getContainerClassAccessor(false)).append(".").append(this.myFieldName).append(");\n");
            } else {
                output.append("return ").append(this.getContainerClassAccessor(false)).append(".").append(this.myFieldName).append(";\n");
            }
            output.append("}\n");
        } else {
            output.append("\n // TODO: Implement ").append(this.myFieldName).append(" getter manually (unsupported type).\n");
        }
    }

    void generateSetter(StringBuilder output) {
        String typeString = this.getTypeString();
        if (typeString != null) {
            output.append("public void ").append(this.getSetterName()).append("(").append(typeString).append(" value").append("){");
            output.append(this.getContainerClassAccessor(true)).append(".").append(this.myFieldName).append("= ");
            ValueType valueType = this.getValueType();
            if (valueType == ValueType.WRAP) {
                output.append("wrapTypeToInt(");
            }
            output.append("value");
            if (valueType == ValueType.BRACE_STYLE || valueType == ValueType.FORCE_BRACES) {
                output.append(".intValue()");
            }
            if (valueType == ValueType.WRAP) {
                output.append(")");
            }
            output.append(";");
            output.append("}\n");
        } else {
            output.append("\n // TODO: Implement ").append(this.myFieldName).append(" setter manually (unsupported type).\n");
        }
    }

    @NotNull
    Set<String> getImports() {
        Set<String> set = this.myImports;
        if (set == null) {
            CodeStyleBeanAccessorGenerator.$$$reportNull$$$0(5);
        }
        return set;
    }

    static {
        CodeStyleBeanAccessorGenerator.addMapping("SPACE_AFTER_SEMICOLON", "SpaceAfterForSemicolon");
        CodeStyleBeanAccessorGenerator.addMapping("SPACE_BEFORE_SEMICOLON", "SpaceBeforeForSemicolon");
        CodeStyleBeanAccessorGenerator.addMapping("LPAREN", "LeftParen");
        CodeStyleBeanAccessorGenerator.addMapping("RPAREN", "RightParen");
        CodeStyleBeanAccessorGenerator.addMapping("JD", "JavaDoc");
        CodeStyleBeanAccessorGenerator.addMapping("RBRACE", "RightBrace");
        CodeStyleBeanAccessorGenerator.addMapping("LBRACE", "LeftBrace");
        CodeStyleBeanAccessorGenerator.addMapping("INSTANCEOF", "InstanceOf");
        CodeStyleBeanAccessorGenerator.addMapping("DOWHILE", "DoWhile");
        CodeStyleBeanAccessorGenerator.addMapping("INDENT_SIZE", "Indent");
        CodeStyleBeanAccessorGenerator.addMapping("CONTINUATION_INDENT_SIZE", "ContinuationIndent");
        CodeStyleBeanAccessorGenerator.addMapping("PARM", "Param");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/codeStyle/bean/CodeStyleBeanAccessorGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/codeStyle/bean/CodeStyleBeanAccessorGenerator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getImports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addMapping";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendNamePart";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum ValueType {
        BOOLEAN,
        INT,
        STRING,
        WRAP,
        BRACE_STYLE,
        FORCE_BRACES,
        ENUM,
        OTHER;

    }
}

