/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.gradle;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;
import org.jetbrains.plugins.gradle.frameworkSupport.GradleFrameworkSupportProvider;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;

public class GradleIntellijPluginFrameworkSupportProvider
extends GradleFrameworkSupportProvider {
    private static final String ID = "gradle-intellij-plugin";
    private static final Logger LOG = Logger.getInstance(GradleIntellijPluginFrameworkSupportProvider.class);
    private static final String LATEST_GRADLE_VERSION_KEY = "LATEST_GRADLE_VERSION_KEY";
    private static final String LATEST_UPDATING_TIME_KEY = "LATEST_UPDATING_TIME_KEY";

    @NotNull
    public FrameworkTypeEx getFrameworkType() {
        FrameworkTypeEx frameworkTypeEx = new FrameworkTypeEx(ID){

            @NotNull
            public FrameworkSupportInModuleProvider createProvider() {
                GradleIntellijPluginFrameworkSupportProvider gradleIntellijPluginFrameworkSupportProvider = GradleIntellijPluginFrameworkSupportProvider.this;
                if (gradleIntellijPluginFrameworkSupportProvider == null) {
                    1.$$$reportNull$$$0(0);
                }
                return gradleIntellijPluginFrameworkSupportProvider;
            }

            @NotNull
            public String getPresentableName() {
                if ("IntelliJ Platform Plugin" == null) {
                    1.$$$reportNull$$$0(1);
                }
                return "IntelliJ Platform Plugin";
            }

            @NotNull
            public Icon getIcon() {
                Icon icon = AllIcons.Nodes.Plugin;
                if (icon == null) {
                    1.$$$reportNull$$$0(2);
                }
                return icon;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/idea/devkit/gradle/GradleIntellijPluginFrameworkSupportProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createProvider";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (frameworkTypeEx == null) {
            GradleIntellijPluginFrameworkSupportProvider.$$$reportNull$$$0(0);
        }
        return frameworkTypeEx;
    }

    public void addSupport(@NotNull ProjectId projectId, @NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider, @NotNull BuildScriptDataBuilder buildScriptData) {
        BuildNumber build;
        if (projectId == null) {
            GradleIntellijPluginFrameworkSupportProvider.$$$reportNull$$$0(1);
        }
        if (module == null) {
            GradleIntellijPluginFrameworkSupportProvider.$$$reportNull$$$0(2);
        }
        if (rootModel == null) {
            GradleIntellijPluginFrameworkSupportProvider.$$$reportNull$$$0(3);
        }
        if (modifiableModelsProvider == null) {
            GradleIntellijPluginFrameworkSupportProvider.$$$reportNull$$$0(4);
        }
        if (buildScriptData == null) {
            GradleIntellijPluginFrameworkSupportProvider.$$$reportNull$$$0(5);
        }
        String pluginVersion = PropertiesComponent.getInstance().getValue(LATEST_GRADLE_VERSION_KEY, "0.2.13");
        ApplicationInfoEx applicationInfo = ApplicationInfoEx.getInstanceEx();
        String ideVersion = applicationInfo.isEAP() ? ((build = applicationInfo.getBuild()).isSnapshot() ? build.getBaselineVersion() + "-SNAPSHOT" : build.asStringWithoutProductCode()) : applicationInfo.getFullVersion();
        buildScriptData.addPluginDefinitionInPluginsGroup("id 'org.jetbrains.intellij' version '" + pluginVersion + "'").addOther("intellij {\n    version '" + ideVersion + "'\n}\n").addOther("patchPluginXml {\n    changeNotes \"\"\"\n      Add change notes here.<br>\n      <em>most HTML tags may be used</em>\"\"\"\n}");
        VirtualFile contentRoot = (VirtualFile)ArrayUtil.getFirstElement((Object[])rootModel.getContentRoots());
        if (contentRoot == null) {
            return;
        }
        if (!this.createPluginXml(projectId, module, contentRoot.getPath())) {
            return;
        }
        StartupManager.getInstance((Project)module.getProject()).runWhenProjectIsInitialized(() -> {
            if (module == null) {
                GradleIntellijPluginFrameworkSupportProvider.$$$reportNull$$$0(11);
            }
            if (buildScriptData == null) {
                GradleIntellijPluginFrameworkSupportProvider.$$$reportNull$$$0(12);
            }
            FileEditorManager.getInstance((Project)module.getProject()).openFile(buildScriptData.getBuildScriptFile(), true);
            GradleIntellijPluginFrameworkSupportProvider.createRunConfiguration(module, contentRoot.getPath());
        });
    }

    public JComponent createComponent() {
        String latestVersion = PropertiesComponent.getInstance().getValue(LATEST_GRADLE_VERSION_KEY);
        long timeCheck = PropertiesComponent.getInstance().getOrInitLong(LATEST_UPDATING_TIME_KEY, System.currentTimeMillis());
        if (latestVersion == null || TimeUnit.MILLISECONDS.toDays(System.currentTimeMillis() - timeCheck) >= 1L) {
            ModalityState modalityState = ModalityState.defaultModalityState();
            Lazy.EXECUTOR.submit(() -> {
                try {
                    String content = HttpRequests.request((String)"https://plugins.gradle.org/plugin/org.jetbrains.intellij").productNameAsUserAgent().readString((ProgressIndicator)new EmptyProgressIndicator(modalityState));
                    Matcher matcher = Pattern.compile("Version ([\\d.]+) \\(latest\\)").matcher(content);
                    if (matcher.find()) {
                        PropertiesComponent.getInstance().setValue(LATEST_GRADLE_VERSION_KEY, matcher.group(1));
                        PropertiesComponent.getInstance().setValue(LATEST_UPDATING_TIME_KEY, String.valueOf(System.currentTimeMillis()));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        return null;
    }

    private boolean createPluginXml(@NotNull ProjectId projectId, @NotNull Module module, @NotNull String contentRootPath) {
        if (projectId == null) {
            GradleIntellijPluginFrameworkSupportProvider.$$$reportNull$$$0(6);
        }
        if (module == null) {
            GradleIntellijPluginFrameworkSupportProvider.$$$reportNull$$$0(7);
        }
        if (contentRootPath == null) {
            GradleIntellijPluginFrameworkSupportProvider.$$$reportNull$$$0(8);
        }
        try {
            VirtualFile metaInf = VfsUtil.createDirectoryIfMissing((String)(contentRootPath + "/src/main/resources/META-INF"));
            if (metaInf == null) {
                return false;
            }
            if (metaInf.findChild("plugin.xml") != null) {
                return true;
            }
            Project project = module.getProject();
            VirtualFile pluginXml = metaInf.createChildData((Object)this, "plugin.xml");
            FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)project);
            FileTemplate template = templateManager.getJ2eeTemplate("gradleBasedPlugin.xml");
            if (template == null) {
                return false;
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            String groupId = projectId.getGroupId();
            String artifactId = projectId.getArtifactId();
            if (StringUtil.isNotEmpty((String)artifactId)) {
                attributes.put("PLUGIN_ID", StringUtil.isNotEmpty((String)groupId) ? groupId + "." + artifactId : artifactId);
            } else {
                attributes.put("PLUGIN_ID", project.getName());
            }
            VfsUtil.saveText((VirtualFile)pluginXml, (String)template.getText(attributes));
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> FileEditorManager.getInstance((Project)project).openFile(pluginXml, true));
            return true;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    private static void createRunConfiguration(@NotNull Module module, @NotNull String contentRootPath) {
        if (module == null) {
            GradleIntellijPluginFrameworkSupportProvider.$$$reportNull$$$0(9);
        }
        if (contentRootPath == null) {
            GradleIntellijPluginFrameworkSupportProvider.$$$reportNull$$$0(10);
        }
        RunManager runManager = RunManager.getInstance((Project)module.getProject());
        ConfigurationFactory configurationFactory = new GradleExternalTaskConfigurationType().getConfigurationFactories()[0];
        String configurationName = DevKitBundle.message("run.configuration.title", new Object[0]);
        RunnerAndConfigurationSettings configuration = runManager.createConfiguration(configurationName, configurationFactory);
        RunConfiguration runConfiguration = configuration.getConfiguration();
        if (runConfiguration instanceof ExternalSystemRunConfiguration) {
            ExternalSystemTaskExecutionSettings settings = ((ExternalSystemRunConfiguration)runConfiguration).getSettings();
            settings.setTaskNames(Collections.singletonList(":runIde"));
            settings.setExternalProjectPath(contentRootPath);
        }
        runManager.addConfiguration(configuration);
        runManager.setSelectedConfiguration(configuration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/gradle/GradleIntellijPluginFrameworkSupportProvider";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectId";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableModelsProvider";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildScriptData";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRootPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/gradle/GradleIntellijPluginFrameworkSupportProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addSupport";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPluginXml";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createRunConfiguration";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addSupport$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Lazy {
        static final ExecutorService EXECUTOR = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"UPDATE_GRADLE_PLUGIN_VERSIONS");

        private Lazy() {
        }
    }
}

