/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;

public class CodeCleanupCodeProcessor
extends AbstractLayoutCodeProcessor {
    public static final String COMMAND_NAME = "Cleanup code";
    public static final String PROGRESS_TEXT = CodeInsightBundle.message((String)"process.cleanup.code", (Object[])new Object[0]);
    private SelectionModel mySelectionModel;

    public CodeCleanupCodeProcessor(@NotNull AbstractLayoutCodeProcessor previousProcessor) {
        if (previousProcessor == null) {
            CodeCleanupCodeProcessor.$$$reportNull$$$0(0);
        }
        super(previousProcessor, COMMAND_NAME, PROGRESS_TEXT);
        this.mySelectionModel = null;
    }

    public CodeCleanupCodeProcessor(@NotNull AbstractLayoutCodeProcessor previousProcessor, @NotNull SelectionModel selectionModel) {
        if (previousProcessor == null) {
            CodeCleanupCodeProcessor.$$$reportNull$$$0(1);
        }
        if (selectionModel == null) {
            CodeCleanupCodeProcessor.$$$reportNull$$$0(2);
        }
        super(previousProcessor, COMMAND_NAME, PROGRESS_TEXT);
        this.mySelectionModel = null;
        this.mySelectionModel = selectionModel;
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(@NotNull PsiFile file2, boolean processChangedTextOnly) {
        if (file2 == null) {
            CodeCleanupCodeProcessor.$$$reportNull$$$0(3);
        }
        FutureTask<Boolean> futureTask = new FutureTask<Boolean>(() -> {
            if (file2 == null) {
                CodeCleanupCodeProcessor.$$$reportNull$$$0(7);
            }
            Collection<TextRange> ranges = this.getRanges(file2, processChangedTextOnly);
            GlobalInspectionContextBase.cleanupElements(this.myProject, null, descriptor -> CodeCleanupCodeProcessor.isInRanges(ranges, descriptor), new PsiElement[]{file2});
            return true;
        });
        if (futureTask == null) {
            CodeCleanupCodeProcessor.$$$reportNull$$$0(4);
        }
        return futureTask;
    }

    private Collection<TextRange> getRanges(@NotNull PsiFile file2, boolean processChangedTextOnly) {
        if (file2 == null) {
            CodeCleanupCodeProcessor.$$$reportNull$$$0(5);
        }
        if (this.mySelectionModel != null) {
            return CodeCleanupCodeProcessor.getSelectedRanges(this.mySelectionModel);
        }
        if (processChangedTextOnly) {
            return FormatChangedTextUtil.getInstance().getChangedTextRanges(this.myProject, file2);
        }
        return ContainerUtil.newSmartList((Object)file2.getTextRange());
    }

    private static boolean isInRanges(Collection<TextRange> ranges, @NotNull ProblemDescriptor descriptor) {
        if (descriptor == null) {
            CodeCleanupCodeProcessor.$$$reportNull$$$0(6);
        }
        for (TextRange range2 : ranges) {
            if (!range2.containsOffset(descriptor.getStartElement().getTextOffset()) && !range2.containsOffset(descriptor.getEndElement().getTextOffset())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/CodeCleanupCodeProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/CodeCleanupCodeProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareTask";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRanges";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInRanges";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$prepareTask$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

