/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodQuickFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtil;
import com.theoryinpractice.testng.DataProviderReference;
import com.theoryinpractice.testng.TestNGFramework;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.testng.annotations.DataProvider;

public class TestNGDataProviderInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            TestNGDataProviderInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitAnnotation(PsiAnnotation annotation) {
                PsiAnnotationMemberValue provider;
                if (TestNGUtil.TEST_ANNOTATION_FQN.equals(annotation.getQualifiedName()) && (provider = annotation.findDeclaredAttributeValue("dataProvider")) != null && !TestNGUtil.isDisabled(annotation)) {
                    for (PsiReference reference : provider.getReferences()) {
                        if (!(reference instanceof DataProviderReference)) continue;
                        PsiElement dataProviderMethod = reference.resolve();
                        PsiElement element = reference.getElement();
                        PsiClass topLevelClass = PsiUtil.getTopLevelClass((PsiElement)element);
                        PsiClass providerClass = TestNGUtil.getProviderClass(element, topLevelClass);
                        if (!(dataProviderMethod instanceof PsiMethod)) {
                            LocalQuickFix[] fixes = isOnTheFly && providerClass != null ? new LocalQuickFix[]{TestNGDataProviderInspection.createMethodFix(provider, providerClass, topLevelClass)} : LocalQuickFix.EMPTY_ARRAY;
                            holder.registerProblem((PsiElement)provider, "Data provider does not exist", fixes);
                            break;
                        }
                        Version version = TestNGUtil.detectVersion(holder.getProject(), ModuleUtilCore.findModuleForPsiElement((PsiElement)providerClass));
                        if (version != null && version.isOrGreaterThan(Integer.valueOf(6), Integer.valueOf(9), Integer.valueOf(13))) break;
                        PsiMethod providerMethod = (PsiMethod)dataProviderMethod;
                        if (providerClass == topLevelClass || providerMethod.hasModifierProperty("static")) break;
                        holder.registerProblem((PsiElement)provider, "Data provider from foreign class need to be static", new LocalQuickFix[0]);
                        break;
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            TestNGDataProviderInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    private static CreateMethodQuickFix createMethodFix(PsiAnnotationMemberValue provider, @NotNull PsiClass providerClass, PsiClass topLevelClass) {
        if (providerClass == null) {
            TestNGDataProviderInspection.$$$reportNull$$$0(2);
        }
        String name = StringUtil.unquoteString((String)provider.getText());
        FileTemplateDescriptor templateDesc = new TestNGFramework().getParametersMethodFileTemplateDescriptor();
        assert (templateDesc != null);
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)provider.getProject()).getCodeTemplate(templateDesc.getFileName());
        String body = "";
        try {
            Properties attributes = new Properties();
            attributes.put("NAME", name);
            body = fileTemplate.getText(attributes);
            body = body.replace("${BODY}\n", "");
            PsiMethod methodFromTemplate = JavaPsiFacade.getElementFactory((Project)providerClass.getProject()).createMethodFromText(body, (PsiElement)providerClass);
            PsiCodeBlock methodBody = methodFromTemplate.getBody();
            body = methodBody != null ? StringUtil.trimEnd((String)StringUtil.trimStart((String)methodBody.getText(), (String)"{"), (String)"}") : "";
        }
        catch (Exception attributes) {
            // empty catch block
        }
        if (StringUtil.isEmptyOrSpaces((String)body)) {
            body = "return new Object[][]{};";
        }
        String signature = "@" + DataProvider.class.getName() + " public ";
        if (providerClass == topLevelClass) {
            signature = signature + "static ";
        }
        signature = signature + "Object[][] " + name + "()";
        return CreateMethodQuickFix.createFix((PsiClass)providerClass, (String)signature, (String)body);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/theoryinpractice/testng/inspection/TestNGDataProviderInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/theoryinpractice/testng/inspection/TestNGDataProviderInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createMethodFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

