/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.internal.impldep.com.google.common.collect.Maps;

public class DefaultImmutableModuleIdentifierFactory
implements ImmutableModuleIdentifierFactory {
    private final Map<String, Map<String, ModuleIdentifier>> groupIdToModules = Maps.newConcurrentMap();
    private final Map<ModuleIdentifier, Map<String, ModuleVersionIdentifier>> idToVersions = Maps.newConcurrentMap();

    @Override
    public ModuleIdentifier module(String group, String name) {
        ModuleIdentifier moduleIdentifier;
        ConcurrentMap byName = this.groupIdToModules.get(group);
        if (byName == null && (byName = this.groupIdToModules.get(group)) == null) {
            byName = Maps.newConcurrentMap();
            this.groupIdToModules.put(group, byName);
        }
        if ((moduleIdentifier = byName.get(name)) == null) {
            moduleIdentifier = DefaultModuleIdentifier.newId(group, name);
            byName.put(name, moduleIdentifier);
        }
        return moduleIdentifier;
    }

    @Override
    public ModuleVersionIdentifier moduleWithVersion(String group, String name, String version) {
        ModuleIdentifier mi = this.module(group, name);
        return this.moduleWithVersion(mi, version);
    }

    @Override
    public ModuleVersionIdentifier moduleWithVersion(ModuleIdentifier mi, String version) {
        ModuleVersionIdentifier identifier;
        ConcurrentMap byVersion = this.idToVersions.get(mi);
        if (byVersion == null && (byVersion = this.idToVersions.get(mi)) == null) {
            byVersion = Maps.newConcurrentMap();
            this.idToVersions.put(mi, byVersion);
        }
        if ((identifier = byVersion.get(version)) == null) {
            identifier = DefaultModuleVersionIdentifier.newId(mi, version);
            byVersion.put(version, identifier);
        }
        return identifier;
    }

    @Override
    public ModuleVersionIdentifier moduleWithVersion(Module module) {
        return this.moduleWithVersion(module.getGroup(), module.getName(), module.getVersion());
    }
}

