/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.UnionVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.DefaultConflictResolverDetails;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.VersionConflictResolutionDetails;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.ComponentStateFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.ResolvableSelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.SelectorStateResolverResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.resolve.result.ComponentIdResolveResult;

public class SelectorStateResolver<T extends ComponentResolutionState> {
    private final ModuleConflictResolver conflictResolver;
    private final ComponentStateFactory<T> componentFactory;
    private final T rootComponent;
    private final ModuleIdentifier rootModuleId;

    public SelectorStateResolver(ModuleConflictResolver conflictResolver, ComponentStateFactory<T> componentFactory, T rootComponent) {
        this.conflictResolver = conflictResolver;
        this.componentFactory = componentFactory;
        this.rootComponent = rootComponent;
        this.rootModuleId = rootComponent.getId().getModule();
    }

    public T selectBest(ModuleIdentifier moduleId, List<? extends ResolvableSelectorState> selectors) {
        VersionSelector allRejects = this.createAllRejects(selectors);
        List<T> candidates = this.resolveSelectors(selectors, allRejects);
        assert (!candidates.isEmpty());
        if (moduleId.equals(this.rootModuleId) && !candidates.contains(this.rootComponent)) {
            candidates = new ArrayList<T>(candidates);
            candidates.add(this.rootComponent);
        }
        if (candidates.size() == 1) {
            return (T)((ComponentResolutionState)candidates.get(0));
        }
        return this.resolveConflicts(candidates);
    }

    private List<T> resolveSelectors(List<? extends ResolvableSelectorState> selectors, VersionSelector allRejects) {
        if (selectors.size() == 1) {
            ResolvableSelectorState selectorState = selectors.get(0);
            ComponentIdResolveResult resolved = selectorState.resolve(allRejects);
            T selected = SelectorStateResolverResults.componentForIdResolveResult(this.componentFactory, resolved, selectorState);
            return Collections.singletonList(selected);
        }
        return this.buildResolveResults(selectors, allRejects);
    }

    private List<T> buildResolveResults(List<? extends ResolvableSelectorState> selectors, VersionSelector allRejects) {
        SelectorStateResolverResults results = new SelectorStateResolverResults(selectors.size());
        for (ResolvableSelectorState resolvableSelectorState : selectors) {
            if (results.alreadyHaveResolution(resolvableSelectorState)) {
                resolvableSelectorState.markResolved();
                continue;
            }
            ComponentIdResolveResult resolved = resolvableSelectorState.resolve(allRejects);
            results.registerResolution(resolvableSelectorState, resolved);
        }
        return results.getResolved(this.componentFactory);
    }

    private VersionSelector createAllRejects(List<? extends ResolvableSelectorState> selectors) {
        List rejectSelectors = null;
        for (ResolvableSelectorState resolvableSelectorState : selectors) {
            ResolvedVersionConstraint versionConstraint = resolvableSelectorState.getVersionConstraint();
            if (versionConstraint == null || versionConstraint.getRejectedSelector() == null) continue;
            if (rejectSelectors == null) {
                rejectSelectors = Lists.newArrayListWithCapacity((int)selectors.size());
            }
            rejectSelectors.add(versionConstraint.getRejectedSelector());
        }
        if (rejectSelectors == null) {
            return null;
        }
        if (rejectSelectors.size() == 1) {
            return (VersionSelector)rejectSelectors.get(0);
        }
        return new UnionVersionSelector(rejectSelectors);
    }

    private T resolveConflicts(Collection<T> candidates) {
        DefaultConflictResolverDetails<T> details = new DefaultConflictResolverDetails<T>(candidates);
        this.conflictResolver.select(details);
        Object selected = details.getSelected();
        if (details.hasFailure()) {
            throw UncheckedException.throwAsUncheckedException(details.getFailure());
        }
        ComponentSelectionDescriptorInternal desc = VersionSelectionReasons.CONFLICT_RESOLUTION;
        selected.addCause(desc.withReason(new VersionConflictResolutionDetails(candidates)));
        return selected;
    }
}

