/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.artifacts.DependencyConstraintMetadata;
import org.gradle.api.artifacts.DirectDependencyMetadata;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.VariantMetadata;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.repositories.resolver.VariantMetadataAdapter;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;

public class ComponentMetadataDetailsAdapter
implements ComponentMetadataDetails {
    private final MutableModuleComponentResolveMetadata metadata;
    private final Instantiator instantiator;
    private final NotationParser<Object, DirectDependencyMetadata> dependencyMetadataNotationParser;
    private final NotationParser<Object, DependencyConstraintMetadata> dependencyConstraintMetadataNotationParser;
    private final NotationParser<Object, ComponentIdentifier> componentIdentifierParser;

    public ComponentMetadataDetailsAdapter(MutableModuleComponentResolveMetadata metadata, Instantiator instantiator, NotationParser<Object, DirectDependencyMetadata> dependencyMetadataNotationParser, NotationParser<Object, DependencyConstraintMetadata> dependencyConstraintMetadataNotationParser, NotationParser<Object, ComponentIdentifier> dependencyNotationParser) {
        this.metadata = metadata;
        this.instantiator = instantiator;
        this.dependencyMetadataNotationParser = dependencyMetadataNotationParser;
        this.dependencyConstraintMetadataNotationParser = dependencyConstraintMetadataNotationParser;
        this.componentIdentifierParser = dependencyNotationParser;
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.metadata.getModuleVersionId();
    }

    @Override
    public boolean isChanging() {
        return this.metadata.isChanging();
    }

    @Override
    public String getStatus() {
        return this.metadata.getStatus();
    }

    @Override
    public List<String> getStatusScheme() {
        return this.metadata.getStatusScheme();
    }

    @Override
    public void setChanging(boolean changing) {
        this.metadata.setChanging(changing);
    }

    @Override
    public void setStatus(String status) {
        this.metadata.setStatus(status);
    }

    @Override
    public void setStatusScheme(List<String> statusScheme) {
        this.metadata.setStatusScheme(statusScheme);
    }

    @Override
    public void withVariant(String name, Action<? super VariantMetadata> action) {
        action.execute(this.instantiator.newInstance(VariantMetadataAdapter.class, new VariantNameSpec(name), this.metadata, this.instantiator, this.dependencyMetadataNotationParser, this.dependencyConstraintMetadataNotationParser));
    }

    @Override
    public void allVariants(Action<? super VariantMetadata> action) {
        action.execute(this.instantiator.newInstance(VariantMetadataAdapter.class, Specs.satisfyAll(), this.metadata, this.instantiator, this.dependencyMetadataNotationParser, this.dependencyConstraintMetadataNotationParser));
    }

    @Override
    public void belongsTo(Object notation) {
        this.metadata.belongsTo(this.componentIdentifierParser.parseNotation(notation));
    }

    @Override
    public ComponentMetadataDetails attributes(Action<? super AttributeContainer> action) {
        AttributeContainerInternal attributes = this.metadata.getAttributesFactory().mutable((AttributeContainerInternal)this.metadata.getAttributes());
        action.execute(attributes);
        this.metadata.setAttributes(attributes);
        return this;
    }

    @Override
    public AttributeContainer getAttributes() {
        return this.metadata.getAttributes();
    }

    public String toString() {
        return this.metadata.getModuleVersionId().toString();
    }

    private static class VariantNameSpec
    implements Spec<VariantResolveMetadata> {
        private final String name;

        private VariantNameSpec(String name) {
            this.name = name;
        }

        @Override
        public boolean isSatisfiedBy(VariantResolveMetadata element) {
            return this.name.equals(element.getName());
        }
    }
}

