/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classloading;

import java.lang.reflect.Method;
import org.gradle.api.GradleException;
import org.gradle.api.internal.classloading.GroovySystemLoader;
import org.gradle.api.internal.classloading.LeakyOnJava7GroovySystemLoader;
import org.gradle.api.internal.classloading.NoOpGroovySystemLoader;
import org.gradle.util.VersionNumber;

public class GroovySystemLoaderFactory {
    public static final NoOpGroovySystemLoader NOT_BROKEN = new NoOpGroovySystemLoader();

    public GroovySystemLoader forClassLoader(ClassLoader classLoader) {
        try {
            String versionString;
            Class<?> groovySystem;
            try {
                groovySystem = classLoader.loadClass("groovy.lang.GroovySystem");
            }
            catch (ClassNotFoundException e) {
                return NOT_BROKEN;
            }
            if (groovySystem.getClassLoader() != classLoader) {
                return NOT_BROKEN;
            }
            try {
                Method getVersion = groovySystem.getDeclaredMethod("getVersion", new Class[0]);
                versionString = (String)getVersion.invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException ex) {
                return NOT_BROKEN;
            }
            VersionNumber groovyVersion = VersionNumber.parse(versionString);
            boolean isFaultyGroovy = groovyVersion.getMajor() == 2 && groovyVersion.getMinor() == 4;
            return isFaultyGroovy ? new LeakyOnJava7GroovySystemLoader(classLoader) : NOT_BROKEN;
        }
        catch (Exception e) {
            throw new GradleException("Could not inspect the Groovy system for ClassLoader " + classLoader, e);
        }
    }
}

