/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.result;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.testing.junit.result.JUnitXmlResultWriter;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestOutputAssociation;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.FileUtils;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.util.GFileUtils;

public class Binary2JUnitXmlReportGenerator {
    private final File testResultsDir;
    private final TestResultsProvider testResultsProvider;
    private JUnitXmlResultWriter xmlWriter;
    private final BuildOperationExecutor buildOperationExecutor;
    private static final Logger LOG = Logging.getLogger(Binary2JUnitXmlReportGenerator.class);

    public Binary2JUnitXmlReportGenerator(File testResultsDir, TestResultsProvider testResultsProvider, TestOutputAssociation outputAssociation, BuildOperationExecutor buildOperationExecutor, String hostName) {
        this.testResultsDir = testResultsDir;
        this.testResultsProvider = testResultsProvider;
        this.xmlWriter = new JUnitXmlResultWriter(hostName, testResultsProvider, outputAssociation);
        this.buildOperationExecutor = buildOperationExecutor;
    }

    public void generate() {
        Timer clock = Time.startTimer();
        this.buildOperationExecutor.run(new RunnableBuildOperation(){

            @Override
            public void run(BuildOperationContext context) {
                File[] oldXmlFiles;
                for (File oldXmlFile : oldXmlFiles = Binary2JUnitXmlReportGenerator.this.testResultsDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith("TEST") && name.endsWith(".xml");
                    }
                })) {
                    GFileUtils.deleteQuietly(oldXmlFile);
                }
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName("Delete old JUnit XML results");
            }
        });
        this.buildOperationExecutor.runAll(new Action<BuildOperationQueue<JUnitXmlReportFileGenerator>>(){

            @Override
            public void execute(final BuildOperationQueue<JUnitXmlReportFileGenerator> queue) {
                Binary2JUnitXmlReportGenerator.this.testResultsProvider.visitClasses((Action<? super TestClassResult>)new Action<TestClassResult>(){

                    @Override
                    public void execute(TestClassResult result) {
                        File reportFile = new File(Binary2JUnitXmlReportGenerator.this.testResultsDir, Binary2JUnitXmlReportGenerator.this.getReportFileName(result));
                        queue.add(new JUnitXmlReportFileGenerator(result, reportFile, Binary2JUnitXmlReportGenerator.this.xmlWriter));
                    }
                });
            }
        });
        LOG.info("Finished generating test XML results ({}) into: {}", clock.getElapsed(), this.testResultsDir);
    }

    private String getReportFileName(TestClassResult result) {
        return "TEST-" + FileUtils.toSafeFileName(result.getClassName()) + ".xml";
    }

    private static class JUnitXmlReportFileGenerator
    implements RunnableBuildOperation {
        private final TestClassResult result;
        private final File reportFile;
        private final JUnitXmlResultWriter xmlWriter;

        public JUnitXmlReportFileGenerator(TestClassResult result, File reportFile, JUnitXmlResultWriter xmlWriter) {
            this.result = result;
            this.reportFile = reportFile;
            this.xmlWriter = xmlWriter;
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName("Generate junit XML test report for ".concat(this.result.getClassName()));
        }

        @Override
        public void run(BuildOperationContext context) {
            FileOutputStream output = null;
            try {
                output = new FileOutputStream(this.reportFile);
                this.xmlWriter.write(this.result, output);
                output.close();
            }
            catch (Exception e) {
                try {
                    throw new GradleException(String.format("Could not write XML test results for %s to file %s.", this.result.getClassName(), this.reportFile), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(output);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)output);
        }
    }
}

