/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.attributes.Usage;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;

@Incubating
public class JavaLibraryPlugin
implements Plugin<Project> {
    private final ObjectFactory objectFactory;

    @Inject
    public JavaLibraryPlugin(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        SourceSetContainer sourceSets = project.getExtensions().getByType(SourceSetContainer.class);
        ConfigurationContainer configurations = project.getConfigurations();
        this.addApiToMainSourceSet(project, sourceSets, configurations);
    }

    private void addApiToMainSourceSet(Project project, SourceSetContainer sourceSets, ConfigurationContainer configurations) {
        SourceSet sourceSet = (SourceSet)sourceSets.getByName("main");
        Configuration apiConfiguration = (Configuration)configurations.maybeCreate(sourceSet.getApiConfigurationName());
        apiConfiguration.setVisible(false);
        apiConfiguration.setDescription("API dependencies for " + sourceSet + ".");
        apiConfiguration.setCanBeResolved(false);
        apiConfiguration.setCanBeConsumed(false);
        Configuration apiElementsConfiguration = configurations.getByName(sourceSet.getApiElementsConfigurationName());
        apiElementsConfiguration.extendsFrom(apiConfiguration);
        final TaskProvider<JavaCompile> javaCompile = project.getTasks().withType(JavaCompile.class).named("compileJava");
        ConfigurationPublications publications = apiElementsConfiguration.getOutgoing();
        ConfigurationVariant variant = publications.getVariants().create("classes");
        variant.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, this.objectFactory.named(Usage.class, "java-api-classes"));
        variant.artifact(new JavaPlugin.IntermediateJavaArtifact("java-classes-directory", javaCompile){

            @Override
            public File getFile() {
                return ((JavaCompile)javaCompile.get()).getDestinationDir();
            }
        });
        Configuration implementationConfiguration = configurations.getByName(sourceSet.getImplementationConfigurationName());
        implementationConfiguration.extendsFrom(apiConfiguration);
        Configuration compileConfiguration = configurations.getByName(sourceSet.getCompileConfigurationName());
        apiConfiguration.extendsFrom(compileConfiguration);
    }
}

