/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality.internal.findbugs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.quality.FindBugsReports;
import org.gradle.api.plugins.quality.internal.FindBugsReportsImpl;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsSpec;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsXmlReportImpl;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.reporting.internal.CustomizableHtmlReportImpl;
import org.gradle.api.reporting.internal.TaskGeneratedSingleFileReport;
import org.gradle.api.specs.Spec;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.util.CollectionUtils;

public class FindBugsSpecBuilder {
    private static final Set<String> VALID_EFFORTS = ImmutableSet.of((Object)"min", (Object)"default", (Object)"max");
    private static final Set<String> VALID_REPORT_LEVELS = ImmutableSet.of((Object)"experimental", (Object)"low", (Object)"medium", (Object)"high");
    private FileCollection pluginsList;
    private FileCollection sources;
    private FileCollection classpath;
    private FileCollection classesDirs;
    private FindBugsReports reports;
    private String effort;
    private String reportLevel;
    private String maxHeapSize;
    private Collection<String> visitors;
    private Collection<String> omitVisitors;
    private File excludeFilter;
    private File includeFilter;
    private File excludeBugsFilter;
    private Collection<String> extraArgs;
    private Collection<String> jvmArgs;
    private boolean debugEnabled;
    private boolean showProgress;

    public FindBugsSpecBuilder(FileCollection classesDirs) {
        if (classesDirs == null || classesDirs.isEmpty()) {
            throw new InvalidUserDataException("No class directories configured for FindBugs analysis.");
        }
        this.classesDirs = classesDirs;
    }

    public FindBugsSpecBuilder withPluginsList(FileCollection pluginsClasspath) {
        this.pluginsList = pluginsClasspath;
        return this;
    }

    public FindBugsSpecBuilder withSources(FileCollection sources) {
        this.sources = sources;
        return this;
    }

    public FindBugsSpecBuilder withClasspath(FileCollection classpath) {
        this.classpath = classpath;
        return this;
    }

    public FindBugsSpecBuilder configureReports(FindBugsReports reports) {
        this.reports = reports;
        return this;
    }

    public FindBugsSpecBuilder withEffort(@Nullable String effort) {
        if (effort != null && !VALID_EFFORTS.contains(effort)) {
            throw new InvalidUserDataException("Invalid value for FindBugs 'effort' property: " + effort);
        }
        this.effort = effort;
        return this;
    }

    public FindBugsSpecBuilder withReportLevel(@Nullable String reportLevel) {
        if (reportLevel != null && !VALID_REPORT_LEVELS.contains(reportLevel)) {
            throw new InvalidUserDataException("Invalid value for FindBugs 'reportLevel' property: " + reportLevel);
        }
        this.reportLevel = reportLevel;
        return this;
    }

    public FindBugsSpecBuilder withMaxHeapSize(@Nullable String maxHeapSize) {
        this.maxHeapSize = maxHeapSize;
        return this;
    }

    public FindBugsSpecBuilder withVisitors(@Nullable Collection<String> visitors) {
        this.visitors = visitors;
        return this;
    }

    public FindBugsSpecBuilder withOmitVisitors(@Nullable Collection<String> omitVisitors) {
        this.omitVisitors = omitVisitors;
        return this;
    }

    public FindBugsSpecBuilder withExcludeFilter(@Nullable File excludeFilter) {
        if (excludeFilter != null && !excludeFilter.canRead()) {
            String errorStr = String.format("Cannot read file specified for FindBugs 'excludeFilter' property: %s", excludeFilter);
            throw new InvalidUserDataException(errorStr);
        }
        this.excludeFilter = excludeFilter;
        return this;
    }

    public FindBugsSpecBuilder withIncludeFilter(@Nullable File includeFilter) {
        if (includeFilter != null && !includeFilter.canRead()) {
            String errorStr = String.format("Cannot read file specified for FindBugs 'includeFilter' property: %s", includeFilter);
            throw new InvalidUserDataException(errorStr);
        }
        this.includeFilter = includeFilter;
        return this;
    }

    public FindBugsSpecBuilder withExcludeBugsFilter(@Nullable File excludeBugsFilter) {
        if (excludeBugsFilter != null && !excludeBugsFilter.canRead()) {
            String errorStr = String.format("Cannot read file specified for FindBugs 'excludeBugsFilter' property: %s", excludeBugsFilter);
            throw new InvalidUserDataException(errorStr);
        }
        this.excludeBugsFilter = excludeBugsFilter;
        return this;
    }

    public FindBugsSpecBuilder withExtraArgs(@Nullable Collection<String> extraArgs) {
        this.extraArgs = extraArgs;
        return this;
    }

    public FindBugsSpecBuilder withDebugging(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
        return this;
    }

    public FindBugsSpecBuilder withJvmArgs(@Nullable Collection<String> jvmArgs) {
        this.jvmArgs = jvmArgs;
        return this;
    }

    public FindBugsSpec build() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-pluginList");
        args.add(this.pluginsList == null ? "" : this.pluginsList.getAsPath());
        args.add("-sortByClass");
        args.add("-timestampNow");
        if (this.showProgress) {
            args.add("-progress");
        }
        if (this.reports != null && !this.reports.getEnabled().isEmpty()) {
            if (this.reports.getEnabled().size() == 1) {
                TaskGeneratedSingleFileReport r;
                FindBugsReportsImpl reportsImpl = (FindBugsReportsImpl)this.reports;
                String outputArg = "-" + ((SingleFileReport)reportsImpl.getFirstEnabled()).getName();
                if (reportsImpl.getFirstEnabled() instanceof FindBugsXmlReportImpl) {
                    r = (FindBugsXmlReportImpl)reportsImpl.getFirstEnabled();
                    if (((FindBugsXmlReportImpl)r).isWithMessages()) {
                        outputArg = outputArg + ":withMessages";
                    }
                } else if (reportsImpl.getFirstEnabled() instanceof CustomizableHtmlReportImpl && ((CustomizableHtmlReportImpl)(r = (CustomizableHtmlReportImpl)reportsImpl.getFirstEnabled())).getStylesheet() != null) {
                    outputArg = outputArg + ':' + ((CustomizableHtmlReportImpl)r).getStylesheet().asFile().getAbsolutePath();
                }
                args.add(outputArg);
                args.add("-outputFile");
                args.add(((SingleFileReport)reportsImpl.getFirstEnabled()).getDestination().getAbsolutePath());
            } else {
                throw new InvalidUserDataException("FindBugs tasks can only have one report enabled, however more than one report was enabled. You need to disable all but one of them.");
            }
        }
        if (this.has(this.sources)) {
            args.add("-sourcepath");
            args.add(this.sources.getAsPath());
        }
        if (this.has(this.classpath)) {
            args.add("-auxclasspath");
            args.add(this.classpath.filter((Spec<? super File>)new Spec<File>(){

                @Override
                public boolean isSatisfiedBy(File element) {
                    return element.exists();
                }
            }).getAsPath());
        }
        if (this.has(this.effort)) {
            args.add(String.format("-effort:%s", this.effort));
        }
        if (this.has(this.reportLevel)) {
            args.add(String.format("-%s", this.reportLevel));
        }
        if (this.has(this.visitors)) {
            args.add("-visitors");
            args.add(CollectionUtils.join(",", this.visitors));
        }
        if (this.has(this.omitVisitors)) {
            args.add("-omitVisitors");
            args.add(CollectionUtils.join(",", this.omitVisitors));
        }
        if (this.has(this.excludeFilter)) {
            args.add("-exclude");
            args.add(this.excludeFilter.getPath());
        }
        if (this.has(this.includeFilter)) {
            args.add("-include");
            args.add(this.includeFilter.getPath());
        }
        if (this.has(this.excludeBugsFilter)) {
            args.add("-excludeBugs");
            args.add(this.excludeBugsFilter.getPath());
        }
        if (this.has(this.extraArgs)) {
            args.addAll(this.extraArgs);
        }
        for (File classDir : this.classesDirs) {
            if (!classDir.exists()) continue;
            args.add(classDir.getAbsolutePath());
        }
        return new FindBugsSpec(args, this.maxHeapSize, this.debugEnabled, this.jvmArgs == null ? Collections.emptyList() : this.jvmArgs);
    }

    private boolean has(@Nullable String str) {
        return str != null && str.length() > 0;
    }

    private boolean has(@Nullable File file) {
        return file != null && file.canRead();
    }

    private boolean has(@Nullable Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    private boolean has(@Nullable FileCollection fileCollection) {
        return fileCollection != null && !fileCollection.isEmpty();
    }

    public FindBugsSpecBuilder withShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
        return this;
    }
}

