/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.Collections;
import java.util.Set;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.DisambiguationRule;
import org.gradle.api.internal.attributes.EmptySchema;
import org.gradle.api.internal.attributes.MultipleCandidatesResult;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public class PreferJavaRuntimeVariant
extends EmptySchema {
    private static final Usage RUNTIME_USAGE = NamedObjectInstantiator.INSTANCE.named(Usage.class, "java-runtime");
    private static final Usage API_USAGE = NamedObjectInstantiator.INSTANCE.named(Usage.class, "java-api");
    private static final Set<Usage> DEFAULT_JAVA_USAGES = ImmutableSet.of((Object)API_USAGE, (Object)RUNTIME_USAGE);
    private static final Set<Attribute<?>> SUPPORTED_ATTRIBUTES = Collections.singleton(Usage.USAGE_ATTRIBUTE);
    private static final PreferJavaRuntimeVariant SCHEMA_DEFAULT_JAVA_VARIANTS = new PreferJavaRuntimeVariant();

    static PreferJavaRuntimeVariant schema() {
        return SCHEMA_DEFAULT_JAVA_VARIANTS;
    }

    private PreferJavaRuntimeVariant() {
    }

    @Override
    public Set<Attribute<?>> getAttributes() {
        return SUPPORTED_ATTRIBUTES;
    }

    @Override
    public DisambiguationRule<Object> disambiguationRules(Attribute<?> attribute) {
        if (Usage.USAGE_ATTRIBUTE.equals(attribute)) {
            return (DisambiguationRule)Cast.uncheckedCast(new DisambiguationRule<Usage>(){

                @Override
                public boolean doesSomething() {
                    return true;
                }

                @Override
                public void execute(MultipleCandidatesResult<Usage> details) {
                    if (details.getConsumerValue() == null) {
                        Set candidates = details.getCandidateValues();
                        if (candidates.equals(DEFAULT_JAVA_USAGES)) {
                            details.closestMatch(RUNTIME_USAGE);
                        } else {
                            for (Usage candidate : candidates) {
                                if (candidate == null || DEFAULT_JAVA_USAGES.contains(candidate)) continue;
                                return;
                            }
                            details.closestMatch(RUNTIME_USAGE);
                        }
                    }
                }
            });
        }
        return super.disambiguationRules(attribute);
    }
}

