/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.composite;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.gradle.api.initialization.ConfigurableIncludedBuild;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.initialization.SettingsLoader;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.build.PublicBuildPath;

public class ChildBuildRegisteringSettingsLoader
implements SettingsLoader {
    private final SettingsLoader delegate;
    private final BuildStateRegistry buildRegistry;
    private final PublicBuildPath publicBuildPath;

    public ChildBuildRegisteringSettingsLoader(SettingsLoader delegate, BuildStateRegistry buildRegistry, PublicBuildPath publicBuildPath) {
        this.delegate = delegate;
        this.buildRegistry = buildRegistry;
        this.publicBuildPath = publicBuildPath;
    }

    @Override
    public SettingsInternal findAndLoadSettings(GradleInternal gradle) {
        SettingsInternal settings = this.delegate.findAndLoadSettings(gradle);
        List<IncludedBuildSpec> includedBuilds = settings.getIncludedBuilds();
        if (!includedBuilds.isEmpty()) {
            LinkedHashSet<ConfigurableIncludedBuild> children = new LinkedHashSet<ConfigurableIncludedBuild>(includedBuilds.size());
            for (IncludedBuildSpec includedBuildSpec : includedBuilds) {
                gradle.getOwner().assertCanAdd(includedBuildSpec);
                BuildDefinition buildDefinition = BuildDefinition.fromStartParameterForBuild(gradle.getStartParameter(), null, includedBuildSpec.rootDir, this.publicBuildPath);
                IncludedBuildState includedBuild = this.buildRegistry.addIncludedBuild(buildDefinition);
                includedBuildSpec.configurer.execute(includedBuild.getModel());
                children.add(includedBuild.getModel());
            }
            gradle.setIncludedBuilds(children);
        } else {
            gradle.setIncludedBuilds(Collections.emptyList());
        }
        return settings;
    }
}

