/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.plugins;

import java.io.File;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.Factory;
import org.gradle.internal.cleanup.BuildOutputCleanupRegistry;
import org.gradle.language.base.internal.plugins.CleanRule;

@Incubating
public class LifecycleBasePlugin
implements Plugin<ProjectInternal> {
    public static final String CLEAN_TASK_NAME = "clean";
    public static final String ASSEMBLE_TASK_NAME = "assemble";
    public static final String CHECK_TASK_NAME = "check";
    public static final String BUILD_TASK_NAME = "build";
    public static final String BUILD_GROUP = "build";
    public static final String VERIFICATION_GROUP = "verification";

    @Override
    public void apply(ProjectInternal project) {
        this.addClean(project);
        this.addCleanRule(project);
        this.addAssemble(project);
        this.addCheck(project);
        this.addBuild(project);
    }

    private void addClean(final ProjectInternal project) {
        final Callable<File> buildDir = new Callable<File>(){

            @Override
            public File call() {
                return project.getBuildDir();
            }
        };
        BuildOutputCleanupRegistry buildOutputCleanupRegistry = project.getServices().get(BuildOutputCleanupRegistry.class);
        buildOutputCleanupRegistry.registerOutputs(buildDir);
        final TaskProvider<Delete> clean = project.getTasks().register(CLEAN_TASK_NAME, Delete.class, new Action<Delete>(){

            @Override
            public void execute(Delete cleanTask) {
                cleanTask.setDescription("Deletes the build directory.");
                cleanTask.setGroup("build");
                cleanTask.delete(buildDir);
            }
        });
        buildOutputCleanupRegistry.registerOutputs(new Callable<FileCollection>(){

            @Override
            public FileCollection call() {
                ProjectState projectState = project.getServices().get(ProjectStateRegistry.class).stateFor(project);
                return projectState.withMutableState(new Factory<FileCollection>(){

                    @Override
                    @Nullable
                    public FileCollection create() {
                        return ((Delete)clean.get()).getTargetFiles();
                    }
                });
            }
        });
    }

    private void addCleanRule(Project project) {
        project.getTasks().addRule(new CleanRule(project.getTasks()));
    }

    private void addAssemble(ProjectInternal project) {
        project.getTasks().register(ASSEMBLE_TASK_NAME, (Action<? super Task>)new Action<Task>(){

            @Override
            public void execute(Task assembleTask) {
                assembleTask.setDescription("Assembles the outputs of this project.");
                assembleTask.setGroup("build");
            }
        });
    }

    private void addCheck(ProjectInternal project) {
        project.getTasks().register(CHECK_TASK_NAME, (Action<? super Task>)new Action<Task>(){

            @Override
            public void execute(Task checkTask) {
                checkTask.setDescription("Runs all checks.");
                checkTask.setGroup(LifecycleBasePlugin.VERIFICATION_GROUP);
            }
        });
    }

    private void addBuild(ProjectInternal project) {
        project.getTasks().register("build", (Action<? super Task>)new Action<Task>(){

            @Override
            public void execute(Task buildTask) {
                buildTask.setDescription("Assembles and tests this project.");
                buildTask.setGroup("build");
                buildTask.dependsOn(LifecycleBasePlugin.ASSEMBLE_TASK_NAME);
                buildTask.dependsOn(LifecycleBasePlugin.CHECK_TASK_NAME);
            }
        });
    }
}

