/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Named;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.util.GUtil;

public class DefaultBinaryNamingScheme
implements BinaryNamingScheme {
    @Nullable
    final String parentName;
    @Nullable
    private final String binaryName;
    @Nullable
    final String binaryType;
    final String dimensionPrefix;
    @Nullable
    private final String role;
    private final boolean main;
    final List<String> dimensions;

    DefaultBinaryNamingScheme(@Nullable String parentName, @Nullable String binaryName, @Nullable String binaryType, @Nullable String role, boolean main, List<String> dimensions) {
        this.parentName = parentName;
        this.binaryName = binaryName;
        this.binaryType = binaryType;
        this.role = role;
        this.main = main;
        this.dimensions = dimensions;
        this.dimensionPrefix = this.createPrefix(dimensions);
    }

    public static BinaryNamingScheme component(@Nullable String componentName) {
        return new DefaultBinaryNamingScheme(componentName, null, null, null, false, Collections.<String>emptyList());
    }

    @Override
    public BinaryNamingScheme withVariantDimension(String dimension) {
        ArrayList<String> newDimensions = new ArrayList<String>(this.dimensions.size() + 1);
        newDimensions.addAll(this.dimensions);
        newDimensions.add(dimension);
        return new DefaultBinaryNamingScheme(this.parentName, this.binaryName, this.binaryType, this.role, this.main, newDimensions);
    }

    @Override
    public <T extends Named> BinaryNamingScheme withVariantDimension(T value, Collection<? extends T> allValuesForAxis) {
        if (allValuesForAxis.size() == 1) {
            return this;
        }
        return this.withVariantDimension(value.getName());
    }

    @Override
    public BinaryNamingScheme withRole(String role, boolean isMain) {
        return new DefaultBinaryNamingScheme(this.parentName, this.binaryName, this.binaryType, role, isMain, this.dimensions);
    }

    @Override
    public BinaryNamingScheme withBinaryType(@Nullable String type) {
        return new DefaultBinaryNamingScheme(this.parentName, this.binaryName, type, this.role, this.main, this.dimensions);
    }

    @Override
    public BinaryNamingScheme withComponentName(@Nullable String componentName) {
        return new DefaultBinaryNamingScheme(componentName, this.binaryName, this.binaryType, this.role, this.main, this.dimensions);
    }

    @Override
    public BinaryNamingScheme withBinaryName(@Nullable String name) {
        return new DefaultBinaryNamingScheme(this.parentName, name, this.binaryType, this.role, this.main, this.dimensions);
    }

    private String createPrefix(List<String> dimensions) {
        if (dimensions.isEmpty()) {
            return "";
        }
        return this.makeName(dimensions.toArray(new String[0]));
    }

    public String getBaseName() {
        return this.parentName;
    }

    @Override
    public String getBinaryName() {
        return this.binaryName != null ? this.binaryName : this.makeName(this.dimensionPrefix, this.binaryType);
    }

    private String getOutputDirectoryBase(@Nullable String outputType) {
        ArrayList elements = Lists.newArrayList();
        elements.add(outputType);
        elements.add(this.parentName);
        if (this.binaryName != null) {
            elements.add(this.binaryName);
        } else {
            if (!this.main) {
                if (this.role != null) {
                    elements.add(this.role);
                } else {
                    elements.add(this.binaryType);
                }
            }
            elements.addAll(this.dimensions);
        }
        return this.makePath(elements);
    }

    @Override
    public File getOutputDirectory(File baseDir) {
        return this.getOutputDirectory(baseDir, null);
    }

    @Override
    public File getOutputDirectory(File baseDir, @Nullable String outputType) {
        return new File(baseDir, this.getOutputDirectoryBase(outputType));
    }

    @Override
    public String getDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append(GUtil.toWords(this.binaryType));
        builder.append(" '");
        ArrayList elements = Lists.newArrayList();
        elements.add(this.parentName);
        if (this.binaryName != null) {
            elements.add(this.binaryName);
        } else {
            elements.addAll(this.dimensions);
            elements.add(this.binaryType);
        }
        builder.append(this.makeSeparated(elements));
        builder.append("'");
        return builder.toString();
    }

    @Override
    public List<String> getVariantDimensions() {
        return this.dimensions;
    }

    @Override
    public String getTaskName(@Nullable String verb) {
        return this.getTaskName(verb, null);
    }

    @Override
    public String getTaskName(@Nullable String verb, @Nullable String target) {
        if (this.binaryName != null) {
            return this.makeName(verb, this.parentName, this.binaryName, target);
        }
        return this.makeName(verb, this.parentName, this.dimensionPrefix, this.binaryType, target);
    }

    private String makeName(String ... words) {
        int expectedLength = 0;
        for (String word : words) {
            if (word == null) continue;
            expectedLength += word.length();
        }
        StringBuilder builder = new StringBuilder(expectedLength);
        for (String word : words) {
            if (word == null || word.length() == 0) continue;
            if (builder.length() == 0) {
                this.appendUncapitalized(builder, word);
                continue;
            }
            this.appendCapitalized(builder, word);
        }
        return builder.toString();
    }

    private String makePath(Iterable<String> words) {
        int expectedLength = 0;
        for (String word : words) {
            if (word == null) continue;
            expectedLength += word.length() + 1;
        }
        StringBuilder builder = new StringBuilder(expectedLength);
        for (String word : words) {
            if (word == null || word.length() == 0) continue;
            if (builder.length() > 0) {
                builder.append('/');
            }
            this.appendUncapitalized(builder, word);
        }
        return builder.toString();
    }

    private String makeSeparated(Iterable<String> words) {
        int expectedLength = 0;
        for (String word : words) {
            if (word == null) continue;
            expectedLength += word.length() + 1;
        }
        StringBuilder builder = new StringBuilder(expectedLength);
        for (String word : words) {
            if (word == null || word.length() == 0) continue;
            if (builder.length() > 0) {
                builder.append(':');
            }
            this.appendUncapitalized(builder, word);
        }
        return builder.toString();
    }

    private void appendCapitalized(StringBuilder builder, String word) {
        if (word.length() == 0) {
            return;
        }
        builder.append(Character.toTitleCase(word.charAt(0))).append(word.substring(1));
    }

    private void appendUncapitalized(StringBuilder builder, String word) {
        if (word.length() == 0) {
            return;
        }
        builder.append(Character.toLowerCase(word.charAt(0))).append(word.substring(1));
    }
}

