/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea.model;

import groovy.util.Node;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Incubating;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.plugins.ide.idea.model.PathFactory;

@Incubating
public class ProjectLibrary {
    private String name;
    private String type;
    private Set<File> compilerClasspath = Sets.newLinkedHashSet();
    private Set<File> classes = Sets.newLinkedHashSet();
    private Set<File> javadoc = Sets.newLinkedHashSet();
    private Set<File> sources = Sets.newLinkedHashSet();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Set<File> getCompilerClasspath() {
        return this.compilerClasspath;
    }

    public void setCompilerClasspath(Set<File> compilerClasspath) {
        this.compilerClasspath = compilerClasspath;
    }

    public Set<File> getClasses() {
        return this.classes;
    }

    public void setClasses(Set<File> classes) {
        this.classes = classes;
    }

    public Set<File> getJavadoc() {
        return this.javadoc;
    }

    public void setJavadoc(Set<File> javadoc) {
        this.javadoc = javadoc;
    }

    public Set<File> getSources() {
        return this.sources;
    }

    public void setSources(Set<File> sources) {
        this.sources = sources;
    }

    public void addToNode(Node parentNode, PathFactory pathFactory) {
        LinkedHashMap libraryAttributes = Maps.newLinkedHashMap();
        libraryAttributes.put("name", this.name);
        if (this.type != null) {
            libraryAttributes.put("type", this.type);
        }
        Node libraryNode = parentNode.appendNode((Object)"library", (Map)libraryAttributes);
        Node classesNode = libraryNode.appendNode((Object)"CLASSES");
        for (File file : this.classes) {
            LinkedHashMap attributes = Maps.newLinkedHashMap();
            attributes.put("url", pathFactory.path(file).getUrl());
            classesNode.appendNode((Object)"root", (Map)attributes);
        }
        Node javadocNode = libraryNode.appendNode((Object)"JAVADOC");
        for (File file : this.javadoc) {
            LinkedHashMap attributes = Maps.newLinkedHashMap();
            attributes.put("url", pathFactory.path(file).getUrl());
            javadocNode.appendNode((Object)"root", (Map)attributes);
        }
        Node sourcesNode = libraryNode.appendNode((Object)"SOURCES");
        for (File file : this.sources) {
            LinkedHashMap attributes = Maps.newLinkedHashMap();
            attributes.put("url", pathFactory.path(file).getUrl());
            sourcesNode.appendNode((Object)"root", (Map)attributes);
        }
        if (this.compilerClasspath.size() > 0) {
            Node properties = libraryNode.appendNode((Object)"properties");
            Node compilerClasspathNode = properties.appendNode((Object)"compiler-classpath");
            for (File file : this.compilerClasspath) {
                LinkedHashMap attributes = Maps.newLinkedHashMap();
                attributes.put("url", pathFactory.path(file, true).getUrl());
                compilerClasspathNode.appendNode((Object)"root", (Map)attributes);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProjectLibrary)) {
            return false;
        }
        ProjectLibrary that = (ProjectLibrary)obj;
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal(this.compilerClasspath, that.compilerClasspath) && Objects.equal(this.classes, that.classes) && Objects.equal(this.javadoc, that.javadoc) && Objects.equal(this.sources, that.sources);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + this.compilerClasspath.hashCode();
        result = 31 * result + this.classes.hashCode();
        result = 31 * result + this.javadoc.hashCode();
        result = 31 * result + this.sources.hashCode();
        return result;
    }
}

