/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.io.File;
import java.util.Set;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.JavaForkOptionsInternal;
import org.gradle.workers.internal.KeepAliveMode;

public class DaemonForkOptions {
    private final JavaForkOptionsInternal forkOptions;
    private final Iterable<File> classpath;
    private final Iterable<String> sharedPackages;
    private final KeepAliveMode keepAliveMode;

    DaemonForkOptions(JavaForkOptionsInternal forkOptions, Iterable<File> classpath, Iterable<String> sharedPackages, KeepAliveMode keepAliveMode) {
        this.forkOptions = forkOptions;
        this.classpath = classpath;
        this.sharedPackages = sharedPackages;
        this.keepAliveMode = keepAliveMode;
    }

    public Iterable<File> getClasspath() {
        return this.classpath;
    }

    public Iterable<String> getSharedPackages() {
        return this.sharedPackages;
    }

    public KeepAliveMode getKeepAliveMode() {
        return this.keepAliveMode;
    }

    public JavaForkOptions getJavaForkOptions() {
        return this.forkOptions;
    }

    public boolean isCompatibleWith(DaemonForkOptions other) {
        return this.forkOptions.isCompatibleWith(other.forkOptions) && this.getNormalizedClasspath(this.classpath).containsAll(this.getNormalizedClasspath(other.getClasspath())) && this.getNormalizedSharedPackages(this.sharedPackages).containsAll(this.getNormalizedSharedPackages(other.sharedPackages)) && this.keepAliveMode == other.getKeepAliveMode();
    }

    public DaemonForkOptions mergeWith(DaemonForkOptions other) {
        if (this.keepAliveMode != other.getKeepAliveMode()) {
            throw new IllegalArgumentException("Cannot merge a fork options object with a different keep alive mode (this: " + (Object)((Object)this.keepAliveMode) + ", other: " + (Object)((Object)other.getKeepAliveMode()) + ").");
        }
        Set<File> mergedClasspath = this.getNormalizedClasspath(this.classpath);
        mergedClasspath.addAll(this.getNormalizedClasspath(other.classpath));
        Set<String> mergedAllowedPackages = this.getNormalizedSharedPackages(this.sharedPackages);
        mergedAllowedPackages.addAll(this.getNormalizedSharedPackages(other.sharedPackages));
        return new DaemonForkOptions(this.forkOptions.mergeWith(other.forkOptions), mergedClasspath, mergedAllowedPackages, this.keepAliveMode);
    }

    private Set<File> getNormalizedClasspath(Iterable<File> classpath) {
        return Sets.newLinkedHashSet(classpath);
    }

    private Set<String> getNormalizedSharedPackages(Iterable<String> allowedPackages) {
        return Sets.newLinkedHashSet(allowedPackages);
    }

    private String getNormalized(String string) {
        return Strings.nullToEmpty((String)string).trim();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("executable", (Object)this.forkOptions.getExecutable()).add("minHeapSize", (Object)this.forkOptions.getMinHeapSize()).add("maxHeapSize", (Object)this.forkOptions.getMaxHeapSize()).add("jvmArgs", this.forkOptions.getJvmArgs()).add("classpath", this.classpath).add("keepAliveMode", (Object)this.keepAliveMode).toString();
    }
}

