/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.io.PathKt;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.maven.indices.IndicesBundle;
import org.jetbrains.idea.maven.indices.MavenArchetypesProvider;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndexException;
import org.jetbrains.idea.maven.indices.MavenIndices;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenIndexerWrapper;
import org.jetbrains.idea.maven.server.MavenServerDownloadListener;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenRehighlighter;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenIndicesManager
implements Disposable {
    private static final String ELEMENT_ARCHETYPES = "archetypes";
    private static final String ELEMENT_ARCHETYPE = "archetype";
    private static final String ELEMENT_GROUP_ID = "groupId";
    private static final String ELEMENT_ARTIFACT_ID = "artifactId";
    private static final String ELEMENT_VERSION = "version";
    private static final String ELEMENT_REPOSITORY = "repository";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String LOCAL_REPOSITORY_ID = "local";
    private MavenServerDownloadListener myDownloadListener;
    private volatile Path myTestIndicesDir;
    private volatile MavenIndexerWrapper myIndexer;
    private volatile MavenIndices myIndices;
    private final Object myUpdatingIndicesLock = new Object();
    private final List<MavenIndex> myWaitingIndices = new ArrayList<MavenIndex>();
    private volatile MavenIndex myUpdatingIndex;
    private final BackgroundTaskQueue myUpdatingQueue = new BackgroundTaskQueue(null, IndicesBundle.message("maven.indices.updating", new Object[0]));
    private volatile List<MavenArchetype> myUserArchetypes = new ArrayList<MavenArchetype>();

    public static MavenIndicesManager getInstance() {
        return (MavenIndicesManager)ServiceManager.getService(MavenIndicesManager.class);
    }

    public void setTestIndexDir(Path indicesDir) {
        this.myTestIndicesDir = indicesDir;
    }

    public void clear() {
        this.myUpdatingQueue.clear();
    }

    private synchronized MavenIndices getIndicesObject() {
        this.ensureInitialized();
        return this.myIndices;
    }

    private synchronized void ensureInitialized() {
        if (this.myIndices != null) {
            return;
        }
        this.myIndexer = MavenServerManager.getInstance().createIndexer();
        this.myDownloadListener = new MavenServerDownloadListener(){

            public void artifactDownloaded(File file, String relativePath) {
                MavenIndicesManager.this.addArtifact(file, relativePath);
            }
        };
        MavenServerManager.getInstance().addDownloadListener(this.myDownloadListener);
        this.myIndices = new MavenIndices(this.myIndexer, this.getIndicesDir().toFile(), new MavenIndex.IndexListener(){

            @Override
            public void indexIsBroken(@NotNull MavenIndex index) {
                if (index == null) {
                    2.$$$reportNull$$$0(0);
                }
                MavenIndicesManager.this.scheduleUpdate(null, Collections.singletonList(index), false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "org/jetbrains/idea/maven/indices/MavenIndicesManager$2", "indexIsBroken"));
            }
        });
        this.loadUserArchetypes();
    }

    @NotNull
    private Path getIndicesDir() {
        Path path = this.myTestIndicesDir == null ? MavenUtil.getPluginSystemDir("Indices") : this.myTestIndicesDir;
        if (path == null) {
            MavenIndicesManager.$$$reportNull$$$0(0);
        }
        return path;
    }

    public void dispose() {
        this.doShutdown();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PathKt.delete((Path)this.getIndicesDir());
        }
    }

    private synchronized void doShutdown() {
        if (this.myDownloadListener != null) {
            MavenServerManager.getInstance().removeDownloadListener(this.myDownloadListener);
            this.myDownloadListener = null;
        }
        if (this.myIndices != null) {
            try {
                this.myIndices.close();
            }
            catch (Exception e) {
                MavenLog.LOG.error("", (Throwable)e);
            }
            this.myIndices = null;
        }
        this.clear();
        this.myIndexer = null;
    }

    public void doShutdownInTests() {
        this.doShutdown();
    }

    public List<MavenIndex> getIndices() {
        return this.getIndicesObject().getIndices();
    }

    public synchronized List<MavenIndex> ensureIndicesExist(Project project, File localRepository, Collection<Pair<String, String>> remoteRepositoriesIdsAndUrls) {
        LinkedHashSet<MavenIndex> result = new LinkedHashSet<MavenIndex>();
        MavenIndices indicesObjectCache = this.getIndicesObject();
        try {
            MavenIndex localIndex = indicesObjectCache.add(LOCAL_REPOSITORY_ID, localRepository.getPath(), MavenIndex.Kind.LOCAL);
            result.add(localIndex);
            if (localIndex.getUpdateTimestamp() == -1L) {
                this.scheduleUpdate(project, Collections.singletonList(localIndex));
            }
        }
        catch (MavenIndexException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
        for (Pair<String, String> eachIdAndUrl : remoteRepositoriesIdsAndUrls) {
            try {
                result.add(indicesObjectCache.add((String)eachIdAndUrl.first, (String)eachIdAndUrl.second, MavenIndex.Kind.REMOTE));
            }
            catch (MavenIndexException e) {
                MavenLog.LOG.warn((Throwable)e);
            }
        }
        return new ArrayList<MavenIndex>(result);
    }

    private void addArtifact(File artifactFile, String relativePath) {
        String repositoryPath = MavenIndicesManager.getRepositoryUrl(artifactFile, relativePath);
        MavenIndex index = this.getIndicesObject().find(repositoryPath, MavenIndex.Kind.LOCAL);
        if (index != null) {
            index.addArtifact(artifactFile);
        }
    }

    private static String getRepositoryUrl(File artifactFile, String name) {
        List<String> parts = MavenIndicesManager.getArtifactParts(name);
        File result = artifactFile;
        for (int i = 0; i < parts.size(); ++i) {
            result = result.getParentFile();
        }
        return result.getPath();
    }

    private static List<String> getArtifactParts(String name) {
        return StringUtil.split((String)name, (String)"/");
    }

    public Promise<Void> scheduleUpdate(Project project, List<MavenIndex> indices) {
        return this.scheduleUpdate(project, indices, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Promise<Void> scheduleUpdate(final Project projectOrNull, List<MavenIndex> indices, final boolean fullUpdate) {
        final ArrayList<MavenIndex> toSchedule = new ArrayList<MavenIndex>();
        Object object = this.myUpdatingIndicesLock;
        synchronized (object) {
            for (MavenIndex each : indices) {
                if (this.myWaitingIndices.contains(each)) continue;
                toSchedule.add(each);
            }
            this.myWaitingIndices.addAll(toSchedule);
        }
        if (toSchedule.isEmpty()) {
            return Promises.resolvedPromise();
        }
        final AsyncPromise promise = new AsyncPromise();
        this.myUpdatingQueue.run(new Task.Backgroundable(projectOrNull, IndicesBundle.message("maven.indices.updating", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                try {
                    indicator.setIndeterminate(false);
                    MavenIndicesManager.this.doUpdateIndices(projectOrNull, toSchedule, fullUpdate, new MavenProgressIndicator(indicator));
                }
                catch (MavenProcessCanceledException mavenProcessCanceledException) {
                }
                finally {
                    promise.setResult(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/indices/MavenIndicesManager$3", "run"));
            }
        });
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateIndices(Project projectOrNull, List<MavenIndex> indices, boolean fullUpdate, MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        Object object;
        MavenLog.LOG.assertTrue(!fullUpdate || projectOrNull != null);
        ArrayList<MavenIndex> remainingWaiting = new ArrayList<MavenIndex>(indices);
        try {
            for (MavenIndex each : indices) {
                if (indicator.isCanceled()) {
                    return;
                }
                indicator.setText(IndicesBundle.message("maven.indices.updating.index", each.getRepositoryId(), each.getRepositoryPathOrUrl()));
                object = this.myUpdatingIndicesLock;
                synchronized (object) {
                    remainingWaiting.remove(each);
                    this.myWaitingIndices.remove(each);
                    this.myUpdatingIndex = each;
                }
                try {
                    MavenIndices.updateOrRepair(each, fullUpdate, fullUpdate ? MavenIndicesManager.getMavenSettings(projectOrNull, indicator) : null, indicator);
                    if (projectOrNull == null) continue;
                    MavenRehighlighter.rehighlight(projectOrNull);
                }
                finally {
                    object = this.myUpdatingIndicesLock;
                    synchronized (object) {
                        this.myUpdatingIndex = null;
                    }
                }
            }
        }
        finally {
            object = this.myUpdatingIndicesLock;
            synchronized (object) {
                this.myWaitingIndices.removeAll(remainingWaiting);
            }
        }
    }

    private static MavenGeneralSettings getMavenSettings(@NotNull Project project, @NotNull MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        MavenGeneralSettings settings;
        if (project == null) {
            MavenIndicesManager.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            MavenIndicesManager.$$$reportNull$$$0(2);
        }
        if ((settings = (MavenGeneralSettings)ReadAction.compute(() -> {
            if (project == null) {
                MavenIndicesManager.$$$reportNull$$$0(4);
            }
            return project.isDisposed() ? null : MavenProjectsManager.getInstance(project).getGeneralSettings().clone();
        })) == null) {
            indicator.cancel();
            indicator.checkCanceled();
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexUpdatingState getUpdatingState(MavenIndex index) {
        Object object = this.myUpdatingIndicesLock;
        synchronized (object) {
            if (this.myUpdatingIndex == index) {
                return IndexUpdatingState.UPDATING;
            }
            if (this.myWaitingIndices.contains(index)) {
                return IndexUpdatingState.WAITING;
            }
            return IndexUpdatingState.IDLE;
        }
    }

    public synchronized Set<MavenArchetype> getArchetypes() {
        this.ensureInitialized();
        THashSet result = new THashSet(this.myIndexer.getArchetypes());
        result.addAll(this.myUserArchetypes);
        for (MavenIndex index : this.myIndices.getIndices()) {
            result.addAll(index.getArchetypes());
        }
        for (MavenArchetypesProvider each : MavenArchetypesProvider.EP_NAME.getExtensionList()) {
            result.addAll(each.getArchetypes());
        }
        return result;
    }

    public synchronized void addArchetype(MavenArchetype archetype) {
        this.ensureInitialized();
        int idx = this.myUserArchetypes.indexOf(archetype);
        if (idx >= 0) {
            this.myUserArchetypes.set(idx, archetype);
        } else {
            this.myUserArchetypes.add(archetype);
        }
        this.saveUserArchetypes();
    }

    private void loadUserArchetypes() {
        try {
            Path file = this.getUserArchetypesFile();
            if (!PathKt.exists((Path)file)) {
                return;
            }
            LinkedHashSet<MavenArchetype> result = new LinkedHashSet<MavenArchetype>();
            List children = JdomKt.loadElement((Path)file).getChildren(ELEMENT_ARCHETYPE);
            for (int i = children.size() - 1; i >= 0; --i) {
                Element each = (Element)children.get(i);
                String groupId = each.getAttributeValue(ELEMENT_GROUP_ID);
                String artifactId = each.getAttributeValue(ELEMENT_ARTIFACT_ID);
                String version = each.getAttributeValue(ELEMENT_VERSION);
                String repository = each.getAttributeValue(ELEMENT_REPOSITORY);
                String description = each.getAttributeValue(ELEMENT_DESCRIPTION);
                if (StringUtil.isEmptyOrSpaces((String)groupId) || StringUtil.isEmptyOrSpaces((String)artifactId) || StringUtil.isEmptyOrSpaces((String)version)) continue;
                result.add(new MavenArchetype(groupId, artifactId, version, repository, description));
            }
            ArrayList<MavenArchetype> listResult = new ArrayList<MavenArchetype>(result);
            Collections.reverse(listResult);
            this.myUserArchetypes = listResult;
        }
        catch (IOException | JDOMException e) {
            MavenLog.LOG.warn(e);
        }
    }

    private void saveUserArchetypes() {
        Element root = new Element(ELEMENT_ARCHETYPES);
        for (MavenArchetype each : this.myUserArchetypes) {
            Element childElement = new Element(ELEMENT_ARCHETYPE);
            childElement.setAttribute(ELEMENT_GROUP_ID, each.groupId);
            childElement.setAttribute(ELEMENT_ARTIFACT_ID, each.artifactId);
            childElement.setAttribute(ELEMENT_VERSION, each.version);
            if (each.repository != null) {
                childElement.setAttribute(ELEMENT_REPOSITORY, each.repository);
            }
            if (each.description != null) {
                childElement.setAttribute(ELEMENT_DESCRIPTION, each.description);
            }
            root.addContent(childElement);
        }
        try {
            JdomKt.write((Parent)root, (Path)this.getUserArchetypesFile());
        }
        catch (IOException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
    }

    @NotNull
    private Path getUserArchetypesFile() {
        Path path = this.getIndicesDir().resolve("UserArchetypes.xml");
        if (path == null) {
            MavenIndicesManager.$$$reportNull$$$0(3);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/indices/MavenIndicesManager";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndicesDir";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenIndicesManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserArchetypesFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMavenSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getMavenSettings$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum IndexUpdatingState {
        IDLE,
        WAITING,
        UPDATING;

    }
}

