/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightFixUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CastMethodArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeStringLiteralToCharInMethodCallFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeTypeArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ConstructorParametersFixer;
import com.intellij.codeInsight.daemon.impl.quickfix.ConvertDoubleToFloatFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodReturnFixFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.PermuteArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifySuperArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyThisArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveRedundantArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapExpressionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapObjectWithOptionalOfNullableFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapWithAdapterMethodCallFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.LocalQuickFixOnPsiElementAsIntentionAdapter;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightMethodUtil {
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();
    private static final String MISMATCH_COLOR = UIUtil.isUnderDarcula() ? "ff6464" : "red";
    private static final Logger LOG = Logger.getInstance(HighlightMethodUtil.class);

    private HighlightMethodUtil() {
    }

    @NotNull
    static String createClashMethodMessage(@NotNull PsiMethod method1, @NotNull PsiMethod method2, boolean showContainingClasses) {
        if (method1 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(0);
        }
        if (method2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(1);
        }
        if (showContainingClasses) {
            PsiClass class1 = method1.getContainingClass();
            PsiClass class2 = method2.getContainingClass();
            if (class1 != null && class2 != null) {
                String string = JavaErrorMessages.message("clash.methods.message.show.classes", JavaHighlightUtil.formatMethod(method1), JavaHighlightUtil.formatMethod(method2), HighlightUtil.formatClass(class1), HighlightUtil.formatClass(class2));
                if (string == null) {
                    HighlightMethodUtil.$$$reportNull$$$0(2);
                }
                return string;
            }
        }
        String string = JavaErrorMessages.message("clash.methods.message", JavaHighlightUtil.formatMethod(method1), JavaHighlightUtil.formatMethod(method2));
        if (string == null) {
            HighlightMethodUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    static HighlightInfo checkMethodWeakerPrivileges(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<? extends HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo, @NotNull PsiFile containingFile) {
        PsiMethod method;
        PsiModifierList modifierList;
        if (methodSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(4);
        }
        if (superMethodSignatures == null) {
            HighlightMethodUtil.$$$reportNull$$$0(5);
        }
        if (containingFile == null) {
            HighlightMethodUtil.$$$reportNull$$$0(6);
        }
        if ((modifierList = (method = methodSignature.getMethod()).getModifierList()).hasModifierProperty("public")) {
            return null;
        }
        int accessLevel = PsiUtil.getAccessLevel((PsiModifierList)modifierList);
        String accessModifier = PsiUtil.getAccessModifier((int)accessLevel);
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            HighlightInfo info;
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            if (method.hasModifierProperty("abstract") && !MethodSignatureUtil.isSuperMethod((PsiMethod)superMethod, (PsiMethod)method) || !PsiUtil.isAccessible((Project)containingFile.getProject(), (PsiMember)superMethod, (PsiElement)method, null) || !includeRealPositionInfo && MethodSignatureUtil.isSuperMethod((PsiMethod)superMethod, (PsiMethod)method) || (info = HighlightMethodUtil.isWeaker(method, modifierList, accessModifier, accessLevel, superMethod, includeRealPositionInfo)) == null) continue;
            return info;
        }
        return null;
    }

    private static HighlightInfo isWeaker(@NotNull PsiMethod method, @NotNull PsiModifierList modifierList, @NotNull String accessModifier, int accessLevel, @NotNull PsiMethod superMethod, boolean includeRealPositionInfo) {
        int superAccessLevel;
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(7);
        }
        if (modifierList == null) {
            HighlightMethodUtil.$$$reportNull$$$0(8);
        }
        if (accessModifier == null) {
            HighlightMethodUtil.$$$reportNull$$$0(9);
        }
        if (superMethod == null) {
            HighlightMethodUtil.$$$reportNull$$$0(10);
        }
        if (accessLevel < (superAccessLevel = PsiUtil.getAccessLevel((PsiModifierList)superMethod.getModifierList()))) {
            String description = JavaErrorMessages.message("weaker.privileges", HighlightMethodUtil.createClashMethodMessage(method, superMethod, true), VisibilityUtil.toPresentableText((String)accessModifier), PsiUtil.getAccessModifier((int)superAccessLevel));
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (includeRealPositionInfo) {
                PsiElement keyword = PsiUtil.findModifierInList((PsiModifierList)modifierList, (String)accessModifier);
                if (keyword != null) {
                    textRange = keyword.getTextRange();
                } else {
                    PsiIdentifier identifier = method.getNameIdentifier();
                    if (identifier != null) {
                        textRange = identifier.getTextRange();
                    }
                }
            }
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, PsiUtil.getAccessModifier((int)superAccessLevel), true, false));
            return info;
        }
        return null;
    }

    static HighlightInfo checkMethodIncompatibleReturnType(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<? extends HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo) {
        if (methodSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(11);
        }
        if (superMethodSignatures == null) {
            HighlightMethodUtil.$$$reportNull$$$0(12);
        }
        return HighlightMethodUtil.checkMethodIncompatibleReturnType(methodSignature, superMethodSignatures, includeRealPositionInfo, null);
    }

    static HighlightInfo checkMethodIncompatibleReturnType(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<? extends HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo, @Nullable TextRange textRange) {
        if (methodSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(13);
        }
        if (superMethodSignatures == null) {
            HighlightMethodUtil.$$$reportNull$$$0(14);
        }
        PsiMethod method = methodSignature.getMethod();
        PsiType returnType = methodSignature.getSubstitutor().substitute(method.getReturnType());
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            HighlightInfo info;
            PsiTypeElement typeElement;
            PsiClass superClass;
            PsiType declaredReturnType;
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            PsiType superReturnType = declaredReturnType = superMethod.getReturnType();
            if (methodSignatureBackedByPsiMethod.isRaw()) {
                superReturnType = TypeConversionUtil.erasure((PsiType)declaredReturnType);
            }
            if (returnType == null || superReturnType == null || method == superMethod || (superClass = superMethod.getContainingClass()) == null) continue;
            if (textRange == null && includeRealPositionInfo && (typeElement = method.getReturnTypeElement()) != null) {
                textRange = typeElement.getTextRange();
            }
            if (textRange == null) {
                textRange = TextRange.EMPTY_RANGE;
            }
            if ((info = HighlightMethodUtil.checkSuperMethodSignature(superMethod, methodSignatureBackedByPsiMethod, superReturnType, method, methodSignature, returnType, JavaErrorMessages.message("incompatible.return.type", new Object[0]), textRange, PsiUtil.getLanguageLevel((PsiElement)aClass))) == null) continue;
            return info;
        }
        return null;
    }

    private static HighlightInfo checkSuperMethodSignature(@NotNull PsiMethod superMethod, @NotNull MethodSignatureBackedByPsiMethod superMethodSignature, @NotNull PsiType superReturnType, @NotNull PsiMethod method, @NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull PsiType returnType, @NotNull String detailMessage, @NotNull TextRange range, @NotNull LanguageLevel languageLevel) {
        PsiSubstitutor unifyingSubstitutor;
        PsiClass containingClass;
        PsiClass superContainingClass;
        if (superMethod == null) {
            HighlightMethodUtil.$$$reportNull$$$0(15);
        }
        if (superMethodSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(16);
        }
        if (superReturnType == null) {
            HighlightMethodUtil.$$$reportNull$$$0(17);
        }
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(18);
        }
        if (methodSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(19);
        }
        if (returnType == null) {
            HighlightMethodUtil.$$$reportNull$$$0(20);
        }
        if (detailMessage == null) {
            HighlightMethodUtil.$$$reportNull$$$0(21);
        }
        if (range == null) {
            HighlightMethodUtil.$$$reportNull$$$0(22);
        }
        if (languageLevel == null) {
            HighlightMethodUtil.$$$reportNull$$$0(23);
        }
        if ((superContainingClass = superMethod.getContainingClass()) != null && "java.lang.Object".equals(superContainingClass.getQualifiedName()) && !superMethod.hasModifierProperty("public") && (containingClass = method.getContainingClass()) != null && containingClass.isInterface() && !superContainingClass.isInterface()) {
            return null;
        }
        boolean isJdk15 = languageLevel.isAtLeast(LanguageLevel.JDK_1_5);
        PsiType substitutedSuperReturnType = isJdk15 && !superMethodSignature.isRaw() && superMethodSignature.equals((Object)methodSignature) ? ((unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)methodSignature, (MethodSignature)superMethodSignature)) == null ? superReturnType : unifyingSubstitutor.substitute(superReturnType)) : TypeConversionUtil.erasure((PsiType)superMethodSignature.getSubstitutor().substitute(superReturnType));
        if (returnType.equals(substitutedSuperReturnType)) {
            return null;
        }
        if (!(returnType instanceof PsiPrimitiveType) && substitutedSuperReturnType.getDeepComponentType() instanceof PsiClassType && isJdk15 && ((Boolean)LambdaUtil.performWithSubstitutedParameterBounds((PsiTypeParameter[])methodSignature.getTypeParameters(), (PsiSubstitutor)methodSignature.getSubstitutor(), () -> {
            if (returnType == null) {
                HighlightMethodUtil.$$$reportNull$$$0(202);
            }
            return TypeConversionUtil.isAssignable((PsiType)substitutedSuperReturnType, (PsiType)returnType);
        })).booleanValue()) {
            return null;
        }
        return HighlightMethodUtil.createIncompatibleReturnTypeMessage(method, superMethod, substitutedSuperReturnType, returnType, detailMessage, range);
    }

    private static HighlightInfo createIncompatibleReturnTypeMessage(@NotNull PsiMethod method, @NotNull PsiMethod superMethod, @NotNull PsiType substitutedSuperReturnType, @NotNull PsiType returnType, @NotNull String detailMessage, @NotNull TextRange textRange) {
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(24);
        }
        if (superMethod == null) {
            HighlightMethodUtil.$$$reportNull$$$0(25);
        }
        if (substitutedSuperReturnType == null) {
            HighlightMethodUtil.$$$reportNull$$$0(26);
        }
        if (returnType == null) {
            HighlightMethodUtil.$$$reportNull$$$0(27);
        }
        if (detailMessage == null) {
            HighlightMethodUtil.$$$reportNull$$$0(28);
        }
        if (textRange == null) {
            HighlightMethodUtil.$$$reportNull$$$0(29);
        }
        String description = MessageFormat.format("{0}; {1}", HighlightMethodUtil.createClashMethodMessage(method, superMethod, true), detailMessage);
        HighlightInfo errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(method, substitutedSuperReturnType, false));
        QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createSuperMethodReturnFix(superMethod, returnType));
        PsiClass returnClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)returnType);
        if (returnClass != null && substitutedSuperReturnType instanceof PsiClassType) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createChangeParameterClassFix(returnClass, (PsiClassType)substitutedSuperReturnType));
        }
        return errorResult;
    }

    static HighlightInfo checkMethodOverridesFinal(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<? extends HierarchicalMethodSignature> superMethodSignatures) {
        if (methodSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(30);
        }
        if (superMethodSignatures == null) {
            HighlightMethodUtil.$$$reportNull$$$0(31);
        }
        PsiMethod method = methodSignature.getMethod();
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            HighlightInfo info = HighlightMethodUtil.checkSuperMethodIsFinal(method, superMethod);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    private static HighlightInfo checkSuperMethodIsFinal(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(32);
        }
        if (superMethod == null) {
            HighlightMethodUtil.$$$reportNull$$$0(33);
        }
        if (superMethod.hasModifierProperty("final")) {
            PsiClass superClass = superMethod.getContainingClass();
            String description = JavaErrorMessages.message("final.method.override", JavaHighlightUtil.formatMethod(method), JavaHighlightUtil.formatMethod(superMethod), superClass != null ? HighlightUtil.formatClass(superClass) : "<unknown>");
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            HighlightInfo errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)superMethod, "final", false, true));
            return errorResult;
        }
        return null;
    }

    static HighlightInfo checkMethodIncompatibleThrows(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<? extends HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo, @NotNull PsiClass analyzedClass) {
        PsiJavaCodeReferenceElement[] referenceElements;
        ArrayList<PsiJavaCodeReferenceElement> exceptionContexts;
        PsiMethod method;
        PsiClass aClass;
        if (methodSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(34);
        }
        if (superMethodSignatures == null) {
            HighlightMethodUtil.$$$reportNull$$$0(35);
        }
        if (analyzedClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(36);
        }
        if ((aClass = (method = methodSignature.getMethod()).getContainingClass()) == null) {
            return null;
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)aClass, (PsiClass)analyzedClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        PsiClassType[] exceptions = method.getThrowsList().getReferencedTypes();
        if (includeRealPositionInfo) {
            exceptionContexts = new ArrayList<PsiJavaCodeReferenceElement>();
            referenceElements = method.getThrowsList().getReferenceElements();
        } else {
            exceptionContexts = null;
            referenceElements = null;
        }
        ArrayList<PsiClassType> checkedExceptions = new ArrayList<PsiClassType>();
        for (int i = 0; i < exceptions.length; ++i) {
            PsiClassType psiClassType = exceptions[i];
            if (psiClassType == null) {
                LOG.error("throws: " + method.getThrowsList().getText() + "; method: " + method);
                continue;
            }
            if (ExceptionUtil.isUncheckedException(psiClassType)) continue;
            checkedExceptions.add(psiClassType);
            if (!includeRealPositionInfo || i >= referenceElements.length) continue;
            PsiJavaCodeReferenceElement exceptionRef = referenceElements[i];
            exceptionContexts.add(exceptionRef);
        }
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            TextRange textRange;
            PsiClass superContainingClass;
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            int index = HighlightMethodUtil.getExtraExceptionNum((MethodSignature)methodSignature, methodSignatureBackedByPsiMethod, checkedExceptions, superSubstitutor);
            if (index == -1 || aClass.isInterface() && ((superContainingClass = superMethod.getContainingClass()) != null && !superContainingClass.isInterface() || superContainingClass != null && !aClass.isInheritor(superContainingClass, true))) continue;
            PsiClassType exception = (PsiClassType)checkedExceptions.get(index);
            String description = JavaErrorMessages.message("overridden.method.does.not.throw", HighlightMethodUtil.createClashMethodMessage(method, superMethod, true), JavaHighlightUtil.formatType((PsiType)exception));
            if (includeRealPositionInfo) {
                PsiElement exceptionContext = (PsiElement)exceptionContexts.get(index);
                textRange = exceptionContext.getTextRange();
            } else {
                textRange = TextRange.EMPTY_RANGE;
            }
            HighlightInfo errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)new LocalQuickFixOnPsiElementAsIntentionAdapter(QUICK_FIX_FACTORY.createMethodThrowsFix(method, exception, false, false)));
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)new LocalQuickFixOnPsiElementAsIntentionAdapter(QUICK_FIX_FACTORY.createMethodThrowsFix(superMethod, exception, true, true)));
            return errorResult;
        }
        return null;
    }

    private static int getExtraExceptionNum(@NotNull MethodSignature methodSignature, @NotNull MethodSignatureBackedByPsiMethod superSignature, @NotNull List<? extends PsiClassType> checkedExceptions, @NotNull PsiSubstitutor substitutorForDerivedClass) {
        if (methodSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(37);
        }
        if (superSignature == null) {
            HighlightMethodUtil.$$$reportNull$$$0(38);
        }
        if (checkedExceptions == null) {
            HighlightMethodUtil.$$$reportNull$$$0(39);
        }
        if (substitutorForDerivedClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(40);
        }
        PsiMethod superMethod = superSignature.getMethod();
        PsiSubstitutor substitutorForMethod = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)methodSignature, (MethodSignature)superSignature);
        for (int i = 0; i < checkedExceptions.size(); ++i) {
            PsiClassType checkedEx = checkedExceptions.get(i);
            PsiType substituted = substitutorForMethod == null ? TypeConversionUtil.erasure((PsiType)checkedEx) : substitutorForMethod.substitute((PsiType)checkedEx);
            PsiType exception = substitutorForDerivedClass.substitute(substituted);
            if (HighlightMethodUtil.isMethodThrows(superMethod, substitutorForMethod, exception, substitutorForDerivedClass)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isMethodThrows(@NotNull PsiMethod method, @Nullable PsiSubstitutor substitutorForMethod, PsiType exception, @NotNull PsiSubstitutor substitutorForDerivedClass) {
        PsiClassType[] thrownExceptions;
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(41);
        }
        if (substitutorForDerivedClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(42);
        }
        for (PsiClassType thrownException1 : thrownExceptions = method.getThrowsList().getReferencedTypes()) {
            PsiType thrownException = substitutorForMethod != null ? substitutorForMethod.substitute((PsiType)thrownException1) : TypeConversionUtil.erasure((PsiType)thrownException1);
            if (!TypeConversionUtil.isAssignable((PsiType)(thrownException = substitutorForDerivedClass.substitute(thrownException)), (PsiType)exception)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static HighlightInfo checkMethodCall(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper, @NotNull LanguageLevel languageLevel, @NotNull JavaSdkVersion javaSdkVersion, @NotNull PsiFile file) {
        HighlightInfo highlightInfo;
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(43);
        }
        if (resolveHelper == null) {
            HighlightMethodUtil.$$$reportNull$$$0(44);
        }
        if (languageLevel == null) {
            HighlightMethodUtil.$$$reportNull$$$0(45);
        }
        if (javaSdkVersion == null) {
            HighlightMethodUtil.$$$reportNull$$$0(46);
        }
        if (file == null) {
            HighlightMethodUtil.$$$reportNull$$$0(47);
        }
        PsiExpressionList list = methodCall.getArgumentList();
        PsiReferenceExpression referenceToMethod = methodCall.getMethodExpression();
        JavaResolveResult[] results = referenceToMethod.multiResolve(true);
        JavaResolveResult resolveResult = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        PsiElement resolved = resolveResult.getElement();
        boolean isDummy = HighlightMethodUtil.isDummyConstructorCall(methodCall, resolveHelper, list, referenceToMethod);
        if (isDummy) {
            return null;
        }
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        if (resolved instanceof PsiMethod && resolveResult.isValidResult()) {
            String errorMessage;
            PsiElement element;
            PsiClass containingClass;
            PsiElement nameElement = referenceToMethod.getReferenceNameElement();
            TextRange fixRange = HighlightMethodUtil.getFixRange((PsiElement)methodCall);
            highlightInfo = HighlightUtil.checkUnhandledExceptions((PsiElement)methodCall, nameElement != null ? nameElement.getTextRange() : fixRange);
            if (highlightInfo == null && ((PsiMethod)resolved).hasModifierProperty("static") && (containingClass = ((PsiMethod)resolved).getContainingClass()) != null && containingClass.isInterface() && (highlightInfo = HighlightUtil.checkFeature(element = (PsiElement)ObjectUtils.notNull((Object)referenceToMethod.getReferenceNameElement(), (Object)referenceToMethod), HighlightUtil.Feature.STATIC_INTERFACE_CALLS, languageLevel, file)) == null) {
                highlightInfo = HighlightMethodUtil.checkStaticInterfaceCallQualifier(referenceToMethod, resolveResult, fixRange, containingClass);
            }
            if (highlightInfo == null) {
                highlightInfo = GenericsHighlightUtil.checkInferredIntersections(substitutor, fixRange);
            }
            if (highlightInfo == null) {
                highlightInfo = HighlightMethodUtil.checkVarargParameterErasureToBeAccessible((MethodCandidateInfo)resolveResult, (PsiCall)methodCall);
            }
            if (highlightInfo == null && (errorMessage = ((MethodCandidateInfo)resolveResult).getInferenceErrorMessage()) != null && (highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(errorMessage).range(fixRange).create()) != null) {
                HighlightMethodUtil.registerMethodCallIntentions(highlightInfo, methodCall, list, resolveHelper);
                HighlightMethodUtil.registerMethodReturnFixAction(highlightInfo, (MethodCandidateInfo)resolveResult, (PsiCall)methodCall);
                HighlightMethodUtil.registerTargetTypeFixesBasedOnApplicabilityInference(methodCall, (MethodCandidateInfo)resolveResult, (PsiMethod)resolved, highlightInfo);
            }
        } else {
            PsiMethod resolvedMethod = null;
            MethodCandidateInfo candidateInfo = null;
            if (resolveResult instanceof MethodCandidateInfo) {
                candidateInfo = (MethodCandidateInfo)resolveResult;
                resolvedMethod = candidateInfo.getElement();
            }
            if (!resolveResult.isAccessible() || !resolveResult.isStaticsScopeCorrect()) {
                highlightInfo = null;
            } else if (candidateInfo != null && !candidateInfo.isApplicable()) {
                if (candidateInfo.isTypeArgumentsApplicable()) {
                    PsiElement element;
                    String toolTip;
                    assert (resolved != null);
                    String methodName = HighlightMessageUtil.getSymbolName(resolved, substitutor);
                    PsiElement parent = resolved.getParent();
                    String containerName = parent == null ? "" : HighlightMessageUtil.getSymbolName(parent, substitutor);
                    String argTypes = HighlightMethodUtil.buildArgTypesList(list);
                    String description = JavaErrorMessages.message("wrong.method.arguments", methodName, containerName, argTypes);
                    Ref elementToHighlight = new Ref((Object)list);
                    if (parent instanceof PsiClass) {
                        toolTip = HighlightMethodUtil.buildOneLineMismatchDescription(list, candidateInfo, (Ref<? super PsiElement>)elementToHighlight);
                        if (toolTip == null) {
                            toolTip = HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(candidateInfo, list);
                        }
                    } else {
                        toolTip = description;
                    }
                    int navigationShift = (element = (PsiElement)elementToHighlight.get()) instanceof PsiExpressionList ? 1 : 0;
                    highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(element).description(description).escapedToolTip(toolTip).navigationShift(navigationShift).create();
                    if (highlightInfo != null) {
                        HighlightMethodUtil.registerMethodCallIntentions(highlightInfo, methodCall, list, resolveHelper);
                        HighlightMethodUtil.registerMethodReturnFixAction(highlightInfo, candidateInfo, (PsiCall)methodCall);
                        HighlightMethodUtil.registerTargetTypeFixesBasedOnApplicabilityInference(methodCall, candidateInfo, resolvedMethod, highlightInfo);
                    }
                } else {
                    PsiReferenceParameterList typeArgumentList = methodCall.getTypeArgumentList();
                    PsiSubstitutor applicabilitySubstitutor = candidateInfo.getSubstitutor(false);
                    highlightInfo = typeArgumentList.getTypeArguments().length == 0 && resolvedMethod.hasTypeParameters() ? GenericsHighlightUtil.checkInferredTypeArguments((PsiTypeParameterListOwner)resolvedMethod, (PsiElement)methodCall, applicabilitySubstitutor) : GenericsHighlightUtil.checkParameterizedReferenceTypeArguments(resolved, (PsiJavaCodeReferenceElement)referenceToMethod, applicabilitySubstitutor, javaSdkVersion);
                }
            } else {
                String description = JavaErrorMessages.message("method.call.expected", new Object[0]);
                highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)methodCall).descriptionAndTooltip(description).create();
                if (resolved instanceof PsiClass) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createInsertNewFix(methodCall, (PsiClass)resolved));
                } else {
                    PsiMethod method;
                    TextRange range = HighlightMethodUtil.getFixRange((PsiElement)methodCall);
                    HighlightMethodUtil.registerUsageFixes(methodCall, highlightInfo, range);
                    QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)range, (IntentionAction)QUICK_FIX_FACTORY.createStaticImportMethodFix(methodCall));
                    QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)range, (IntentionAction)QUICK_FIX_FACTORY.createQualifyStaticMethodCallFix(methodCall));
                    QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)range, (IntentionAction)QUICK_FIX_FACTORY.addMethodQualifierFix(methodCall));
                    if (resolved instanceof PsiVariable && languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && (method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)((PsiVariable)resolved).getType())) != null) {
                        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)range, (IntentionAction)QUICK_FIX_FACTORY.createInsertMethodCallFix(methodCall, method));
                    }
                }
            }
        }
        if (highlightInfo == null) {
            highlightInfo = GenericsHighlightUtil.checkParameterizedReferenceTypeArguments(resolved, (PsiJavaCodeReferenceElement)referenceToMethod, substitutor, javaSdkVersion);
        }
        return highlightInfo;
    }

    private static void registerUsageFixes(@NotNull PsiMethodCallExpression methodCall, @Nullable HighlightInfo highlightInfo, @NotNull TextRange range) {
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(48);
        }
        if (range == null) {
            HighlightMethodUtil.$$$reportNull$$$0(49);
        }
        if (JvmElementActionFactories.useInterlaguageActions()) {
            for (IntentionAction action : QUICK_FIX_FACTORY.createCreateMethodFromUsageFixes(methodCall)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)range, (IntentionAction)action);
            }
        } else {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)range, (IntentionAction)QUICK_FIX_FACTORY.createCreateMethodFromUsageFix(methodCall));
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)range, (IntentionAction)QUICK_FIX_FACTORY.createCreateAbstractMethodFromUsageFix(methodCall));
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)range, (IntentionAction)QUICK_FIX_FACTORY.createCreatePropertyFromUsageFix(methodCall));
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)range, (IntentionAction)QUICK_FIX_FACTORY.createCreateGetterSetterPropertyFromUsageFix(methodCall));
        }
    }

    private static void registerThisSuperFixes(@NotNull PsiMethodCallExpression methodCall, @Nullable HighlightInfo highlightInfo, @NotNull TextRange range) {
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(50);
        }
        if (range == null) {
            HighlightMethodUtil.$$$reportNull$$$0(51);
        }
        for (IntentionAction action : QUICK_FIX_FACTORY.createCreateConstructorFromCallExpressionFixes(methodCall)) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)range, (IntentionAction)action);
        }
    }

    private static void registerTargetTypeFixesBasedOnApplicabilityInference(@NotNull PsiMethodCallExpression methodCall, @NotNull MethodCandidateInfo resolveResult, @NotNull PsiMethod resolved, HighlightInfo highlightInfo) {
        PsiType expectedTypeByApplicabilityConstraints;
        PsiType rType;
        PsiElement resolve;
        PsiExpression lExpression;
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(52);
        }
        if (resolveResult == null) {
            HighlightMethodUtil.$$$reportNull$$$0(53);
        }
        if (resolved == null) {
            HighlightMethodUtil.$$$reportNull$$$0(54);
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)methodCall.getParent());
        PsiVariable variable = null;
        if (parent instanceof PsiVariable) {
            variable = (PsiVariable)parent;
        } else if (parent instanceof PsiAssignmentExpression && (lExpression = ((PsiAssignmentExpression)parent).getLExpression()) instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiVariable) {
            variable = (PsiVariable)resolve;
        }
        if (variable != null && (rType = methodCall.getType()) != null && !variable.getType().isAssignableFrom(rType) && (expectedTypeByApplicabilityConstraints = resolveResult.getSubstitutor(false).substitute(resolved.getReturnType())) != null && !variable.getType().isAssignableFrom(expectedTypeByApplicabilityConstraints)) {
            HighlightFixUtil.registerChangeVariableTypeFixes(variable, expectedTypeByApplicabilityConstraints, (PsiExpression)methodCall, highlightInfo);
        }
    }

    static HighlightInfo checkStaticInterfaceCallQualifier(@NotNull PsiReferenceExpression referenceToMethod, @NotNull JavaResolveResult resolveResult, @NotNull TextRange fixRange, @NotNull PsiClass containingClass) {
        String message2;
        if (referenceToMethod == null) {
            HighlightMethodUtil.$$$reportNull$$$0(55);
        }
        if (resolveResult == null) {
            HighlightMethodUtil.$$$reportNull$$$0(56);
        }
        if (fixRange == null) {
            HighlightMethodUtil.$$$reportNull$$$0(57);
        }
        if (containingClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(58);
        }
        if ((message2 = HighlightMethodUtil.checkStaticInterfaceMethodCallQualifier(referenceToMethod, resolveResult.getCurrentFileResolveScope(), containingClass)) != null) {
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(message2).range(fixRange).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createAccessStaticViaInstanceFix(referenceToMethod, resolveResult));
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    private static String checkStaticInterfaceMethodCallQualifier(@NotNull PsiReferenceExpression ref, @Nullable PsiElement scope, @NotNull PsiClass containingClass) {
        PsiExpression qualifierExpression2;
        if (ref == null) {
            HighlightMethodUtil.$$$reportNull$$$0(59);
        }
        if (containingClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(60);
        }
        if ((qualifierExpression2 = ref.getQualifierExpression()) == null && (scope instanceof PsiImportStaticStatement || PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)ref, (boolean)true))) {
            return null;
        }
        if (qualifierExpression2 instanceof PsiReferenceExpression) {
            PsiElement resolve = ((PsiReferenceExpression)qualifierExpression2).resolve();
            if (resolve == containingClass) {
                return null;
            }
            if (resolve instanceof PsiTypeParameter) {
                HashSet<PsiClass> classes2 = new HashSet<PsiClass>();
                for (PsiClassType type2 : ((PsiTypeParameter)resolve).getExtendsListTypes()) {
                    PsiClass aClass = type2.resolve();
                    if (aClass == null) continue;
                    classes2.add(aClass);
                }
                if (classes2.size() == 1 && classes2.contains(containingClass)) {
                    return null;
                }
            }
        }
        return JavaErrorMessages.message("static.interface.method.call.qualifier", new Object[0]);
    }

    private static void registerMethodReturnFixAction(@NotNull HighlightInfo highlightInfo, @NotNull MethodCandidateInfo candidate, @NotNull PsiCall methodCall) {
        PsiMethod containerMethod;
        if (highlightInfo == null) {
            HighlightMethodUtil.$$$reportNull$$$0(61);
        }
        if (candidate == null) {
            HighlightMethodUtil.$$$reportNull$$$0(62);
        }
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(63);
        }
        if (methodCall.getParent() instanceof PsiReturnStatement && (containerMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class})) != null) {
            PsiMethod method = candidate.getElement();
            PsiExpression methodCallCopy = JavaPsiFacade.getElementFactory((Project)method.getProject()).createExpressionFromText(methodCall.getText(), (PsiElement)methodCall);
            PsiType methodCallTypeByArgs = methodCallCopy.getType();
            methodCallTypeByArgs = JavaPsiFacade.getElementFactory((Project)method.getProject()).createRawSubstitutor((PsiTypeParameterListOwner)method).substitute(methodCallTypeByArgs);
            if (methodCallTypeByArgs != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)HighlightMethodUtil.getFixRange((PsiElement)methodCall), (IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(containerMethod, methodCallTypeByArgs, true));
            }
        }
    }

    private static String buildOneLineMismatchDescription(@NotNull PsiExpressionList list, @NotNull MethodCandidateInfo candidateInfo, @NotNull Ref<? super PsiElement> elementToHighlight) {
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(64);
        }
        if (candidateInfo == null) {
            HighlightMethodUtil.$$$reportNull$$$0(65);
        }
        if (elementToHighlight == null) {
            HighlightMethodUtil.$$$reportNull$$$0(66);
        }
        PsiExpression[] expressions2 = list.getExpressions();
        PsiMethod resolvedMethod = candidateInfo.getElement();
        PsiSubstitutor substitutor = candidateInfo.getSubstitutor();
        PsiParameter[] parameters2 = resolvedMethod.getParameterList().getParameters();
        if (expressions2.length == parameters2.length && parameters2.length > 1) {
            PsiExpression wrongArg;
            PsiType argType;
            int idx = -1;
            for (int i = 0; i < expressions2.length; ++i) {
                JavaResolveResult result;
                PsiExpression expression2 = expressions2[i];
                if (expression2 instanceof PsiMethodCallExpression && (result = ((PsiCallExpression)expression2).resolveMethodGenerics()) instanceof MethodCandidateInfo && PsiUtil.isLanguageLevel8OrHigher((PsiElement)list) && ((MethodCandidateInfo)result).isToInferApplicability() && ((MethodCandidateInfo)result).getInferenceErrorMessage() == null || TypeConversionUtil.areTypesAssignmentCompatible((PsiType)substitutor.substitute(parameters2[i].getType()), (PsiExpression)expression2)) continue;
                if (idx != -1) {
                    idx = -1;
                    break;
                }
                idx = i;
            }
            if (idx > -1 && (argType = (wrongArg = expressions2[idx]).getType()) != null) {
                elementToHighlight.set((Object)wrongArg);
                String message2 = JavaErrorMessages.message("incompatible.call.types", idx + 1, substitutor.substitute(parameters2[idx].getType()).getCanonicalText(), argType.getCanonicalText());
                return XmlStringUtil.wrapInHtml((CharSequence)("<body>" + XmlStringUtil.escapeString((String)message2) + " <a href=\"#assignment/" + XmlStringUtil.escapeString((String)HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(candidateInfo, list)) + "\"" + (UIUtil.isUnderDarcula() ? " color=\"7AB4C9\" " : "") + ">" + DaemonBundle.message((String)"inspection.extended.description", (Object[])new Object[0]) + "</a></body>"));
            }
        }
        return null;
    }

    static boolean isDummyConstructorCall(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper, @NotNull PsiExpressionList list, @NotNull PsiReferenceExpression referenceToMethod) {
        CandidateInfo[] candidates;
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(67);
        }
        if (resolveHelper == null) {
            HighlightMethodUtil.$$$reportNull$$$0(68);
        }
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(69);
        }
        if (referenceToMethod == null) {
            HighlightMethodUtil.$$$reportNull$$$0(70);
        }
        boolean isDummy = false;
        boolean isThisOrSuper = referenceToMethod.getReferenceNameElement() instanceof PsiKeyword;
        if (isThisOrSuper && list.isEmpty() && (candidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)methodCall, true)).length == 1 && !candidates[0].getElement().isPhysical()) {
            isDummy = true;
        }
        return isDummy;
    }

    @Nullable
    static HighlightInfo checkAmbiguousMethodCallIdentifier(@NotNull PsiReferenceExpression referenceToMethod, @NotNull JavaResolveResult[] resolveResults, @NotNull PsiExpressionList list, @Nullable PsiElement element, @NotNull JavaResolveResult resolveResult, @NotNull PsiMethodCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper, @NotNull LanguageLevel languageLevel, @NotNull PsiFile file) {
        HighlightInfo info;
        String description;
        MethodCandidateInfo methodCandidate2;
        if (referenceToMethod == null) {
            HighlightMethodUtil.$$$reportNull$$$0(71);
        }
        if (resolveResults == null) {
            HighlightMethodUtil.$$$reportNull$$$0(72);
        }
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(73);
        }
        if (resolveResult == null) {
            HighlightMethodUtil.$$$reportNull$$$0(74);
        }
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(75);
        }
        if (resolveHelper == null) {
            HighlightMethodUtil.$$$reportNull$$$0(76);
        }
        if (languageLevel == null) {
            HighlightMethodUtil.$$$reportNull$$$0(77);
        }
        if (file == null) {
            HighlightMethodUtil.$$$reportNull$$$0(78);
        }
        if ((methodCandidate2 = (MethodCandidateInfo)HighlightMethodUtil.findCandidates((JavaResolveResult[])resolveResults).second) != null) {
            return null;
        }
        MethodCandidateInfo[] candidates = HighlightMethodUtil.toMethodCandidates(resolveResults);
        HighlightInfoType highlightInfoType = HighlightInfoType.ERROR;
        PsiElement elementToHighlight = (PsiElement)ObjectUtils.notNull((Object)referenceToMethod.getReferenceNameElement(), (Object)referenceToMethod);
        if (element != null && !resolveResult.isAccessible()) {
            description = HighlightUtil.accessProblemDescription((PsiElement)referenceToMethod, element, resolveResult);
        } else if (element != null && !resolveResult.isStaticsScopeCorrect()) {
            PsiClass containingClass;
            if (element instanceof PsiMethod && ((PsiMethod)element).hasModifierProperty("static") && (containingClass = ((PsiMethod)element).getContainingClass()) != null && containingClass.isInterface()) {
                info = HighlightUtil.checkFeature(elementToHighlight, HighlightUtil.Feature.STATIC_INTERFACE_CALLS, languageLevel, file);
                if (info != null) {
                    return info;
                }
                info = HighlightMethodUtil.checkStaticInterfaceCallQualifier(referenceToMethod, resolveResult, elementToHighlight.getTextRange(), containingClass);
                if (info != null) {
                    return info;
                }
            }
            description = HighlightUtil.staticContextProblemDescription(element);
        } else {
            String methodName = referenceToMethod.getReferenceName() + HighlightMethodUtil.buildArgTypesList(list);
            description = JavaErrorMessages.message("cannot.resolve.method", methodName);
            if (candidates.length == 0) {
                highlightInfoType = HighlightInfoType.WRONG_REF;
            } else {
                return null;
            }
        }
        String toolTip = XmlStringUtil.escapeString((String)description);
        info = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(elementToHighlight).description(description).escapedToolTip(toolTip).create();
        HighlightMethodUtil.registerMethodCallIntentions(info, methodCall, list, resolveHelper);
        if (element != null && !resolveResult.isStaticsScopeCorrect()) {
            HighlightFixUtil.registerStaticProblemQuickFixAction(element, info, (PsiJavaCodeReferenceElement)referenceToMethod);
        }
        TextRange fixRange = HighlightMethodUtil.getFixRange(elementToHighlight);
        CastMethodArgumentFix.REGISTRAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        WrapObjectWithOptionalOfNullableFix.REGISTAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        WrapWithAdapterMethodCallFix.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        PermuteArgumentsFix.registerFix(info, (PsiCall)methodCall, (CandidateInfo[])candidates, fixRange);
        WrapExpressionFix.registerWrapAction((JavaResolveResult[])candidates, list.getExpressions(), info);
        HighlightMethodUtil.registerChangeParameterClassFix((PsiCall)methodCall, list, info);
        if (candidates.length == 0) {
            UnresolvedReferenceQuickFixProvider.registerReferenceFixes((PsiReference)methodCall.getMethodExpression(), (QuickFixActionRegistrar)new QuickFixActionRegistrarImpl(info));
        }
        return info;
    }

    @Nullable
    static HighlightInfo checkAmbiguousMethodCallArguments(@NotNull PsiReferenceExpression referenceToMethod, @NotNull JavaResolveResult[] resolveResults, @NotNull PsiExpressionList list, PsiElement element, @NotNull JavaResolveResult resolveResult, @NotNull PsiMethodCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper, @NotNull PsiElement elementToHighlight) {
        String toolTip;
        String description;
        if (referenceToMethod == null) {
            HighlightMethodUtil.$$$reportNull$$$0(79);
        }
        if (resolveResults == null) {
            HighlightMethodUtil.$$$reportNull$$$0(80);
        }
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(81);
        }
        if (resolveResult == null) {
            HighlightMethodUtil.$$$reportNull$$$0(82);
        }
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(83);
        }
        if (resolveHelper == null) {
            HighlightMethodUtil.$$$reportNull$$$0(84);
        }
        if (elementToHighlight == null) {
            HighlightMethodUtil.$$$reportNull$$$0(85);
        }
        Pair<MethodCandidateInfo, MethodCandidateInfo> pair = HighlightMethodUtil.findCandidates(resolveResults);
        MethodCandidateInfo methodCandidate1 = (MethodCandidateInfo)pair.first;
        MethodCandidateInfo methodCandidate2 = (MethodCandidateInfo)pair.second;
        MethodCandidateInfo[] candidates = HighlightMethodUtil.toMethodCandidates(resolveResults);
        HighlightInfoType highlightInfoType = HighlightInfoType.ERROR;
        if (methodCandidate2 != null) {
            VirtualFile virtualFile2;
            PsiMethod element1 = methodCandidate1.getElement();
            String m1 = PsiFormatUtil.formatMethod((PsiMethod)element1, (PsiSubstitutor)methodCandidate1.getSubstitutor(false), (int)4353, (int)2);
            PsiMethod element2 = methodCandidate2.getElement();
            String m2 = PsiFormatUtil.formatMethod((PsiMethod)element2, (PsiSubstitutor)methodCandidate2.getSubstitutor(false), (int)4353, (int)2);
            VirtualFile virtualFile1 = PsiUtilCore.getVirtualFile((PsiElement)element1);
            if (!Comparing.equal((Object)virtualFile1, (Object)(virtualFile2 = PsiUtilCore.getVirtualFile((PsiElement)element2)))) {
                if (virtualFile1 != null) {
                    m1 = m1 + " (In " + virtualFile1.getPresentableUrl() + ")";
                }
                if (virtualFile2 != null) {
                    m2 = m2 + " (In " + virtualFile2.getPresentableUrl() + ")";
                }
            }
            description = JavaErrorMessages.message("ambiguous.method.call", m1, m2);
            toolTip = HighlightMethodUtil.createAmbiguousMethodHtmlTooltip(new MethodCandidateInfo[]{methodCandidate1, methodCandidate2});
        } else {
            if (element != null && !resolveResult.isAccessible()) {
                return null;
            }
            if (element != null && !resolveResult.isStaticsScopeCorrect()) {
                return null;
            }
            String methodName = referenceToMethod.getReferenceName() + HighlightMethodUtil.buildArgTypesList(list);
            description = JavaErrorMessages.message("cannot.resolve.method", methodName);
            if (candidates.length == 0) {
                return null;
            }
            toolTip = XmlStringUtil.escapeString((String)description);
        }
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(elementToHighlight).description(description).escapedToolTip(toolTip).create();
        if (methodCandidate2 == null) {
            HighlightMethodUtil.registerMethodCallIntentions(info, methodCall, list, resolveHelper);
        }
        if (!resolveResult.isAccessible() && resolveResult.isStaticsScopeCorrect() && methodCandidate2 != null) {
            HighlightFixUtil.registerAccessQuickFixAction((PsiMember)element, (PsiJavaCodeReferenceElement)referenceToMethod, info, resolveResult.getCurrentFileResolveScope());
        }
        if (element != null && !resolveResult.isStaticsScopeCorrect()) {
            HighlightFixUtil.registerStaticProblemQuickFixAction(element, info, (PsiJavaCodeReferenceElement)referenceToMethod);
        }
        TextRange fixRange = HighlightMethodUtil.getFixRange(elementToHighlight);
        CastMethodArgumentFix.REGISTRAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        WrapObjectWithOptionalOfNullableFix.REGISTAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        WrapWithAdapterMethodCallFix.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        PermuteArgumentsFix.registerFix(info, (PsiCall)methodCall, (CandidateInfo[])candidates, fixRange);
        WrapExpressionFix.registerWrapAction((JavaResolveResult[])candidates, list.getExpressions(), info);
        HighlightMethodUtil.registerChangeParameterClassFix((PsiCall)methodCall, list, info);
        return info;
    }

    @NotNull
    private static Pair<MethodCandidateInfo, MethodCandidateInfo> findCandidates(@NotNull JavaResolveResult[] resolveResults) {
        if (resolveResults == null) {
            HighlightMethodUtil.$$$reportNull$$$0(86);
        }
        MethodCandidateInfo methodCandidate1 = null;
        MethodCandidateInfo methodCandidate2 = null;
        for (JavaResolveResult result : resolveResults) {
            MethodCandidateInfo candidate;
            if (!(result instanceof MethodCandidateInfo) || !(candidate = (MethodCandidateInfo)result).isApplicable() || candidate.getElement().isConstructor()) continue;
            if (methodCandidate1 == null) {
                methodCandidate1 = candidate;
                continue;
            }
            methodCandidate2 = candidate;
            break;
        }
        Pair pair = Pair.pair(methodCandidate1, methodCandidate2);
        if (pair == null) {
            HighlightMethodUtil.$$$reportNull$$$0(87);
        }
        return pair;
    }

    @NotNull
    private static MethodCandidateInfo[] toMethodCandidates(@NotNull JavaResolveResult[] resolveResults) {
        if (resolveResults == null) {
            HighlightMethodUtil.$$$reportNull$$$0(88);
        }
        ArrayList<MethodCandidateInfo> candidateList = new ArrayList<MethodCandidateInfo>(resolveResults.length);
        for (JavaResolveResult result : resolveResults) {
            MethodCandidateInfo candidate;
            if (!(result instanceof MethodCandidateInfo) || !(candidate = (MethodCandidateInfo)result).isAccessible()) continue;
            candidateList.add(candidate);
        }
        MethodCandidateInfo[] methodCandidateInfoArray = candidateList.toArray(new MethodCandidateInfo[0]);
        if (methodCandidateInfoArray == null) {
            HighlightMethodUtil.$$$reportNull$$$0(89);
        }
        return methodCandidateInfoArray;
    }

    private static void registerMethodCallIntentions(@Nullable HighlightInfo highlightInfo, @NotNull PsiMethodCallExpression methodCall, @NotNull PsiExpressionList list, @NotNull PsiResolveHelper resolveHelper) {
        PsiType methodCallType;
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(90);
        }
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(91);
        }
        if (resolveHelper == null) {
            HighlightMethodUtil.$$$reportNull$$$0(92);
        }
        TextRange fixRange = HighlightMethodUtil.getFixRange((PsiElement)methodCall);
        PsiExpression qualifierExpression2 = methodCall.getMethodExpression().getQualifierExpression();
        if (qualifierExpression2 instanceof PsiReferenceExpression) {
            PsiElement resolve = ((PsiReferenceExpression)qualifierExpression2).resolve();
            if (resolve instanceof PsiClass && ((PsiClass)resolve).getContainingClass() != null && !((PsiClass)resolve).hasModifierProperty("static")) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)((PsiClass)resolve), "static", true, false));
            }
        } else if (qualifierExpression2 instanceof PsiSuperExpression && ((PsiSuperExpression)qualifierExpression2).getQualifier() == null) {
            QualifySuperArgumentFix.registerQuickFixAction((PsiSuperExpression)qualifierExpression2, highlightInfo);
        }
        HighlightMethodUtil.registerUsageFixes(methodCall, highlightInfo, fixRange);
        HighlightMethodUtil.registerThisSuperFixes(methodCall, highlightInfo, fixRange);
        CandidateInfo[] methodCandidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)methodCall, false);
        CastMethodArgumentFix.REGISTRAR.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        PermuteArgumentsFix.registerFix(highlightInfo, (PsiCall)methodCall, methodCandidates, fixRange);
        AddTypeArgumentsFix.REGISTRAR.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        WrapObjectWithOptionalOfNullableFix.REGISTAR.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        MethodReturnFixFactory.INSTANCE.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        WrapWithAdapterMethodCallFix.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        HighlightMethodUtil.registerMethodAccessLevelIntentions(methodCandidates, methodCall, list, highlightInfo);
        HighlightMethodUtil.registerChangeMethodSignatureFromUsageIntentions((JavaResolveResult[])methodCandidates, list, highlightInfo, fixRange);
        RemoveRedundantArgumentsFix.registerIntentions((JavaResolveResult[])methodCandidates, list, highlightInfo, fixRange);
        ConvertDoubleToFloatFix.registerIntentions((JavaResolveResult[])methodCandidates, list, highlightInfo, fixRange);
        WrapExpressionFix.registerWrapAction((JavaResolveResult[])methodCandidates, list.getExpressions(), highlightInfo);
        HighlightMethodUtil.registerChangeParameterClassFix((PsiCall)methodCall, list, highlightInfo);
        if (methodCandidates.length == 0) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)QUICK_FIX_FACTORY.createStaticImportMethodFix(methodCall));
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)QUICK_FIX_FACTORY.createQualifyStaticMethodCallFix(methodCall));
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)QUICK_FIX_FACTORY.addMethodQualifierFix(methodCall));
        }
        for (IntentionAction action : QUICK_FIX_FACTORY.getVariableTypeFromCallFixes(methodCall, list)) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)action);
        }
        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)QUICK_FIX_FACTORY.createReplaceAddAllArrayToCollectionFix(methodCall));
        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)QUICK_FIX_FACTORY.createSurroundWithArrayFix((PsiCall)methodCall, null));
        QualifyThisArgumentFix.registerQuickFixAction(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        PsiType expectedTypeByParent = PsiTypesUtil.getExpectedTypeByParent((PsiElement)methodCall);
        if (expectedTypeByParent != null && (methodCallType = methodCall.getType()) != null && TypeConversionUtil.areTypesConvertible((PsiType)methodCallType, (PsiType)expectedTypeByParent)) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createAddTypeCastFix(expectedTypeByParent, (PsiExpression)methodCall));
        }
        CandidateInfo[] candidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)methodCall, true);
        ChangeStringLiteralToCharInMethodCallFix.registerFixes(candidates, methodCall, highlightInfo);
    }

    private static void registerMethodAccessLevelIntentions(@NotNull CandidateInfo[] methodCandidates, @NotNull PsiMethodCallExpression methodCall, @NotNull PsiExpressionList exprList, @Nullable HighlightInfo highlightInfo) {
        if (methodCandidates == null) {
            HighlightMethodUtil.$$$reportNull$$$0(93);
        }
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(94);
        }
        if (exprList == null) {
            HighlightMethodUtil.$$$reportNull$$$0(95);
        }
        for (CandidateInfo methodCandidate : methodCandidates) {
            PsiMethod method = (PsiMethod)methodCandidate.getElement();
            if (methodCandidate.isAccessible() || !PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)methodCandidate.getSubstitutor(), (PsiExpressionList)exprList)) continue;
            HighlightFixUtil.registerAccessQuickFixAction((PsiMember)method, (PsiJavaCodeReferenceElement)methodCall.getMethodExpression(), highlightInfo, methodCandidate.getCurrentFileResolveScope());
        }
    }

    @NotNull
    private static String createAmbiguousMethodHtmlTooltip(@NotNull MethodCandidateInfo[] methodCandidates) {
        if (methodCandidates == null) {
            HighlightMethodUtil.$$$reportNull$$$0(96);
        }
        String string = JavaErrorMessages.message("ambiguous.method.html.tooltip", methodCandidates[0].getElement().getParameterList().getParametersCount() + 2, HighlightMethodUtil.createAmbiguousMethodHtmlTooltipMethodRow(methodCandidates[0]), HighlightMethodUtil.getContainingClassName(methodCandidates[0]), HighlightMethodUtil.createAmbiguousMethodHtmlTooltipMethodRow(methodCandidates[1]), HighlightMethodUtil.getContainingClassName(methodCandidates[1]));
        if (string == null) {
            HighlightMethodUtil.$$$reportNull$$$0(97);
        }
        return string;
    }

    @NotNull
    private static String getContainingClassName(@NotNull MethodCandidateInfo methodCandidate) {
        PsiMethod method;
        PsiClass containingClass;
        if (methodCandidate == null) {
            HighlightMethodUtil.$$$reportNull$$$0(98);
        }
        String string = (containingClass = (method = methodCandidate.getElement()).getContainingClass()) == null ? method.getContainingFile().getName() : HighlightUtil.formatClass(containingClass, false);
        if (string == null) {
            HighlightMethodUtil.$$$reportNull$$$0(99);
        }
        return string;
    }

    @Language(value="HTML")
    @NotNull
    private static String createAmbiguousMethodHtmlTooltipMethodRow(@NotNull MethodCandidateInfo methodCandidate) {
        if (methodCandidate == null) {
            HighlightMethodUtil.$$$reportNull$$$0(100);
        }
        PsiMethod method = methodCandidate.getElement();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        PsiSubstitutor substitutor = methodCandidate.getSubstitutor();
        StringBuilder ms = new StringBuilder("<td><b>" + method.getName() + "</b></td>");
        for (int j = 0; j < parameters2.length; ++j) {
            PsiParameter parameter2 = parameters2[j];
            PsiType type2 = substitutor.substitute(parameter2.getType());
            ms.append("<td><b>").append(j == 0 ? "(" : "").append(XmlStringUtil.escapeString((String)type2.getPresentableText())).append(j == parameters2.length - 1 ? ")" : ",").append("</b></td>");
        }
        if (parameters2.length == 0) {
            ms.append("<td><b>()</b></td>");
        }
        String string = ms.toString();
        if (string == null) {
            HighlightMethodUtil.$$$reportNull$$$0(101);
        }
        return string;
    }

    @NotNull
    private static String createMismatchedArgumentsHtmlTooltip(@NotNull MethodCandidateInfo info, @NotNull PsiExpressionList list) {
        if (info == null) {
            HighlightMethodUtil.$$$reportNull$$$0(102);
        }
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(103);
        }
        PsiMethod method = info.getElement();
        PsiSubstitutor substitutor = info.getSubstitutor();
        PsiClass aClass = method.getContainingClass();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        String methodName = method.getName();
        String string = HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(list, info, parameters2, methodName, substitutor, aClass);
        if (string == null) {
            HighlightMethodUtil.$$$reportNull$$$0(104);
        }
        return string;
    }

    private static String createShortMismatchedArgumentsHtmlTooltip(@NotNull PsiExpressionList list, @Nullable MethodCandidateInfo info, @NotNull PsiParameter[] parameters2, @NotNull String methodName, @NotNull PsiSubstitutor substitutor, @NotNull PsiClass aClass) {
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(105);
        }
        if (parameters2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(106);
        }
        if (methodName == null) {
            HighlightMethodUtil.$$$reportNull$$$0(107);
        }
        if (substitutor == null) {
            HighlightMethodUtil.$$$reportNull$$$0(108);
        }
        if (aClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(109);
        }
        PsiExpression[] expressions2 = list.getExpressions();
        int cols = Math.max(parameters2.length, expressions2.length);
        String parenthesizedName = methodName + (parameters2.length == 0 ? "(&nbsp;)&nbsp;" : "");
        String errorMessage = info != null ? info.getInferenceErrorMessage() : null;
        return JavaErrorMessages.message("argument.mismatch.html.tooltip", cols - parameters2.length + 1, parenthesizedName, HighlightUtil.formatClass(aClass, false), HighlightMethodUtil.createMismatchedArgsHtmlTooltipParamsRow(parameters2, substitutor, expressions2), HighlightMethodUtil.createMismatchedArgsHtmlTooltipArgumentsRow(expressions2, parameters2, substitutor, cols), errorMessage != null ? "<br/>reason: " + XmlStringUtil.escapeString((String)errorMessage).replaceAll("\n", "<br/>") : "");
    }

    @NotNull
    private static String escTrim(@NotNull String s) {
        if (s == null) {
            HighlightMethodUtil.$$$reportNull$$$0(110);
        }
        String string = XmlStringUtil.escapeString((String)HighlightMethodUtil.trimNicely(s));
        if (string == null) {
            HighlightMethodUtil.$$$reportNull$$$0(111);
        }
        return string;
    }

    @NotNull
    private static String trimNicely(@NotNull String s) {
        if (s == null) {
            HighlightMethodUtil.$$$reportNull$$$0(112);
        }
        if (s.length() <= 40) {
            String string = s;
            if (string == null) {
                HighlightMethodUtil.$$$reportNull$$$0(113);
            }
            return string;
        }
        List wordIndices = StringUtil.getWordIndicesIn((String)s);
        if (wordIndices.size() > 2) {
            int firstWordEnd = ((TextRange)wordIndices.get(0)).getEndOffset();
            for (int i = 1; i < wordIndices.size(); ++i) {
                int stringLength = firstWordEnd + s.length() - ((TextRange)wordIndices.get(i)).getStartOffset();
                if (stringLength > 40) continue;
                String string = s.substring(0, firstWordEnd) + "..." + s.substring(((TextRange)wordIndices.get(i)).getStartOffset());
                if (string == null) {
                    HighlightMethodUtil.$$$reportNull$$$0(114);
                }
                return string;
            }
        }
        if (!wordIndices.isEmpty() && s.length() - ((TextRange)wordIndices.get(wordIndices.size() - 1)).getStartOffset() <= 40) {
            String string = "..." + s.substring(((TextRange)wordIndices.get(wordIndices.size() - 1)).getStartOffset());
            if (string == null) {
                HighlightMethodUtil.$$$reportNull$$$0(115);
            }
            return string;
        }
        String string = StringUtil.last((CharSequence)s, (int)40, (boolean)true).toString();
        if (string == null) {
            HighlightMethodUtil.$$$reportNull$$$0(116);
        }
        return string;
    }

    @NotNull
    private static String createMismatchedArgumentsHtmlTooltip(@NotNull PsiExpressionList list, @Nullable MethodCandidateInfo info, @NotNull PsiParameter[] parameters2, @NotNull String methodName, @NotNull PsiSubstitutor substitutor, @NotNull PsiClass aClass) {
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(117);
        }
        if (parameters2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(118);
        }
        if (methodName == null) {
            HighlightMethodUtil.$$$reportNull$$$0(119);
        }
        if (substitutor == null) {
            HighlightMethodUtil.$$$reportNull$$$0(120);
        }
        if (aClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(121);
        }
        String string = Math.max(parameters2.length, list.getExpressionCount()) <= 2 ? HighlightMethodUtil.createShortMismatchedArgumentsHtmlTooltip(list, info, parameters2, methodName, substitutor, aClass) : HighlightMethodUtil.createLongMismatchedArgumentsHtmlTooltip(list, info, parameters2, methodName, substitutor, aClass);
        if (string == null) {
            HighlightMethodUtil.$$$reportNull$$$0(122);
        }
        return string;
    }

    @Language(value="HTML")
    @NotNull
    private static String createLongMismatchedArgumentsHtmlTooltip(@NotNull PsiExpressionList list, @Nullable MethodCandidateInfo info, @NotNull PsiParameter[] parameters2, @NotNull String methodName, @NotNull PsiSubstitutor substitutor, @NotNull PsiClass aClass) {
        String errorMessage;
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(123);
        }
        if (parameters2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(124);
        }
        if (methodName == null) {
            HighlightMethodUtil.$$$reportNull$$$0(125);
        }
        if (substitutor == null) {
            HighlightMethodUtil.$$$reportNull$$$0(126);
        }
        if (aClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(127);
        }
        PsiExpression[] expressions2 = list.getExpressions();
        StringBuilder s = new StringBuilder().append("<html><body><table border=0>").append("<tr><td colspan=3>").append("<nobr><b>").append(methodName).append("()</b> in <b>").append(HighlightUtil.formatClass(aClass, false)).append("</b> cannot be applied to:</nobr>").append("</td></tr>").append("<tr><td colspan=2 align=left>Expected<br>Parameters:</td><td align=left>Actual<br>Arguments:</td></tr>").append("<tr><td colspan=3><hr></td></tr>");
        for (int i = 0; i < Math.max(parameters2.length, expressions2.length); ++i) {
            PsiType type2;
            String name;
            PsiParameter parameter2 = i < parameters2.length ? parameters2[i] : null;
            PsiExpression expression2 = i < expressions2.length ? expressions2[i] : null;
            boolean showShort = HighlightMethodUtil.showShortType(i, parameters2, expressions2, substitutor);
            String mismatchColor = showShort ? null : (UIUtil.isUnderDarcula() ? "FF6B68" : "red");
            s.append("<tr");
            if (i % 2 == 0) {
                String bg = UIUtil.isUnderDarcula() ? ColorUtil.toHex((Color)ColorUtil.shift((Color)UIUtil.getToolTipBackground(), (double)1.1)) : "eeeeee";
                s.append(" style='background-color: #").append(bg).append("'");
            }
            s.append(">");
            s.append("<td><b><nobr>");
            if (parameter2 != null && (name = parameter2.getName()) != null) {
                s.append(HighlightMethodUtil.escTrim(name)).append(":");
            }
            s.append("</nobr></b></td>");
            s.append("<td><b><nobr>");
            if (parameter2 != null) {
                type2 = substitutor.substitute(parameter2.getType());
                s.append("<font ");
                if (mismatchColor != null) {
                    s.append("color=").append(mismatchColor);
                }
                s.append(">");
                s.append(HighlightMethodUtil.escTrim(showShort ? type2.getPresentableText() : JavaHighlightUtil.formatType(type2)));
                s.append("</font>");
            }
            s.append("</nobr></b></td>");
            s.append("<td><b><nobr>");
            if (expression2 != null) {
                type2 = expression2.getType();
                s.append("<font ");
                if (mismatchColor != null) {
                    s.append("color='").append(mismatchColor).append("'");
                }
                s.append(">");
                s.append(HighlightMethodUtil.escTrim(expression2.getText()));
                s.append("&nbsp;&nbsp;");
                if (mismatchColor != null && type2 != null && type2 != PsiType.NULL) {
                    s.append("(").append(HighlightMethodUtil.escTrim(JavaHighlightUtil.formatType(type2))).append(")");
                }
                s.append("</font>");
            }
            s.append("</nobr></b></td>");
            s.append("</tr>");
        }
        s.append("</table>");
        String string = errorMessage = info != null ? info.getInferenceErrorMessage() : null;
        if (errorMessage != null) {
            s.append("reason: ").append(XmlStringUtil.escapeString((String)errorMessage).replaceAll("\n", "<br/>"));
        }
        s.append("</body></html>");
        String string2 = s.toString();
        if (string2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(128);
        }
        return string2;
    }

    @Language(value="HTML")
    @NotNull
    private static String createMismatchedArgsHtmlTooltipArgumentsRow(@NotNull PsiExpression[] expressions2, @NotNull PsiParameter[] parameters2, @NotNull PsiSubstitutor substitutor, int cols) {
        int i;
        if (expressions2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(129);
        }
        if (parameters2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(130);
        }
        if (substitutor == null) {
            HighlightMethodUtil.$$$reportNull$$$0(131);
        }
        StringBuilder ms = new StringBuilder();
        for (i = 0; i < expressions2.length; ++i) {
            PsiExpression expression2 = expressions2[i];
            PsiType type2 = expression2.getType();
            boolean showShort = HighlightMethodUtil.showShortType(i, parameters2, expressions2, substitutor);
            String mismatchColor = showShort ? null : MISMATCH_COLOR;
            ms.append("<td> <b><nobr>");
            ms.append(i == 0 ? "(" : "");
            ms.append("<font ");
            if (!showShort) {
                ms.append("color=").append(mismatchColor);
            }
            ms.append(">");
            ms.append(XmlStringUtil.escapeString((String)(type2 != null && showShort ? type2.getPresentableText() : JavaHighlightUtil.formatType(type2))));
            ms.append("</font>");
            ms.append(i == expressions2.length - 1 ? ")" : ",");
            ms.append("</nobr></b></td>");
        }
        for (i = expressions2.length; i < cols + 1; ++i) {
            ms.append("<td>");
            if (i == 0) {
                ms.append("<b>()</b>");
            }
            ms.append("&nbsp;</td>");
        }
        String string = ms.toString();
        if (string == null) {
            HighlightMethodUtil.$$$reportNull$$$0(132);
        }
        return string;
    }

    @Language(value="HTML")
    @NotNull
    private static String createMismatchedArgsHtmlTooltipParamsRow(@NotNull PsiParameter[] parameters2, @NotNull PsiSubstitutor substitutor, @NotNull PsiExpression[] expressions2) {
        if (parameters2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(133);
        }
        if (substitutor == null) {
            HighlightMethodUtil.$$$reportNull$$$0(134);
        }
        if (expressions2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(135);
        }
        StringBuilder ms = new StringBuilder();
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parameter2 = parameters2[i];
            PsiType type2 = substitutor.substitute(parameter2.getType());
            boolean showShort = HighlightMethodUtil.showShortType(i, parameters2, expressions2, substitutor);
            ms.append("<td><b><nobr>");
            ms.append(i == 0 ? "(" : "");
            ms.append(XmlStringUtil.escapeString((String)(showShort ? type2.getPresentableText() : JavaHighlightUtil.formatType(type2))));
            ms.append(i == parameters2.length - 1 ? ")" : ",");
            ms.append("</nobr></b></td>");
        }
        String string = ms.toString();
        if (string == null) {
            HighlightMethodUtil.$$$reportNull$$$0(136);
        }
        return string;
    }

    private static boolean showShortType(int i, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] expressions2, @NotNull PsiSubstitutor substitutor) {
        PsiExpression expression2;
        if (parameters2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(137);
        }
        if (expressions2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(138);
        }
        if (substitutor == null) {
            HighlightMethodUtil.$$$reportNull$$$0(139);
        }
        PsiExpression psiExpression = expression2 = i < expressions2.length ? expressions2[i] : null;
        if (expression2 == null) {
            return true;
        }
        PsiType paramType = i < parameters2.length && parameters2[i] != null ? substitutor.substitute(parameters2[i].getType()) : null;
        PsiType expressionType = expression2.getType();
        return paramType != null && expressionType != null && TypeConversionUtil.isAssignable((PsiType)paramType, (PsiType)expressionType);
    }

    static HighlightInfo checkMethodMustHaveBody(@NotNull PsiMethod method, @Nullable PsiClass aClass) {
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(140);
        }
        HighlightInfo errorResult = null;
        if (!(method.getBody() != null || method.hasModifierProperty("abstract") || method.hasModifierProperty("native") || aClass == null || aClass.isInterface() || PsiUtilCore.hasErrorElementChild((PsiElement)method))) {
            int start = method.getModifierList().getTextRange().getStartOffset();
            int end = method.getTextRange().getEndOffset();
            String description = JavaErrorMessages.message("missing.method.body", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(start, end).descriptionAndTooltip(description).create();
            if (HighlightUtil.getIncompatibleModifier("abstract", method.getModifierList()) == null && !(aClass instanceof PsiAnonymousClass)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "abstract", true, false));
            }
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createAddMethodBodyFix(method));
        }
        return errorResult;
    }

    static HighlightInfo checkAbstractMethodInConcreteClass(@NotNull PsiMethod method, @NotNull PsiElement elementToHighlight) {
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(141);
        }
        if (elementToHighlight == null) {
            HighlightMethodUtil.$$$reportNull$$$0(142);
        }
        HighlightInfo errorResult = null;
        PsiClass aClass = method.getContainingClass();
        if (method.hasModifierProperty("abstract") && aClass != null && !aClass.hasModifierProperty("abstract") && !aClass.isEnum() && !PsiUtilCore.hasErrorElementChild((PsiElement)method)) {
            String description = JavaErrorMessages.message("abstract.method.in.non.abstract.class", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(description).create();
            if (method.getBody() != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "abstract", false, false));
            }
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createAddMethodBodyFix(method));
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "abstract", true, false));
        }
        return errorResult;
    }

    static HighlightInfo checkConstructorName(@NotNull PsiMethod method) {
        PsiClass aClass;
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(143);
        }
        if ((aClass = method.getContainingClass()) != null) {
            String className;
            String string = className = aClass instanceof PsiAnonymousClass ? null : aClass.getName();
            if (className == null || !Comparing.strEqual((String)method.getName(), (String)className)) {
                PsiElement element = (PsiElement)ObjectUtils.notNull((Object)method.getNameIdentifier(), (Object)method);
                String description = JavaErrorMessages.message("missing.return.type", new Object[0]);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
                if (className != null) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createRenameElementFix((PsiNamedElement)method, className));
                }
                return info;
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkDuplicateMethod(@NotNull PsiClass aClass, @NotNull PsiMethod method, @NotNull MostlySingularMultiMap<MethodSignature, PsiMethod> duplicateMethods) {
        if (aClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(144);
        }
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(145);
        }
        if (duplicateMethods == null) {
            HighlightMethodUtil.$$$reportNull$$$0(146);
        }
        if (method instanceof ExternallyDefinedPsiElement) {
            return null;
        }
        MethodSignature methodSignature = method.getSignature(PsiSubstitutor.EMPTY);
        int methodCount = 1;
        List methods = (List)duplicateMethods.get((Object)methodSignature);
        if (methods.size() > 1) {
            ++methodCount;
        }
        if (methodCount == 1 && aClass.isEnum() && GenericsHighlightUtil.isEnumSyntheticMethod(methodSignature, aClass.getProject())) {
            ++methodCount;
        }
        if (methodCount > 1) {
            String description = JavaErrorMessages.message("duplicate.method", JavaHighlightUtil.formatMethod(method), HighlightUtil.formatClass(aClass));
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)method, textRange.getStartOffset(), textRange.getEndOffset()).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkMethodCanHaveBody(@NotNull PsiMethod method, @NotNull LanguageLevel languageLevel) {
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(147);
        }
        if (languageLevel == null) {
            HighlightMethodUtil.$$$reportNull$$$0(148);
        }
        PsiClass aClass = method.getContainingClass();
        boolean hasNoBody = method.getBody() == null;
        boolean isInterface = aClass != null && aClass.isInterface();
        boolean isExtension = method.hasModifierProperty("default");
        boolean isStatic = method.hasModifierProperty("static");
        boolean isPrivate = method.hasModifierProperty("private");
        ArrayList<Object> additionalFixes = new ArrayList<Object>();
        String description = null;
        if (hasNoBody) {
            if (isExtension) {
                description = JavaErrorMessages.message("extension.method.should.have.a.body", new Object[0]);
                additionalFixes.add(QUICK_FIX_FACTORY.createAddMethodBodyFix(method));
            } else if (isInterface) {
                if (isStatic && languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                    description = "Static methods in interfaces should have a body";
                } else if (isPrivate && languageLevel.isAtLeast(LanguageLevel.JDK_1_9)) {
                    description = "Private methods in interfaces should have a body";
                }
            }
        } else if (isInterface) {
            if (!(isExtension || isStatic || isPrivate)) {
                description = JavaErrorMessages.message("interface.methods.cannot.have.body", new Object[0]);
                if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && Stream.of(method.findDeepestSuperMethods()).map(PsiMember::getContainingClass).filter(Objects::nonNull).map(PsiClass::getQualifiedName).noneMatch("java.lang.Object"::equals)) {
                    additionalFixes.add(QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "default", true, false));
                    additionalFixes.add(QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "static", true, false));
                }
            }
        } else if (isExtension) {
            description = JavaErrorMessages.message("extension.method.in.class", new Object[0]);
        } else if (method.hasModifierProperty("abstract")) {
            description = JavaErrorMessages.message("abstract.methods.cannot.have.a.body", new Object[0]);
        } else if (method.hasModifierProperty("native")) {
            description = JavaErrorMessages.message("native.methods.cannot.have.a.body", new Object[0]);
        }
        if (description == null) {
            return null;
        }
        TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        if (!hasNoBody) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createDeleteMethodBodyFix(method));
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createPushDownMethodFix());
        }
        if (method.hasModifierProperty("abstract") && !isInterface) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "abstract", false, false));
        }
        for (IntentionAction intentionAction : additionalFixes) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)intentionAction);
        }
        return info;
    }

    @Nullable
    static HighlightInfo checkConstructorCallMustBeFirstStatement(@NotNull PsiMethodCallExpression methodCall) {
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(149);
        }
        if (!JavaPsiConstructorUtil.isConstructorCall((PsiElement)methodCall)) {
            return null;
        }
        PsiElement codeBlock = methodCall.getParent().getParent();
        if (codeBlock instanceof PsiCodeBlock && codeBlock.getParent() instanceof PsiMethod && ((PsiMethod)codeBlock.getParent()).isConstructor()) {
            PsiElement prevSibling = methodCall.getParent().getPrevSibling();
            while (true) {
                if (prevSibling == null) {
                    return null;
                }
                if (prevSibling instanceof PsiStatement) break;
                prevSibling = prevSibling.getPrevSibling();
            }
        }
        PsiReferenceExpression expression2 = methodCall.getMethodExpression();
        String message2 = JavaErrorMessages.message("constructor.call.must.be.first.statement", expression2.getText() + "()");
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)methodCall).descriptionAndTooltip(message2).create();
    }

    static HighlightInfo checkSuperAbstractMethodDirectCall(@NotNull PsiMethodCallExpression methodCallExpression) {
        PsiReferenceExpression expression2;
        if (methodCallExpression == null) {
            HighlightMethodUtil.$$$reportNull$$$0(150);
        }
        if (!((expression2 = methodCallExpression.getMethodExpression()).getQualifierExpression() instanceof PsiSuperExpression)) {
            return null;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method != null && method.hasModifierProperty("abstract")) {
            String message2 = JavaErrorMessages.message("direct.abstract.method.access", JavaHighlightUtil.formatMethod(method));
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)methodCallExpression).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    static HighlightInfo checkConstructorCallsBaseClassConstructor(@NotNull PsiMethod constructor, @Nullable RefCountHolder refCountHolder, @NotNull PsiResolveHelper resolveHelper) {
        PsiClassType[] handledExceptions;
        if (constructor == null) {
            HighlightMethodUtil.$$$reportNull$$$0(151);
        }
        if (resolveHelper == null) {
            HighlightMethodUtil.$$$reportNull$$$0(152);
        }
        if (!constructor.isConstructor()) {
            return null;
        }
        PsiClass aClass = constructor.getContainingClass();
        if (aClass == null) {
            return null;
        }
        if (aClass.isEnum()) {
            return null;
        }
        PsiCodeBlock body2 = constructor.getBody();
        if (body2 == null) {
            return null;
        }
        if (JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)constructor) != null) {
            return null;
        }
        TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(constructor);
        HighlightInfo info = HighlightClassUtil.checkBaseClassDefaultConstructorProblem(aClass, refCountHolder, resolveHelper, textRange, handledExceptions = constructor.getThrowsList().getReferencedTypes());
        if (info != null) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createInsertSuperFix(constructor));
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createInsertThisFix(constructor));
            PsiClass superClass = aClass.getSuperClass();
            if (superClass != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createAddDefaultConstructorFix(superClass));
            }
        }
        return info;
    }

    static HighlightInfo checkStaticMethodOverride(@NotNull PsiMethod method, @NotNull PsiFile containingFile) {
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(153);
        }
        if (containingFile == null) {
            HighlightMethodUtil.$$$reportNull$$$0(154);
        }
        if (method.isConstructor()) {
            return null;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        HierarchicalMethodSignature methodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature(method);
        List superSignatures = methodSignature.getSuperSignatures();
        if (superSignatures.isEmpty()) {
            return null;
        }
        boolean isStatic = method.hasModifierProperty("static");
        for (HierarchicalMethodSignature signature : superSignatures) {
            HighlightInfo highlightInfo;
            PsiMethod superMethod = signature.getMethod();
            PsiClass superClass = superMethod.getContainingClass();
            if (superClass == null || (highlightInfo = HighlightMethodUtil.checkStaticMethodOverride(aClass, method, isStatic, superClass, superMethod, containingFile)) == null) continue;
            return highlightInfo;
        }
        return null;
    }

    private static HighlightInfo checkStaticMethodOverride(@NotNull PsiClass aClass, @NotNull PsiMethod method, boolean isMethodStatic, @NotNull PsiClass superClass, @NotNull PsiMethod superMethod, @NotNull PsiFile containingFile) {
        if (aClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(155);
        }
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(156);
        }
        if (superClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(157);
        }
        if (superMethod == null) {
            HighlightMethodUtil.$$$reportNull$$$0(158);
        }
        if (containingFile == null) {
            HighlightMethodUtil.$$$reportNull$$$0(159);
        }
        PsiManager manager = containingFile.getManager();
        PsiModifierList superModifierList = superMethod.getModifierList();
        PsiModifierList modifierList = method.getModifierList();
        if (superModifierList.hasModifierProperty("private")) {
            return null;
        }
        if (superModifierList.hasModifierProperty("packageLocal") && !JavaPsiFacade.getInstance((Project)manager.getProject()).arePackagesTheSame((PsiElement)aClass, (PsiElement)superClass)) {
            return null;
        }
        boolean isSuperMethodStatic = superModifierList.hasModifierProperty("static");
        if (isMethodStatic != isSuperMethodStatic) {
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            String messageKey = isMethodStatic ? "static.method.cannot.override.instance.method" : "instance.method.cannot.override.static.method";
            String description = JavaErrorMessages.message(messageKey, JavaHighlightUtil.formatMethod(method), HighlightUtil.formatClass(aClass), JavaHighlightUtil.formatMethod(superMethod), HighlightUtil.formatClass(superClass));
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            if (!isSuperMethodStatic || HighlightUtil.getIncompatibleModifier("static", modifierList) == null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "static", isSuperMethodStatic, false));
            }
            if (manager.isInProject((PsiElement)superMethod) && (!isMethodStatic || HighlightUtil.getIncompatibleModifier("static", superModifierList) == null)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)superMethod, "static", isMethodStatic, true));
            }
            return info;
        }
        if (isMethodStatic) {
            if (superClass.isInterface()) {
                return null;
            }
            int accessLevel = PsiUtil.getAccessLevel((PsiModifierList)modifierList);
            String accessModifier = PsiUtil.getAccessModifier((int)accessLevel);
            HighlightInfo info = HighlightMethodUtil.isWeaker(method, modifierList, accessModifier, accessLevel, superMethod, true);
            if (info != null) {
                return info;
            }
            info = HighlightMethodUtil.checkSuperMethodIsFinal(method, superMethod);
            if (info != null) {
                return info;
            }
        }
        return null;
    }

    private static HighlightInfo checkInterfaceInheritedMethodsReturnTypes(@NotNull List<? extends MethodSignatureBackedByPsiMethod> superMethodSignatures, @NotNull LanguageLevel languageLevel) {
        if (superMethodSignatures == null) {
            HighlightMethodUtil.$$$reportNull$$$0(160);
        }
        if (languageLevel == null) {
            HighlightMethodUtil.$$$reportNull$$$0(161);
        }
        if (superMethodSignatures.size() < 2) {
            return null;
        }
        MethodSignatureBackedByPsiMethod[] returnTypeSubstitutable = new MethodSignatureBackedByPsiMethod[]{superMethodSignatures.get(0)};
        for (int i = 1; i < superMethodSignatures.size(); ++i) {
            PsiMethod currentMethod = returnTypeSubstitutable[0].getMethod();
            PsiType currentType = returnTypeSubstitutable[0].getSubstitutor().substitute(currentMethod.getReturnType());
            MethodSignatureBackedByPsiMethod otherSuperSignature = superMethodSignatures.get(i);
            PsiMethod otherSuperMethod = otherSuperSignature.getMethod();
            PsiSubstitutor otherSubstitutor = otherSuperSignature.getSubstitutor();
            PsiType otherSuperReturnType = otherSubstitutor.substitute(otherSuperMethod.getReturnType());
            PsiSubstitutor unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)returnTypeSubstitutable[0], (MethodSignature)otherSuperSignature);
            if (unifyingSubstitutor != null) {
                otherSuperReturnType = unifyingSubstitutor.substitute(otherSuperReturnType);
                currentType = unifyingSubstitutor.substitute(currentType);
            }
            if (otherSuperReturnType == null || currentType == null || otherSuperReturnType.equals(currentType)) continue;
            PsiType otherReturnType = otherSuperReturnType;
            PsiType curType = currentType;
            HighlightInfo info = (HighlightInfo)LambdaUtil.performWithSubstitutedParameterBounds((PsiTypeParameter[])otherSuperMethod.getTypeParameters(), (PsiSubstitutor)otherSubstitutor, () -> {
                if (languageLevel == null) {
                    HighlightMethodUtil.$$$reportNull$$$0(201);
                }
                if (languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
                    if (!(otherReturnType instanceof PsiPrimitiveType) && !(curType instanceof PsiPrimitiveType)) {
                        if (otherReturnType.isAssignableFrom(curType)) {
                            return null;
                        }
                        if (curType.isAssignableFrom(otherReturnType)) {
                            returnTypeSubstitutable[0] = otherSuperSignature;
                            return null;
                        }
                    }
                    if (otherSuperMethod.getTypeParameters().length > 0 && JavaGenericsUtil.isRawToGeneric((PsiType)otherReturnType, (PsiType)curType)) {
                        return null;
                    }
                }
                return HighlightMethodUtil.createIncompatibleReturnTypeMessage(otherSuperMethod, currentMethod, curType, otherReturnType, JavaErrorMessages.message("unrelated.overriding.methods.return.types", new Object[0]), TextRange.EMPTY_RANGE);
            });
            if (info == null) continue;
            return info;
        }
        return null;
    }

    static HighlightInfo checkOverrideEquivalentInheritedMethods(@NotNull PsiClass aClass, @NotNull PsiFile containingFile, @NotNull LanguageLevel languageLevel) {
        if (aClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(162);
        }
        if (containingFile == null) {
            HighlightMethodUtil.$$$reportNull$$$0(163);
        }
        if (languageLevel == null) {
            HighlightMethodUtil.$$$reportNull$$$0(164);
        }
        String description = null;
        boolean appendImplementMethodFix = true;
        Collection visibleSignatures = aClass.getVisibleSignatures();
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)aClass.getProject()).getResolveHelper();
        block0: for (HierarchicalMethodSignature signature : visibleSignatures) {
            HighlightInfo highlightInfo;
            PsiMethod method = signature.getMethod();
            if (!resolveHelper.isAccessible((PsiMember)method, (PsiElement)aClass, null)) continue;
            ArrayList<HierarchicalMethodSignature> superSignatures = signature.getSuperSignatures();
            boolean allAbstracts = method.hasModifierProperty("abstract");
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || aClass.equals(containingClass) || aClass.isInterface() && !containingClass.isInterface()) continue;
            if (allAbstracts) {
                superSignatures = new ArrayList<HierarchicalMethodSignature>(superSignatures);
                superSignatures.add(0, signature);
                highlightInfo = HighlightMethodUtil.checkInterfaceInheritedMethodsReturnTypes(superSignatures, languageLevel);
            } else {
                highlightInfo = HighlightMethodUtil.checkMethodIncompatibleReturnType((MethodSignatureBackedByPsiMethod)signature, (List<? extends HierarchicalMethodSignature>)superSignatures, false);
            }
            if (highlightInfo != null) {
                description = highlightInfo.getDescription();
            }
            if (method.hasModifierProperty("static")) {
                for (HierarchicalMethodSignature superSignature : superSignatures) {
                    PsiMethod superMethod = superSignature.getMethod();
                    if (superMethod.hasModifierProperty("static")) continue;
                    PsiClass superClass = superMethod.getContainingClass();
                    description = JavaErrorMessages.message("static.method.cannot.override.instance.method", JavaHighlightUtil.formatMethod(method), HighlightUtil.formatClass(containingClass), JavaHighlightUtil.formatMethod(superMethod), superClass != null ? HighlightUtil.formatClass(superClass) : "<unknown>");
                    appendImplementMethodFix = false;
                    break block0;
                }
                continue;
            }
            if (description == null && (highlightInfo = HighlightMethodUtil.checkMethodIncompatibleThrows((MethodSignatureBackedByPsiMethod)signature, superSignatures, false, aClass)) != null) {
                description = highlightInfo.getDescription();
            }
            if (description == null && (highlightInfo = HighlightMethodUtil.checkMethodWeakerPrivileges((MethodSignatureBackedByPsiMethod)signature, superSignatures, false, containingFile)) != null) {
                description = highlightInfo.getDescription();
            }
            if (description == null) continue;
            break;
        }
        if (description != null) {
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            if (appendImplementMethodFix) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createImplementMethodsFix(aClass));
            }
            return highlightInfo;
        }
        return null;
    }

    static HighlightInfo checkConstructorHandleSuperClassExceptions(@NotNull PsiMethod method) {
        PsiStatement[] statements;
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(165);
        }
        if (!method.isConstructor()) {
            return null;
        }
        PsiCodeBlock body2 = method.getBody();
        PsiStatement[] psiStatementArray = statements = body2 == null ? null : body2.getStatements();
        if (statements == null) {
            return null;
        }
        Collection<PsiClassType> unhandled = ExceptionUtil.collectUnhandledExceptions((PsiElement)method, (PsiElement)method.getContainingClass());
        if (unhandled.isEmpty()) {
            return null;
        }
        String description = HighlightUtil.getUnhandledExceptionsDescriptor(unhandled);
        TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        for (PsiClassType exception : unhandled) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)new LocalQuickFixOnPsiElementAsIntentionAdapter(QUICK_FIX_FACTORY.createMethodThrowsFix(method, exception, true, false)));
        }
        return highlightInfo;
    }

    static HighlightInfo checkRecursiveConstructorInvocation(@NotNull PsiMethod method) {
        if (method == null) {
            HighlightMethodUtil.$$$reportNull$$$0(166);
        }
        if (HighlightControlFlowUtil.isRecursivelyCalledConstructor(method)) {
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            String description = JavaErrorMessages.message("recursive.constructor.invocation", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @NotNull
    public static TextRange getFixRange(@NotNull PsiElement element) {
        if (element == null) {
            HighlightMethodUtil.$$$reportNull$$$0(167);
        }
        TextRange range = element.getTextRange();
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        PsiElement nextSibling = element.getNextSibling();
        if (PsiUtil.isJavaToken((PsiElement)nextSibling, (IElementType)JavaTokenType.SEMICOLON)) {
            TextRange textRange = new TextRange(start, end + 1);
            if (textRange == null) {
                HighlightMethodUtil.$$$reportNull$$$0(168);
            }
            return textRange;
        }
        TextRange textRange = range;
        if (textRange == null) {
            HighlightMethodUtil.$$$reportNull$$$0(169);
        }
        return textRange;
    }

    static void checkNewExpression(@NotNull PsiNewExpression expression2, @Nullable PsiType type2, @NotNull HighlightInfoHolder holder, @NotNull JavaSdkVersion javaSdkVersion) {
        if (expression2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(170);
        }
        if (holder == null) {
            HighlightMethodUtil.$$$reportNull$$$0(171);
        }
        if (javaSdkVersion == null) {
            HighlightMethodUtil.$$$reportNull$$$0(172);
        }
        if (!(type2 instanceof PsiClassType)) {
            return;
        }
        PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type2).resolveGenerics();
        PsiClass aClass = typeResult.getElement();
        if (aClass == null) {
            return;
        }
        if (aClass instanceof PsiAnonymousClass && (aClass = (typeResult = ((PsiClassType)(type2 = ((PsiAnonymousClass)aClass).getBaseClassType())).resolveGenerics()).getElement()) == null) {
            return;
        }
        PsiJavaCodeReferenceElement classReference2 = expression2.getClassOrAnonymousClassReference();
        HighlightMethodUtil.checkConstructorCall(typeResult, (PsiConstructorCall)expression2, type2, classReference2, holder, javaSdkVersion);
    }

    static void checkConstructorCall(@NotNull PsiClassType.ClassResolveResult typeResolveResult, @NotNull PsiConstructorCall constructorCall, @NotNull PsiType type2, @Nullable PsiJavaCodeReferenceElement classReference2, @NotNull HighlightInfoHolder holder, @NotNull JavaSdkVersion javaSdkVersion) {
        PsiExpression qualifier;
        PsiExpressionList list;
        if (typeResolveResult == null) {
            HighlightMethodUtil.$$$reportNull$$$0(173);
        }
        if (constructorCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(174);
        }
        if (type2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(175);
        }
        if (holder == null) {
            HighlightMethodUtil.$$$reportNull$$$0(176);
        }
        if (javaSdkVersion == null) {
            HighlightMethodUtil.$$$reportNull$$$0(177);
        }
        if ((list = constructorCall.getArgumentList()) == null) {
            return;
        }
        PsiClass aClass = typeResolveResult.getElement();
        if (aClass == null) {
            return;
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)holder.getProject()).getResolveHelper();
        PsiClass accessObjectClass = null;
        if (constructorCall instanceof PsiNewExpression && (qualifier = ((PsiNewExpression)constructorCall).getQualifier()) != null) {
            accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)qualifier).getElement();
        }
        if (classReference2 != null && !resolveHelper.isAccessible((PsiMember)aClass, (PsiElement)constructorCall, accessObjectClass)) {
            String description = HighlightUtil.accessProblemDescription((PsiElement)classReference2, (PsiElement)aClass, (JavaResolveResult)typeResolveResult);
            PsiElement element = (PsiElement)ObjectUtils.notNull((Object)classReference2.getReferenceNameElement(), (Object)classReference2);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
            HighlightFixUtil.registerAccessQuickFixAction((PsiMember)aClass, classReference2, info, null);
            holder.add(info);
            return;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            PsiReferenceParameterList typeArgumentList;
            if (!list.isEmpty()) {
                String constructorName = aClass.getName();
                String argTypes = HighlightMethodUtil.buildArgTypesList(list);
                String description = JavaErrorMessages.message("wrong.constructor.arguments", constructorName + "()", argTypes);
                String tooltip = HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(list, null, PsiParameter.EMPTY_ARRAY, constructorName, PsiSubstitutor.EMPTY, aClass);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).description(description).escapedToolTip(tooltip).navigationShift(1).create();
                QuickFixAction.registerQuickFixActions((HighlightInfo)info, (TextRange)constructorCall.getTextRange(), (Iterable)QUICK_FIX_FACTORY.createCreateConstructorFromUsageFixes(constructorCall));
                if (classReference2 != null) {
                    ConstructorParametersFixer.registerFixActions(classReference2, constructorCall, info, HighlightMethodUtil.getFixRange((PsiElement)list));
                }
                holder.add(info);
                return;
            }
            if (classReference2 != null && aClass.hasModifierProperty("protected") && HighlightMethodUtil.callingProtectedConstructorFromDerivedClass(constructorCall, aClass)) {
                holder.add(HighlightMethodUtil.buildAccessProblem(classReference2, (PsiMember)aClass, (JavaResolveResult)typeResolveResult));
            } else if (aClass.isInterface() && constructorCall instanceof PsiNewExpression && (typeArgumentList = ((PsiNewExpression)constructorCall).getTypeArgumentList()).getTypeArguments().length > 0) {
                holder.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeArgumentList).descriptionAndTooltip("Anonymous class implements interface; cannot have type arguments").create());
            }
        } else {
            PsiReferenceParameterList typeArgumentList;
            HighlightInfo info;
            PsiExpressionList infoElement;
            PsiAnonymousClass anonymousClass;
            PsiExpressionList place = list;
            if (constructorCall instanceof PsiNewExpression && (anonymousClass = ((PsiNewExpression)constructorCall).getAnonymousClass()) != null) {
                place = anonymousClass;
            }
            JavaResolveResult[] results = resolveHelper.multiResolveConstructor((PsiClassType)type2, list, (PsiElement)place);
            MethodCandidateInfo result = null;
            if (results.length == 1) {
                result = (MethodCandidateInfo)results[0];
            }
            PsiMethod constructor = result == null ? null : result.getElement();
            boolean applicable = true;
            try {
                JavaResolveResult staticFactory;
                PsiDiamondType diamondType = constructorCall instanceof PsiNewExpression ? PsiDiamondType.getDiamondType((PsiNewExpression)((PsiNewExpression)constructorCall)) : null;
                JavaResolveResult javaResolveResult = staticFactory = diamondType != null ? diamondType.getStaticFactory() : null;
                if (staticFactory instanceof MethodCandidateInfo) {
                    if (((MethodCandidateInfo)staticFactory).isApplicable()) {
                        result = (MethodCandidateInfo)staticFactory;
                        constructor = ((MethodCandidateInfo)staticFactory).getElement();
                    } else {
                        applicable = false;
                    }
                } else {
                    applicable = result != null && result.isApplicable();
                }
            }
            catch (IndexNotReadyException diamondType) {
                // empty catch block
            }
            Object object = infoElement = list.getTextLength() > 0 ? list : constructorCall;
            if (constructor == null) {
                String name = aClass.getName();
                name = name + HighlightMethodUtil.buildArgTypesList(list);
                String description = JavaErrorMessages.message("cannot.resolve.constructor", name);
                HighlightInfo info2 = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(description).navigationShift(1).create();
                if (info2 != null) {
                    WrapExpressionFix.registerWrapAction(results, list.getExpressions(), info2);
                    HighlightMethodUtil.registerFixesOnInvalidConstructorCall(constructorCall, classReference2, list, aClass, constructors, results, (PsiElement)infoElement, info2);
                    holder.add(info2);
                }
            } else if (classReference2 != null && (!result.isAccessible() || constructor.hasModifierProperty("protected") && HighlightMethodUtil.callingProtectedConstructorFromDerivedClass(constructorCall, aClass))) {
                holder.add(HighlightMethodUtil.buildAccessProblem(classReference2, (PsiMember)constructor, (JavaResolveResult)result));
            } else if (!applicable) {
                String constructorName = HighlightMessageUtil.getSymbolName((PsiElement)constructor, result.getSubstitutor());
                PsiClass constructorClass = constructor.getContainingClass();
                String containerName = constructorClass != null ? HighlightMessageUtil.getSymbolName((PsiElement)constructorClass, result.getSubstitutor()) : "<unknown>";
                String argTypes = HighlightMethodUtil.buildArgTypesList(list);
                String description = JavaErrorMessages.message("wrong.method.arguments", constructorName, containerName, argTypes);
                String toolTip = HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(result, list);
                HighlightInfo info3 = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)infoElement).description(description).escapedToolTip(toolTip).navigationShift(1).create();
                if (info3 != null) {
                    JavaResolveResult[] methodCandidates = results;
                    if (constructorCall instanceof PsiNewExpression) {
                        methodCandidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)constructorCall, true);
                    }
                    HighlightMethodUtil.registerFixesOnInvalidConstructorCall(constructorCall, classReference2, list, aClass, constructors, methodCandidates, (PsiElement)infoElement, info3);
                    HighlightMethodUtil.registerMethodReturnFixAction(info3, result, (PsiCall)constructorCall);
                    holder.add(info3);
                }
            } else if (constructorCall instanceof PsiNewExpression && (info = GenericsHighlightUtil.checkReferenceTypeArgumentList((PsiTypeParameterListOwner)constructor, typeArgumentList = ((PsiNewExpression)constructorCall).getTypeArgumentList(), result.getSubstitutor(), false, javaSdkVersion)) != null) {
                holder.add(info);
            }
            if (result != null && !holder.hasErrorResults()) {
                holder.add(HighlightMethodUtil.checkVarargParameterErasureToBeAccessible(result, (PsiCall)constructorCall));
            }
        }
    }

    private static HighlightInfo checkVarargParameterErasureToBeAccessible(@NotNull MethodCandidateInfo info, @NotNull PsiCall place) {
        if (info == null) {
            HighlightMethodUtil.$$$reportNull$$$0(178);
        }
        if (place == null) {
            HighlightMethodUtil.$$$reportNull$$$0(179);
        }
        PsiMethod method = info.getElement();
        if (info.isVarargs() || method.isVarArgs() && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)place)) {
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiType componentType = ((PsiEllipsisType)parameters2[parameters2.length - 1].getType()).getComponentType();
            PsiType substitutedTypeErasure = TypeConversionUtil.erasure((PsiType)info.getSubstitutor().substitute(componentType));
            PsiClass targetClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)substitutedTypeErasure);
            if (targetClass != null && !PsiUtil.isAccessible((PsiMember)targetClass, (PsiElement)place, null)) {
                PsiExpressionList argumentList = place.getArgumentList();
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip("Formal varargs element type " + PsiFormatUtil.formatClass((PsiClass)targetClass, (int)2048) + " is inaccessible here").range((PsiElement)(argumentList != null ? argumentList : place)).create();
            }
        }
        return null;
    }

    private static void registerFixesOnInvalidConstructorCall(@NotNull PsiConstructorCall constructorCall, @Nullable PsiJavaCodeReferenceElement classReference2, @NotNull PsiExpressionList list, @NotNull PsiClass aClass, @NotNull PsiMethod[] constructors, @NotNull JavaResolveResult[] results, @NotNull PsiElement infoElement, @NotNull HighlightInfo info) {
        if (constructorCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(180);
        }
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(181);
        }
        if (aClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(182);
        }
        if (constructors == null) {
            HighlightMethodUtil.$$$reportNull$$$0(183);
        }
        if (results == null) {
            HighlightMethodUtil.$$$reportNull$$$0(184);
        }
        if (infoElement == null) {
            HighlightMethodUtil.$$$reportNull$$$0(185);
        }
        if (info == null) {
            HighlightMethodUtil.$$$reportNull$$$0(186);
        }
        QuickFixAction.registerQuickFixActions((HighlightInfo)info, (TextRange)constructorCall.getTextRange(), (Iterable)QUICK_FIX_FACTORY.createCreateConstructorFromUsageFixes(constructorCall));
        if (classReference2 != null) {
            ConstructorParametersFixer.registerFixActions(classReference2, constructorCall, info, HighlightMethodUtil.getFixRange(infoElement));
            ChangeTypeArgumentsFix.registerIntentions(results, list, info, aClass);
            ConvertDoubleToFloatFix.registerIntentions(results, list, info, null);
        }
        HighlightMethodUtil.registerChangeMethodSignatureFromUsageIntentions(results, list, info, null);
        PermuteArgumentsFix.registerFix(info, (PsiCall)constructorCall, (CandidateInfo[])HighlightMethodUtil.toMethodCandidates(results), HighlightMethodUtil.getFixRange((PsiElement)list));
        HighlightMethodUtil.registerChangeParameterClassFix((PsiCall)constructorCall, list, info);
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (TextRange)HighlightMethodUtil.getFixRange((PsiElement)list), (IntentionAction)QUICK_FIX_FACTORY.createSurroundWithArrayFix((PsiCall)constructorCall, null));
        ChangeStringLiteralToCharInMethodCallFix.registerFixes(constructors, constructorCall, info);
    }

    private static HighlightInfo buildAccessProblem(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiMember resolved, @NotNull JavaResolveResult result) {
        if (ref == null) {
            HighlightMethodUtil.$$$reportNull$$$0(187);
        }
        if (resolved == null) {
            HighlightMethodUtil.$$$reportNull$$$0(188);
        }
        if (result == null) {
            HighlightMethodUtil.$$$reportNull$$$0(189);
        }
        String description = HighlightUtil.accessProblemDescription((PsiElement)ref, (PsiElement)resolved, result);
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)ref).descriptionAndTooltip(description).navigationShift(1).create();
        if (result.isStaticsScopeCorrect()) {
            HighlightFixUtil.registerAccessQuickFixAction(resolved, ref, info, result.getCurrentFileResolveScope());
        }
        return info;
    }

    private static boolean callingProtectedConstructorFromDerivedClass(@NotNull PsiConstructorCall place, @NotNull PsiClass constructorClass) {
        PsiClass aClass;
        if (place == null) {
            HighlightMethodUtil.$$$reportNull$$$0(190);
        }
        if (constructorClass == null) {
            HighlightMethodUtil.$$$reportNull$$$0(191);
        }
        if (place instanceof PsiNewExpression && ((PsiNewExpression)place).getAnonymousClass() != null) {
            return false;
        }
        PsiConstructorCall curElement = place;
        PsiClass containingClass = constructorClass.getContainingClass();
        do {
            if ((aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)curElement, PsiClass.class)) == null) {
                return false;
            }
            curElement = aClass;
        } while (!aClass.isInheritor(constructorClass, true) && (containingClass == null || !aClass.isInheritor(containingClass, true)) || JavaPsiFacade.getInstance((Project)aClass.getProject()).arePackagesTheSame((PsiElement)aClass, (PsiElement)constructorClass));
        return true;
    }

    @NotNull
    private static String buildArgTypesList(@NotNull PsiExpressionList list) {
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(192);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        PsiExpression[] args = list.getExpressions();
        for (int i = 0; i < args.length; ++i) {
            PsiType argType;
            if (i > 0) {
                builder.append(", ");
            }
            builder.append((argType = args[i].getType()) != null ? JavaHighlightUtil.formatType(argType) : "?");
        }
        builder.append(")");
        String string = builder.toString();
        if (string == null) {
            HighlightMethodUtil.$$$reportNull$$$0(193);
        }
        return string;
    }

    private static void registerChangeParameterClassFix(@NotNull PsiCall methodCall, @NotNull PsiExpressionList list, @Nullable HighlightInfo highlightInfo) {
        if (methodCall == null) {
            HighlightMethodUtil.$$$reportNull$$$0(194);
        }
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(195);
        }
        JavaResolveResult result = methodCall.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)result.getElement();
        PsiSubstitutor substitutor = result.getSubstitutor();
        PsiExpression[] expressions2 = list.getExpressions();
        if (method == null) {
            return;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length != expressions2.length) {
            return;
        }
        for (int i = 0; i < expressions2.length; ++i) {
            PsiExpression expression2 = expressions2[i];
            PsiParameter parameter2 = parameters2[i];
            PsiType expressionType = expression2.getType();
            PsiType parameterType = substitutor.substitute(parameter2.getType());
            if (expressionType == null || expressionType instanceof PsiPrimitiveType || TypeConversionUtil.isNullType((PsiType)expressionType) || expressionType instanceof PsiArrayType || parameterType instanceof PsiPrimitiveType || TypeConversionUtil.isNullType((PsiType)parameterType) || parameterType instanceof PsiArrayType || parameterType.isAssignableFrom(expressionType)) continue;
            PsiClass parameterClass = PsiUtil.resolveClassInType((PsiType)parameterType);
            PsiClass expressionClass = PsiUtil.resolveClassInType((PsiType)expressionType);
            if (parameterClass == null || expressionClass == null || expressionClass instanceof PsiAnonymousClass || parameterClass.isInheritor(expressionClass, true)) continue;
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createChangeParameterClassFix(expressionClass, (PsiClassType)parameterType));
        }
    }

    private static void registerChangeMethodSignatureFromUsageIntentions(@NotNull JavaResolveResult[] candidates, @NotNull PsiExpressionList list, @Nullable HighlightInfo highlightInfo, @Nullable TextRange fixRange) {
        if (candidates == null) {
            HighlightMethodUtil.$$$reportNull$$$0(196);
        }
        if (list == null) {
            HighlightMethodUtil.$$$reportNull$$$0(197);
        }
        if (candidates.length == 0) {
            return;
        }
        PsiExpression[] expressions2 = list.getExpressions();
        for (JavaResolveResult candidate : candidates) {
            HighlightMethodUtil.registerChangeMethodSignatureFromUsageIntention(expressions2, highlightInfo, fixRange, candidate, (PsiElement)list);
        }
    }

    private static void registerChangeMethodSignatureFromUsageIntention(@NotNull PsiExpression[] expressions2, @Nullable HighlightInfo highlightInfo, @Nullable TextRange fixRange, @NotNull JavaResolveResult candidate, @NotNull PsiElement context) {
        if (expressions2 == null) {
            HighlightMethodUtil.$$$reportNull$$$0(198);
        }
        if (candidate == null) {
            HighlightMethodUtil.$$$reportNull$$$0(199);
        }
        if (context == null) {
            HighlightMethodUtil.$$$reportNull$$$0(200);
        }
        if (!candidate.isStaticsScopeCorrect()) {
            return;
        }
        PsiMethod method = (PsiMethod)candidate.getElement();
        PsiSubstitutor substitutor = candidate.getSubstitutor();
        if (method != null && context.getManager().isInProject((PsiElement)method)) {
            IntentionAction fix2 = QUICK_FIX_FACTORY.createChangeMethodSignatureFromUsageFix(method, expressions2, substitutor, context, false, 2);
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)fix2);
            IntentionAction f2 = QUICK_FIX_FACTORY.createChangeMethodSignatureFromUsageReverseOrderFix(method, expressions2, substitutor, context, false, 2);
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)f2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 87: 
            case 89: 
            case 97: 
            case 99: 
            case 101: 
            case 104: 
            case 111: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 122: 
            case 128: 
            case 132: 
            case 136: 
            case 168: 
            case 169: 
            case 193: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 87: 
            case 89: 
            case 97: 
            case 99: 
            case 101: 
            case 104: 
            case 111: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 122: 
            case 128: 
            case 132: 
            case 136: 
            case 168: 
            case 169: 
            case 193: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method2";
                break;
            }
            case 2: 
            case 3: 
            case 87: 
            case 89: 
            case 97: 
            case 99: 
            case 101: 
            case 104: 
            case 111: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 122: 
            case 128: 
            case 132: 
            case 136: 
            case 168: 
            case 169: 
            case 193: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil";
                break;
            }
            case 4: 
            case 11: 
            case 13: 
            case 19: 
            case 30: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSignature";
                break;
            }
            case 5: 
            case 12: 
            case 14: 
            case 31: 
            case 35: 
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethodSignatures";
                break;
            }
            case 6: 
            case 154: 
            case 159: 
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 7: 
            case 18: 
            case 24: 
            case 32: 
            case 41: 
            case 140: 
            case 141: 
            case 143: 
            case 145: 
            case 147: 
            case 153: 
            case 156: 
            case 165: 
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessModifier";
                break;
            }
            case 10: 
            case 15: 
            case 25: 
            case 33: 
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethodSignature";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superReturnType";
                break;
            }
            case 20: 
            case 27: 
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailMessage";
                break;
            }
            case 22: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 23: 
            case 45: 
            case 77: 
            case 148: 
            case 161: 
            case 164: 
            case 201: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutedSuperReturnType";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analyzedClass";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superSignature";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedExceptions";
                break;
            }
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutorForDerivedClass";
                break;
            }
            case 43: 
            case 48: 
            case 50: 
            case 52: 
            case 63: 
            case 67: 
            case 75: 
            case 83: 
            case 90: 
            case 94: 
            case 149: 
            case 194: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 44: 
            case 68: 
            case 76: 
            case 84: 
            case 92: 
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveHelper";
                break;
            }
            case 46: 
            case 172: 
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSdkVersion";
                break;
            }
            case 47: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 53: 
            case 56: 
            case 74: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 54: 
            case 188: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 55: 
            case 70: 
            case 71: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceToMethod";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixRange";
                break;
            }
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 59: 
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfo";
                break;
            }
            case 62: 
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 64: 
            case 69: 
            case 73: 
            case 81: 
            case 91: 
            case 103: 
            case 105: 
            case 117: 
            case 123: 
            case 181: 
            case 192: 
            case 195: 
            case 197: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateInfo";
                break;
            }
            case 66: 
            case 85: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
            case 72: 
            case 80: 
            case 86: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 93: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCandidates";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exprList";
                break;
            }
            case 98: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCandidate";
                break;
            }
            case 102: 
            case 178: 
            case 186: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 106: 
            case 118: 
            case 124: 
            case 130: 
            case 133: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 107: 
            case 119: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 108: 
            case 120: 
            case 126: 
            case 131: 
            case 134: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 109: 
            case 121: 
            case 127: 
            case 144: 
            case 155: 
            case 162: 
            case 182: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 110: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 129: 
            case 135: 
            case 138: 
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicateMethods";
                break;
            }
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 171: 
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 173: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeResolveResult";
                break;
            }
            case 174: 
            case 180: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorCall";
                break;
            }
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 179: 
            case 190: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 183: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructors";
                break;
            }
            case 184: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 185: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoElement";
                break;
            }
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 191: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorClass";
                break;
            }
            case 196: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 200: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightMethodUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createClashMethodMessage";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "findCandidates";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "toMethodCandidates";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "createAmbiguousMethodHtmlTooltip";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingClassName";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "createAmbiguousMethodHtmlTooltipMethodRow";
                break;
            }
            case 104: 
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "createMismatchedArgumentsHtmlTooltip";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "escTrim";
                break;
            }
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "trimNicely";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "createLongMismatchedArgumentsHtmlTooltip";
                break;
            }
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "createMismatchedArgsHtmlTooltipArgumentsRow";
                break;
            }
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "createMismatchedArgsHtmlTooltipParamsRow";
                break;
            }
            case 168: 
            case 169: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixRange";
                break;
            }
            case 193: {
                objectArray = objectArray2;
                objectArray2[1] = "buildArgTypesList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createClashMethodMessage";
                break;
            }
            case 2: 
            case 3: 
            case 87: 
            case 89: 
            case 97: 
            case 99: 
            case 101: 
            case 104: 
            case 111: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 122: 
            case 128: 
            case 132: 
            case 136: 
            case 168: 
            case 169: 
            case 193: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodWeakerPrivileges";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isWeaker";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodIncompatibleReturnType";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkSuperMethodSignature";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createIncompatibleReturnTypeMessage";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodOverridesFinal";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkSuperMethodIsFinal";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodIncompatibleThrows";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getExtraExceptionNum";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isMethodThrows";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodCall";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "registerUsageFixes";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "registerThisSuperFixes";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "registerTargetTypeFixesBasedOnApplicabilityInference";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "checkStaticInterfaceCallQualifier";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "checkStaticInterfaceMethodCallQualifier";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "registerMethodReturnFixAction";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "buildOneLineMismatchDescription";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isDummyConstructorCall";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "checkAmbiguousMethodCallIdentifier";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "checkAmbiguousMethodCallArguments";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "findCandidates";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "toMethodCandidates";
                break;
            }
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "registerMethodCallIntentions";
                break;
            }
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "registerMethodAccessLevelIntentions";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "createAmbiguousMethodHtmlTooltip";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getContainingClassName";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "createAmbiguousMethodHtmlTooltipMethodRow";
                break;
            }
            case 102: 
            case 103: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "createMismatchedArgumentsHtmlTooltip";
                break;
            }
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "createShortMismatchedArgumentsHtmlTooltip";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "escTrim";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "trimNicely";
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "createLongMismatchedArgumentsHtmlTooltip";
                break;
            }
            case 129: 
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "createMismatchedArgsHtmlTooltipArgumentsRow";
                break;
            }
            case 133: 
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "createMismatchedArgsHtmlTooltipParamsRow";
                break;
            }
            case 137: 
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "showShortType";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodMustHaveBody";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "checkAbstractMethodInConcreteClass";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructorName";
                break;
            }
            case 144: 
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicateMethod";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodCanHaveBody";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructorCallMustBeFirstStatement";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "checkSuperAbstractMethodDirectCall";
                break;
            }
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructorCallsBaseClassConstructor";
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "checkStaticMethodOverride";
                break;
            }
            case 160: 
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "checkInterfaceInheritedMethodsReturnTypes";
                break;
            }
            case 162: 
            case 163: 
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "checkOverrideEquivalentInheritedMethods";
                break;
            }
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructorHandleSuperClassExceptions";
                break;
            }
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "checkRecursiveConstructorInvocation";
                break;
            }
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "getFixRange";
                break;
            }
            case 170: 
            case 171: 
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "checkNewExpression";
                break;
            }
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructorCall";
                break;
            }
            case 178: 
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "checkVarargParameterErasureToBeAccessible";
                break;
            }
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "registerFixesOnInvalidConstructorCall";
                break;
            }
            case 187: 
            case 188: 
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "buildAccessProblem";
                break;
            }
            case 190: 
            case 191: {
                objectArray = objectArray;
                objectArray[2] = "callingProtectedConstructorFromDerivedClass";
                break;
            }
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "buildArgTypesList";
                break;
            }
            case 194: 
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeParameterClassFix";
                break;
            }
            case 196: 
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeMethodSignatureFromUsageIntentions";
                break;
            }
            case 198: 
            case 199: 
            case 200: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeMethodSignatureFromUsageIntention";
                break;
            }
            case 201: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkInterfaceInheritedMethodsReturnTypes$1";
                break;
            }
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkSuperMethodSignature$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 87: 
            case 89: 
            case 97: 
            case 99: 
            case 101: 
            case 104: 
            case 111: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 122: 
            case 128: 
            case 132: 
            case 136: 
            case 168: 
            case 169: 
            case 193: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

