/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CreateClassFromUsageFix
extends CreateClassFromUsageBaseFix {
    public CreateClassFromUsageFix(PsiJavaCodeReferenceElement refElement, CreateClassKind kind2) {
        super(kind2, refElement);
    }

    @Override
    public String getText(String varName) {
        return QuickFixBundle.message("create.class.from.usage.text", this.myKind.getDescription(), varName);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            CreateClassFromUsageFix.$$$reportNull$$$0(0);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiJavaCodeReferenceElement element = this.getRefElement();
        if (element == null) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)element)) {
            return;
        }
        String superClassName = this.getSuperClassName(element);
        PsiClass aClass = CreateFromUsageUtils.createClass(element, this.myKind, superClassName);
        if (aClass == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project == null) {
                CreateClassFromUsageFix.$$$reportNull$$$0(1);
            }
            PsiJavaCodeReferenceElement refElement = element;
            try {
                refElement = (PsiJavaCodeReferenceElement)refElement.bindToElement((PsiElement)aClass);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
            Navigatable descriptor = PsiNavigationSupport.getInstance().createNavigatable(refElement.getProject(), aClass.getContainingFile().getVirtualFile(), aClass.getTextOffset());
            descriptor.navigate(true);
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateClassFromUsageFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$invoke$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

