/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModifierFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.ModifierFix");
    @PsiModifier.ModifierConstant
    private final String myModifier;
    private final boolean myShouldHave;
    private final boolean myShowContainingClass;
    private final String myName;
    private final SmartPsiElementPointer<PsiVariable> myVariable;

    public ModifierFix(PsiModifierList modifierList, @PsiModifier.ModifierConstant @NotNull String modifier, boolean shouldHave, boolean showContainingClass) {
        if (modifier == null) {
            ModifierFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)modifierList);
        this.myModifier = modifier;
        this.myShouldHave = shouldHave;
        this.myShowContainingClass = showContainingClass;
        this.myName = this.format(null, modifierList);
        this.myVariable = null;
    }

    public ModifierFix(@NotNull PsiModifierListOwner owner, @PsiModifier.ModifierConstant @NotNull String modifier, boolean shouldHave, boolean showContainingClass) {
        if (owner == null) {
            ModifierFix.$$$reportNull$$$0(1);
        }
        if (modifier == null) {
            ModifierFix.$$$reportNull$$$0(2);
        }
        super((PsiElement)owner.getModifierList());
        this.myModifier = modifier;
        this.myShouldHave = shouldHave;
        this.myShowContainingClass = showContainingClass;
        PsiVariable variable = owner instanceof PsiVariable ? (PsiVariable)owner : null;
        this.myName = this.format(variable, owner.getModifierList());
        this.myVariable = variable == null ? null : SmartPointerManager.getInstance((Project)owner.getProject()).createSmartPsiElementPointer((PsiElement)variable);
    }

    private String format(PsiVariable variable, PsiModifierList modifierList) {
        PsiVariable parent;
        String name = null;
        Object object = variable != null ? variable : (parent = modifierList != null ? modifierList.getParent() : null);
        if (parent instanceof PsiClass) {
            name = ((PsiClass)parent).getName();
        } else if (parent instanceof PsiJavaModule) {
            name = ((PsiJavaModule)parent).getName();
        } else if (parent instanceof PsiMethod) {
            int options = 1 | (this.myShowContainingClass ? 4096 : 0);
            name = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)parent), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options, (int)0);
        } else if (parent instanceof PsiVariable) {
            int options = 1 | (this.myShowContainingClass ? 4096 : 0);
            name = PsiFormatUtil.formatVariable((PsiVariable)parent, (int)options, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        } else if (parent instanceof PsiClassInitializer) {
            PsiClass containingClass = ((PsiClassInitializer)parent).getContainingClass();
            String className = containingClass instanceof PsiAnonymousClass ? QuickFixBundle.message("anonymous.class.presentation", ((PsiAnonymousClass)containingClass).getBaseClassType().getPresentableText()) : (containingClass != null ? containingClass.getName() : "unknown");
            name = QuickFixBundle.message("class.initializer.presentation", className);
        } else if (parent instanceof PsiRequiresStatement) {
            name = "requires " + ((PsiRequiresStatement)parent).getModuleName();
        }
        String modifierText = VisibilityUtil.toPresentableText((String)this.myModifier);
        return QuickFixBundle.message(this.myShouldHave ? "add.modifier.fix" : "remove.modifier.fix", name, modifierText);
    }

    @NotNull
    public String getText() {
        String string = this.myName;
        if (string == null) {
            ModifierFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.modifiers.family", new Object[0]);
        if (string == null) {
            ModifierFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            ModifierFix.$$$reportNull$$$0(5);
        }
        if (file == null) {
            ModifierFix.$$$reportNull$$$0(6);
        }
        if (startElement == null) {
            ModifierFix.$$$reportNull$$$0(7);
        }
        if (endElement == null) {
            ModifierFix.$$$reportNull$$$0(8);
        }
        PsiModifierList myModifierList = (PsiModifierList)startElement;
        PsiVariable variable = this.myVariable == null ? null : (PsiVariable)this.myVariable.getElement();
        return BaseIntentionAction.canModify((PsiElement)myModifierList) && myModifierList.hasExplicitModifier(this.myModifier) != this.myShouldHave && (variable == null || variable.isValid());
    }

    private void changeModifierList(@NotNull PsiModifierList modifierList) {
        if (modifierList == null) {
            ModifierFix.$$$reportNull$$$0(9);
        }
        try {
            modifierList.setModifierProperty(this.myModifier, this.myShouldHave);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiElement owner;
        PsiModifierList modifierList;
        PsiVariable variable;
        if (project == null) {
            ModifierFix.$$$reportNull$$$0(10);
        }
        if (file == null) {
            ModifierFix.$$$reportNull$$$0(11);
        }
        if (startElement == null) {
            ModifierFix.$$$reportNull$$$0(12);
        }
        if (endElement == null) {
            ModifierFix.$$$reportNull$$$0(13);
        }
        PsiModifierList myModifierList = (PsiModifierList)startElement;
        PsiVariable psiVariable = variable = this.myVariable == null ? null : (PsiVariable)this.myVariable.getElement();
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)myModifierList)) {
            return;
        }
        if (variable != null && !FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)variable)) {
            return;
        }
        final ArrayList modifierLists = new ArrayList();
        PsiFile containingFile = myModifierList.getContainingFile();
        if (variable != null && variable.isValid()) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    variable.normalizeDeclaration();
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            });
            modifierList = variable.getModifierList();
            assert (modifierList != null);
        } else {
            modifierList = myModifierList;
        }
        if ((owner = modifierList.getParent()) instanceof PsiMethod) {
            PsiModifierList copy = (PsiModifierList)myModifierList.copy();
            this.changeModifierList(copy);
            final int accessLevel = PsiUtil.getAccessLevel((PsiModifierList)copy);
            OverridingMethodsSearch.search((PsiMethod)((PsiMethod)owner), (SearchScope)owner.getResolveScope(), (boolean)true).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)new PsiElementProcessor<PsiMethod>(){

                public boolean execute(@NotNull PsiMethod inheritor) {
                    if (inheritor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    PsiModifierList list = inheritor.getModifierList();
                    if (BaseIntentionAction.canModify((PsiElement)inheritor) && PsiUtil.getAccessLevel((PsiModifierList)list) < accessLevel) {
                        modifierLists.add(list);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inheritor", "com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix$1", "execute"));
                }
            }));
        }
        if (!modifierLists.isEmpty() && Messages.showYesNoDialog((Project)project, (String)QuickFixBundle.message("change.inheritors.visibility.warning.text", new Object[0]), (String)QuickFixBundle.message("change.inheritors.visibility.warning.title", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (!FileModificationService.getInstance().preparePsiElementsForWrite((Collection)modifierLists)) {
                    return;
                }
                for (PsiModifierList modifierList1 : modifierLists) {
                    this.changeModifierList(modifierList1);
                }
            });
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.changeModifierList(modifierList);
            if (this.myShouldHave && owner instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)owner;
                if ("abstract".equals(this.myModifier)) {
                    PsiModifierList classModifierList;
                    PsiClass aClass = method.getContainingClass();
                    if (aClass != null && !aClass.hasModifierProperty("abstract") && (classModifierList = aClass.getModifierList()) != null) {
                        this.changeModifierList(classModifierList);
                    }
                } else if ("public".equals(this.myModifier) && method.getBody() != null && !method.hasModifierProperty("static")) {
                    PsiClass containingClass = method.getContainingClass();
                    if (containingClass != null && containingClass.isInterface()) {
                        modifierList.setModifierProperty("default", true);
                    }
                } else if ("static".equals(this.myModifier)) {
                    if (method.hasModifierProperty("default")) {
                        modifierList.setModifierProperty("default", false);
                    } else if (method.hasModifierProperty("abstract")) {
                        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"abstract", (boolean)false);
                        CreateFromUsageUtils.setupMethodBody(method);
                    }
                }
            }
            UndoUtil.markPsiFileForUndo((PsiFile)containingFile);
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "changeModifierList";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

