/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExternalAnnotationsManagerImpl;
import com.intellij.codeInsight.externalAnnotation.AnnotationProvider;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class AnnotateIntentionAction
extends BaseIntentionAction
implements LowPriorityAction {
    private static final AnnotationProvider[] PROVIDERS = (AnnotationProvider[])AnnotationProvider.KEY.getExtensions();
    private AnnotationProvider myAnnotationProvider;
    private boolean mySingleMode;

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.add.annotation.family", (Object[])new Object[0]);
        if (string == null) {
            AnnotateIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static StreamEx<AnnotationProvider> availableAnnotations(PsiModifierListOwner owner, Project project) {
        return (StreamEx)((StreamEx)StreamEx.of((Object[])PROVIDERS).filter(p -> p.isAvailable(owner))).filter(p -> !AnnotateIntentionAction.alreadyAnnotated(owner, p, project));
    }

    public boolean selectSingle(Editor editor, PsiFile file, String annotationShortName) {
        if (this.mySingleMode) {
            throw new IllegalStateException();
        }
        this.mySingleMode = true;
        PsiModifierListOwner owner = AddAnnotationPsiFix.getContainer(file, editor.getCaretModel().getOffset());
        if (owner == null || owner.getModifierList() == null || !ExternalAnnotationsManagerImpl.areExternalAnnotationsApplicable(owner)) {
            return false;
        }
        Optional provider = (Optional)((StreamEx)AnnotateIntentionAction.availableAnnotations(owner, file.getProject()).filter(p -> StringUtil.getShortName((String)p.getName(file.getProject())).equals(annotationShortName))).collect(MoreCollectors.onlyOne());
        this.myAnnotationProvider = provider.orElse(null);
        return provider.isPresent();
    }

    private static boolean alreadyAnnotated(PsiModifierListOwner owner, AnnotationProvider p, Project project) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])((String[])ArrayUtil.prepend((Object)p.getName(owner.getProject()), (Object[])p.getAnnotationsToRemove(project))));
        return annotation != null && !AnnotationUtil.isInferredAnnotation((PsiAnnotation)annotation);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiModifierListOwner owner;
        if (project == null) {
            AnnotateIntentionAction.$$$reportNull$$$0(1);
        }
        if ((owner = AddAnnotationPsiFix.getContainer(file, editor.getCaretModel().getOffset())) == null || owner.getModifierList() == null || !ExternalAnnotationsManagerImpl.areExternalAnnotationsApplicable(owner)) {
            return false;
        }
        if (this.mySingleMode) {
            return this.myAnnotationProvider != null && AnnotateIntentionAction.availableAnnotations(owner, project).has((Object)this.myAnnotationProvider);
        }
        List annotations2 = (List)((StreamEx)AnnotateIntentionAction.availableAnnotations(owner, project).limit(2L)).collect(Collectors.toList());
        if (annotations2.isEmpty()) {
            return false;
        }
        if (annotations2.size() == 1) {
            this.myAnnotationProvider = (AnnotationProvider)annotations2.get(0);
            this.setText(AddAnnotationPsiFix.calcText(owner, this.myAnnotationProvider.getName(project)));
        } else {
            this.myAnnotationProvider = null;
            this.setText(AddAnnotationPsiFix.calcText(owner, null));
        }
        return true;
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            AnnotateIntentionAction.$$$reportNull$$$0(2);
        }
        final PsiModifierListOwner owner = AddAnnotationPsiFix.getContainer(file, editor.getCaretModel().getOffset());
        assert (owner != null);
        if (this.myAnnotationProvider != null) {
            if (AnnotateIntentionAction.alreadyAnnotated(owner, this.myAnnotationProvider, project)) {
                return;
            }
            AddAnnotationFix fix2 = new AddAnnotationFix(this.myAnnotationProvider.getName(project), owner, this.myAnnotationProvider.getAnnotationsToRemove(project));
            fix2.invoke(project, editor, file);
        } else {
            List annotations2 = (List)AnnotateIntentionAction.availableAnnotations(owner, project).collect(Collectors.toList());
            if (annotations2.isEmpty()) {
                return;
            }
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<AnnotationProvider>(CodeInsightBundle.message((String)"annotate.intention.chooser.title", (Object[])new Object[0]), annotations2){

                public PopupStep onChosen(AnnotationProvider selectedValue, boolean finalChoice) {
                    return this.doFinalStep(() -> {
                        if (project == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        new AddAnnotationFix(selectedValue.getName(project), owner, selectedValue.getAnnotationsToRemove(project)).invoke(project, editor, file);
                    });
                }

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                @NotNull
                public String getTextFor(AnnotationProvider value2) {
                    String string = value2.getName(project);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 1: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 1: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/codeInsight/intention/impl/AnnotateIntentionAction$1";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getTextFor";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/codeInsight/intention/impl/AnnotateIntentionAction$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "lambda$onChosen$0";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }).showInBestPositionFor(editor);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/AnnotateIntentionAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/AnnotateIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

