/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.UastContextKt;

public abstract class AnnotatedElementInspectionBase
extends LocalInspectionTool {
    public boolean myIgnoreInsideImports = true;

    @NotNull
    protected abstract List<String> getAnnotations();

    protected abstract void createProblem(@NotNull PsiReference var1, @NotNull ProblemsHolder var2);

    protected abstract boolean shouldProcessElement(@NotNull PsiModifierListOwner var1);

    @NotNull
    public JPanel createOptionsPanel() {
        SingleCheckboxOptionsPanel singleCheckboxOptionsPanel = new SingleCheckboxOptionsPanel(JvmAnalysisBundle.message("jvm.inspections.unstable.api.usage.ignore.inside.imports", new Object[0]), (InspectionProfileEntry)this, "myIgnoreInsideImports");
        if (singleCheckboxOptionsPanel == null) {
            AnnotatedElementInspectionBase.$$$reportNull$$$0(0);
        }
        return singleCheckboxOptionsPanel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AnnotatedElementInspectionBase.$$$reportNull$$$0(1);
        }
        if (!this.isApplicable(holder.getFile(), holder.getProject())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                AnnotatedElementInspectionBase.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                if (element instanceof PsiLanguageInjectionHost || element instanceof LeafPsiElement) {
                    return;
                }
                if (AnnotatedElementInspectionBase.this.myIgnoreInsideImports && AnnotatedElementInspectionBase.isInsideImport(element)) {
                    return;
                }
                PsiMethod resolvedConstructor = null;
                PsiElement elementParent = element.getParent();
                if (elementParent instanceof PsiConstructorCall) {
                    resolvedConstructor = ((PsiConstructorCall)elementParent).resolveConstructor();
                }
                for (PsiReference reference : element.getReferences()) {
                    PsiModifierListOwner modifierListOwner = AnnotatedElementInspectionBase.getModifierListOwner(reference, resolvedConstructor);
                    if (modifierListOwner == null || !AnnotatedElementInspectionBase.this.shouldProcessElement(modifierListOwner)) continue;
                    for (String annotation : AnnotatedElementInspectionBase.this.getAnnotations()) {
                        if (!modifierListOwner.hasAnnotation(annotation)) continue;
                        AnnotatedElementInspectionBase.this.createProblem(reference, holder);
                        return;
                    }
                }
            }
        };
        if (psiElementVisitor == null) {
            AnnotatedElementInspectionBase.$$$reportNull$$$0(3);
        }
        return psiElementVisitor;
    }

    private static boolean isInsideImport(@NotNull PsiElement element) {
        if (element == null) {
            AnnotatedElementInspectionBase.$$$reportNull$$$0(4);
        }
        return PsiTreeUtil.findFirstParent((PsiElement)element, parent -> UastContextKt.toUElement((PsiElement)parent, UImportStatement.class) != null) != null;
    }

    @Nullable
    private static PsiModifierListOwner getModifierListOwner(@NotNull PsiReference reference, @Nullable PsiMethod resolvedConstructor) {
        if (reference == null) {
            AnnotatedElementInspectionBase.$$$reportNull$$$0(5);
        }
        if (resolvedConstructor != null) {
            return resolvedConstructor;
        }
        if (reference instanceof ResolvingHint && !((ResolvingHint)reference).canResolveTo(PsiModifierListOwner.class)) {
            return null;
        }
        PsiElement resolvedElement = reference.resolve();
        if (resolvedElement instanceof PsiModifierListOwner) {
            return (PsiModifierListOwner)resolvedElement;
        }
        return null;
    }

    private boolean isApplicable(@Nullable PsiFile file, @Nullable Project project) {
        if (file == null || project == null) {
            return false;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scope = file.getResolveScope();
        for (String annotation : this.getAnnotations()) {
            if (javaPsiFacade.findClass(annotation, scope) == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected static String getReferenceText(@NotNull PsiReference reference) {
        String referenceName;
        if (reference == null) {
            AnnotatedElementInspectionBase.$$$reportNull$$$0(6);
        }
        if (reference instanceof PsiQualifiedReference && (referenceName = ((PsiQualifiedReference)reference).getReferenceName()) != null) {
            String string = referenceName;
            if (string == null) {
                AnnotatedElementInspectionBase.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = StringUtil.getShortName((String)reference.getCanonicalText());
        if (string == null) {
            AnnotatedElementInspectionBase.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/AnnotatedElementInspectionBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/AnnotatedElementInspectionBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInsideImport";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModifierListOwner";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

