/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.EndOfInitializerInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonDataflow {
    @Contract(value="null -> null")
    @Nullable
    private static DataflowResult runDFA(@Nullable PsiElement block) {
        if (block == null) {
            return null;
        }
        DataFlowRunner runner = new DataFlowRunner(false, block);
        CommonDataflowVisitor visitor = new CommonDataflowVisitor();
        RunnerResult result = runner.analyzeMethodRecursively(block, visitor);
        if (result != RunnerResult.OK) {
            return null;
        }
        if (!(block instanceof PsiClass)) {
            return visitor.myResult;
        }
        DataflowResult dfr = visitor.myResult.copy();
        List states = visitor.myEndOfInitializerStates;
        for (PsiMethod method : ((PsiClass)block).getConstructors()) {
            PsiCodeBlock body2 = method.getBody();
            if (body2 == null) continue;
            PsiMethodCallExpression call = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)method);
            List initialStates = JavaPsiConstructorUtil.isChainedConstructorCall((PsiElement)call) || call == null && DfaUtil.hasImplicitImpureSuperCall((PsiClass)block, method) ? Collections.singletonList(runner.createMemoryState()) : StreamEx.of((Collection)states).map(DfaMemoryState::createCopy).toList();
            if (runner.analyzeBlockRecursively((PsiElement)body2, initialStates, visitor) == RunnerResult.OK) {
                dfr = visitor.myResult.copy();
                continue;
            }
            visitor.myResult = dfr;
        }
        return dfr;
    }

    @Nullable
    public static DataflowResult getDataflowResult(PsiExpression context) {
        PsiElement body2 = DfaUtil.getDataflowContext(context);
        if (body2 == null) {
            return null;
        }
        return (DataflowResult)CachedValuesManager.getCachedValue((PsiElement)body2, () -> {
            DataflowResult result = CommonDataflow.runDFA(body2);
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    public static <T> T getExpressionFact(PsiExpression expression2, DfaFactType<T> type2) {
        DataflowResult result = CommonDataflow.getDataflowResult(expression2);
        if (result == null) {
            return null;
        }
        return result.getExpressionFact(PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2), type2);
    }

    private static class CommonDataflowVisitor
    extends StandardInstructionVisitor {
        private DataflowResult myResult = new DataflowResult();
        private final List<DfaMemoryState> myEndOfInitializerStates = new ArrayList<DfaMemoryState>();

        private CommonDataflowVisitor() {
        }

        @Override
        public DfaInstructionState[] visitEndOfInitializer(EndOfInitializerInstruction instruction, DataFlowRunner runner, DfaMemoryState state) {
            if (!instruction.isStatic()) {
                this.myEndOfInitializerStates.add(state.createCopy());
            }
            return super.visitEndOfInitializer(instruction, runner, state);
        }

        @Override
        protected void beforeExpressionPush(@NotNull DfaValue value2, @NotNull PsiExpression expression2, @Nullable TextRange range, @NotNull DfaMemoryState state) {
            if (value2 == null) {
                CommonDataflowVisitor.$$$reportNull$$$0(0);
            }
            if (expression2 == null) {
                CommonDataflowVisitor.$$$reportNull$$$0(1);
            }
            if (state == null) {
                CommonDataflowVisitor.$$$reportNull$$$0(2);
            }
            if (range == null && !DfaConstValue.isContractFail(value2)) {
                this.myResult.add(expression2, (DfaMemoryStateImpl)state, value2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "state";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/CommonDataflow$CommonDataflowVisitor";
            objectArray[2] = "beforeExpressionPush";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DataflowResult {
        private final Object VALUE_NOT_KNOWN = ObjectUtils.sentinel((String)"VALUE_NOT_KNOWN");
        private final Map<PsiExpression, DfaFactMap> myFacts = new HashMap<PsiExpression, DfaFactMap>();
        private final Map<PsiExpression, Object> myValues = new HashMap<PsiExpression, Object>();
        private final Map<PsiExpression, Set<Object>> myNotValues = new HashMap<PsiExpression, Set<Object>>();

        DataflowResult copy() {
            DataflowResult copy = new DataflowResult();
            copy.myFacts.putAll(this.myFacts);
            return copy;
        }

        void add(PsiExpression expression2, DfaMemoryStateImpl memState, DfaValue value2) {
            this.addFacts(expression2, memState, value2);
            this.addValue(expression2, memState, value2);
            this.addNotValues(expression2, memState, value2);
        }

        private void addNotValues(PsiExpression expression2, DfaMemoryStateImpl memState, DfaValue value2) {
            if (value2 instanceof DfaVariableValue && !TypeConversionUtil.isIntegralNumberType((PsiType)value2.getType())) {
                Set<Object> notValues = this.myNotValues.get(expression2);
                if (notValues == null) {
                    Set<Object> constants = memState.getNonEqualConstants((DfaVariableValue)value2);
                    this.myNotValues.put(expression2, constants.isEmpty() ? Collections.emptySet() : constants);
                } else if (!notValues.isEmpty()) {
                    notValues.retainAll(memState.getNonEqualConstants((DfaVariableValue)value2));
                    if (notValues.isEmpty()) {
                        this.myNotValues.put(expression2, Collections.emptySet());
                    }
                }
            }
        }

        private void addValue(PsiExpression expression2, DfaMemoryStateImpl memState, DfaValue value2) {
            Object curValue = this.myValues.get(expression2);
            if (curValue != this.VALUE_NOT_KNOWN) {
                Object newValue;
                DfaConstValue constantValue = memState.getConstantValue(value2);
                Object object = newValue = constantValue == null ? null : constantValue.getValue();
                if (newValue == null || curValue != null && !Objects.equals(curValue, newValue)) {
                    newValue = this.VALUE_NOT_KNOWN;
                }
                this.myValues.put(expression2, newValue);
            }
        }

        private void addFacts(PsiExpression expression2, DfaMemoryStateImpl memState, DfaValue value2) {
            DfaFactMap existing = this.myFacts.get(expression2);
            if (existing != DfaFactMap.EMPTY) {
                DfaFactMap newMap = memState.getFactMap(value2);
                if (!DfaNullability.isNotNull(newMap) && memState.isNotNull(value2)) {
                    newMap = newMap.with(DfaFactType.NULLABILITY, DfaNullability.NOT_NULL);
                }
                this.myFacts.put(expression2, existing == null ? newMap : existing.unite(newMap));
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
                if (parent instanceof PsiConditionalExpression && !PsiTreeUtil.isAncestor((PsiElement)((PsiConditionalExpression)parent).getCondition(), (PsiElement)expression2, (boolean)false)) {
                    this.add((PsiExpression)parent, memState, value2);
                }
            }
        }

        public boolean expressionWasAnalyzed(PsiExpression expression2) {
            if (expression2 instanceof PsiParenthesizedExpression) {
                throw new IllegalArgumentException("Should not pass parenthesized expression");
            }
            return this.myFacts.containsKey(expression2);
        }

        @Nullable
        public <T> T getExpressionFact(PsiExpression expression2, DfaFactType<T> type2) {
            DfaFactMap map2 = this.myFacts.get(expression2);
            return map2 == null ? null : (T)map2.get(type2);
        }

        @Nullable
        @Contract(value="null -> null")
        public Object getExpressionValue(@Nullable PsiExpression expression2) {
            return this.myValues.get(expression2);
        }

        @NotNull
        public Set<Object> getValuesNotEqualToExpression(@Nullable PsiExpression expression2) {
            Set<Object> set = this.myNotValues.getOrDefault(expression2, Collections.emptySet());
            if (set == null) {
                DataflowResult.$$$reportNull$$$0(0);
            }
            return set;
        }

        @Nullable
        public DfaFactMap getAllFacts(PsiExpression expression2) {
            return this.myFacts.get(expression2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/CommonDataflow$DataflowResult", "getValuesNotEqualToExpression"));
        }
    }
}

