/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.CustomMethodHandlers;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.DfaCallState;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.instructions.ArrayAccessInstruction;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckNotNullInstruction;
import com.intellij.codeInspection.dataFlow.instructions.DereferenceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EscapeInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.NotInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableSource;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardInstructionVisitor
extends InstructionVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.StandardInstructionVisitor");
    private final Set<InstanceofInstruction> myReachable = new THashSet();
    private final Set<InstanceofInstruction> myCanBeNullInInstanceof = new THashSet();
    private final Set<InstanceofInstruction> myUsefulInstanceofs = new THashSet();

    @Override
    public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        NullabilityProblemKind<PsiExpression> kind2;
        DfaValue dfaSource = memState.pop();
        DfaValue dfaDest = memState.pop();
        if (!(dfaDest instanceof DfaVariableValue) && instruction.getAssignedValue() != null) {
            dfaDest = instruction.getAssignedValue();
        }
        if (dfaSource == dfaDest) {
            memState.push(dfaDest);
            this.flushArrayOnUnknownAssignment(instruction, runner.getFactory(), dfaDest, memState);
            return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
        }
        if (!(dfaDest instanceof DfaVariableValue && ((DfaVariableValue)dfaDest).getPsiVariable() instanceof PsiLocalVariable && dfaSource instanceof DfaVariableValue && ControlFlowAnalyzer.isTempVariable((DfaVariableValue)dfaSource))) {
            StandardInstructionVisitor.dropLocality(dfaSource, memState);
        }
        PsiExpression lValue = PsiUtil.skipParenthesizedExprDown((PsiExpression)instruction.getLExpression());
        PsiExpression rValue = instruction.getRExpression();
        if (lValue instanceof PsiArrayAccessExpression) {
            kind2 = NullabilityProblemKind.storingToNotNullArray;
            this.checkArrayElementAssignability(runner, memState, dfaSource, lValue, rValue);
        } else {
            kind2 = NullabilityProblemKind.assigningToNotNull;
        }
        if (dfaDest instanceof DfaVariableValue) {
            boolean forceDeclaredNullity;
            DfaVariableValue var = (DfaVariableValue)dfaDest;
            PsiModifierListOwner psi = var.getPsiVariable();
            boolean bl = forceDeclaredNullity = !(psi instanceof PsiParameter) || !(psi.getParent() instanceof PsiParameterList);
            if (psi instanceof PsiField && !psi.hasModifierProperty("final") && var.getInherentNullability() == Nullability.UNKNOWN) {
                this.checkNotNullable(memState, dfaSource, NullabilityProblemKind.assigningNullableValueToNonAnnotatedField.problem((PsiElement)rValue));
            } else if (forceDeclaredNullity && var.getInherentNullability() == Nullability.NOT_NULL) {
                this.checkNotNullable(memState, dfaSource, kind2.problem(rValue));
            }
            if (dfaSource instanceof DfaFactMapValue && var.getQualifier() != null && !Boolean.TRUE.equals(memState.getValueFact(var.getQualifier(), DfaFactType.LOCALITY))) {
                dfaSource = ((DfaFactMapValue)dfaSource).withFact(DfaFactType.LOCALITY, null);
            }
            if (!(psi instanceof PsiField) || !psi.hasModifierProperty("volatile")) {
                memState.setVarValue(var, dfaSource);
            }
            if (var.getInherentNullability() == Nullability.NULLABLE && !memState.isNotNull(dfaSource) && instruction.isVariableInitializer()) {
                DfaMemoryStateImpl stateImpl = (DfaMemoryStateImpl)memState;
                stateImpl.setVariableState(var, stateImpl.getVariableState(var).withFact(DfaFactType.NULLABILITY, DfaNullability.NULLABLE));
            }
        } else if (dfaDest instanceof DfaFactMapValue && DfaNullability.isNotNull(((DfaFactMapValue)dfaDest).getFacts())) {
            this.checkNotNullable(memState, dfaSource, kind2.problem(rValue));
        }
        this.pushExpressionResult(dfaDest, instruction, memState);
        this.flushArrayOnUnknownAssignment(instruction, runner.getFactory(), dfaDest, memState);
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    private void checkArrayElementAssignability(DataFlowRunner runner, DfaMemoryState memState, DfaValue dfaSource, PsiExpression lValue, PsiExpression rValue) {
        DfaValue arrayValue;
        if (rValue == null) {
            return;
        }
        PsiType rCodeType = rValue.getType();
        PsiType lCodeType = lValue.getType();
        if (rCodeType == null || lCodeType == null || !TypeConversionUtil.areTypesConvertible((PsiType)rCodeType, (PsiType)lCodeType)) {
            return;
        }
        PsiExpression array = ((PsiArrayAccessExpression)lValue).getArrayExpression();
        PsiType arrayType = StandardInstructionVisitor.getType(array, arrayValue = runner.getFactory().createValue(array), memState);
        if (!(arrayType instanceof PsiArrayType)) {
            return;
        }
        PsiType componentType = ((PsiArrayType)arrayType).getComponentType();
        PsiType sourceType = StandardInstructionVisitor.getType(rValue, dfaSource, memState);
        if (sourceType == null || TypeConversionUtil.areTypesConvertible((PsiType)sourceType, (PsiType)componentType)) {
            return;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)rValue, PsiAssignmentExpression.class);
        this.processArrayStoreTypeMismatch(assignmentExpression, sourceType, componentType);
    }

    @Nullable
    private static PsiType getType(@Nullable PsiExpression expression2, @Nullable DfaValue value2, @NotNull DfaMemoryState memState) {
        PsiType type2;
        if (memState == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(0);
        }
        TypeConstraint fact = value2 == null ? null : memState.getValueFact(value2, DfaFactType.TYPE_CONSTRAINT);
        PsiType psiType = type2 = fact == null ? null : fact.getPsiType();
        if (type2 != null) {
            return type2;
        }
        return expression2 == null ? null : expression2.getType();
    }

    protected void processArrayStoreTypeMismatch(PsiAssignmentExpression assignmentExpression, PsiType fromType, PsiType toType) {
    }

    @Override
    public DfaInstructionState[] visitEscapeInstruction(EscapeInstruction instruction, DataFlowRunner runner, DfaMemoryState state) {
        instruction.getEscapedVars().forEach(var -> StandardInstructionVisitor.dropLocality(var, state));
        return super.visitEscapeInstruction(instruction, runner, state);
    }

    private static void dropLocality(DfaValue value2, DfaMemoryState state) {
        if (!(value2 instanceof DfaVariableValue)) {
            return;
        }
        DfaVariableValue var = (DfaVariableValue)value2;
        state.dropFact(var, DfaFactType.LOCALITY);
        for (DfaVariableValue v : new ArrayList<DfaVariableValue>(var.getDependentVariables())) {
            state.dropFact(v, DfaFactType.LOCALITY);
        }
    }

    @Override
    public DfaInstructionState[] visitArrayAccess(ArrayAccessInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiArrayAccessExpression arrayExpression = instruction.getExpression();
        DfaValue index = memState.pop();
        DfaValue array = this.dereference(memState, memState.pop(), NullabilityProblemKind.arrayAccessNPE.problem(arrayExpression));
        boolean alwaysOutOfBounds = false;
        DfaValueFactory factory = runner.getFactory();
        if (index != DfaUnknownValue.getInstance()) {
            DfaValue indexLessThanLength;
            DfaValue dfaLength;
            DfaValue indexNonNegative = factory.createCondition(index, DfaRelationValue.RelationType.GE, factory.getInt(0));
            if (!memState.applyCondition(indexNonNegative)) {
                alwaysOutOfBounds = true;
            }
            if ((dfaLength = SpecialField.ARRAY_LENGTH.createValue(factory, array)) != null && !memState.applyCondition(indexLessThanLength = factory.createCondition(index, DfaRelationValue.RelationType.LT, dfaLength))) {
                alwaysOutOfBounds = true;
            }
        }
        this.processArrayAccess(arrayExpression, alwaysOutOfBounds);
        DfaValue result = instruction.getValue();
        LongRangeSet rangeSet = memState.getValueFact(index, DfaFactType.RANGE);
        DfaValue arrayElementValue = runner.getFactory().getExpressionFactory().getArrayElementValue(array, rangeSet == null ? LongRangeSet.all() : rangeSet);
        if (arrayElementValue != DfaUnknownValue.getInstance()) {
            result = arrayElementValue;
        }
        this.pushExpressionResult(result, instruction, memState);
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    protected void processArrayAccess(PsiArrayAccessExpression expression2, boolean alwaysOutOfBounds) {
    }

    @Override
    public DfaInstructionState[] visitFieldReference(DereferenceInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiExpression expression2 = instruction.getExpression();
        DfaValue qualifier = this.dereference(memState, memState.pop(), NullabilityProblemKind.fieldAccessNPE.problem(expression2));
        PsiElement parent = expression2.getParent();
        if (parent instanceof PsiMethodReferenceExpression) {
            StandardInstructionVisitor.dropLocality(qualifier, memState);
            this.handleMethodReference(qualifier, (PsiMethodReferenceExpression)parent, runner, memState);
        }
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    private void handleMethodReference(DfaValue qualifier, PsiMethodReferenceExpression methodRef, DataFlowRunner runner, DfaMemoryState state) {
        PsiType functionalInterfaceType = methodRef.getFunctionalInterfaceType();
        if (functionalInterfaceType == null) {
            return;
        }
        PsiMethod sam2 = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
        if (sam2 == null || PsiType.VOID.equals((Object)sam2.getReturnType())) {
            return;
        }
        JavaResolveResult resolveResult = methodRef.advancedResolve(false);
        PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)resolveResult.getElement(), PsiMethod.class);
        if (method == null || !JavaMethodContractUtil.isPure(method)) {
            return;
        }
        List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts(method, null);
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        DfaCallArguments callArguments = StandardInstructionVisitor.getMethodReferenceCallArguments(methodRef, qualifier, runner, sam2, method, substitutor);
        this.dereference(state, callArguments.myQualifier, NullabilityProblemKind.callMethodRefNPE.problem(methodRef));
        if (contracts2.isEmpty()) {
            return;
        }
        PsiType returnType = substitutor.substitute(method.getReturnType());
        DfaValue defaultResult = runner.getFactory().createTypeValue(returnType, DfaPsiUtil.getElementNullability(returnType, (PsiModifierListOwner)method));
        Set<DfaCallState> currentStates = Collections.singleton(new DfaCallState(state.createClosureState(), callArguments));
        for (MethodContract methodContract : contracts2) {
            currentStates = this.addContractResults(methodContract, currentStates, runner.getFactory(), new HashSet<DfaMemoryState>(), defaultResult, (PsiExpression)methodRef);
        }
        for (DfaCallState dfaCallState : currentStates) {
            this.pushExpressionResult(defaultResult, () -> methodRef, dfaCallState.myMemoryState);
        }
    }

    @NotNull
    private static DfaCallArguments getMethodReferenceCallArguments(PsiMethodReferenceExpression methodRef, DfaValue qualifier, DataFlowRunner runner, PsiMethod sam2, PsiMethod method, PsiSubstitutor substitutor) {
        PsiParameter[] samParameters = sam2.getParameterList().getParameters();
        boolean isStatic = method.hasModifierProperty("static");
        boolean instanceBound = !isStatic && !PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)methodRef);
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        Object[] arguments = new DfaValue[parameters2.length];
        Arrays.fill(arguments, DfaUnknownValue.getInstance());
        for (int i = 0; i < samParameters.length; ++i) {
            DfaValue value2 = runner.getFactory().createTypeValue(substitutor.substitute(samParameters[i].getType()), DfaPsiUtil.getFunctionalParameterNullability((PsiFunctionalExpression)methodRef, i));
            if (i == 0 && !isStatic && !instanceBound) {
                qualifier = value2;
                continue;
            }
            int idx = i - (isStatic || instanceBound ? 0 : 1);
            if (idx >= arguments.length) break;
            if (parameters2[idx].getType() instanceof PsiEllipsisType) continue;
            arguments[idx] = value2;
        }
        DfaCallArguments dfaCallArguments = new DfaCallArguments(qualifier, (DfaValue[])arguments, JavaMethodContractUtil.isPure(method));
        if (dfaCallArguments == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(1);
        }
        return dfaCallArguments;
    }

    @Override
    public DfaInstructionState[] visitTypeCast(TypeCastInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiType type2 = instruction.getCastTo();
        DfaValueFactory factory = runner.getFactory();
        PsiType fromType = instruction.getCasted().getType();
        if (fromType != null && type2.isConvertibleFrom(fromType) && !memState.castTopOfStack(factory.createDfaType(type2))) {
            this.onInstructionProducesCCE(instruction);
        }
        DfaValue value2 = memState.pop();
        if (type2 instanceof PsiPrimitiveType) {
            value2 = DfaUtil.boxUnbox(value2, type2);
        }
        this.pushExpressionResult(value2, instruction, memState);
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    protected void onInstructionProducesCCE(TypeCastInstruction instruction) {
    }

    protected void beforeMethodCall(@NotNull PsiExpression expression2, @NotNull DfaCallArguments arguments, @NotNull DataFlowRunner runner, @NotNull DfaMemoryState memState) {
        if (expression2 == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(2);
        }
        if (arguments == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(3);
        }
        if (runner == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(4);
        }
        if (memState == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(5);
        }
    }

    @Override
    public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValueFactory factory = runner.getFactory();
        DfaCallArguments callArguments = this.popCall(instruction, factory, memState);
        if (callArguments.myArguments != null && instruction.getExpression() != null) {
            this.beforeMethodCall(instruction.getExpression(), callArguments, runner, memState);
        }
        LinkedHashSet finalStates = ContainerUtil.newLinkedHashSet();
        finalStates.addAll(this.handleKnownMethods(instruction, runner, memState, callArguments));
        if (finalStates.isEmpty()) {
            Set<DfaCallState> currentStates = Collections.singleton(new DfaCallState(memState, callArguments));
            DfaValue defaultResult = StandardInstructionVisitor.getMethodResultValue(instruction, callArguments.myQualifier, memState, factory);
            if (callArguments.myArguments != null) {
                for (MethodContract contract : instruction.getContracts()) {
                    currentStates = this.addContractResults(contract, currentStates, factory, finalStates, defaultResult, instruction.getExpression());
                    if (currentStates.size() + finalStates.size() <= 300) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Too complex contract on " + instruction.getContext() + ", skipping contract processing");
                    }
                    finalStates.clear();
                    currentStates = Collections.singleton(new DfaCallState(memState, callArguments));
                    break;
                }
            }
            for (DfaCallState callState : currentStates) {
                this.pushExpressionResult(defaultResult, instruction, callState.myMemoryState);
                finalStates.add(callState.myMemoryState);
            }
        }
        DfaInstructionState[] result = new DfaInstructionState[finalStates.size()];
        int i = 0;
        for (DfaMemoryState state : finalStates) {
            if (instruction.shouldFlushFields()) {
                state.flushFields();
            }
            result[i++] = new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), state);
        }
        return result;
    }

    @NotNull
    private List<DfaMemoryState> handleKnownMethods(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaCallArguments callArguments) {
        if (callArguments.myArguments == null) {
            List<DfaMemoryState> list = Collections.emptyList();
            if (list == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(6);
            }
            return list;
        }
        PsiMethod method = instruction.getTargetMethod();
        if (method == null) {
            List<DfaMemoryState> list = Collections.emptyList();
            if (list == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(7);
            }
            return list;
        }
        CustomMethodHandlers.CustomMethodHandler handler = CustomMethodHandlers.find(method);
        if (handler == null) {
            List<DfaMemoryState> list = Collections.emptyList();
            if (list == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(8);
            }
            return list;
        }
        DfaValue result = handler.getMethodResult(callArguments, memState, runner.getFactory());
        if (result == null) {
            List<DfaMemoryState> list = Collections.emptyList();
            if (list == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(9);
            }
            return list;
        }
        this.pushExpressionResult(result, instruction, memState);
        List<DfaMemoryState> list = Collections.singletonList(memState);
        if (list == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    protected DfaCallArguments popCall(MethodCallInstruction instruction, DfaValueFactory factory, DfaMemoryState memState) {
        PsiMethod method = instruction.getTargetMethod();
        MutationSignature sig = MutationSignature.fromMethod(method);
        DfaValue[] argValues = this.popCallArguments(instruction, factory, memState, sig);
        DfaValue qualifier = this.popQualifier(instruction, memState, sig);
        DfaCallArguments dfaCallArguments = new DfaCallArguments(qualifier, argValues, !instruction.shouldFlushFields());
        if (dfaCallArguments == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(11);
        }
        return dfaCallArguments;
    }

    @Nullable
    private DfaValue[] popCallArguments(MethodCallInstruction instruction, DfaValueFactory factory, DfaMemoryState memState, MutationSignature sig) {
        PsiParameterList paramList;
        int paramCount;
        int argCount = instruction.getArgCount();
        PsiMethod method = instruction.getTargetMethod();
        boolean varargCall = instruction.isVarArgCall();
        DfaValue[] argValues = null;
        if (method != null && ((paramCount = (paramList = method.getParameterList()).getParametersCount()) == argCount || method.isVarArgs() && argCount >= paramCount - 1)) {
            argValues = new DfaValue[paramCount];
            if (varargCall) {
                argValues[paramCount - 1] = factory.createTypeValue(paramList.getParameters()[paramCount - 1].getType(), Nullability.NOT_NULL);
            }
        }
        for (int i = 0; i < argCount; ++i) {
            DfaValue arg = memState.pop();
            int paramIndex = argCount - i - 1;
            StandardInstructionVisitor.dropLocality(arg, memState);
            PsiElement anchor = instruction.getArgumentAnchor(paramIndex);
            Nullability requiredNullability = instruction.getArgRequiredNullability(paramIndex);
            if (requiredNullability == Nullability.NOT_NULL) {
                arg = this.dereference(memState, arg, NullabilityProblemKind.passingNullableToNotNullParameter.problem(anchor));
            } else if (requiredNullability == Nullability.UNKNOWN) {
                this.checkNotNullable(memState, arg, NullabilityProblemKind.passingNullableArgumentToNonAnnotatedParameter.problem(anchor));
            }
            if (sig.mutatesArg(paramIndex) && !memState.applyFact(arg, DfaFactType.MUTABILITY, Mutability.MUTABLE)) {
                this.reportMutabilityViolation(false, anchor);
                if (arg instanceof DfaVariableValue) {
                    memState.forceVariableFact((DfaVariableValue)arg, DfaFactType.MUTABILITY, Mutability.MUTABLE);
                }
            }
            if (argValues == null || paramIndex >= argValues.length - 1 && varargCall) continue;
            argValues[paramIndex] = arg;
        }
        return argValues;
    }

    protected void reportMutabilityViolation(boolean receiver2, @NotNull PsiElement anchor) {
        if (anchor == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(12);
        }
    }

    private DfaValue popQualifier(MethodCallInstruction instruction, DfaMemoryState memState, MutationSignature sig) {
        DfaValue value2 = this.dereference(memState, memState.pop(), instruction.getQualifierNullabilityProblem());
        if (sig.mutatesThis() && !memState.applyFact(value2, DfaFactType.MUTABILITY, Mutability.MUTABLE)) {
            this.reportMutabilityViolation(true, instruction.getContext());
            if (value2 instanceof DfaVariableValue) {
                memState.forceVariableFact((DfaVariableValue)value2, DfaFactType.MUTABILITY, Mutability.MUTABLE);
            }
        }
        if (value2 instanceof DfaVariableValue && !(value2.getType() instanceof PsiArrayType) && (instruction.shouldFlushFields() || !(instruction.getResultType() instanceof PsiPrimitiveType))) {
            StandardInstructionVisitor.dropLocality(value2, memState);
        }
        return value2;
    }

    private Set<DfaCallState> addContractResults(MethodContract contract, Set<DfaCallState> states, DfaValueFactory factory, Set<DfaMemoryState> finalStates, DfaValue defaultResult, PsiExpression expression2) {
        if (contract.isTrivial()) {
            for (DfaCallState callState : states) {
                DfaValue result = contract.getReturnValue().getDfaValue(factory, defaultResult, callState);
                this.pushExpressionResult(result, () -> expression2, callState.myMemoryState);
                finalStates.add(callState.myMemoryState);
            }
            return Collections.emptySet();
        }
        LinkedHashSet<DfaCallState> falseStates = new LinkedHashSet<DfaCallState>();
        for (DfaCallState callState : states) {
            DfaMemoryState state = callState.myMemoryState;
            DfaCallArguments arguments = callState.myCallArguments;
            for (ContractValue contractValue : contract.getConditions()) {
                DfaMemoryState falseState;
                DfaValue condition2 = contractValue.makeDfaValue(factory, callState.myCallArguments);
                if (condition2 == null) {
                    condition2 = DfaUnknownValue.getInstance();
                }
                if ((falseState = state.createCopy()).applyContractCondition(condition2.createNegated())) {
                    DfaCallArguments falseArguments = contractValue.updateArguments(arguments, true);
                    falseStates.add(new DfaCallState(falseState, falseArguments));
                }
                if (!state.applyContractCondition(condition2)) {
                    state = null;
                    break;
                }
                arguments = contractValue.updateArguments(arguments, false);
            }
            if (state == null) continue;
            DfaValue result = contract.getReturnValue().getDfaValue(factory, defaultResult, new DfaCallState(state, arguments));
            this.pushExpressionResult(result, () -> expression2, state);
            finalStates.add(state);
        }
        return falseStates;
    }

    private <T extends PsiElement> DfaValue dereference(DfaMemoryState memState, DfaValue value2, @Nullable NullabilityProblemKind.NullabilityProblem<T> problem) {
        boolean ok = this.checkNotNullable(memState, value2, problem);
        if (value2 instanceof DfaFactMapValue) {
            return ((DfaFactMapValue)value2).withFact(DfaFactType.NULLABILITY, DfaNullability.NOT_NULL);
        }
        if (ok) {
            return value2;
        }
        if (memState.isNull(value2) && NullabilityProblemKind.nullableFunctionReturn.isMyProblem(problem)) {
            return value2.getFactory().getFactValue(DfaFactType.NULLABILITY, DfaNullability.NOT_NULL);
        }
        if (value2 instanceof DfaVariableValue) {
            memState.forceVariableFact((DfaVariableValue)value2, DfaFactType.NULLABILITY, DfaNullability.NOT_NULL);
        }
        return value2;
    }

    @NotNull
    private static PsiMethod findSpecificMethod(@NotNull PsiMethod method, @NotNull DfaMemoryState state, @Nullable DfaValue qualifier) {
        if (method == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(13);
        }
        if (state == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(14);
        }
        if (qualifier == null || !PsiUtil.canBeOverridden((PsiMethod)method)) {
            PsiMethod psiMethod = method;
            if (psiMethod == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(15);
            }
            return psiMethod;
        }
        TypeConstraint constraint = state.getValueFact(qualifier, DfaFactType.TYPE_CONSTRAINT);
        PsiType type2 = constraint == null ? null : constraint.getPsiType();
        PsiMethod psiMethod = MethodUtils.findSpecificMethod(method, type2);
        if (psiMethod == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(16);
        }
        return psiMethod;
    }

    @NotNull
    private static DfaValue getMethodResultValue(MethodCallInstruction instruction, @Nullable DfaValue qualifierValue, DfaMemoryState state, DfaValueFactory factory) {
        DfaValue precalculated = instruction.getPrecalculatedReturnValue();
        if (precalculated != null) {
            DfaValue dfaValue = precalculated;
            if (dfaValue == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(17);
            }
            return dfaValue;
        }
        PsiType type2 = instruction.getResultType();
        MethodCallInstruction.MethodType methodType = instruction.getMethodType();
        if (methodType == MethodCallInstruction.MethodType.METHOD_REFERENCE_CALL && qualifierValue instanceof DfaVariableValue) {
            PsiMethod method = instruction.getTargetMethod();
            SpecialField field = SpecialField.findSpecialField((PsiElement)method);
            if (field != null) {
                DfaValue dfaValue = field.createValue(factory, qualifierValue);
                if (dfaValue == null) {
                    StandardInstructionVisitor.$$$reportNull$$$0(18);
                }
                return dfaValue;
            }
            DfaVariableSource source = DfaExpressionFactory.getAccessedVariableOrGetter((PsiElement)method);
            if (source != null) {
                DfaVariableValue dfaVariableValue = factory.getVarFactory().createVariableValue(source, instruction.getResultType(), (DfaVariableValue)qualifierValue);
                if (dfaVariableValue == null) {
                    StandardInstructionVisitor.$$$reportNull$$$0(19);
                }
                return dfaVariableValue;
            }
        }
        if (methodType == MethodCallInstruction.MethodType.UNBOXING) {
            DfaValue dfaValue = factory.getBoxedFactory().createUnboxed(qualifierValue, (PsiPrimitiveType)ObjectUtils.tryCast((Object)type2, PsiPrimitiveType.class));
            if (dfaValue == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(20);
            }
            return dfaValue;
        }
        if (methodType == MethodCallInstruction.MethodType.BOXING) {
            DfaValue boxed = factory.getBoxedFactory().createBoxed(qualifierValue, type2);
            DfaValue dfaValue = boxed == null ? factory.createTypeValue(type2, Nullability.NOT_NULL) : boxed;
            if (dfaValue == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(21);
            }
            return dfaValue;
        }
        if (methodType == MethodCallInstruction.MethodType.CAST) {
            assert (qualifierValue != null);
            if (qualifierValue instanceof DfaConstValue && type2 != null) {
                Object casted = TypeConversionUtil.computeCastTo((Object)((DfaConstValue)qualifierValue).getValue(), (PsiType)type2);
                DfaConstValue dfaConstValue = factory.getConstFactory().createFromValue(casted, type2);
                if (dfaConstValue == null) {
                    StandardInstructionVisitor.$$$reportNull$$$0(22);
                }
                return dfaConstValue;
            }
            DfaValue dfaValue = qualifierValue;
            if (dfaValue == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(23);
            }
            return dfaValue;
        }
        if (type2 != null && !(type2 instanceof PsiPrimitiveType)) {
            DfaValue value2;
            Nullability nullability = instruction.getReturnNullability();
            PsiMethod targetMethod = instruction.getTargetMethod();
            Mutability mutable = Mutability.UNKNOWN;
            if (targetMethod != null) {
                mutable = Mutability.getMutability((PsiModifierListOwner)targetMethod);
                PsiMethod realMethod = StandardInstructionVisitor.findSpecificMethod(targetMethod, state, qualifierValue);
                if (realMethod != targetMethod) {
                    nullability = DfaPsiUtil.getElementNullability(type2, (PsiModifierListOwner)realMethod);
                    mutable = Mutability.getMutability((PsiModifierListOwner)realMethod);
                    PsiType returnType = realMethod.getReturnType();
                    if (returnType != null && TypeConversionUtil.erasure((PsiType)type2).isAssignableFrom(returnType)) {
                        type2 = returnType;
                    }
                }
                if (nullability == Nullability.UNKNOWN) {
                    nullability = factory.suggestNullabilityForNonAnnotatedMember((PsiModifierListOwner)targetMethod);
                }
            }
            DfaValue dfaValue = value2 = instruction.getContext() instanceof PsiNewExpression ? factory.createExactTypeValue(type2) : factory.createTypeValue(type2, nullability);
            if (!instruction.shouldFlushFields() && instruction.getContext() instanceof PsiNewExpression) {
                value2 = factory.withFact(value2, DfaFactType.LOCALITY, true);
            }
            DfaValue dfaValue2 = factory.withFact(value2, DfaFactType.MUTABILITY, mutable);
            if (dfaValue2 == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(24);
            }
            return dfaValue2;
        }
        LongRangeSet range = LongRangeSet.fromType(type2);
        if (range != null) {
            PsiCall call = instruction.getCallExpression();
            if (call instanceof PsiMethodCallExpression) {
                range = range.intersect(LongRangeSet.fromPsiElement((PsiModifierListOwner)call.resolveMethod()));
            }
            DfaValue dfaValue = factory.getFactValue(DfaFactType.RANGE, range);
            if (dfaValue == null) {
                StandardInstructionVisitor.$$$reportNull$$$0(25);
            }
            return dfaValue;
        }
        DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
        if (dfaUnknownValue == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(26);
        }
        return dfaUnknownValue;
    }

    protected boolean checkNotNullable(DfaMemoryState state, DfaValue value2, @Nullable NullabilityProblemKind.NullabilityProblem<?> problem) {
        boolean notNullable = state.checkNotNullable(value2);
        if (notNullable && !NullabilityProblemKind.passingNullableArgumentToNonAnnotatedParameter.isMyProblem(problem) && !NullabilityProblemKind.assigningNullableValueToNonAnnotatedField.isMyProblem(problem)) {
            DfaValueFactory factory = ((DfaMemoryStateImpl)state).getFactory();
            state.applyCondition(factory.createCondition(value2, DfaRelationValue.RelationType.NE, factory.getConstFactory().getNull()));
        }
        return notNullable;
    }

    @Override
    public DfaInstructionState[] visitCheckNotNull(CheckNotNullInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        NullabilityProblemKind.NullabilityProblem<?> problem = instruction.getProblem();
        if (NullabilityProblemKind.nullableReturn.isMyProblem(problem)) {
            this.checkNotNullable(memState, memState.peek(), problem);
        } else {
            memState.push(this.dereference(memState, memState.pop(), problem));
        }
        return super.visitCheckNotNull(instruction, runner, memState);
    }

    @Override
    public DfaInstructionState[] visitNot(NotInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue dfaValue = memState.pop();
        DfaMemoryState falseState = memState.createCopy();
        DfaValueFactory factory = runner.getFactory();
        ArrayList<DfaInstructionState> result = new ArrayList<DfaInstructionState>(2);
        if (memState.applyCondition(dfaValue.createNegated())) {
            this.pushExpressionResult(factory.getBoolean(true), instruction, memState);
            result.add(new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), memState));
        }
        if (falseState.applyCondition(dfaValue)) {
            this.pushExpressionResult(factory.getBoolean(false), instruction, falseState);
            result.add(new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), falseState));
        }
        return result.toArray(DfaInstructionState.EMPTY_ARRAY);
    }

    @Override
    public DfaInstructionState[] visitBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue dfaRight = memState.pop();
        DfaValue dfaLeft = memState.pop();
        IElementType opSign = instruction.getOperationSign();
        DfaRelationValue.RelationType relationType = DfaRelationValue.RelationType.fromElementType(opSign);
        if (relationType != null) {
            DfaInstructionState[] states = this.handleConstantComparison(instruction, runner, memState, dfaRight, dfaLeft, relationType);
            if (states == null) {
                states = this.handleRelationBinop(instruction, runner, memState, dfaRight, dfaLeft, relationType);
            }
            if (states != null) {
                return states;
            }
        }
        DfaValue result = DfaUnknownValue.getInstance();
        PsiType type2 = instruction.getResultType();
        if (PsiType.INT.equals((Object)type2) || PsiType.LONG.equals((Object)type2)) {
            LongRangeSet resultRange;
            LongRangeSet left = memState.getValueFact(dfaLeft, DfaFactType.RANGE);
            LongRangeSet right = memState.getValueFact(dfaRight, DfaFactType.RANGE);
            if (left != null && right != null && (resultRange = left.binOpFromToken(opSign, right, PsiType.LONG.equals((Object)type2))) != null) {
                result = runner.getFactory().getFactValue(DfaFactType.RANGE, resultRange);
            }
        }
        if (result == DfaUnknownValue.getInstance() && JavaTokenType.PLUS == opSign && TypeUtils.isJavaLangString(type2)) {
            result = runner.getFactory().createTypeValue(type2, Nullability.NOT_NULL);
        }
        this.pushExpressionResult(result, instruction, memState);
        instruction.setTrueReachable();
        instruction.setFalseReachable();
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    @Nullable
    private DfaInstructionState[] handleRelationBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaValue dfaRight, DfaValue dfaLeft, DfaRelationValue.RelationType relationType) {
        DfaValueFactory factory = runner.getFactory();
        if (!(relationType != DfaRelationValue.RelationType.EQ && relationType != DfaRelationValue.RelationType.NE || dfaLeft == dfaRight && !(dfaLeft instanceof DfaBoxedValue) && !(dfaLeft instanceof DfaConstValue) || !StandardInstructionVisitor.isComparedByEquals(instruction.getExpression()) || memState.isNull(dfaLeft) || memState.isNull(dfaRight))) {
            ArrayList<DfaInstructionState> states = new ArrayList<DfaInstructionState>(2);
            DfaMemoryState equality = memState.createCopy();
            if (equality.applyCondition(factory.createCondition(dfaLeft, DfaRelationValue.RelationType.EQ, dfaRight))) {
                states.add(this.makeBooleanResult(instruction, runner, equality, ThreeState.UNSURE));
            }
            if (memState.applyCondition(factory.createCondition(dfaLeft, DfaRelationValue.RelationType.NE, dfaRight))) {
                states.add(this.makeBooleanResult(instruction, runner, memState, ThreeState.fromBoolean((relationType == DfaRelationValue.RelationType.NE ? 1 : 0) != 0)));
            }
            return states.toArray(DfaInstructionState.EMPTY_ARRAY);
        }
        DfaRelationValue.RelationType[] relations = StandardInstructionVisitor.splitRelation(relationType);
        ArrayList<DfaInstructionState> states = new ArrayList<DfaInstructionState>(relations.length);
        for (int i = 0; i < relations.length; ++i) {
            DfaMemoryState copy;
            DfaRelationValue.RelationType relation = relations[i];
            DfaValue condition2 = factory.createCondition(dfaLeft, relation, dfaRight);
            if (condition2 instanceof DfaUnknownValue) {
                return null;
            }
            if (condition2 instanceof DfaConstValue) {
                Object value2 = ((DfaConstValue)condition2).getValue();
                if (Boolean.FALSE.equals(value2)) continue;
                if (Boolean.TRUE.equals(value2)) {
                    return this.makeBooleanResultArray(instruction, runner, memState, relationType.isSubRelation(relation));
                }
            }
            DfaMemoryState dfaMemoryState = copy = i == relations.length - 1 && !states.isEmpty() ? memState : memState.createCopy();
            if (!copy.applyCondition(condition2)) continue;
            boolean isTrue = relationType.isSubRelation(relation);
            states.add(this.makeBooleanResult(instruction, runner, copy, ThreeState.fromBoolean((boolean)isTrue)));
        }
        if (states.isEmpty()) {
            memState.push(factory.getConstFactory().getFalse());
            return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
        }
        return states.toArray(DfaInstructionState.EMPTY_ARRAY);
    }

    private static boolean isComparedByEquals(PsiExpression expression2) {
        if (expression2 instanceof PsiBinaryExpression) {
            PsiExpression left = ((PsiBinaryExpression)expression2).getLOperand();
            PsiExpression right = ((PsiBinaryExpression)expression2).getROperand();
            return right != null && DfaUtil.isComparedByEquals(left.getType()) && DfaUtil.isComparedByEquals(right.getType());
        }
        return false;
    }

    @NotNull
    private static DfaRelationValue.RelationType[] splitRelation(DfaRelationValue.RelationType relationType) {
        switch (relationType) {
            case LT: 
            case LE: 
            case GT: 
            case GE: {
                DfaRelationValue.RelationType[] relationTypeArray = new DfaRelationValue.RelationType[]{DfaRelationValue.RelationType.LT, DfaRelationValue.RelationType.GT, DfaRelationValue.RelationType.EQ};
                if (relationTypeArray == null) {
                    StandardInstructionVisitor.$$$reportNull$$$0(27);
                }
                return relationTypeArray;
            }
        }
        DfaRelationValue.RelationType[] relationTypeArray = new DfaRelationValue.RelationType[]{relationType, relationType.getNegated()};
        if (relationTypeArray == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(28);
        }
        return relationTypeArray;
    }

    @Override
    public DfaInstructionState[] visitInstanceof(InstanceofInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        boolean useful;
        this.myReachable.add(instruction);
        DfaValue dfaRight = memState.pop();
        DfaValue dfaLeft = memState.pop();
        DfaValueFactory factory = runner.getFactory();
        if (!memState.isNotNull(dfaLeft)) {
            this.myCanBeNullInInstanceof.add(instruction);
        }
        boolean unknownTargetType = false;
        DfaValue condition2 = null;
        if (instruction.isClassObjectCheck()) {
            PsiType type2;
            DfaConstValue constant = memState.getConstantValue(dfaRight);
            PsiType psiType = type2 = constant == null ? null : (PsiType)ObjectUtils.tryCast((Object)constant.getValue(), PsiType.class);
            if (type2 == null || type2 instanceof PsiPrimitiveType) {
                DfaConstValue aNull = factory.getConstFactory().getNull();
                condition2 = factory.createCondition(dfaLeft, DfaRelationValue.RelationType.NE, aNull);
                unknownTargetType = true;
            } else {
                dfaRight = factory.createTypeValue(type2, Nullability.NOT_NULL);
            }
        }
        if (condition2 == null) {
            condition2 = factory.createCondition(dfaLeft, DfaRelationValue.RelationType.IS, dfaRight);
        }
        ArrayList<DfaInstructionState> states = new ArrayList<DfaInstructionState>(2);
        if (condition2 instanceof DfaUnknownValue) {
            if (dfaLeft instanceof DfaFactMapValue && dfaRight instanceof DfaFactMapValue) {
                DfaFactMapValue left = (DfaFactMapValue)dfaLeft;
                DfaFactMapValue right = (DfaFactMapValue)dfaRight;
                useful = !right.getFacts().with(DfaFactType.NULLABILITY, null).isSuperStateOf(left.getFacts());
            } else {
                useful = true;
            }
            states.add(this.makeBooleanResult(instruction, runner, memState, ThreeState.UNSURE));
        } else {
            DfaMemoryState trueState = memState.createCopy();
            useful = unknownTargetType;
            if (trueState.applyCondition(condition2)) {
                states.add(this.makeBooleanResult(instruction, runner, trueState, unknownTargetType ? ThreeState.UNSURE : ThreeState.YES));
            }
            if (memState.applyCondition(condition2.createNegated())) {
                if (unknownTargetType) {
                    memState.markEphemeral();
                }
                states.add(this.makeBooleanResult(instruction, runner, memState, ThreeState.NO));
                useful |= !memState.isNull(dfaLeft);
            }
        }
        if (useful) {
            this.myUsefulInstanceofs.add(instruction);
        }
        return states.toArray(DfaInstructionState.EMPTY_ARRAY);
    }

    @Nullable
    private DfaInstructionState[] handleConstantComparison(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaValue dfaRight, DfaValue dfaLeft, DfaRelationValue.RelationType relationType) {
        DfaInstructionState[] result;
        Object value2;
        if (dfaLeft instanceof DfaVariableValue && dfaRight instanceof DfaVariableValue) {
            Number leftValue = StandardInstructionVisitor.getKnownNumberValue(memState, (DfaVariableValue)dfaLeft);
            Number rightValue = StandardInstructionVisitor.getKnownNumberValue(memState, (DfaVariableValue)dfaRight);
            if (leftValue != null && rightValue != null) {
                return this.checkComparisonWithKnownValue(instruction, runner, memState, relationType, leftValue, rightValue);
            }
        }
        if (dfaRight instanceof DfaConstValue && dfaLeft instanceof DfaVariableValue && (value2 = ((DfaConstValue)dfaRight).getValue()) instanceof Number && (result = this.checkComparingWithConstant(instruction, runner, memState, (DfaVariableValue)dfaLeft, relationType, (Number)value2)) != null) {
            return result;
        }
        if (dfaRight instanceof DfaVariableValue && dfaLeft instanceof DfaConstValue) {
            return this.handleConstantComparison(instruction, runner, memState, dfaLeft, dfaRight, relationType.getFlipped());
        }
        if (relationType != DfaRelationValue.RelationType.EQ && relationType != DfaRelationValue.RelationType.NE) {
            return null;
        }
        if (dfaLeft instanceof DfaConstValue && dfaRight instanceof DfaConstValue && !TypeUtils.isJavaLangString(dfaLeft.getType()) && !TypeUtils.isJavaLangString(dfaRight.getType()) || DfaConstValue.isContractFail(dfaLeft) || DfaConstValue.isContractFail(dfaRight)) {
            boolean negated = relationType == DfaRelationValue.RelationType.NE ^ (DfaMemoryStateImpl.isNaN(dfaLeft) || DfaMemoryStateImpl.isNaN(dfaRight));
            boolean result2 = dfaLeft == dfaRight ^ negated;
            return this.makeBooleanResultArray(instruction, runner, memState, result2);
        }
        return null;
    }

    @Nullable
    private DfaInstructionState[] checkComparingWithConstant(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaVariableValue var, DfaRelationValue.RelationType opSign, Number comparedWith) {
        Number knownValue = StandardInstructionVisitor.getKnownNumberValue(memState, var);
        if (knownValue != null) {
            return this.checkComparisonWithKnownValue(instruction, runner, memState, opSign, knownValue, comparedWith);
        }
        return null;
    }

    @Nullable
    private static Number getKnownNumberValue(DfaMemoryState memState, DfaVariableValue var) {
        DfaConstValue knownConstantValue = memState.getConstantValue(var);
        return knownConstantValue != null && knownConstantValue.getValue() instanceof Number ? (Number)((Number)knownConstantValue.getValue()) : (Number)null;
    }

    private DfaInstructionState[] checkComparisonWithKnownValue(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaRelationValue.RelationType opSign, Number leftValue, Number rightValue) {
        boolean hasNaN;
        int cmp = StandardInstructionVisitor.compare(leftValue, rightValue);
        Boolean result = null;
        boolean bl = hasNaN = DfaUtil.isNaN(leftValue) || DfaUtil.isNaN(rightValue);
        if (cmp < 0 || cmp > 0) {
            if (opSign == DfaRelationValue.RelationType.EQ) {
                result = false;
            } else if (opSign == DfaRelationValue.RelationType.NE) {
                result = true;
            }
        }
        if (opSign == DfaRelationValue.RelationType.LT) {
            result = !hasNaN && cmp < 0;
        } else if (opSign == DfaRelationValue.RelationType.GT) {
            result = !hasNaN && cmp > 0;
        } else if (opSign == DfaRelationValue.RelationType.LE) {
            result = !hasNaN && cmp <= 0;
        } else if (opSign == DfaRelationValue.RelationType.GE) {
            result = !hasNaN && cmp >= 0;
        }
        if (result == null) {
            return null;
        }
        return this.makeBooleanResultArray(instruction, runner, memState, result);
    }

    private static int compare(Number a, Number b) {
        long bLong;
        long aLong = a.longValue();
        if (aLong != (bLong = b.longValue())) {
            return aLong > bLong ? 1 : -1;
        }
        return Double.compare(a.doubleValue(), b.doubleValue());
    }

    private DfaInstructionState[] makeBooleanResultArray(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, boolean result) {
        return new DfaInstructionState[]{this.makeBooleanResult(instruction, runner, memState, ThreeState.fromBoolean((boolean)result))};
    }

    private DfaInstructionState makeBooleanResult(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, @NotNull ThreeState result) {
        if (result == null) {
            StandardInstructionVisitor.$$$reportNull$$$0(29);
        }
        DfaUnknownValue value2 = result == ThreeState.UNSURE ? DfaUnknownValue.getInstance() : runner.getFactory().getBoolean(result.toBoolean());
        this.pushExpressionResult(value2, instruction, memState);
        if (result != ThreeState.NO) {
            instruction.setTrueReachable();
        }
        if (result != ThreeState.YES) {
            instruction.setFalseReachable();
        }
        return new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), memState);
    }

    public boolean isInstanceofRedundant(InstanceofInstruction instruction) {
        return !this.myUsefulInstanceofs.contains(instruction) && !instruction.isConditionConst() && this.myReachable.contains(instruction);
    }

    public boolean canBeNull(InstanceofInstruction instruction) {
        return this.myCanBeNullInInstanceof.contains(instruction);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memState";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodReferenceCallArguments";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "handleKnownMethods";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "popCall";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findSpecificMethod";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodResultValue";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "splitRelation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "beforeMethodCall";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reportMutabilityViolation";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findSpecificMethod";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "makeBooleanResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

