/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inliner;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.CFGBuilder;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.inliner.CallInliner;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;

public class CollectionFactoryInliner
implements CallInliner {
    private static final CallMapper<FactoryInfo> STATIC_FACTORIES = new CallMapper<FactoryInfo>().register((CallMatcher)CallMatcher.staticCall("java.util.Collections", "emptyList", "emptySet").parameterCount(0), new FactoryInfo(0, SpecialField.COLLECTION_SIZE)).register((CallMatcher)CallMatcher.staticCall("java.util.Collections", "singletonList", "singleton").parameterCount(1), new FactoryInfo(1, SpecialField.COLLECTION_SIZE)).register((CallMatcher)CallMatcher.staticCall("java.util.Collections", "emptyMap").parameterCount(0), new FactoryInfo(0, SpecialField.MAP_SIZE)).register((CallMatcher)CallMatcher.staticCall("java.util.Collections", "singletonMap").parameterCount(2), new FactoryInfo(1, SpecialField.MAP_SIZE));
    private static final CallMatcher JDK9_MAP_FACTORIES = CallMatcher.staticCall("java.util.Map", "of", "ofEntries");
    private static final CallMatcher JDK9_FACTORIES = CallMatcher.anyOf(CallMatcher.staticCall("java.util.List", "of"), CallMatcher.staticCall("java.util.Set", "of"));
    private static final CallMatcher JDK9_ARRAY_FACTORIES = CallMatcher.anyOf(CallMatcher.staticCall("java.util.List", "of").parameterTypes("E..."), CallMatcher.staticCall("java.util.Set", "of").parameterTypes("E..."));

    private static FactoryInfo getFactoryInfo(@NotNull PsiMethodCallExpression call) {
        FactoryInfo info;
        if (call == null) {
            CollectionFactoryInliner.$$$reportNull$$$0(0);
        }
        if ((info = STATIC_FACTORIES.mapFirst(call)) != null) {
            return info;
        }
        if (JDK9_FACTORIES.test(call)) {
            int size = JDK9_ARRAY_FACTORIES.test(call) && !MethodCallUtils.isVarArgCall(call) ? -1 : call.getArgumentList().getExpressionCount();
            return new FactoryInfo(size, SpecialField.COLLECTION_SIZE, true);
        }
        if (JDK9_MAP_FACTORIES.test(call)) {
            boolean ofEntries = "ofEntries".equals(call.getMethodExpression().getReferenceName());
            int size = ofEntries && !MethodCallUtils.isVarArgCall(call) ? -1 : call.getArgumentList().getExpressionCount() / (ofEntries ? 1 : 2);
            return new FactoryInfo(size, SpecialField.MAP_SIZE, true);
        }
        return null;
    }

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        PsiExpression[] args;
        FactoryInfo factoryInfo;
        if (builder == null) {
            CollectionFactoryInliner.$$$reportNull$$$0(1);
        }
        if (call == null) {
            CollectionFactoryInliner.$$$reportNull$$$0(2);
        }
        if ((factoryInfo = CollectionFactoryInliner.getFactoryInfo(call)) == null) {
            return false;
        }
        for (PsiExpression arg : args = call.getArgumentList().getExpressions()) {
            builder.pushExpression(arg);
            if (factoryInfo.myNotNull) {
                builder.checkNotNull(arg, NullabilityProblemKind.passingNullableToNotNullParameter);
            }
            builder.pop();
        }
        DfaValueFactory factory = builder.getFactory();
        DfaValue result = factory.withFact(factory.createTypeValue(call.getType(), Nullability.NOT_NULL), DfaFactType.MUTABILITY, Mutability.UNMODIFIABLE);
        if (factoryInfo.mySize == -1) {
            builder.push(result, (PsiExpression)call);
        } else {
            DfaVariableValue variableValue = builder.createTempVariable(call.getType());
            builder.pushForWrite(variableValue).push(result, (PsiExpression)call).assign();
            builder.assignAndPop(factoryInfo.mySizeField.createValue(factory, variableValue), factory.getInt(factoryInfo.mySize));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/inliner/CollectionFactoryInliner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFactoryInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "tryInlineCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class FactoryInfo {
        final boolean myNotNull;
        final int mySize;
        final SpecialField mySizeField;

        FactoryInfo(int size, SpecialField sizeField) {
            this(size, sizeField, false);
        }

        FactoryInfo(int size, SpecialField sizeField, boolean notNull) {
            this.mySize = size;
            this.mySizeField = sizeField;
            this.myNotNull = notNull;
        }
    }
}

