/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFix;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.javaDoc.JavadocHighlightUtil;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.FQNameCellRenderer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.javadoc.JavadocManager;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocReferenceInspection
extends LocalInspectionTool {
    private static final String SHORT_NAME = "JavadocReference";
    public boolean REPORT_INACCESSIBLE = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("<html>Report inaccessible symbols<br>(javadoc tool may be unable to create hyperlink)", (InspectionProfileEntry)this, "REPORT_INACCESSIBLE");
    }

    private static LocalQuickFix createAddQualifierFix(PsiJavaCodeReferenceElement reference) {
        List<PsiClass> classesToImport = new ImportClassFix(reference).getClassesToImport();
        return classesToImport.isEmpty() ? null : new AddQualifierFix(classesToImport);
    }

    private static RenameReferenceQuickFix createRenameReferenceQuickFix(Set<String> unboundParams) {
        return new RenameReferenceQuickFix(unboundParams);
    }

    private String getResolveErrorMessage(PsiElement resolved, @NotNull PsiElement context, CharSequence referenceText) {
        if (context == null) {
            JavaDocReferenceInspection.$$$reportNull$$$0(0);
        }
        if (resolved == null) {
            return InspectionsBundle.message((String)"inspection.javadoc.problem.cannot.resolve", (Object[])new Object[]{"<code>" + referenceText + "</code>"});
        }
        if (this.REPORT_INACCESSIBLE && !JavaDocReferenceInspection.isAccessible(resolved, context)) {
            return InspectionsBundle.message((String)"inspection.javadoc.problem.inaccessible", (Object[])new Object[]{"<code>" + referenceText + "</code>"});
        }
        return null;
    }

    private static boolean isAccessible(@NotNull PsiElement resolved, @NotNull PsiElement context) {
        if (resolved == null) {
            JavaDocReferenceInspection.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JavaDocReferenceInspection.$$$reportNull$$$0(2);
        }
        if (!(resolved instanceof PsiMember)) {
            return true;
        }
        if (!PsiResolveHelper.SERVICE.getInstance((Project)resolved.getProject()).isAccessible((PsiMember)resolved, context, null)) {
            return false;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)resolved);
        return file == null || context.getResolveScope().contains(file);
    }

    private void visitRefInDocTag(PsiDocTag tag, JavadocManager manager, PsiElement context, ProblemsHolder holder, boolean isOnTheFly) {
        PsiDocCommentOwner commentOwner;
        PsiReference reference;
        String message2;
        PsiDocTagValue value2 = tag.getValueElement();
        if (value2 == null) {
            return;
        }
        String tagName = tag.getName();
        JavadocTagInfo info = manager.getTagInfo(tagName);
        if (info != null && !info.isValidInContext(context)) {
            return;
        }
        if (info != null && info.isInline() && (message2 = info.checkTagValue(value2)) != null) {
            holder.registerProblem(holder.getManager().createProblemDescriptor((PsiElement)value2, message2, isOnTheFly, null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL));
        }
        if ((reference = value2.getReference()) == null) {
            return;
        }
        PsiElement element = reference.resolve();
        int textOffset = value2.getTextOffset();
        if (textOffset == value2.getTextRange().getEndOffset()) {
            return;
        }
        PsiDocTagValue valueElement = tag.getValueElement();
        if (valueElement == null) {
            return;
        }
        CharSequence paramName = value2.getContainingFile().getViewProvider().getContents().subSequence(textOffset, value2.getTextRange().getEndOffset());
        String message3 = this.getResolveErrorMessage(element, context, paramName);
        if (message3 == null) {
            return;
        }
        ArrayList<Object> fixes = new ArrayList<Object>();
        if (isOnTheFly && "param".equals(tagName) && (commentOwner = (PsiDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)tag, PsiDocCommentOwner.class)) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)commentOwner;
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiDocTag[] tags = tag.getContainingComment().getTags();
            HashSet<String> unboundParams = new HashSet<String>();
            for (PsiParameter parameter2 : parameters2) {
                if (JavadocHighlightUtil.hasTagForParameter(tags, (PsiElement)parameter2)) continue;
                unboundParams.add(parameter2.getName());
            }
            if (!unboundParams.isEmpty()) {
                fixes.add(JavaDocReferenceInspection.createRenameReferenceQuickFix(unboundParams));
            }
        }
        fixes.add(new RemoveTagFix(tagName, paramName));
        holder.registerProblem(holder.getManager().createProblemDescriptor((PsiElement)valueElement, reference.getRangeInElement(), message3, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, isOnTheFly, fixes.toArray(LocalQuickFix.EMPTY_ARRAY)));
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.javadoc.ref.display.name", (Object[])new Object[0]);
        if (string == null) {
            JavaDocReferenceInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.javadoc.issues", (Object[])new Object[0]);
        if (string == null) {
            JavaDocReferenceInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            JavaDocReferenceInspection.$$$reportNull$$$0(5);
        }
        return SHORT_NAME;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            JavaDocReferenceInspection.$$$reportNull$$$0(6);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            JavaDocReferenceInspection.$$$reportNull$$$0(7);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitJavaFile(PsiJavaFile file) {
                if ("package-info.java".equals(file.getName())) {
                    JavaDocReferenceInspection.this.checkComment((PsiDocComment)PsiTreeUtil.getChildOfType((PsiElement)file, PsiDocComment.class), (PsiElement)file, holder, isOnTheFly);
                }
            }

            public void visitModule(PsiJavaModule module) {
                JavaDocReferenceInspection.this.checkComment(module.getDocComment(), (PsiElement)module, holder, isOnTheFly);
            }

            public void visitClass(PsiClass aClass) {
                JavaDocReferenceInspection.this.checkComment(aClass.getDocComment(), (PsiElement)aClass, holder, isOnTheFly);
            }

            public void visitField(PsiField field) {
                JavaDocReferenceInspection.this.checkComment(field.getDocComment(), (PsiElement)field, holder, isOnTheFly);
            }

            public void visitMethod(PsiMethod method) {
                JavaDocReferenceInspection.this.checkComment(method.getDocComment(), (PsiElement)method, holder, isOnTheFly);
            }
        };
        if (javaElementVisitor == null) {
            JavaDocReferenceInspection.$$$reportNull$$$0(8);
        }
        return javaElementVisitor;
    }

    private void checkComment(PsiDocComment comment, final @NotNull PsiElement context, final ProblemsHolder holder, final boolean isOnTheFly) {
        if (context == null) {
            JavaDocReferenceInspection.$$$reportNull$$$0(9);
        }
        if (comment == null) {
            return;
        }
        final JavadocManager javadocManager = JavadocManager.SERVICE.getInstance((Project)holder.getProject());
        comment.accept((PsiElementVisitor)new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                this.visitElement((PsiElement)expression2);
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                JavaResolveResult result = reference.advancedResolve(false);
                PsiElement resolved = result.getElement();
                String message2 = JavaDocReferenceInspection.this.getResolveErrorMessage(resolved, context, reference.getText());
                if (message2 != null && !result.isPackagePrefixPackageReference()) {
                    PsiElement referenceNameElement = reference.getReferenceNameElement();
                    PsiElement element = referenceNameElement != null ? referenceNameElement : reference;
                    LocalQuickFix fix2 = isOnTheFly ? JavaDocReferenceInspection.createAddQualifierFix(reference) : null;
                    holder.registerProblem(holder.getManager().createProblemDescriptor(element, message2, fix2, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, isOnTheFly));
                }
            }

            public void visitDocTag(PsiDocTag tag) {
                super.visitDocTag(tag);
                JavadocTagInfo info = javadocManager.getTagInfo(tag.getName());
                if (info == null || !info.isInline()) {
                    JavaDocReferenceInspection.this.visitRefInDocTag(tag, javadocManager, context, holder, isOnTheFly);
                }
            }

            public void visitInlineDocTag(PsiInlineDocTag tag) {
                super.visitInlineDocTag(tag);
                JavaDocReferenceInspection.this.visitRefInDocTag((PsiDocTag)tag, javadocManager, context, holder, isOnTheFly);
            }

            public void visitElement(PsiElement element) {
                for (PsiElement child : element.getChildren()) {
                    child.accept((PsiElementVisitor)this);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResolveErrorMessage";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoveTagFix
    implements LocalQuickFix {
        private final String myTagName;
        private final CharSequence myParamName;

        RemoveTagFix(String tagName, CharSequence paramName) {
            this.myTagName = tagName;
            this.myParamName = paramName;
        }

        @NotNull
        public String getName() {
            String string = "Remove @" + this.myTagName + " " + this.myParamName;
            if (string == null) {
                RemoveTagFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Remove tag" == null) {
                RemoveTagFix.$$$reportNull$$$0(1);
            }
            return "Remove tag";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiDocTag myTag;
            if (project == null) {
                RemoveTagFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                RemoveTagFix.$$$reportNull$$$0(3);
            }
            if ((myTag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiDocTag.class)) != null) {
                myTag.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$RemoveTagFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$RemoveTagFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AddQualifierFix
    implements LocalQuickFix {
        private final List<? extends PsiClass> originalClasses;

        AddQualifierFix(List<? extends PsiClass> originalClasses) {
            this.originalClasses = originalClasses;
        }

        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("add.qualifier", new Object[0]);
            if (string == null) {
                AddQualifierFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiJavaCodeReferenceElement element;
            if (project == null) {
                AddQualifierFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                AddQualifierFix.$$$reportNull$$$0(2);
            }
            if ((element = (PsiJavaCodeReferenceElement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiJavaCodeReferenceElement.class)) != null) {
                Collections.sort(this.originalClasses, new PsiProximityComparator(element.getElement()));
                DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(dataContext -> {
                    if (project == null) {
                        AddQualifierFix.$$$reportNull$$$0(3);
                    }
                    JBPopupFactory.getInstance().createPopupChooserBuilder(this.originalClasses).setTitle(QuickFixBundle.message("add.qualifier.original.class.chooser.title", new Object[0])).setItemChosenCallback(psiClass -> {
                        if (project == null) {
                            AddQualifierFix.$$$reportNull$$$0(4);
                        }
                        if (!element.isValid()) {
                            return;
                        }
                        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{element.getContainingFile()}).run(() -> {
                            if (project == null) {
                                AddQualifierFix.$$$reportNull$$$0(5);
                            }
                            if (psiClass.isValid()) {
                                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                                element.bindToElement((PsiElement)psiClass);
                            }
                        });
                    }).setRenderer((ListCellRenderer)new FQNameCellRenderer()).createPopup().showInBestPositionFor(dataContext);
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$AddQualifierFix";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$AddQualifierFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$applyFix$2";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$1";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RenameReferenceQuickFix
    implements LocalQuickFix {
        private final Set<String> myUnboundParams;

        RenameReferenceQuickFix(Set<String> unboundParams) {
            this.myUnboundParams = unboundParams;
        }

        @NotNull
        public String getFamilyName() {
            if ("Change to ..." == null) {
                RenameReferenceQuickFix.$$$reportNull$$$0(0);
            }
            return "Change to ...";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                RenameReferenceQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RenameReferenceQuickFix.$$$reportNull$$$0(2);
            }
            DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(dataContext -> {
                if (descriptor == null) {
                    RenameReferenceQuickFix.$$$reportNull$$$0(3);
                }
                if (project == null) {
                    RenameReferenceQuickFix.$$$reportNull$$$0(4);
                }
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                assert (editor != null);
                TextRange textRange = ((ProblemDescriptorBase)descriptor).getTextRange();
                editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
                String word = editor.getSelectionModel().getSelectedText();
                if (word == null || StringUtil.isEmptyOrSpaces((String)word)) {
                    return;
                }
                ArrayList<LookupElementBuilder> items = new ArrayList<LookupElementBuilder>();
                for (String variant : this.myUnboundParams) {
                    items.add(LookupElementBuilder.create((String)variant));
                }
                LookupManager.getInstance((Project)project).showLookup(editor, items.toArray(LookupElement.EMPTY_ARRAY));
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$RenameReferenceQuickFix";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$RenameReferenceQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$applyFix$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

