/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cyclicDependencies;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.ForwardDependenciesBuilder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CyclicDependenciesBuilder {
    private final Project myProject;
    private final AnalysisScope myScope;
    private final Map<String, PsiPackage> myPackages = new HashMap<String, PsiPackage>();
    private Graph<PsiPackage> myGraph;
    private final Map<PsiPackage, Map<PsiPackage, Set<PsiFile>>> myFilesInDependentPackages = new HashMap<PsiPackage, Map<PsiPackage, Set<PsiFile>>>();
    private final Map<PsiPackage, Map<PsiPackage, Set<PsiFile>>> myBackwardFilesInDependentPackages = new HashMap<PsiPackage, Map<PsiPackage, Set<PsiFile>>>();
    private final Map<PsiPackage, Set<PsiPackage>> myPackageDependencies = new HashMap<PsiPackage, Set<PsiPackage>>();
    private HashMap<PsiPackage, Set<List<PsiPackage>>> myCyclicDependencies = new HashMap();
    private int myFileCount;
    private final ForwardDependenciesBuilder myForwardBuilder;
    private String myRootNodeNameInUsageView;

    public CyclicDependenciesBuilder(Project project, AnalysisScope scope) {
        this.myProject = project;
        this.myScope = scope;
        this.myForwardBuilder = new ForwardDependenciesBuilder(this.myProject, this.myScope){

            public String getRootNodeNameInUsageView() {
                return CyclicDependenciesBuilder.this.getRootNodeNameInUsageView();
            }

            public String getInitialUsagesPosition() {
                return AnalysisScopeBundle.message((String)"cyclic.dependencies.usage.view.initial.text", (Object[])new Object[0]);
            }
        };
    }

    public String getRootNodeNameInUsageView() {
        return this.myRootNodeNameInUsageView;
    }

    public void setRootNodeNameInUsageView(String rootNodeNameInUsageView) {
        this.myRootNodeNameInUsageView = rootNodeNameInUsageView;
    }

    public Project getProject() {
        return this.myProject;
    }

    public AnalysisScope getScope() {
        return this.myScope;
    }

    public DependenciesBuilder getForwardBuilder() {
        return this.myForwardBuilder;
    }

    public void analyze() {
        final ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
        this.getScope().accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitFile(PsiFile file) {
                if (file instanceof PsiJavaFile) {
                    PsiPackage aPackage;
                    PsiJavaFile psiJavaFile = (PsiJavaFile)file;
                    if (CyclicDependenciesBuilder.this.getScope().contains((PsiElement)psiJavaFile) && (aPackage = CyclicDependenciesBuilder.this.findPackage(psiJavaFile.getPackageName())) != null) {
                        CyclicDependenciesBuilder.this.myPackages.put(psiJavaFile.getPackageName(), aPackage);
                    }
                    Set<PsiPackage> packs = CyclicDependenciesBuilder.this.getPackageHierarhy(psiJavaFile.getPackageName());
                    ForwardDependenciesBuilder builder = new ForwardDependenciesBuilder(CyclicDependenciesBuilder.this.getProject(), new AnalysisScope((PsiFile)psiJavaFile));
                    builder.setTotalFileCount(CyclicDependenciesBuilder.this.getScope().getFileCount());
                    builder.setInitialFileCount(++CyclicDependenciesBuilder.this.myFileCount);
                    builder.analyze();
                    Set psiFiles = (Set)builder.getDependencies().get(psiJavaFile);
                    if (psiFiles == null) {
                        return;
                    }
                    for (PsiPackage pack : packs) {
                        HashSet<PsiPackage> pack2Packages = (HashSet<PsiPackage>)CyclicDependenciesBuilder.this.myPackageDependencies.get(pack);
                        if (pack2Packages == null) {
                            pack2Packages = new HashSet<PsiPackage>();
                            CyclicDependenciesBuilder.this.myPackageDependencies.put(pack, pack2Packages);
                        }
                        for (PsiFile psiFile : psiFiles) {
                            PsiPackage depPackage;
                            String packageName;
                            if (!(psiFile instanceof PsiJavaFile) || !projectFileIndex.isInSourceContent(psiFile.getVirtualFile()) || !CyclicDependenciesBuilder.this.getScope().contains((PsiElement)psiFile) || (packageName = ((PsiJavaFile)psiFile).getPackageName()).startsWith(pack.getQualifiedName()) || (depPackage = CyclicDependenciesBuilder.this.findPackage(packageName)) == null) continue;
                            pack2Packages.add(depPackage);
                            CyclicDependenciesBuilder.this.constractFilesInDependenciesPackagesMap(pack, depPackage, psiFile, CyclicDependenciesBuilder.this.myFilesInDependentPackages);
                            CyclicDependenciesBuilder.this.constractFilesInDependenciesPackagesMap(depPackage, pack, (PsiFile)psiJavaFile, CyclicDependenciesBuilder.this.myBackwardFilesInDependentPackages);
                            CyclicDependenciesBuilder.this.constractWholeDependenciesMap(psiJavaFile, psiFile);
                        }
                    }
                }
            }
        });
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            if (indicator.isCanceled()) {
                throw new ProcessCanceledException();
            }
            indicator.setText(AnalysisScopeBundle.message((String)"cyclic.dependencies.progress.text", (Object[])new Object[0]));
            indicator.setText2("");
            indicator.setIndeterminate(true);
        }
        this.myCyclicDependencies = this.getCycles(this.myPackages.values());
    }

    private void constractFilesInDependenciesPackagesMap(PsiPackage pack, PsiPackage depPackage, PsiFile file, Map<PsiPackage, Map<PsiPackage, Set<PsiFile>>> filesInDependentPackages) {
        Set<PsiFile> depFiles;
        Map<PsiPackage, Set<PsiFile>> dependentPackages2Files = filesInDependentPackages.get(pack);
        if (dependentPackages2Files == null) {
            dependentPackages2Files = new HashMap<PsiPackage, Set<PsiFile>>();
            filesInDependentPackages.put(pack, dependentPackages2Files);
        }
        if ((depFiles = dependentPackages2Files.get(depPackage)) == null) {
            depFiles = new HashSet<PsiFile>();
            dependentPackages2Files.put(depPackage, depFiles);
        }
        depFiles.add(file);
    }

    private void constractWholeDependenciesMap(PsiJavaFile psiJavaFile, PsiFile psiFile) {
        HashSet<PsiFile> wholeDependencies = (HashSet<PsiFile>)this.myForwardBuilder.getDependencies().get(psiJavaFile);
        if (wholeDependencies == null) {
            wholeDependencies = new HashSet<PsiFile>();
            this.myForwardBuilder.getDependencies().put(psiJavaFile, wholeDependencies);
        }
        wholeDependencies.add(psiFile);
    }

    public Set<PsiFile> getDependentFilesInPackage(PsiPackage pack, PsiPackage depPack) {
        Set<Object> psiFiles = new HashSet<PsiFile>();
        Map<PsiPackage, Set<PsiFile>> map2 = this.myFilesInDependentPackages.get(pack);
        if (map2 != null) {
            psiFiles = map2.get(depPack);
        }
        if (psiFiles == null) {
            psiFiles = new HashSet();
        }
        return psiFiles;
    }

    public Set<PsiFile> getDependentFilesInPackage(PsiPackage firstPack, PsiPackage middlePack, PsiPackage lastPack) {
        Map<PsiPackage, Set<PsiFile>> backwardMap;
        HashSet<PsiFile> result = new HashSet<PsiFile>();
        Map<PsiPackage, Set<PsiFile>> forwardMap = this.myFilesInDependentPackages.get(firstPack);
        if (forwardMap != null && forwardMap.get(middlePack) != null) {
            result.addAll((Collection)forwardMap.get(middlePack));
        }
        if ((backwardMap = this.myBackwardFilesInDependentPackages.get(lastPack)) != null && backwardMap.get(middlePack) != null) {
            result.addAll((Collection<PsiFile>)backwardMap.get(middlePack));
        }
        return result;
    }

    public HashMap<PsiPackage, Set<List<PsiPackage>>> getCyclicDependencies() {
        return this.myCyclicDependencies;
    }

    public HashMap<PsiPackage, Set<List<PsiPackage>>> getCycles(Collection<PsiPackage> packages) {
        if (this.myGraph == null) {
            this.myGraph = this.buildGraph();
        }
        HashMap<PsiPackage, Set<List<PsiPackage>>> result = new HashMap<PsiPackage, Set<List<PsiPackage>>>();
        for (PsiPackage psiPackage : packages) {
            Set<List<PsiPackage>> paths2Pack = result.get(psiPackage);
            if (paths2Pack == null) {
                paths2Pack = new HashSet<List<PsiPackage>>();
                result.put(psiPackage, paths2Pack);
            }
            paths2Pack.addAll(GraphAlgorithms.getInstance().findCycles(this.myGraph, (Object)psiPackage));
        }
        return result;
    }

    public Map<String, PsiPackage> getAllScopePackages() {
        if (this.myPackages.isEmpty()) {
            final PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
            this.getScope().accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitFile(PsiFile file) {
                    if (file instanceof PsiJavaFile) {
                        PsiJavaFile psiJavaFile = (PsiJavaFile)file;
                        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage(psiJavaFile.getPackageName());
                        if (aPackage != null) {
                            CyclicDependenciesBuilder.this.myPackages.put(aPackage.getQualifiedName(), aPackage);
                        }
                    }
                }
            });
        }
        return this.myPackages;
    }

    private Graph<PsiPackage> buildGraph() {
        return GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<PsiPackage>(){

            @NotNull
            public Collection<PsiPackage> getNodes() {
                Collection<PsiPackage> collection = CyclicDependenciesBuilder.this.getAllScopePackages().values();
                if (collection == null) {
                    4.$$$reportNull$$$0(0);
                }
                return collection;
            }

            @NotNull
            public Iterator<PsiPackage> getIn(PsiPackage psiPack) {
                Set psiPackages = (Set)CyclicDependenciesBuilder.this.myPackageDependencies.get(psiPack);
                if (psiPackages == null) {
                    Iterator<PsiPackage> iterator = new HashSet().iterator();
                    if (iterator == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return iterator;
                }
                Iterator<PsiPackage> iterator = psiPackages.iterator();
                if (iterator == null) {
                    4.$$$reportNull$$$0(2);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/cyclicDependencies/CyclicDependenciesBuilder$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }));
    }

    public Set<PsiPackage> getPackageHierarhy(String packageName) {
        PsiPackage aPackage;
        HashSet<PsiPackage> result = new HashSet<PsiPackage>();
        PsiPackage psiPackage = this.findPackage(packageName);
        if (psiPackage != null) {
            result.add(psiPackage);
        } else {
            return result;
        }
        while (psiPackage.getParentPackage() != null && psiPackage.getParentPackage().getQualifiedName().length() != 0 && (aPackage = this.findPackage(psiPackage.getParentPackage().getQualifiedName())) != null) {
            result.add(aPackage);
            psiPackage = psiPackage.getParentPackage();
        }
        return result;
    }

    private PsiPackage findPackage(String packName) {
        PsiPackage psiPackage = this.getAllScopePackages().get(packName);
        return psiPackage;
    }
}

