/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.jarFinder.SourceSearchException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.filter2.Filters;
import org.jdom.xpath.XPathFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SourceSearcher {
    private static final String MAVEN_POM_ENTRY_PREFIX = "META-INF/maven/";

    @NotNull
    protected static List<Element> findElements(@NotNull String expression2, @NotNull Element element) {
        if (expression2 == null) {
            SourceSearcher.$$$reportNull$$$0(0);
        }
        if (element == null) {
            SourceSearcher.$$$reportNull$$$0(1);
        }
        List list = XPathFactory.instance().compile(expression2, Filters.element()).evaluate((Object)element);
        if (list == null) {
            SourceSearcher.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    protected String findSourceJar(@NotNull ProgressIndicator indicator, @NotNull String artifactId, @NotNull String version) throws SourceSearchException {
        if (indicator == null) {
            SourceSearcher.$$$reportNull$$$0(3);
        }
        if (artifactId == null) {
            SourceSearcher.$$$reportNull$$$0(4);
        }
        if (version == null) {
            SourceSearcher.$$$reportNull$$$0(5);
        }
        return null;
    }

    @Nullable
    protected String findSourceJar(@NotNull ProgressIndicator indicator, @NotNull String artifactId, @NotNull String version, @NotNull VirtualFile classesJar) throws SourceSearchException {
        if (indicator == null) {
            SourceSearcher.$$$reportNull$$$0(6);
        }
        if (artifactId == null) {
            SourceSearcher.$$$reportNull$$$0(7);
        }
        if (version == null) {
            SourceSearcher.$$$reportNull$$$0(8);
        }
        if (classesJar == null) {
            SourceSearcher.$$$reportNull$$$0(9);
        }
        return this.findSourceJar(indicator, artifactId, version);
    }

    @NotNull
    protected static Element readElementCancelable(final ProgressIndicator indicator, String url) throws IOException {
        Element element = (Element)HttpRequests.request((String)url).accept("application/xml").connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Element>(){

            public Element process(@NotNull HttpRequests.Request request) throws IOException {
                if (request == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    return JDOMUtil.load((Reader)request.getReader(indicator));
                }
                catch (JDOMException e) {
                    throw new IOException(e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/jarFinder/SourceSearcher$1", "process"));
            }
        });
        if (element == null) {
            SourceSearcher.$$$reportNull$$$0(10);
        }
        return element;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected static String findMavenGroupId(@NotNull VirtualFile classesJar, String artifactId) {
        if (classesJar == null) {
            SourceSearcher.$$$reportNull$$$0(11);
        }
        try (JarFile jarFile = new JarFile(VfsUtilCore.virtualToIoFile((VirtualFile)classesJar));){
            JarEntry entry;
            String name;
            Enumeration<JarEntry> entries = jarFile.entries();
            do {
                if (!entries.hasMoreElements()) return null;
            } while (!StringUtil.startsWith((CharSequence)(name = (entry = entries.nextElement()).getName()), (CharSequence)MAVEN_POM_ENTRY_PREFIX) || !StringUtil.endsWith((CharSequence)name, (CharSequence)("/" + artifactId + "/pom.xml")));
            int index = name.indexOf(47, MAVEN_POM_ENTRY_PREFIX.length());
            String string = index != -1 ? name.substring(MAVEN_POM_ENTRY_PREFIX.length(), index) : null;
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarFinder/SourceSearcher";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesJar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarFinder/SourceSearcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findElements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "readElementCancelable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElements";
                break;
            }
            case 2: 
            case 10: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findSourceJar";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findMavenGroupId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

