/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ex;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.rt.compiler.JavacRunner;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.ReflectionUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSdkUtil {
    private static final String IDEA_PREPEND_RT_JAR = "idea.prepend.rtjar";

    public static void addRtJar(PathsList pathsList) {
        String ideaRtJarPath = JavaSdkUtil.getIdeaRtJarPath();
        if (Boolean.getBoolean(IDEA_PREPEND_RT_JAR)) {
            pathsList.addFirst(ideaRtJarPath);
        } else {
            pathsList.addTail(ideaRtJarPath);
        }
    }

    public static String getJunit4JarPath() {
        return PathUtil.getJarPathForClass((Class)ReflectionUtil.forName((String)"org.junit.Test"));
    }

    public static String getJunit3JarPath() {
        return PathUtil.getJarPathForClass((Class)ReflectionUtil.forName((String)"junit.runner.TestSuiteLoader"));
    }

    public static String getIdeaRtJarPath() {
        return PathUtil.getJarPathForClass(JavacRunner.class);
    }

    @NotNull
    public static List<String> getJUnit4JarPaths() {
        List<String> list = Arrays.asList(JavaSdkUtil.getJunit4JarPath(), PathUtil.getJarPathForClass((Class)ReflectionUtil.forName((String)"org.hamcrest.Matcher")));
        if (list == null) {
            JavaSdkUtil.$$$reportNull$$$0(0);
        }
        return list;
    }

    public static boolean isLanguageLevelAcceptable(@NotNull Project project, @NotNull Module module, @NotNull LanguageLevel level) {
        if (project == null) {
            JavaSdkUtil.$$$reportNull$$$0(1);
        }
        if (module == null) {
            JavaSdkUtil.$$$reportNull$$$0(2);
        }
        if (level == null) {
            JavaSdkUtil.$$$reportNull$$$0(3);
        }
        return JavaSdkUtil.isJdkSupportsLevel(JavaSdkUtil.getRelevantJdk(project, module), level);
    }

    private static boolean isJdkSupportsLevel(@Nullable Sdk jdk, @NotNull LanguageLevel level) {
        if (level == null) {
            JavaSdkUtil.$$$reportNull$$$0(4);
        }
        if (jdk == null) {
            return true;
        }
        JavaSdkVersion version = JavaSdkVersionUtil.getJavaSdkVersion((Sdk)jdk);
        JavaSdkVersion required = JavaSdkVersion.fromLanguageLevel((LanguageLevel)level);
        return version != null && (level.isPreview() ? version.equals((Object)required) : version.isAtLeast(required));
    }

    @Nullable
    private static Sdk getRelevantJdk(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            JavaSdkUtil.$$$reportNull$$$0(5);
        }
        if (module == null) {
            JavaSdkUtil.$$$reportNull$$$0(6);
        }
        Sdk projectJdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        Sdk moduleJdk = ModuleRootManager.getInstance((Module)module).getSdk();
        return moduleJdk == null ? projectJdk : moduleJdk;
    }

    @Contract(value="null, _ -> false")
    public static boolean isJdkAtLeast(@Nullable Sdk jdk, @NotNull JavaSdkVersion expected) {
        if (expected == null) {
            JavaSdkUtil.$$$reportNull$$$0(7);
        }
        return JavaSdkVersionUtil.isAtLeast((Sdk)jdk, (JavaSdkVersion)expected);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/ex/JavaSdkUtil";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getJUnit4JarPaths";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/ex/JavaSdkUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageLevelAcceptable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isJdkSupportsLevel";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRelevantJdk";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isJdkAtLeast";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

