/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.BitUtil;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;

public final class ModifierFlags {
    public static final int PUBLIC_MASK = 1;
    public static final int PRIVATE_MASK = 2;
    public static final int PROTECTED_MASK = 4;
    public static final int STATIC_MASK = 8;
    public static final int FINAL_MASK = 16;
    public static final int SYNCHRONIZED_MASK = 32;
    public static final int VOLATILE_MASK = 64;
    public static final int TRANSIENT_MASK = 128;
    public static final int NATIVE_MASK = 256;
    public static final int DEFAULT_MASK = 512;
    public static final int ABSTRACT_MASK = 1024;
    public static final int STRICTFP_MASK = 2048;
    public static final int PACKAGE_LOCAL_MASK = 4096;
    public static final int OPEN_MASK = 8192;
    public static final int TRANSITIVE_MASK = 16384;
    public static final TObjectIntHashMap<String> NAME_TO_MODIFIER_FLAG_MAP = new TObjectIntHashMap();
    public static final TIntObjectHashMap<String> MODIFIER_FLAG_TO_NAME_MAP = new TIntObjectHashMap();
    public static final TObjectIntHashMap<IElementType> KEYWORD_TO_MODIFIER_FLAG_MAP = new TObjectIntHashMap();

    public static boolean hasModifierProperty(String name, int mask) {
        int flag = NAME_TO_MODIFIER_FLAG_MAP.get((Object)name);
        assert (flag != 0) : name;
        return BitUtil.isSet((int)mask, (int)flag);
    }

    static {
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"public", 1);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"private", 2);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"protected", 4);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"static", 8);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"final", 16);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"synchronized", 32);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"volatile", 64);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"transient", 128);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"native", 256);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"default", 512);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"abstract", 1024);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"strictfp", 2048);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"packageLocal", 4096);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"open", 8192);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"transitive", 16384);
        for (Object name : NAME_TO_MODIFIER_FLAG_MAP.keys()) {
            MODIFIER_FLAG_TO_NAME_MAP.put(NAME_TO_MODIFIER_FLAG_MAP.get((Object)((String)name)), (Object)((String)name));
        }
        KEYWORD_TO_MODIFIER_FLAG_MAP.put((Object)JavaTokenType.PUBLIC_KEYWORD, 1);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put((Object)JavaTokenType.PRIVATE_KEYWORD, 2);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put((Object)JavaTokenType.PROTECTED_KEYWORD, 4);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put((Object)JavaTokenType.STATIC_KEYWORD, 8);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put((Object)JavaTokenType.FINAL_KEYWORD, 16);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put((Object)JavaTokenType.SYNCHRONIZED_KEYWORD, 32);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put((Object)JavaTokenType.VOLATILE_KEYWORD, 64);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put((Object)JavaTokenType.TRANSIENT_KEYWORD, 128);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put((Object)JavaTokenType.NATIVE_KEYWORD, 256);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put((Object)JavaTokenType.DEFAULT_KEYWORD, 512);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put((Object)JavaTokenType.ABSTRACT_KEYWORD, 1024);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put((Object)JavaTokenType.STRICTFP_KEYWORD, 2048);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put((Object)JavaTokenType.OPEN_KEYWORD, 8192);
        KEYWORD_TO_MODIFIER_FLAG_MAP.put((Object)JavaTokenType.TRANSITIVE_KEYWORD, 16384);
    }
}

