/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiClassStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.PsiAnonymousClassImpl;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.impl.source.PsiEnumConstantInitializerImpl;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.java.AnonymousClassElement;
import com.intellij.psi.impl.source.tree.java.EnumConstantInitializerElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class JavaClassElementType
extends JavaStubElementType<PsiClassStub, PsiClass> {
    JavaClassElementType(@NotNull String id) {
        if (id == null) {
            JavaClassElementType.$$$reportNull$$$0(0);
        }
        super(id);
    }

    public PsiClass createPsi(@NotNull PsiClassStub stub) {
        if (stub == null) {
            JavaClassElementType.$$$reportNull$$$0(1);
        }
        return this.getPsiFactory(stub).createClass(stub);
    }

    @Override
    public PsiClass createPsi(@NotNull ASTNode node) {
        if (node == null) {
            JavaClassElementType.$$$reportNull$$$0(2);
        }
        if (node instanceof EnumConstantInitializerElement) {
            return new PsiEnumConstantInitializerImpl(node);
        }
        if (node instanceof AnonymousClassElement) {
            return new PsiAnonymousClassImpl(node);
        }
        return new PsiClassImpl(node);
    }

    @NotNull
    public PsiClassStub createStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement parentStub) {
        LighterASTNode parent;
        if (tree == null) {
            JavaClassElementType.$$$reportNull$$$0(3);
        }
        if (node == null) {
            JavaClassElementType.$$$reportNull$$$0(4);
        }
        if (parentStub == null) {
            JavaClassElementType.$$$reportNull$$$0(5);
        }
        boolean isDeprecatedByComment = false;
        boolean isInterface = false;
        boolean isEnum = false;
        boolean isEnumConst = false;
        boolean isAnonymous = false;
        boolean isAnnotation = false;
        boolean isInQualifiedNew = false;
        boolean hasDeprecatedAnnotation = false;
        String qualifiedName = null;
        String name = null;
        String baseRef = null;
        if (node.getTokenType() == JavaElementType.ANONYMOUS_CLASS) {
            isAnonymous = true;
        } else if (node.getTokenType() == JavaElementType.ENUM_CONSTANT_INITIALIZER) {
            isEnumConst = true;
            isAnonymous = true;
            baseRef = ((PsiClassStub)parentStub.getParentStub()).getName();
        }
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type2 = child.getTokenType();
            if (type2 == JavaDocElementType.DOC_COMMENT) {
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment(tree, child);
                continue;
            }
            if (type2 == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation(tree, child);
                continue;
            }
            if (type2 == JavaTokenType.AT) {
                isAnnotation = true;
                continue;
            }
            if (type2 == JavaTokenType.INTERFACE_KEYWORD) {
                isInterface = true;
                continue;
            }
            if (type2 == JavaTokenType.ENUM_KEYWORD) {
                isEnum = true;
                continue;
            }
            if (!isAnonymous && type2 == JavaTokenType.IDENTIFIER) {
                name = RecordUtil.intern(tree.getCharTable(), child);
                continue;
            }
            if (!isAnonymous || isEnumConst || type2 != JavaElementType.JAVA_CODE_REFERENCE) continue;
            baseRef = LightTreeUtil.toFilteredString((LighterAST)tree, (LighterASTNode)child, null);
        }
        if (name != null) {
            if (parentStub instanceof PsiJavaFileStub) {
                String pkg = ((PsiJavaFileStub)parentStub).getPackageName();
                qualifiedName = !pkg.isEmpty() ? pkg + '.' + name : name;
            } else if (parentStub instanceof PsiClassStub) {
                String parentFqn = ((PsiClassStub)parentStub).getQualifiedName();
                String string = qualifiedName = parentFqn != null ? parentFqn + '.' + name : null;
            }
        }
        if (isAnonymous && (parent = tree.getParent(node)) != null && parent.getTokenType() == JavaElementType.NEW_EXPRESSION) {
            isInQualifiedNew = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)parent, (IElementType)JavaTokenType.DOT) != null;
        }
        short flags = PsiClassStubImpl.packFlags(isDeprecatedByComment, isInterface, isEnum, isEnumConst, isAnonymous, isAnnotation, isInQualifiedNew, hasDeprecatedAnnotation, false, false);
        JavaClassElementType type3 = JavaClassElementType.typeForClass(isAnonymous, isEnumConst);
        PsiClassStubImpl psiClassStubImpl = new PsiClassStubImpl(type3, parentStub, qualifiedName, name, baseRef, flags);
        if (psiClassStubImpl == null) {
            JavaClassElementType.$$$reportNull$$$0(6);
        }
        return psiClassStubImpl;
    }

    @NotNull
    private static JavaClassElementType typeForClass(boolean anonymous, boolean enumConst) {
        JavaClassElementType javaClassElementType = enumConst ? JavaStubElementTypes.ENUM_CONSTANT_INITIALIZER : (anonymous ? JavaStubElementTypes.ANONYMOUS_CLASS : JavaStubElementTypes.CLASS);
        if (javaClassElementType == null) {
            JavaClassElementType.$$$reportNull$$$0(7);
        }
        return javaClassElementType;
    }

    public void serialize(@NotNull PsiClassStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            JavaClassElementType.$$$reportNull$$$0(8);
        }
        if (dataStream == null) {
            JavaClassElementType.$$$reportNull$$$0(9);
        }
        dataStream.writeShort((int)((PsiClassStubImpl)stub).getFlags());
        if (!stub.isAnonymous()) {
            dataStream.writeName(stub.getName());
            dataStream.writeName(stub.getQualifiedName());
            dataStream.writeName(stub.getSourceFileName());
        } else {
            dataStream.writeName(stub.getBaseClassReferenceText());
        }
    }

    @NotNull
    public PsiClassStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            JavaClassElementType.$$$reportNull$$$0(10);
        }
        short flags = dataStream.readShort();
        boolean isAnonymous = PsiClassStubImpl.isAnonymous(flags);
        boolean isEnumConst = PsiClassStubImpl.isEnumConstInitializer(flags);
        JavaClassElementType type2 = JavaClassElementType.typeForClass(isAnonymous, isEnumConst);
        if (!isAnonymous) {
            String name = dataStream.readNameString();
            String qname = dataStream.readNameString();
            String sourceFileName = dataStream.readNameString();
            PsiClassStubImpl classStub = new PsiClassStubImpl(type2, parentStub, qname, name, null, flags);
            classStub.setSourceFileName(sourceFileName);
            PsiClassStubImpl psiClassStubImpl = classStub;
            if (psiClassStubImpl == null) {
                JavaClassElementType.$$$reportNull$$$0(11);
            }
            return psiClassStubImpl;
        }
        String baseRef = dataStream.readNameString();
        PsiClassStubImpl psiClassStubImpl = new PsiClassStubImpl(type2, parentStub, null, null, baseRef, flags);
        if (psiClassStubImpl == null) {
            JavaClassElementType.$$$reportNull$$$0(12);
        }
        return psiClassStubImpl;
    }

    public void indexStub(@NotNull PsiClassStub stub, @NotNull IndexSink sink) {
        boolean isAnonymous;
        if (stub == null) {
            JavaClassElementType.$$$reportNull$$$0(13);
        }
        if (sink == null) {
            JavaClassElementType.$$$reportNull$$$0(14);
        }
        if (isAnonymous = stub.isAnonymous()) {
            String baseRef = stub.getBaseClassReferenceText();
            if (baseRef != null) {
                sink.occurrence(JavaStubIndexKeys.ANONYMOUS_BASEREF, (Object)PsiNameHelper.getShortClassName((String)baseRef));
            }
        } else {
            String fqn;
            String shortName = stub.getName();
            if (!(shortName == null || stub instanceof PsiClassStubImpl && ((PsiClassStubImpl)stub).isAnonymousInner())) {
                sink.occurrence(JavaStubIndexKeys.CLASS_SHORT_NAMES, (Object)shortName);
            }
            if ((fqn = stub.getQualifiedName()) != null) {
                sink.occurrence(JavaStubIndexKeys.CLASS_FQN, (Object)fqn.hashCode());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/JavaClassElementType";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/JavaClassElementType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "typeForClass";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

