/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.searches.AnnotatedPackagesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class AnnotatedPackagesSearcher
implements QueryExecutor<PsiPackage, AnnotatedPackagesSearch.Parameters> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.AnnotatedPackagesSearcher");

    public boolean execute(@NotNull AnnotatedPackagesSearch.Parameters p, @NotNull Processor<? super PsiPackage> consumer) {
        if (p == null) {
            AnnotatedPackagesSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            AnnotatedPackagesSearcher.$$$reportNull$$$0(1);
        }
        PsiClass annClass = p.getAnnotationClass();
        assert (annClass.isAnnotationType()) : "Annotation type should be passed to annotated packages search";
        String annotationFQN = (String)ReadAction.compute(() -> annClass.getQualifiedName());
        assert (annotationFQN != null);
        PsiManager psiManager = (PsiManager)ReadAction.compute(() -> annClass.getManager());
        GlobalSearchScope useScope = (GlobalSearchScope)p.getScope();
        String annotationShortName = (String)ReadAction.compute(() -> annClass.getName());
        assert (annotationShortName != null);
        Collection<PsiAnnotation> annotations2 = JavaAnnotationIndex.getInstance().get(annotationShortName, psiManager.getProject(), useScope);
        for (PsiAnnotation annotation : annotations2) {
            boolean accepted = (Boolean)ReadAction.compute(() -> {
                PsiClass candidate;
                PsiModifierList modList;
                PsiElement owner;
                if (consumer == null) {
                    AnnotatedPackagesSearcher.$$$reportNull$$$0(3);
                }
                if ((owner = (modList = (PsiModifierList)annotation.getParent()).getParent()) instanceof PsiClass && "package-info".equals((candidate = (PsiClass)owner).getName())) {
                    String qname;
                    LOG.assertTrue(candidate.isValid());
                    PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
                    if (ref != null && psiManager.areElementsEquivalent(ref.resolve(), (PsiElement)annClass) && useScope.contains(candidate.getContainingFile().getVirtualFile()) && (qname = candidate.getQualifiedName()) != null && !consumer.process((Object)JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage(qname.substring(0, qname.lastIndexOf(46))))) {
                        return false;
                    }
                }
                return true;
            });
            if (accepted) continue;
            return false;
        }
        PsiSearchHelper helper = PsiSearchHelper.getInstance((Project)psiManager.getProject());
        PackageInfoFilesOnly infoFilesFilter = new PackageInfoFilesOnly();
        GlobalSearchScope infoFiles = useScope.intersectWith((GlobalSearchScope)infoFilesFilter);
        boolean[] wantMore = new boolean[]{true};
        helper.processAllFilesWithWord(annotationShortName, infoFiles, psiFile -> {
            PsiPackageStatement stmt;
            if (consumer == null) {
                AnnotatedPackagesSearcher.$$$reportNull$$$0(2);
            }
            if ((stmt = (PsiPackageStatement)PsiTreeUtil.getChildOfType((PsiElement)psiFile, PsiPackageStatement.class)) == null) {
                return true;
            }
            PsiModifierList annotations1 = stmt.getAnnotationList();
            if (annotations1 == null) {
                return true;
            }
            PsiAnnotation ann = annotations1.findAnnotation(annotationFQN);
            if (ann == null) {
                return true;
            }
            PsiJavaCodeReferenceElement ref = ann.getNameReferenceElement();
            if (ref == null) {
                return true;
            }
            if (!psiManager.areElementsEquivalent(ref.resolve(), (PsiElement)annClass)) {
                return true;
            }
            wantMore[0] = consumer.process((Object)JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage(stmt.getPackageName()));
            return wantMore[0];
        }, true);
        return wantMore[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/search/AnnotatedPackagesSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$execute$4";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$execute$3";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PackageInfoFilesOnly
    extends GlobalSearchScope {
        private PackageInfoFilesOnly() {
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                PackageInfoFilesOnly.$$$reportNull$$$0(0);
            }
            return "package-info.java".equals(file.getName());
        }

        public boolean isSearchInLibraries() {
            return false;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                PackageInfoFilesOnly.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/search/AnnotatedPackagesSearcher$PackageInfoFilesOnly";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchInModuleContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

