/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDParamListOwnerComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDTag;
import com.intellij.psi.impl.source.codeStyle.javadoc.TagDescription;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDMethodComment
extends JDParamListOwnerComment {
    private String myReturnTag;
    private List<TagDescription> myThrowsList;

    public JDMethodComment(@NotNull CommentFormatter formatter) {
        if (formatter == null) {
            JDMethodComment.$$$reportNull$$$0(0);
        }
        super(formatter);
    }

    @Override
    protected void generateSpecial(@NotNull String prefix, @NotNull StringBuilder sb) {
        JDTag tag;
        if (prefix == null) {
            JDMethodComment.$$$reportNull$$$0(1);
        }
        if (sb == null) {
            JDMethodComment.$$$reportNull$$$0(2);
        }
        super.generateSpecial(prefix, sb);
        if (this.myReturnTag != null && (this.myFormatter.getSettings().JD_KEEP_EMPTY_RETURN || !this.myReturnTag.trim().isEmpty())) {
            tag = JDTag.RETURN;
            sb.append((CharSequence)this.myFormatter.getParser().formatJDTagDescription(this.myReturnTag, prefix + tag.getWithEndWhitespace(), prefix + this.javadocContinuationIndent()));
            if (this.myFormatter.getSettings().JD_ADD_BLANK_AFTER_RETURN) {
                sb.append(prefix);
                sb.append('\n');
            }
        }
        if (this.myThrowsList != null) {
            tag = this.myFormatter.getSettings().JD_USE_THROWS_NOT_EXCEPTION ? JDTag.THROWS : JDTag.EXCEPTION;
            this.generateList(prefix, sb, this.myThrowsList, tag.getWithEndWhitespace(), this.myFormatter.getSettings().JD_ALIGN_EXCEPTION_COMMENTS, this.myFormatter.getSettings().JD_KEEP_EMPTY_EXCEPTION, this.myFormatter.getSettings().JD_PARAM_DESCRIPTION_ON_NEW_LINE);
        }
    }

    public void setReturnTag(@NotNull String returnTag) {
        if (returnTag == null) {
            JDMethodComment.$$$reportNull$$$0(3);
        }
        this.myReturnTag = returnTag;
    }

    public void addThrow(@NotNull String className, @Nullable String description) {
        if (className == null) {
            JDMethodComment.$$$reportNull$$$0(4);
        }
        if (this.myThrowsList == null) {
            this.myThrowsList = ContainerUtilRt.newArrayList();
        }
        this.myThrowsList.add(new TagDescription(className, description));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnTag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/javadoc/JDMethodComment";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "generateSpecial";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setReturnTag";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addThrow";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

