/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsiReflectionAccessUtil {
    PsiReflectionAccessUtil() {
    }

    public static boolean isAccessibleMember(@NotNull PsiMember classMember) {
        if (classMember == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(0);
        }
        return classMember.hasModifierProperty("public") && PsiReflectionAccessUtil.isAccessible(classMember.getContainingClass());
    }

    @Contract(value="null -> false")
    public static boolean isAccessible(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        if (PsiReflectionAccessUtil.isArrayClass(psiClass)) {
            return true;
        }
        while (psiClass != null) {
            if (!psiClass.hasModifierProperty("public")) {
                return false;
            }
            psiClass = psiClass.getContainingClass();
        }
        return true;
    }

    @Nullable
    public static String extractQualifier(@NotNull PsiReferenceExpression referenceExpression) {
        PsiExpression qualifierExpression2;
        if (referenceExpression == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(1);
        }
        PsiType expressionType = (qualifierExpression2 = referenceExpression.getQualifierExpression()) != null ? qualifierExpression2.getType() : null;
        return expressionType == null ? null : qualifierExpression2.getText();
    }

    @Contract(value="null -> true")
    public static boolean isQualifierAccessible(@Nullable PsiExpression qualifierExpression2) {
        if (qualifierExpression2 == null) {
            return true;
        }
        PsiType type2 = qualifierExpression2.getType();
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
        return psiClass == null || PsiReflectionAccessUtil.isAccessible(psiClass);
    }

    @Nullable
    public static String getAccessibleReturnType(@NotNull PsiExpression expression2, @Nullable PsiType type2) {
        String expectedType;
        if (expression2 == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(2);
        }
        if ((expectedType = PsiReflectionAccessUtil.tryGetWeakestAccessibleExpectedType(expression2)) != null) {
            return expectedType;
        }
        PsiType nearestAccessibleBaseType = PsiReflectionAccessUtil.nearestAccessedType(type2);
        if (nearestAccessibleBaseType != null) {
            return nearestAccessibleBaseType.getCanonicalText();
        }
        return PsiReflectionAccessUtil.nearestAccessibleBaseClass(PsiTypesUtil.getPsiClass((PsiType)type2));
    }

    @Nullable
    public static String getAccessibleReturnType(@NotNull PsiExpression expression2, @Nullable PsiClass psiClass) {
        String expectedType;
        if (expression2 == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(3);
        }
        if ((expectedType = PsiReflectionAccessUtil.tryGetWeakestAccessibleExpectedType(expression2)) != null) {
            return expectedType;
        }
        return PsiReflectionAccessUtil.nearestAccessibleBaseClass(psiClass);
    }

    @Nullable
    private static String tryGetWeakestAccessibleExpectedType(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(4);
        }
        PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression2, true);
        PsiType realType = expression2.getType();
        if (expectedType != null && realType != null) {
            for (PsiType type2 : PsiReflectionAccessUtil.getAllAssignableSupertypes(realType, expectedType)) {
                if (!PsiReflectionAccessUtil.isAccessible(type2)) continue;
                return type2.getCanonicalText();
            }
        }
        return null;
    }

    @NotNull
    private static List<PsiType> getAllAssignableSupertypes(@NotNull PsiType from, @NotNull PsiType to) {
        if (from == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(5);
        }
        if (to == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(6);
        }
        LinkedHashSet<PsiType> types = new LinkedHashSet<PsiType>();
        LinkedList<PsiType> queue = new LinkedList<PsiType>();
        queue.offer(from);
        while (!queue.isEmpty()) {
            PsiType type2 = (PsiType)queue.poll();
            if (!to.isAssignableFrom(type2)) continue;
            types.add(type2);
            Arrays.stream(type2.getSuperTypes()).forEach(queue::offer);
        }
        ArrayList<PsiType> result = new ArrayList<PsiType>(types);
        Collections.reverse(result);
        ArrayList<PsiType> arrayList = result;
        if (arrayList == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static String classForName(@NotNull String typeName) {
        if (typeName == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(8);
        }
        String string = TypeConversionUtil.isPrimitive((String)typeName) ? typeName + ".class" : "java.lang.Class.forName(\"" + typeName + "\")";
        if (string == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String getUniqueMethodName(@NotNull PsiClass psiClass, @NotNull String prefix) {
        String name;
        if (psiClass == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(10);
        }
        if (prefix == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(11);
        }
        if (!StringUtil.isJavaIdentifier((String)prefix)) {
            throw new IllegalArgumentException("prefix must be a correct java identifier: " + prefix);
        }
        int i = 1;
        do {
            name = prefix + i;
            ++i;
        } while (psiClass.findMethodsByName(name, false).length != 0);
        String string = name;
        if (string == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static boolean isAccessible(@NotNull PsiType type2) {
        if (type2 == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(13);
        }
        return TypeConversionUtil.isPrimitiveAndNotNull((PsiType)type2) || PsiReflectionAccessUtil.isAccessible(PsiTypesUtil.getPsiClass((PsiType)type2));
    }

    @Nullable
    private static PsiType nearestAccessedType(@Nullable PsiType type2) {
        while (type2 != null && !PsiReflectionAccessUtil.isAccessible(type2)) {
            type2 = (PsiType)ArrayUtil.getFirstElement((Object[])type2.getSuperTypes());
        }
        return type2;
    }

    @Contract(value="null -> null")
    @Nullable
    private static String nearestAccessibleBaseClass(@Nullable PsiClass psiClass) {
        while (psiClass != null && !psiClass.hasModifierProperty("public")) {
            psiClass = psiClass.getSuperClass();
        }
        return psiClass == null ? null : psiClass.getQualifiedName();
    }

    private static boolean isArrayClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(14);
        }
        Project project = psiClass.getProject();
        PsiClass arrayClass = JavaPsiFacade.getElementFactory((Project)project).getArrayClass(PsiUtil.getLanguageLevel((PsiElement)psiClass));
        return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)psiClass, (PsiElement)arrayClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMember";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethodObject/reflect/PsiReflectionAccessUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/PsiReflectionAccessUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAssignableSupertypes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "classForName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleMember";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractQualifier";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAccessibleReturnType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryGetWeakestAccessibleExpectedType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllAssignableSupertypes";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "classForName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueMethodName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isArrayClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

