/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.refactoring.RefactoringBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.Nullable;

public class YesNoPreviewUsagesDialog
extends DialogWrapper {
    private JCheckBox myCbPreviewResults;
    private final boolean myToPreviewUsages;
    private final String myMessage;
    private final String myHelpID;

    public YesNoPreviewUsagesDialog(String title, String message2, boolean previewUsages, String helpID, Project project) {
        super(project, false);
        this.myHelpID = helpID;
        this.setTitle(title);
        this.myMessage = message2;
        this.myToPreviewUsages = previewUsages;
        this.setOKButtonText(RefactoringBundle.message((String)"yes.button"));
        this.setCancelButtonText(RefactoringBundle.message((String)"no.button"));
        this.setButtonsAlignment(0);
        this.init();
    }

    protected JComponent createNorthPanel() {
        JLabel label = new JLabel(this.myMessage);
        label.setUI((LabelUI)new MultiLineLabelUI());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)label, "Center");
        Icon icon = Messages.getQuestionIcon();
        label.setIcon(icon);
        label.setIconTextGap(7);
        return panel;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    public boolean isPreviewUsages() {
        return this.myCbPreviewResults.isSelected();
    }

    protected JComponent createSouthPanel() {
        this.myCbPreviewResults = new JCheckBox();
        this.myCbPreviewResults.setSelected(this.myToPreviewUsages);
        this.myCbPreviewResults.setText(RefactoringBundle.message((String)"preview.usages.to.be.changed"));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)super.createSouthPanel(), "Center");
        panel.add((Component)this.myCbPreviewResults, "West");
        return panel;
    }

    @Nullable
    protected String getHelpId() {
        return this.myHelpID;
    }
}

