/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeClassFinalFix;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassWithOnlyPrivateConstructorsInspection
extends BaseInspection {
    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MakeClassFinalFix((PsiClass)infos[0]);
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.with.only.private.constructors.display.name", new Object[0]);
        if (string == null) {
            ClassWithOnlyPrivateConstructorsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.with.only.private.constructors.problem.descriptor", new Object[0]);
        if (string == null) {
            ClassWithOnlyPrivateConstructorsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassWithOnlyPrivateConstructorsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classlayout/ClassWithOnlyPrivateConstructorsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ClassWithOnlyPrivateConstructorsVisitor
    extends BaseInspectionVisitor {
        private ClassWithOnlyPrivateConstructorsVisitor() {
        }

        public void visitClass(PsiClass aClass) {
            super.visitClass(aClass);
            if (aClass.isEnum() || aClass.hasModifierProperty("final")) {
                return;
            }
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length == 0) {
                return;
            }
            for (PsiMethod constructor : constructors) {
                if (constructor.hasModifierProperty("private")) continue;
                return;
            }
            Collection innerAndLocalClasses = PsiTreeUtil.findChildrenOfType((PsiElement)aClass, PsiClass.class);
            for (PsiClass innerClass : innerAndLocalClasses) {
                if (!innerClass.isInheritor(aClass, false)) continue;
                return;
            }
            this.registerClassError(aClass, aClass);
        }
    }
}

