/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RemoveModifierFix;
import com.siyeh.ig.psiutils.SerializationUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PublicConstructorInNonPublicClassInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("public.constructor.in.non.public.class.display.name", new Object[0]);
        if (string == null) {
            PublicConstructorInNonPublicClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiMethod method = (PsiMethod)infos[0];
        String string = InspectionGadgetsBundle.message("public.constructor.in.non.public.class.problem.descriptor", method.getName());
        if (string == null) {
            PublicConstructorInNonPublicClassInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicConstructorInNonPublicClassVisitor();
    }

    @Override
    @NotNull
    public InspectionGadgetsFix[] buildFixes(Object ... infos) {
        ArrayList<InspectionGadgetsFix> fixes = new ArrayList<InspectionGadgetsFix>();
        PsiMethod constructor = (PsiMethod)infos[0];
        PsiClass aClass = constructor.getContainingClass();
        if (aClass != null && aClass.hasModifierProperty("private")) {
            fixes.add(new SetConstructorModifierFix("private"));
        }
        fixes.add(new RemoveModifierFix("public"));
        InspectionGadgetsFix[] inspectionGadgetsFixArray = fixes.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
        if (inspectionGadgetsFixArray == null) {
            PublicConstructorInNonPublicClassInspection.$$$reportNull$$$0(2);
        }
        return inspectionGadgetsFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classlayout/PublicConstructorInNonPublicClassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class PublicConstructorInNonPublicClassVisitor
    extends BaseInspectionVisitor {
        private PublicConstructorInNonPublicClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiParameterList parameterList;
            if (method == null) {
                PublicConstructorInNonPublicClassVisitor.$$$reportNull$$$0(0);
            }
            if (!method.isConstructor()) {
                return;
            }
            if (!method.hasModifierProperty("public")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.hasModifierProperty("public") || containingClass.hasModifierProperty("protected")) {
                return;
            }
            if (SerializationUtils.isExternalizable(containingClass) && (parameterList = method.getParameterList()).isEmpty()) {
                return;
            }
            this.registerModifierError("public", (PsiModifierListOwner)method, method);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/classlayout/PublicConstructorInNonPublicClassInspection$PublicConstructorInNonPublicClassVisitor", "visitMethod"));
        }
    }

    private static class SetConstructorModifierFix
    extends InspectionGadgetsFix {
        @PsiModifier.ModifierConstant
        private final String modifier;

        SetConstructorModifierFix(@PsiModifier.ModifierConstant String modifier) {
            this.modifier = modifier;
        }

        @NotNull
        public String getFamilyName() {
            if ("Fix constructor modifier" == null) {
                SetConstructorModifierFix.$$$reportNull$$$0(0);
            }
            return "Fix constructor modifier";
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("public.constructor.in.non.public.class.quickfix", this.modifier);
            if (string == null) {
                SetConstructorModifierFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiModifierList modifierList = (PsiModifierList)element.getParent();
            modifierList.setModifierProperty("public", false);
            modifierList.setModifierProperty(this.modifier, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/classlayout/PublicConstructorInNonPublicClassInspection$SetConstructorModifierFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

