/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class DeleteCatchSectionFix
extends InspectionGadgetsFix {
    private final boolean removeTryCatch;

    public DeleteCatchSectionFix(boolean removeTryCatch) {
        this.removeTryCatch = removeTryCatch;
    }

    @NotNull
    public String getName() {
        if (this.removeTryCatch) {
            String string = CommonQuickFixBundle.message((String)"fix.remove.statement", (Object[])new Object[]{"try-catch"});
            if (string == null) {
                DeleteCatchSectionFix.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("delete.catch.section.quickfix", new Object[0]);
        if (string == null) {
            DeleteCatchSectionFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Delete catch statement" == null) {
            DeleteCatchSectionFix.$$$reportNull$$$0(2);
        }
        return "Delete catch statement";
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiParameter)) {
            return;
        }
        PsiParameter parameter2 = (PsiParameter)parent;
        PsiElement grandParent = parameter2.getParent();
        if (!(grandParent instanceof PsiCatchSection)) {
            return;
        }
        PsiCatchSection catchSection = (PsiCatchSection)grandParent;
        if (this.removeTryCatch) {
            BlockUtils.unwrapTryBlock(catchSection.getTryStatement());
        } else {
            catchSection.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/fixes/DeleteCatchSectionFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

