/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleBraceInitializationInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("double.brace.initialization.display.name", new Object[0]);
        if (string == null) {
            DoubleBraceInitializationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("double.brace.initialization.display.name", new Object[0]);
        if (string == null) {
            DoubleBraceInitializationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiClass surroundingClass;
        PsiClass aClass = (PsiClass)infos[0];
        PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)aClass, (Class[])new Class[]{PsiNewExpression.class, PsiParenthesizedExpression.class});
        if (!(parent instanceof PsiVariable) && !(parent instanceof PsiAssignmentExpression)) {
            return null;
        }
        PsiElement anchor = PsiTreeUtil.getParentOfType((PsiElement)aClass, (Class[])new Class[]{PsiMember.class, PsiStatement.class});
        if (anchor instanceof PsiMember && ((surroundingClass = ((PsiMember)anchor).getContainingClass()) == null || surroundingClass.isInterface())) {
            return null;
        }
        return new DoubleBraceInitializationFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DoubleBraceInitializationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/initialization/DoubleBraceInitializationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class DoubleBraceInitializationVisitor
    extends BaseInspectionVisitor {
        private DoubleBraceInitializationVisitor() {
        }

        public void visitAnonymousClass(PsiAnonymousClass aClass) {
            super.visitAnonymousClass(aClass);
            if (ClassUtils.getDoubleBraceInitializer(aClass) == null) {
                return;
            }
            this.registerClassError((PsiClass)aClass, aClass);
        }
    }

    private static class DoubleBraceInitializationFix
    extends InspectionGadgetsFix {
        private DoubleBraceInitializationFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("double.brace.initialization.quickfix", new Object[0]);
            if (string == null) {
                DoubleBraceInitializationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement child;
            String qualifierText;
            PsiElement element = descriptor.getPsiElement().getParent();
            if (!(element instanceof PsiAnonymousClass)) {
                return;
            }
            PsiAnonymousClass aClass = (PsiAnonymousClass)element;
            PsiElement parent = aClass.getParent();
            if (!(parent instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)parent;
            PsiElement ancestor = PsiTreeUtil.skipParentsOfType((PsiElement)newExpression, (Class[])new Class[]{PsiParenthesizedExpression.class});
            if (ancestor instanceof PsiVariable) {
                qualifierText = ((PsiVariable)ancestor).getName();
            } else if (ancestor instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)ancestor;
                PsiExpression lhs = ParenthesesUtils.stripParentheses(assignmentExpression.getLExpression());
                if (!(lhs instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiVariable)) {
                    return;
                }
                qualifierText = referenceExpression.getText();
            } else {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiJavaCodeReferenceElement baseClassReference = aClass.getBaseClassReference();
            PsiElement baseClassTarget = baseClassReference.resolve();
            if (!(baseClassTarget instanceof PsiClass)) {
                return;
            }
            PsiExpressionList argumentList = aClass.getArgumentList();
            if (argumentList == null) {
                return;
            }
            DoubleBraceInitializationFix.qualifyReferences((PsiElement)aClass, (PsiClass)baseClassTarget, qualifierText);
            PsiClassInitializer initializer = aClass.getInitializers()[0];
            PsiCodeBlock body2 = initializer.getBody();
            PsiElement stop = body2.getFirstBodyElement();
            PsiElement anchor = PsiTreeUtil.getParentOfType((PsiElement)aClass, (Class[])new Class[]{PsiMember.class, PsiStatement.class});
            if (anchor == null) {
                return;
            }
            if (anchor instanceof PsiMember) {
                PsiModifierList modifierList;
                PsiMember member = (PsiMember)anchor;
                PsiClassInitializer newInitializer = factory.createClassInitializer();
                if (member.hasModifierProperty("static") && (modifierList = newInitializer.getModifierList()) != null) {
                    modifierList.setModifierProperty("static", true);
                }
                PsiCodeBlock initializerBody = newInitializer.getBody();
                while (child != null && !child.equals(stop)) {
                    initializerBody.add(child);
                    child = child.getPrevSibling();
                }
                member.getParent().addAfter((PsiElement)newInitializer, (PsiElement)member);
            } else {
                PsiElement container = anchor.getParent();
                for (child = body2.getLastBodyElement(); child != null && !child.equals(stop); child = child.getPrevSibling()) {
                    container.addAfter(child, anchor);
                }
            }
            PsiExpression newNewExpression = factory.createExpressionFromText("new " + baseClassReference.getText() + argumentList.getText(), (PsiElement)aClass);
            newExpression.replace((PsiElement)newNewExpression);
        }

        private static void qualifyReferences(PsiElement element, final PsiClass target, final String qualifierText) {
            final PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
            element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    super.visitReferenceExpression(expression2);
                    if (expression2.getQualifierExpression() != null) {
                        return;
                    }
                    PsiElement expressionTarget = expression2.resolve();
                    if (!(expressionTarget instanceof PsiMember)) {
                        return;
                    }
                    PsiMember member = (PsiMember)expressionTarget;
                    PsiClass containingClass = member.getContainingClass();
                    if (!InheritanceUtil.isInheritorOrSelf((PsiClass)target, (PsiClass)containingClass, (boolean)true)) {
                        return;
                    }
                    PsiExpression newExpression = factory.createExpressionFromText(qualifierText + '.' + expression2.getText(), (PsiElement)expression2);
                    expression2.replace((PsiElement)newExpression);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/DoubleBraceInitializationInspection$DoubleBraceInitializationFix", "getFamilyName"));
        }
    }
}

