/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.util.ui.CheckBox;
import com.intellij.util.ui.FormBuilder;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.fixes.SuppressForTestsScopeFix;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.ui.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NonBooleanMethodNameMayNotStartWithQuestionInspection
extends BaseInspection {
    @NonNls
    public String questionString = "add,are,can,check,contains,could,endsWith,equals,has,is,matches,must,put,remove,shall,should,startsWith,was,were,will,would";
    public boolean ignoreBooleanMethods = false;
    public boolean onlyWarnOnBaseMethods = true;
    List<String> questionList = new ArrayList<String>(32);

    public NonBooleanMethodNameMayNotStartWithQuestionInspection() {
        NonBooleanMethodNameMayNotStartWithQuestionInspection.parseString(this.questionString, this.questionList);
    }

    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        ListTable table = new ListTable(new ListWrappingTableModel(this.questionList, InspectionGadgetsBundle.message("boolean.method.name.must.start.with.question.table.column.name", new Object[0])));
        JPanel tablePanel = UiUtils.createAddRemovePanel(table);
        CheckBox checkBox1 = new CheckBox(InspectionGadgetsBundle.message("ignore.methods.with.boolean.return.type.option", new Object[0]), (InspectionProfileEntry)this, "ignoreBooleanMethods");
        CheckBox checkBox2 = new CheckBox(InspectionGadgetsBundle.message("ignore.methods.overriding.super.method", new Object[0]), (InspectionProfileEntry)this, "onlyWarnOnBaseMethods");
        panel.add((Component)tablePanel, "Center");
        panel.add((Component)FormBuilder.createFormBuilder().addComponent((JComponent)checkBox1).addComponent((JComponent)checkBox2).getPanel(), "South");
        return panel;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiElement context = (PsiElement)infos[0];
        SuppressForTestsScopeFix suppressFix = SuppressForTestsScopeFix.build(this, context);
        if (suppressFix == null) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new RenameFix()};
            if (inspectionGadgetsFixArray == null) {
                NonBooleanMethodNameMayNotStartWithQuestionInspection.$$$reportNull$$$0(0);
            }
            return inspectionGadgetsFixArray;
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new RenameFix(), suppressFix};
        if (inspectionGadgetsFixArray == null) {
            NonBooleanMethodNameMayNotStartWithQuestionInspection.$$$reportNull$$$0(1);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.boolean.method.name.must.not.start.with.question.display.name", new Object[0]);
        if (string == null) {
            NonBooleanMethodNameMayNotStartWithQuestionInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.boolean.method.name.must.not.start.with.question.problem.descriptor", new Object[0]);
        if (string == null) {
            NonBooleanMethodNameMayNotStartWithQuestionInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            NonBooleanMethodNameMayNotStartWithQuestionInspection.$$$reportNull$$$0(4);
        }
        super.readSettings(element);
        NonBooleanMethodNameMayNotStartWithQuestionInspection.parseString(this.questionString, this.questionList);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            NonBooleanMethodNameMayNotStartWithQuestionInspection.$$$reportNull$$$0(5);
        }
        this.questionString = NonBooleanMethodNameMayNotStartWithQuestionInspection.formatString(this.questionList);
        super.writeSettings(element);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonBooleanMethodNameMayNotStartWithQuestionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/naming/NonBooleanMethodNameMayNotStartWithQuestionInspection";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/naming/NonBooleanMethodNameMayNotStartWithQuestionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class NonBooleanMethodNameMayNotStartWithQuestionVisitor
    extends BaseInspectionVisitor {
        private NonBooleanMethodNameMayNotStartWithQuestionVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                NonBooleanMethodNameMayNotStartWithQuestionVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            PsiType returnType = method.getReturnType();
            if (returnType == null || returnType.equals(PsiType.BOOLEAN)) {
                return;
            }
            if (NonBooleanMethodNameMayNotStartWithQuestionInspection.this.ignoreBooleanMethods && returnType.equalsToText("java.lang.Boolean")) {
                return;
            }
            String name = method.getName();
            boolean startsWithQuestionWord = false;
            for (String question : NonBooleanMethodNameMayNotStartWithQuestionInspection.this.questionList) {
                if (!name.startsWith(question)) continue;
                if (name.length() == question.length()) {
                    startsWithQuestionWord = true;
                    break;
                }
                char nextChar = name.charAt(question.length());
                if (!Character.isUpperCase(nextChar) && nextChar != '_') continue;
                startsWithQuestionWord = true;
                break;
            }
            if (!startsWithQuestionWord) {
                return;
            }
            if (NonBooleanMethodNameMayNotStartWithQuestionInspection.this.onlyWarnOnBaseMethods ? MethodUtils.hasSuper(method) : LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            this.registerMethodError(method, method);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/naming/NonBooleanMethodNameMayNotStartWithQuestionInspection$NonBooleanMethodNameMayNotStartWithQuestionVisitor", "visitMethod"));
        }
    }
}

